/* Source for drawing Mandelbrot pictures. Included in Pulse #1.
   Should be compiled with Turbo C.
   (c) Tommy Staffans alias Moleql/Remedy in 1993 */

#include <graphics.h>
#include <conio.h>
#include <stdio.h>

main()
{
  int g_driver = 9, g_mode = 2; /* VGA-16 col, 640x480 */
  int count;
  float r0, r1, i0, i1, rz, iz, ztemp, zsize, m, n, rc, ic, rgap, igap;

  clrscr();
  printf("\nIf you don't know what values to put there, try (in order):\n"
	 "-2.0, 0.5, 1.25, -1.25.\n\n");
  printf("First point on real axis: "); scanf("%f", &r0);
  printf("Second point on real axis: "); scanf("%f", &r1);
  printf("First point on imaginary axis: "); scanf("%f", &i0);
  printf("Second point on imaginary axis: "); scanf("%f", &i1);

  /* Set up the graphics. */

  initgraph(&g_driver, &g_mode, "");

  /* The area we want to explore. Change these for different pictures!
     Take special care so that |r1-r0| = |i1-i0|, otherwise the picture
     will be shrunk in either direction. */

  rgap = (r1-r0)/480.0;
  igap = (i1-i0)/480.0;

  for(n = 0; n < 480; ++n)
  {
    /* Calculate the current position on the imaginary axis. (y-axis) */
    ic = i0 + n*igap;
    for(m = 0; m < 480; ++m)
    {
      /* Calculate the current position on the real axis. (x-axis) This is
	 a place where optimizing can be implemented with a good result. */
      rc = r0 + m*rgap;
      rz = iz = 0;

      /* Here 'count' is 256. When you've optimized the routine, so that
	 it is faster, you can change the number to eg. 1000 for better
	 pictures. An optimized assembler routine will be included in the
	 next issue, along with new fractal-formulas and -theories. */
      for(count = zsize = 0; ((count < 256) && (zsize < 4.0)); ++count)
      {
	/* The magic formula! */
	ztemp = rz;
	rz = rz*rz - iz*iz + rc;
	iz = 2*ztemp*iz + ic;
	zsize = rz*rz + iz*iz;
      }

      /* Is the point within the Mandelbrot set? */
      if (count != 256)
      /* No, write the pixel to the screen */
    putpixel(m + 80, n, count%16);  /* repeat the colors every 16th color */

      /* Has a key been pressed? */
      if (kbhit())
      {
	closegraph();
	return(0); /* Yes, close up and leave. */
      }
    }
  }
  getch(); /* Let the user watch the fractal until he presses a key. */
  /* Shut down the graphics and leave the program. */
  closegraph();
  return(0);
}
