Program ReadTgaTo18BitScreenMode;
Uses Crt;


Var
  XMax,YMax,xmaxvir : Word;

const
  ATTRCON_ADDR      = $3c0;
  MISC_ADDR         = $3c2;
  VGAENABLE_ADDR    = $3c3;
  SEQ_ADDR          = $3c4;
  GRACON_ADDR       = $3ce;
  CRTC_ADDR         = $3d4;
  STATUS_ADDR		    = $3da;
  Sc_Index = $3c4;
  Gc_Index = $3ce;
  Crtc_Index = $3d4;
  Crtc_Offset = $13;
  Misc_Output = $3c2;
  Screen_Seg = $a000;
  MapMask = $2;
  BitMask = $8;

Procedure SetColor(Color,Red,Green,Blue : Byte);
Begin
  Asm
    Mov  Dx,3C8H
    Mov  Al,Color
    Out  Dx,Al
    Inc  Dx
    Cli
    Mov  Al,Red
    Out  Dx,Al
    Mov  Al,Green
    Out  Dx,Al
    Mov  Al,Blue
    Out  Dx,Al
    Sti
  End;
End;

Procedure Plot(X,Y : Word;Col : Byte);
Begin
  Asm
    Mov  Ax,Screen_Seg
    Mov  Es,Ax

    Mov  Ax,XMaxvir
    Shr  Ax,2
    Mul  Y
    Mov  Bx,X
    Shr  Bx,2
    Add  Bx,Ax
    Mov  Cl,Byte Ptr X
    And  Cl,011b
    Mov  Ax,0100h+MapMask
    Shl  Ah,Cl
    Mov  Dx,Sc_Index
    Out  Dx,Ax

    Mov  Al,Col
    Mov  [Es:Bx],Al
  End;
End;

procedure ReadyVgaRegs;
var
  v : byte;
begin
  port[$3d4]:=$11;
  v:=port[$3d5] and $7f;
  port[$3d4]:=$11;
  port[$3d5]:=v;
end;

procedure SetVgaReg(vga_reg : word;index : byte; value : byte);
var
  v : byte;
begin
  case vga_reg of

    ATTRCON_ADDR : begin
      v:=port[STATUS_ADDR];
      port[ATTRCON_ADDR]:=index or $20;
      port[ATTRCON_ADDR]:=value;
    end;

    MISC_ADDR,VGAENABLE_ADDR : begin
      port[vga_reg]:=value;
    end;

    else begin
      port[vga_reg]:=index;
      port[vga_reg+1]:=value;
    end;

  end;
end;

procedure load_twkfile(twk_file : string);
var
  twkfile : file of byte;
  reglo : byte;
  reghi : byte;
  index : byte;
  value : byte;
  i,j     : word;
begin
  assign(twkfile,twk_file);
  reset(twkfile);
  asm
    mov ax,$13
    int $10
  end;
  readyvgaregs;
  repeat
    read(twkfile,reglo);
    read(twkfile,reghi);
    read(twkfile,index);
    read(twkfile,value);
    setvgareg(reglo+(reghi shl 8),index,value);
  until EOF(twkfile);
  close(twkfile);
end;

Procedure DrawPic;
Var
  X, Y : Word;
  TgaFile : File;
  Red,Green,Blue : Byte;
  SizeLow, SizeHigh : Byte;
  ScanLine : Array[0..3839] Of Byte;
  Header : Array[0..17] Of Byte;
  Resultat : Integer;
  BytesPerLine, PicXSize, PicYSize : Word;
  HeaderSize : Word;

Begin
  Assign(TgaFile,ParamStr(1));
  Reset(TgaFile,1);
  Seek(TgaFile,0);
  BlockRead(TgaFile,Header,18);
  PicXSize:=Header[12]+256*Header[13];
  PicYSize:=Header[14]+256*Header[15];
  If PicXSize<XMax Then XMax:=PicXSize;
  If PicYSize<YMax Then YMax:=PicYSize;
  HeaderSize:=18+Header[5]+256*Header[6];
  Seek(TgaFile,HeaderSize);
  If (Header[17] And 32)>0 Then Begin
    For Y:=0 To YMax-1 Do Begin
      BlockRead(TgaFile,ScanLine,3*PicXSize,Resultat);
      If Resultat<>PicXSize*3 Then Begin
        TextMode(Co80);
        WriteLn('Error reading file.');
        Halt;
      End;
      For X:=0 To XMax-1 Do Begin
        Blue:=ScanLine[X*3];
        Green:=ScanLine[X*3+1];
        Red:=ScanLine[X*3+2];
        PLOT(X,Y*3+2,128+Blue Shr 2);
        Plot(X,Y*3+1,64+Green Shr 2);
        Plot(X,Y*3+0,Red Shr 2);
      End;
    End;
  End
  Else Begin
    For Y:=YMax-1 DownTo 0 Do Begin
      BlockRead(TgaFile,ScanLine,3*PicXSize,Resultat);
      If Resultat<>PicXSize*3 Then Begin
        TextMode(Co80);
        WriteLn('Error reading file.');
        Halt;
      End;
      For X:=0 To XMax-1 Do Begin
        Blue:=ScanLine[X*3];
        Green:=ScanLine[X*3+1];
        Red:=ScanLine[X*3+2];
        PLOT(X,Y*3+2,128+Blue Shr 2);
        Plot(X,Y*3+1,64+Green Shr 2);
        Plot(X,Y*3+0,Red Shr 2);
      End;
    End;
  End;
  Close(TgaFile);
End;

Procedure FixPalette;
Var
  I : Byte;
Begin
  For I:=0 To 63 Do
    SetColor(I,I,0,0);
  For I:=64 To 127 Do
    SetColor(I,0,I-64,0);
  For I:=128 To 191 Do
    SetColor(I,0,0,I-128);
End;

Procedure CheckInFile;
Var
  InFile : File;
  TGAFormat : Byte;
Begin
  If ParamCount=0 Then Begin
    WriteLn('          18VGA Version 2.0');
    WriteLn('18VGA, a program that simulates 18 bits/pixel, and lets');
    WriteLn('you view a 24-bit picture on any standard VGA-card.');
    WriteLn('Maximum screen resolution: 320x200, but files may be bigger.');
    WriteLn('Supports only uncompressed 24-bit TARGA fileformat.');
    WriteLn('Idea and programming by Adam Bergstrm.');
    WriteLn('This is freeware.');
    WriteLn('Send suggestions and comments to:');
    WriteLn('Adam Bergstrm');
    WriteLn('Storgatan 92');
    WriteLn('903 33 Ume, SWEDEN');
    WriteLn('Internet: adam.bergstrom@um.erisoft.se');
    WriteLn;
    WriteLn('Usage:');
    WriteLn('18VGA filename');
    Halt;
  End;
  {$I-};
  Assign(InFile,ParamStr(1));
  Reset(InFile,1);
  {$I+};
  If IOResult<>0 Then Begin
    WriteLn('File not found.');
    Halt;
  End;
  Seek(InFile,2);
  BlockRead(InFile,TGAFormat,1);
  If TGAFormat<>2 Then Begin
    WriteLn('Sorry, non-supported TGA-format, or not a TGA-file...');
    Halt;
  End;
End;

Begin
  CheckInFile;
  load_twkfile('320x600.256');
  xmax:=320;
  ymax:=600;
  xmaxvir:=320;
  FixPalette;
  DrawPic;
  Repeat
  Until KeyPressed;
  TextMode(Co80);
End.
