{$Q-,A+,S-,R-}
Program DisplayTGA;
{====================================
 = Display TGA in 3840 color Mode X =
 =     by David Dahl @ 1:272/85     =
 ====================================}
(* Public Domain *)
Uses CRT, X3840;
Type TGAHeaderRec = Record
                      IDLen      : Byte;
                      ColMapType : Byte; ImageType : Byte;
                      CMOrg      : Word; CMLen     : Word; CMBits : Byte;
                      XOfs       : Word; YOfs      : Word;
                      XSize      : Word; YSize     : Word;
                      BPix       : Byte;
                      ImageDesc  : Byte;
                    End;
     TGAHeaderPtr = ^TGAHeaderRec;
     Buffer32Array = Array [0 .. (127 * 4)] of Byte;
     Buffer32Ptr   = ^Buffer32Array;
Var Header       : TGAHeaderPtr;
    Fin          : File;
    YPos, XPos   : LongInt;
    XSize, YSize : Integer;
    CodeByte     : Byte;
    Count        : Byte;
    Index        : Word;
    ColorBuffer  : Buffer32Ptr;
    PixelSize    : Word;
    Done         : Boolean;
    FileName     : String;
Begin
  New (ColorBuffer); New (Header);
  If ParamCount = 1
  Then
    FileName := ParamStr(1)
  Else
  Begin
    Writeln ('Enter Filename of Targa File to View');
    Readln  (FileName);
  End;
  If Pos('.',FileName) = 0
  Then
    FileName := FileName + '.TGA';
  Assign (Fin, FileName); Reset  (Fin,1);
  BlockRead (Fin, Header^, SizeOf(Header^));
  If Header^.ImageDesc = 0
  Then
  Begin
    With Header^ do
    Begin
      Writeln ('XSize, YSize :',XSize:6,YSize:6);
      Writeln ('Image Type   :',ImageType:6);
      Writeln ('Bits/Pixel   :',BPix:6);
    End;
    If ((Header^.BPix = 16)OR(Header^.BPix = 24)OR(Header^.BPix = 32)) AND
       (Header^.ImageType >= 8)
    Then
    Begin
      Writeln ('Press Any Key To View Image.');
      While Keypressed do Readkey;
      Repeat Until Keypressed;
      While Keypressed do Readkey;
      InitializeGraphics;
      XSize     := Header^.XSize;
      YSize     := Header^.YSize;
      XPos      := 0;
      YPos      := Header^.YSize-1;
      PixelSize := (Header^.BPix SHR 3);
      Done      := False;
      Repeat
        BlockRead (Fin, CodeByte, SizeOf(CodeByte));
        Count := (CodeByte AND 127) + 1;
        CodeByte := CodeByte SHR 7;
        If CodeByte = 0
        Then  { Output Count Colors }
        Begin
          BlockRead (Fin, ColorBuffer^, Count * PixelSize);
          Index := 0;
          While (Count > 0) AND Not(Done) do
          Begin
            If PixelSize > 2
            Then
              PutPixel ((XPos * 319) DIV XSize,
                        (YPos * 199) DIV YSize,
                        ColorBuffer^[Index+2] SHR 4,  { Red   }
                        ColorBuffer^[Index+1] SHR 4,  { Green }
                        (ColorBuffer^[Index] * 14) DIV 255) { Blue  }
            Else
              PutPixel ((XPos * 319) DIV XSize,
                        (YPos * 199) DIV YSize,
                        (ColorBuffer^[Index+1] SHR 3) AND 15,   { Red   }
                        ((ColorBuffer^[Index] SHR 6) OR
                        (ColorBuffer^[Index+1] SHL 2)) AND 15, { Green }
                        (ColorBuffer^[Index] SHR 1) AND 15);    { Blue  }
            Inc(Index, PixelSize);
            Dec(Count);
            Inc(XPos,1);
            If XPos >= XSize
            Then
            Begin
              XPos := 0; Dec (YPos);
              If YPos < 0
              Then
                Done := True;
            End;
            If KeyPressed
            Then
              Done := ReadKey = #27;
          End;
        End
        Else
        Begin  { Output Color Count Times }
          BlockRead (Fin, ColorBuffer^, PixelSize);
          While (Count > 0) AND Not(Done) do
          Begin
            If PixelSize > 2
            Then
              PutPixel ((XPos * 319) DIV XSize,
                        (YPos * 199) DIV YSize,
                        ColorBuffer^[2] SHR 4,  { Red   }
                        ColorBuffer^[1] SHR 4,  { Green }
                        (ColorBuffer^[0] * 14) DIV 255) { Blue  }
            Else
              PutPixel ((XPos * 319) DIV XSize,
                        (YPos * 199) DIV YSize,
                        (ColorBuffer^[1] SHR 3) AND 15,   { Red   }
                        ((ColorBuffer^[0] SHR 6) OR
                         (ColorBuffer^[1] SHL 2)) AND 15, { Green }
                        (ColorBuffer^[0] SHR 1) AND 15);  { Blue  }
            Dec(Count);
            Inc(XPos,1);
            If XPos >= XSize
            Then
            Begin
              XPos := 0; Dec (YPos);
              If YPos < 0
              Then
                Done := True;
            End;
            If KeyPressed
            Then
              Done := ReadKey = #27;
          End;
        End;
      Until Done;
      While Keypressed do Readkey;
      Repeat EnableScreen Until Keypressed;
      While Keypressed do Readkey;
      TextMode (C80);
    End
    Else
      Writeln ('Cannot view this picture.');
  End
  Else
    Writeln ('Not a TGA File.');
  Close  (Fin); Dispose (Header); Dispose (ColorBuffer);
End.
