; Vertical-retrace interrupt simulating code by
; Jussi Lahdenniemi / Virtual Visions.  Please give credit where
; credit is due.

        IDEAL
        MODEL TPASCAL
        JUMPS
        P386N

DATASEG

        Extrn   vrDoBefore:DWORD,vrDoAfter:DWORD,vrDone:BYTE
        Extrn   globalFrame:DWORD

old08   dd      ?
tim08   dw      ?


NEWRATE = 7000
; 4200 = minimum at 70Hz; most processor time dedicated to this
; 16200 = maximum at 70Hz; least processor time dedicated to this


CODESEG

        Public  vrNormalBefore,vrNormalAfter
        Public  vrInit,vrClose

new08label:

PROC    new08 NOLANGUAGE FAR    ; interrupt proc

        push    eax
        push    ebx
        push    ecx
        push    edx
        push    ds
        push    es
        push    edi
        push    esi
        mov     al,20h
        out     20h,al
        cli
        mov     ax,@DATA
        mov     ds,ax
        mov     es,ax
        call    [vrDoBefore]
        mov     dx,3dah
@@1:
        in      al,dx
        test    al,8
        jz      @@1
        mov     al,30h
        out     43h,al
        mov     al,NEWRATE and 255
        out     40h,al
        mov     al,NEWRATE/256
        out     40h,al
        call    [vrDoAfter]
;        mov     ax,[_NEWRATE]
        add     [WORD tim08],NEWRATE
        jnc     @@nodos
        pushf
        call    [old08]
@@nodos:
        sti
        pop     esi
        pop     edi
        pop     es
        pop     ds
        pop     edx
        pop     ecx
        pop     ebx
        pop     eax
        iret

ENDP

vrNormalBeforeLabel:

PROC    vrNormalBefore FAR

;        call    setVisualPage Pascal,[vispg]
;        mov     dx,3c8h
;        mov     al,0
;        out     dx,al
;        inc     dx
;        mov     al,63
;        out     dx,al
;        out     dx,al
;        out     dx,al

        retf
ENDP

vrNormalAfterLabel:

PROC    vrNormalAfter FAR

;        mov     dx,3c8h
;        mov     al,0
;        out     dx,al
;        inc     dx
;        mov     al,31
;        out     dx,al
;        out     dx,al
;        out     dx,al
        inc     [globalFrame]
        mov     [vrDone],1
;        mov     dx,3c8h
;        mov     al,0
;        out     dx,al
;        inc     dx
;        mov     al,0
;        out     dx,al
;        out     dx,al
;        out     dx,al
        retf
ENDP

PROC    vrInit FAR

        push    es
        mov     ax,cs
        mov     [WORD vrDoBefore+2],ax
        mov     [WORD vrDoAfter+2],ax
        mov     [WORD vrDoBefore],offset vrNormalBeforeLabel
        mov     [WORD vrDoAfter],offset vrNormalAfterLabel
        mov     ah,35h
        mov     al,8
        int     21h
        mov     [WORD old08],bx
        mov     [WORD old08+2],es
        pop     es
        push    ds
        push    cs
        pop     ds
        mov     dx,offset new08label
        mov     ax,2508h
        int     21h
        pop     ds
        mov     dx,3dah
@@1:
        in      al,dx
        test    al,8
        jnz     @@1
@@2:
        in      al,dx
        test    al,8
        jz      @@2
        mov     al,30h
        out     43h,al
        mov     al,NEWRATE and 255
        out     40h,al
        mov     al,NEWRATE/256
        out     40h,al
        mov     [tim08],0
        ret

ENDP

PROC    vrClose FAR

        mov     al,36h
        out     43h,al
        mov     al,0ffh
        out     40h,al
        out     40h,al

        push    ds
        mov     ah,25h
        mov     al,8
        mov     dx,[WORD old08]
        mov     ds,[WORD old08+2]
        int     21h
        pop     ds

        mov     al,20h
        out     20h,al

        mov     al,36h
        out     43h,al
        mov     al,0ffh
        out     40h,al
        out     40h,al

        ret

ENDP

END
