{
  bwpak.pas black and white color animation packer
  (c) 1997 by florian haller/aeiou
  finished 19970731.1637.GRAZ.AT
}

{ header }

{$m 65520, 0, 655360}

program bwpak;

uses crt, dos;

const maxfiles = 4096;
      filenlength = 12;
      tempsize = 64000;
      frameraw = 1;
      framerle = 2;
      framediff = 3;
      frameclear = 0;
      animationend = 255;

type filen = string [filenlength];
     temparray = array [1..tempsize] of byte;
     temppointer = ^temparray;

{ utilities }

function order (x, y: string): boolean;
var i: byte;
    done: boolean;
begin
  i := 1;
  done := false;
  repeat
    if ord (x [i]) < ord (y [i]) then begin
      order := false;
      done := true;
    end else
    if ord (x [i]) > ord (y [i]) then begin
      order := true;
      done := true;
    end else
      inc (i);
  until done;
end;

procedure error (message: string);
begin
  writeln (message);
  halt;
end;

{ file i/o }

const cache_size = 65528;

type cache_array = array [1..cache_size] of byte;
     cache_pointer = ^cache_array;

var cache_readpos, cache_writepos: word;
    cache_read, cache_write: cache_pointer;
    cache_status: boolean;
    inf, outf: file;

function cachedopenread (filename: string): boolean;
begin
  assign (inf, filename);
  {$i-}
  reset (inf, 1);
  {$i+}
  if ioresult <> 0 then
    cachedopenread := false
  else
    cachedopenread := true;
  cache_readpos := cache_size + 1;
  getmem (cache_read, cache_size);
end;

procedure cachedcloseread;
begin
  freemem (cache_read, cache_size);
  close (inf);
end;

procedure cachedblockread (var data: byte);
var result: word;
begin
  if cache_readpos > cache_size then begin
    if eof (inf) then begin
      cache_status := false;
      exit;
    end else
      cache_status := true;
    {$i-}
    blockread (inf, cache_read^, cache_size, result);
    {$i+}
    if ioresult <> 0 then error (' read error.');
    cache_readpos := 1;
  end;
  data := cache_read^ [cache_readpos];
  inc (cache_readpos);
end;

procedure cachedseekread (pos: longint);
begin
  seek (inf, pos);
  cache_readpos := cache_size + 1;
end;

procedure cachedopenwrite (filename: string);
begin
  assign (outf, filename);
  rewrite (outf, 1);
  cache_writepos := 1;
  getmem (cache_write, cache_size);
end;

procedure cachedclosewrite;
var result: word;
begin
  if cache_writepos > 1 then begin
    {$i-}
    blockwrite (outf, cache_write^, cache_writepos - 1, result);
    {$i+}
    if ioresult <> 0 then error (' read error.');
  end;
  freemem (cache_write, cache_size);
  close (outf);
end;

procedure cachedblockwrite (data: byte);
var result: word;
begin
  if cache_writepos > cache_size then begin
    {$i-}
    blockwrite (outf, cache_write^, cache_size, result);
    {$i+}
    if ioresult <> 0 then error (' read error.');
    cache_writepos := 1;
  end;
  cache_write^ [cache_writepos] := data;
  inc (cache_writepos);
end;

{ general variables }

var dirinfo: searchrec;
    dir: array [1..maxfiles] of filen;
    count, lngth: word;
    screen, temp, temp2, temp3: temppointer;
    crunch, crunchx, crunchdiff, nodiff, percent, quiet, invert: boolean;
    speed: byte;

{ pcx functions }

type pcx_headerrec = record
       manufacturer: byte;
       version: byte;
       encoding: byte;
       bitsperpixel: byte;
       xmin, ymin, xmax, ymax: word;
       hdpi, vdpi: word;
       colormap: array [1..48] of byte;
       reserved: byte;
       colorplanes: byte;
       bytesperline: word;
       paletteinfo: word;
       hscreensize, vscreensize: word;
       filler: array [1..54] of byte;
     end;

const pcx_headersize = sizeof (pcx_headerrec);

var pcx_header: pcx_headerrec;
    pcx_rawsize, pcx_xres, pcx_yres: longint;
    pcx_pal: array [1..3] of byte;
    pcx_newpal: array [0..255] of byte;

procedure readpcx (filename: string; target: temppointer);
var x, y, z: word;
    a: byte;
begin
  cachedopenread (filename);
  blockread (inf, pcx_header, pcx_headersize);
  pcx_xres := pcx_header.xmax - pcx_header.xmin + 1;
  pcx_yres := pcx_header.ymax - pcx_header.ymin + 1;
  pcx_rawsize := pcx_xres * pcx_yres;
  if (pcx_header.encoding <> 1) or (pcx_header.bitsperpixel <> 8) or
    (pcx_xres <> 320) or (pcx_yres <> 200) then
    error (' pcx type not supported.');
  cachedseekread (filesize (inf) - 768);
  for x := 0 to 255 do begin
    cachedblockread (pcx_pal [1]);
    cachedblockread (pcx_pal [2]);
    cachedblockread (pcx_pal [3]);
    y := (pcx_pal [1] + pcx_pal [2] + pcx_pal [3]) div 3;
    if y < 128 then pcx_newpal [x] := 0 else pcx_newpal [x] := 1;
  end;
  if invert then
    for x := 0 to 255 do
      if pcx_newpal [x] = 0 then
        pcx_newpal [x] := 1 else
        pcx_newpal [x] := 0;
  cachedseekread (pcx_headersize);
  x := 0;
  repeat
    cachedblockread (a);
    z := 1;
    if a > 191 then begin
      z := a - 192;
      cachedblockread (a);
    end;
    for y := 1 to z do begin
      inc (x);
      target^ [x] := pcx_newpal [a];
    end;
  until (x > pcx_rawsize) or (not cache_status);
  cachedcloseread;
  lngth := pcx_rawsize;
end;

{ compression }

procedure writetype (typ: byte);
begin
  cachedblockwrite (typ);
  if (not percent) and (not quiet) then
    case typ of
      frameclear: write ('.');
      frameraw: write ('0');
      framerle: write ('O');
      framediff: write ('o');
      animationend: write ('#');
    end;
end;

function backgroundcolor (frame: temppointer): byte;
var x, b, w: word;
begin
  b := 0;
  w := 0;
  for x := 1 to lngth do if frame^ [x] = 1 then inc (w) else inc (b);
  if b < w then backgroundcolor := 0 else backgroundcolor := 1;
end;

procedure crunchxframe (frame, newframe: temppointer; bgc: byte);
var pos: word;
begin
  pos := 2;
  newframe^ [1] := frame^ [1];
  repeat
    if (frame^ [pos - 1] = bgc) and (frame^ [pos + 1] = bgc) then
      newframe^ [pos] := bgc else newframe^ [pos] := frame^ [pos];
    inc (pos);
  until pos = lngth;
  newframe^ [lngth] := frame^ [lngth];
end;

procedure crunchframe (frame, newframe: temppointer);
var x, y: word;
    z: byte;
procedure setxy (x, y: word; z: byte);
begin
  newframe^ [y * 320 + x + 1] := z;
end;
function getxy (x, y: word): byte;
begin
  getxy := frame^ [y * 320 + x + 1];
end;
function midval (x, y: word): byte;
begin
  midval := getxy (x - 1, y - 1) + getxy (x, y - 1) + getxy (x + 1, y - 1) +
    getxy (x - 1, y) + getxy (x + 1, y) + getxy (x - 1, y + 1) +
    getxy (x, y + 1) + getxy (x + 1, y + 1);
end;
begin
  move (frame^, newframe^, lngth);
  if lngth <> (320 * 200) then exit;
  for y := 1 to 198 do
    for x := 1 to 318 do begin
      z := midval (x, y);
      if z = 0 then
        setxy (x, y, 0) else
        if z = 8 then
          setxy (x, y, 1);
    end;
end;

function checkdiffrcs (frame, newframe: temppointer): boolean;
var x: word;
    b: boolean;
begin
  b := false;
  for x := 1 to lngth do
    if screen^ [x] <> frame^ [x] then begin
      newframe^ [x] := 1;
      b := true;
    end else
      newframe^ [x] := 0;
  checkdiffrcs := b;
end;

procedure compressframe (frame, target: temppointer; var csize: word);
var x, c: word;
    a: byte;
procedure addbyte (data: byte);
begin
  inc (csize);
  target^ [csize] := data;
end;
procedure addword (data: word);
begin
  inc (csize);
  target^ [csize] := hi (data);
  inc (csize);
  target^ [csize] := lo (data);
end;
begin
  x := 1;
  csize := 0;
  a := 0;
  repeat
    c := 1;
    while (frame^ [x] = a) and (c < 32767) and (x <= lngth) do begin
      inc (c);
      inc (x);
    end;
    if c < 128 then
      addbyte (lo (c))
    else begin
      inc (c, 32768);
      addword (c);
    end;
    if (c = 65535) and (frame^ [x] = frame^ [x - 1]) then begin
      if frame^ [x] = 1 then a := 0 else a := 1;
    end else
      a := frame^ [x];
  until x > lngth;
end;

procedure checkdiff (difframe, source: temppointer);
var x: word;
begin
  for x := 1 to lngth do
    if difframe^ [x] = 1 then
      if source^ [x] = 1 then
        source^ [x] := 0 else
        source^ [x] := 1;
end;

procedure writerawframe (frame: temppointer);
var a: word;
    c, d: byte;
begin
  for a := 1 to (lngth + 7) div 8 do begin
    c := 0;
    for d := 0 to 7 do c := (c shl 1) + frame^ [a * 8 - 7 + d];
    cachedblockwrite (c);
  end;
end;

procedure writeframe (frame: temppointer; size: word);
var x: word;
begin
  for x := 1 to size do cachedblockwrite (frame^ [x]);
end;

{ main procedures }

procedure checkparams;
var s: filen;
    x: byte;
    y: integer;
    t: string [2];
begin
  crunch := true;
  crunchx := false;
  nodiff := false;
  percent := false;
  quiet := false;
  invert := false;
  speed := 1;
  if paramcount > 2 then
    for x := 3 to paramcount do begin
      s := paramstr (x);
      case upcase (s [2]) of
        'C': if length (s) > 2 then
               case s [3] of
                 '0': crunch := false;
                 '2': begin
                        crunch := true;
                        crunchx := true;
                      end;
               end;
        'S': if length (s) > 2 then begin
               if upcase (s [3]) = 'E' then
                 crunchdiff := true;
             end else
               nodiff := true;
        'P': percent := true;
        'Q': quiet := true;
        'D': if length (s) > 2 then begin
               t := s [3];
               y := ord (s [4]);
               if (y > 47) and (y < 58) then t := t + s [4];
               val (t, speed, y);
               if y <> 0 then speed := 1;
               if speed < 1 then speed := 1;
             end;
        'I': invert := true;
      end;
    end;
end;

procedure catchfiles (mask: string);
var dirinfo: searchrec;
    x, y: word;
    s: filen;
begin
  if pos ('.pcx', mask) = 0 then mask := mask + '.pcx';
  count := 0;
  findfirst (mask, anyfile, dirinfo);
  while doserror = 0 do begin
    inc (count);
    if count > maxfiles then begin
      str (maxfiles, s);
      error ('too many files (max ' + s + ').');
    end;
    dir [count] := dirinfo.name;
    findnext (dirinfo);
  end;
  for x := 1 to count do
    for y := 1 to count - 1 do
      if order (dir [y], dir [y + 1]) then begin
        s := dir [y + 1];
        dir [y + 1] := dir [y];
        dir [y] := s;
      end;
end;

procedure encode (output: string);
var x, a, b: word;
begin
  if pos ('.bw', output) = 0 then output := output + '.bw';
  if not quiet then write ('[' + output + '] ');
  getmem (temp3, tempsize);
  getmem (temp2, tempsize);
  getmem (temp, tempsize);
  getmem (screen, tempsize);
  fillchar (screen^, tempsize, 0);
  cachedopenwrite (output);
  for x := 1 to count do begin
    readpcx (dir [x], temp);
    if crunch then begin
      crunchframe (temp, temp3);
      if crunchx then
        crunchxframe (temp3, temp, backgroundcolor (temp)) else
        move (temp3^, temp^, lngth);
    end;
    if checkdiffrcs (temp, temp3) then begin
      if crunchdiff then
        crunchframe (temp3, temp2) else
        move (temp3^, temp2^, lngth);
      if nodiff then
        a := 65535
      else begin
        checkdiff (temp2, screen);
        compressframe (temp2, temp3, a);
      end;
      compressframe (temp, temp2, b);
      if (a > (lngth div 8 - 1)) and (b > (lngth div 8 - 1)) then begin
        move (temp^, screen^, lngth);
        writetype (frameraw);
        writerawframe (screen);
      end else
        if (a < b) then begin
          writetype (framediff);
          writeframe (temp3, a);
        end else begin
          move (temp^, screen^, lngth);
          writetype (framerle);
          writeframe (temp2, b);
        end;
    end else
      writetype (frameclear);
    for a := 2 to speed do writetype (frameclear);
    if not quiet then
      if percent then begin
        write (round (x / count * 100): 3, '%');
        gotoxy (wherex - 4, wherey);
      end;
  end;
  writetype (animationend);
  cachedclosewrite;
  freemem (screen, tempsize);
  freemem (temp, tempsize);
  freemem (temp2, tempsize);
  freemem (temp3, tempsize);
end;

procedure help;
begin
  writeln ('syntax: BWPAK.EXE <output[.bw]> <input[.pcx]> [options[n]]');
  writeln ('<output>  bw file to create');
  writeln ('<input>   source pcx files in current directory (320x200 only)');
  writeln ('[options]  -q  quiet (suppress all output)');
  writeln ('           -p  display status in percent');
  writeln ('           -c0 do not crunch frames');
  writeln ('           -c2 extended frame crunch');
  writeln ('           -s  disable difference packing');
  writeln ('           -se enhanced difference packing');
  writeln ('           -dn set frame intervale to n (sec = 18, default 1)');
  writeln ('           -i  invert frames');
  halt;
end;

{ main program }

begin
  checkparams;
  if (not quiet) or (paramcount < 2) then
    writeln ('bw.pak v6, (c) 1997 florian haller');
  if maxavail < (tempsize * 4 + cache_size * 2) then
    error ('not enough memory.');
  if paramcount < 2 then
    help;
  catchfiles (paramstr (2));
  encode (paramstr (1));
  if not quiet then
    writeln (' ok.');
end.