#include <math.h>
#include <malloc.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <wgt5.h>
#include <pr.h>

#ifdef __3DFX__
#include <glide.h>
#endif

#include "demo.h"


void Part7 (void)
{
PR_OBJECT *greet_shape;
PR_ENTITY *greet_entity;

PR_REAL greetx = -90, greety = 0, greetz = -120;
PR_DWORD past_ticks;

  wnormscreen ();
  wcls (0);
  fading = 0;
  PR_AllocMaterialList (256);
  PR_AllocWorldTextures (64);
  PR_AllocShadeTables (32);

  /* -------------- Load objects ----------------- */

  greet_shape = LoadFile ("greet.pro");

  /* -------------- Initialize Entities ----------- */

  greet_entity = PR_CreateEntity (greet_shape, "Greets");
  PR_ScaleEntity (greet_entity, 0.6, 0.6, 0.6);
  PR_PositionEntity (greet_entity, 0, 0, 0);

  /* -------------- Misc Setup ----------- */


  ticks = 0;
  userlights.NumLights = 1;     /* This sets how many lights are actually used */
  PR_SetLightType (&userlights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&userlights, 0, 1.0);
  PR_AmbientLight = 0;

  PR_SetCameraSource (newcam, 0, 1000, 5000);
  PR_SetCameraTarget (newcam, 0, -500, 0);
  newcam->tilt_angle = 10;
  PR_SetActiveCamera (newcam);

  PR_SetLightPosition (&userlights, 0, 0, 0, 5000);

  PR_SetMipMapState (FALSE);

  /* -------------- Loop ----------- */

  while (CheckSongPosition (0x43, 45))
    {
     PR_OpenScreen (PR_BACKBUFFER);
     past_ticks = ticks;
     ticks = 0;

     /* -------------- Animation Parameters ----------- */

     greetz += past_ticks * 0.31;             /* Greets spin */

     /* -------------- Render Normal Frame ----------- */

     PR_NewFrame ();
     wsetcolor (0);
     PRGFX_ClearScreen ();
     PR_AddLightsToScene (&userlights);

     PR_RotateEntity (greet_entity, greetx, greety, greetz);
     PR_TransformEntity (greet_entity);
     PR_RenderEntity (greet_entity);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_Flip ();
    }

  memcpy (fadepal, global_palette, 768);
  BlackPalette ();
  fading = 1;
  while (CheckSongPosition (0x43, 60)) {}

  PR_FreeObject (greet_shape);
  PR_FreeEntity (greet_entity);
  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();
}



