#include <math.h>
#include <malloc.h>
#include <wgt5.h>
#include <wgtvesa.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <pr.h>
#include <terrain.h>

#ifdef __3DFX__
#include <glide.h>
#endif

#include "demo.h"


#define WORLD_SCALE 100
#define HEIGHT_SCALE 6

PR_TERRAIN *terrain;

#define ABOVE_GROUND 22
#define MAX_HEIGHT 1000

#define ROOHEIGHT 20
#define ROOSPACE 40

block tilesprites[1024];
color temppal[256];
#define NUM_TILES 256
#define OBJ_TILES 256           /* Number of materials allowed for objects */

/* Futuristic Roo */
#define NUMROO 6
PR_REAL baseheight[NUMROO];



/* ---------------------------------------------------------------------- */
/* Makes sure the camera is above the landscape for the first frame */
/* ---------------------------------------------------------------------- */
void SetInitialPosition (void)
{
PR_REAL hgt;


  hgt = PR_GetTerrainHeight (terrain, newcam->source.x,
                                      newcam->source.z,
                                      terrain->level1_heightpic)
                                      + ABOVE_GROUND;


  PR_SetCameraSource (newcam,
                      newcam->source.x,
                      hgt + ABOVE_GROUND,
                      newcam->source.z);
}




void CheckRooHeight (PR_ENTITY *ent, PR_DWORD num)
{

  baseheight[num] = PR_GetTerrainHeight (terrain, ent->orientation.location.x,
                                         ent->orientation.location.z,
                                         terrain->level1_heightpic)
                                         + ROOHEIGHT;
  if (num == NUMROO-1)
    baseheight[num] -= 4;
}



/* ---------------------------------------------------------------------- */
/* Checks for ground collision in the flying model */
/* ---------------------------------------------------------------------- */
void SetFlyingHeight (void)
{
PR_REAL hgt;

  hgt = PR_GetTerrainHeight (terrain, newcam->source.x,
                                      newcam->source.z,
                                      terrain->level1_heightpic)
                                       + ABOVE_GROUND;

  if (newcam->source.y < hgt)
    {
     newcam->dest.y += hgt - newcam->source.y;
     newcam->source.y = hgt;
    }

  if (newcam->source.y > hgt + MAX_HEIGHT)
    {
     newcam->dest.y += (hgt + MAX_HEIGHT) - newcam->source.y;
     newcam->source.y = hgt + MAX_HEIGHT;
    }
}


PR_DWORD tilemap[256*6];
/* ---------------------------------------------------------------------- */
/* Creates a material list with mip mapping for the landscape */
/* ---------------------------------------------------------------------- */
void InitializeMaterials (void)
{
PR_MATERIAL *m;
PR_DWORD i;
char tilename[80];

  PR_SetMipMapState (TRUE);
  PR_SetMipMapShrink (TRUE);

  /* You can adjust these distances depending on what detail you want,
     and how far you can see in the distance. */
  PR_SetMipMapDepth (MIP_LEVEL1, 400);
  PR_SetMipMapDepth (MIP_LEVEL2, 600);
  PR_SetMipMapDepth (MIP_LEVEL3, 700);
  PR_SetMipMapDepth (MIP_LEVEL4, 8000);


  /* Create a NULL material for objects */
  m = &PR_ObjectMaterialList[0];
  PR_SetMaterialName (m, "NULL");
  PR_SetMaterialMethod (m, NULL_TYPE);


  /* Now load the tiles from a sprite file, and set up 4 levels of
     mip mapping for each.  */

  wloadsprites (global_palette, "landtile.spr", tilesprites, 0, 1023);
  /* Load the images into the tilesprites array */
  wsetpalette (0, 255, global_palette);

  /* Set the null type for land tiles
     This is to allow for holes in the landscape. */
  m = &PR_ObjectMaterialList[OBJ_TILES];
  PR_SetMaterialName (m, "NULL");
  PR_SetMaterialMethod (m, NULL_TYPE);


  /* For each tile image, make 4 materials for the mip mapping */

  for (i = 1; i < NUM_TILES; i++)
    {
     m = &PR_ObjectMaterialList[OBJ_TILES + i];

     /* We already have the images loaded in tilesprites, so just
        make a pointer to them */
     sprintf (tilename, "tile%i", i-1);
     tilemap[i-1] = PR_AddWorldTexture (tilename, tilesprites[i-1]);

     sprintf (tilename, "tile%i", i-1 + 256);
     tilemap[i-1 + 256] = PR_AddWorldTexture (tilename, tilesprites[i-1 + 256]);

     sprintf (tilename, "tile%i", i-1 + 512);
     tilemap[i-1 + 512] = PR_AddWorldTexture (tilename, tilesprites[i-1 + 512]);

     sprintf (tilename, "tile%i", i-1 + 768);
     tilemap[i-1 + 768] = PR_AddWorldTexture (tilename, tilesprites[i-1 + 768]);

     /* This is the master material.  Mip mapping information is entered
        in here only.  */
     m = &PR_ObjectMaterialList[OBJ_TILES + i];
     PR_SetMaterialName (m, "tile1");
     PR_SetMaterialMethod (m, T_PGOURAUD_TEXTURED8);
     PR_SetMaterialBaseColor (m, 0);
     PR_SetMaterialColor (m, 255, 255, 255);
     PR_SetMaterialTexture (m, tilemap[i-1]);
     PR_SetMaterialTable (m, 0);
     PR_SetMaterialShades (m, 63);
     PR_SetMaterialEnvironmentMap (m, 0);

     PR_SetMaterialMipMapState (m, TRUE);
     PR_SetMaterialMipMap (m, MIP_LEVEL1, OBJ_TILES + i + 256);
     PR_SetMaterialMipMap (m, MIP_LEVEL2, OBJ_TILES + i + 512);
     PR_SetMaterialMipMap (m, MIP_LEVEL3, OBJ_TILES + i + 768);
     PR_SetMaterialMipMap (m, MIP_LEVEL4, OBJ_TILES + i + 1024);
     PR_SetMaterialMipMapShift (m, MIP_LEVEL1, 0);
     PR_SetMaterialMipMapShift (m, MIP_LEVEL2, 1);
     PR_SetMaterialMipMapShift (m, MIP_LEVEL3, 2);
     PR_SetMaterialMipMapShift (m, MIP_LEVEL4, 3);


     /* Set the tile properties at distance level 1 */
     m = &PR_ObjectMaterialList[OBJ_TILES + i + 256];
     PR_SetMaterialName (m, "mip1");
     PR_SetMaterialMethod (m, T_GOURAUD_TEXTURED8);
     PR_SetMaterialBaseColor (m, 0);
     PR_SetMaterialColor (m, 255, 255, 255);
     PR_SetMaterialTexture (m, tilemap[i-1]);
     PR_SetMaterialTable (m, 0);
     PR_SetMaterialShades (m, 63);
     PR_SetMaterialEnvironmentMap (m, 0);

     /* Set the tile properties at distance level 2 */
     m = &PR_ObjectMaterialList[OBJ_TILES + i + 512];
     PR_SetMaterialName (m, "mip2");
     PR_SetMaterialMethod (m, T_GOURAUD_TEXTURED8);
     PR_SetMaterialBaseColor (m, 0);
     PR_SetMaterialColor (m, 255, 255, 255);
     PR_SetMaterialTexture (m, tilemap[i-1 + 256]);
     PR_SetMaterialTable (m, 0);
     PR_SetMaterialShades (m, 63);
     PR_SetMaterialEnvironmentMap (m, 0);

     /* Set the tile properties at distance level 3 */
     m = &PR_ObjectMaterialList[OBJ_TILES + i + 768];
     PR_SetMaterialName (m, "mip3");
     PR_SetMaterialMethod (m, T_LGOURAUD_TEXTURED);
     PR_SetMaterialBaseColor (m, 0);
     PR_SetMaterialColor (m, 255, 255, 255);
     PR_SetMaterialTexture (m, tilemap[i-1 + 512]);
     PR_SetMaterialTable (m, 0);
     PR_SetMaterialShades (m, 63);
     PR_SetMaterialEnvironmentMap (m, 0);

     /* Set the tile properties at distance level 4 */
     m = &PR_ObjectMaterialList[OBJ_TILES + i + 1024];
     PR_SetMaterialName (m, "mip4");
     PR_SetMaterialMethod (m, T_LGOURAUD_TEXTURED);
     PR_SetMaterialBaseColor (m, 0);
     PR_SetMaterialColor (m, 255, 255, 255);
     PR_SetMaterialTexture (m, tilemap[i-1 + 768]);
     PR_SetMaterialTable (m, 0);
     PR_SetMaterialShades (m, 63);
     PR_SetMaterialEnvironmentMap (m, 0);
    }
}



void InitializeTexture (void)
{
  /* Texture hack */
  load_palette = 0;
  InitializeMaterials ();
}




/* ---------------------------------------------------------------------- */
/* Check the mouse and keyboard input */
/* ---------------------------------------------------------------------- */
void UserInput (void)
{
  PR_ReadInput ();
  /* Move around depending on what movement model we are using */

  PR_CameraDirection (newcam);

  PR_DollyCamera (newcam, currentspeed);
  SetFlyingHeight ();

  PR_SetActiveCamera (newcam);
  /* Updates the transformation matrix */
}






void PR_MorphObject (PR_OBJECT *obj1, PR_OBJECT *obj2, PR_OBJECT *destobj,
                     PR_REAL t)
/* Morphs between two objects, given t from 0 to 1. Assumes the object has
   one segment, all obj1, obj2, and destobj have the same number of
   vertices.  */
{
/* Object 1 */
PR_SEGMENT *seg1;
PR_VERTEX *vert1;

/* Object 2 */
PR_SEGMENT *seg2;
PR_VERTEX *vert2;

/* Dest Object */
PR_SEGMENT *segdest;
PR_VERTEX *vertdest;

PR_DWORD i;
PR_REAL omt;            /* One minus t */

  omt = 1 - t;

  seg1 = obj1->segment_list;
  seg2 = obj2->segment_list;
  segdest = destobj->segment_list;

  vert1 = seg1->vertex_list;
  vert2 = seg2->vertex_list;
  vertdest = segdest->vertex_list;

  for (i = 0; i < seg1->num_vertices; i++)
    {
     vertdest->x = vert1->x * omt + vert2->x * t;
     vertdest->y = vert1->y * omt + vert2->y * t;
     vertdest->z = vert1->z * omt + vert2->z * t;

     vert1++;
     vert2++;
     vertdest++;
    }
}




void Part5 (void)
{
PR_DWORD i;

PR_OBJECT *jump1_shape;
PR_OBJECT *jump2_shape;
PR_OBJECT *jump3_shape;
PR_OBJECT *roo_shape;
PR_OBJECT *shadow_shape;

PR_OBJECT *src_obj;
PR_OBJECT *dst_obj;
PR_REAL tempt;

PR_ENTITY *roo_entity[NUMROO];
PR_REAL roox[NUMROO], rooy[NUMROO], rooz[NUMROO];
PR_REAL roolx[NUMROO], rooly[NUMROO], roolz[NUMROO], roollx[NUMROO];
PR_REAL roo_t[NUMROO];

PR_REAL roo_speed[NUMROO];
PR_REAL roo_jumpheight[NUMROO];
PR_REAL roo_ticks[NUMROO];

PR_REAL camsx, camsy, camsz;
PR_REAL camdx, camdy, camdz;
PR_REAL spin1 = 1;

PR_ENTITY *shadow_entity;

PR_DWORD past_ticks;
PR_DWORD shadowmat;
PR_DWORD landtable;

  wnormscreen ();
  wcls (0);
  PR_AllocMaterialList (256 * 6);
  PR_AllocWorldTextures (256 * 6);
  PR_AllocShadeTables (32);

  InitializeTexture ();
  landtable = PR_LoadTable ("table.dat");
  PR_ShadeTables[landtable].normal_shade = 128 << 16;


  load_palette = 0;
  shadow_shape = LoadFile ("shadow.pro");
  jump1_shape = LoadFile ("runner1.pro");
  jump2_shape = LoadFile ("runner2.pro");
  jump3_shape = LoadFile ("runner3.pro");
  roo_shape = LoadFile ("runner1.pro");

  /* -------------- Load objects ----------------- */
  terrain = PR_AllocateTerrain (16,
                                TERRAIN_PLAIN | TERRAIN_SHADING,
                                WORLD_SCALE, HEIGHT_SCALE, OBJ_TILES+1);
  /* Load in the height and tile maps */
  PR_LoadTerrain (terrain, "hf.gif", "track1.wmp", "shading.pcx", 2);

  wsetpalette (0, 255, global_palette);




  /* -------------- Initialize Entities ----------- */

  shadow_entity = PR_CreateEntity (shadow_shape, "Shadow");
  PR_ScaleEntity (shadow_entity, 0.01, 0.01, 0.01);


  for (i = 0; i < NUMROO; i++)
    {
     roo_entity[i] = PR_CreateEntity (roo_shape, "Roo");
     PR_ScaleEntity (roo_entity[i], 0.01, 0.01, 0.01);
     PR_PositionEntity (roo_entity[i], i*50 - 80, 0, i*50 - 80);

     roox[i] = -90;
     rooy[i] = 0;
     rooz[i] = 0;

     roo_t[i] = i;

     roolx[i] = i*ROOSPACE - 8;
     roollx[i] = 0;
     rooly[i] = ROOHEIGHT;
     roolz[i] = i*ROOSPACE - 8;

     roo_speed[i] = 20;
     roo_jumpheight[i] = 32;
     roo_ticks[i] = 0.04;
    }

  roo_speed[NUMROO-1] = 5;
  roo_jumpheight[NUMROO-1] = 16;
  roo_ticks[NUMROO-1] = 0.16;
  PR_ScaleEntity (roo_entity[NUMROO-1], 0.007, 0.007, 0.007);

  /* -------------- Misc Setup ----------- */

  shadowmat = PR_FindMaterial ("shadow");
  PR_ObjectMaterialList[shadowmat].render_method = T_SOURCETRANSFORM;

  PR_SetFogState (1);
  PR_SetFogRange (500, 900);


  PR_AmbientLight = 0;
  PR_AmbientRed = 0;
  PR_AmbientGreen = 0;
  PR_AmbientBlue = 0;

  PR_SetCameraMode (newcam, CAMFLAG_ANGLE_BASED);
  SetInitialPosition ();

  PR_SetLightPosition (&userlights, 0, 0, 0, 10000);
  PR_SetLightType (&userlights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&userlights, 0, 1.0);
  PR_SetLightOn (&userlights, 0);
  PR_SetLightColor (&userlights, 0, 1.0, 1.0, 1.0);

  /* Initialize the input devices */
  if (secret)
    {
     PR_SetInputDevice (INPUT_MOUSE);
     PR_SetInputModel (MODEL_FLYING);
     PR_SetInputEntity (NO_ENTITY, NO_SEGMENT);
     PR_SetInputCamera (newcam);

     TRANSLATE_SPEED = 1.83;
     MAX_TRANSLATE_SPEED= 17;
     TRANSLATE_DRAG     = 0.24;
    }

  PR_TextureDivisions = 32;

  PR_SetCameraSource (newcam, 0, 0, 0);
  ticks = 0;
  userlights.NumLights = 1;     /* This sets how many lights are actually used */

  /* -------------- Loop ----------- */

  while ((CheckSongPosition (0x3D, 45) && !secret) || (secret && !kbdon[KEY_ESC]))
    {
     PR_OpenScreen (PR_BACKBUFFER);
     past_ticks = ticks;
     ticks = 0;

     /* -------------- Camera Position ----------- */

     if (secret)
       UserInput ();
     else
       {
        if (CheckSongPosition (0x30, 63))
          {
           camsx = -80;
           camsy = ABOVE_GROUND;
           camsz = -60;

           camdx = -80;
           camdy = ABOVE_GROUND;
           camdz = 100;
          }
        else if (CheckSongPosition (0x33, 32))
          {
           camsx = roolx[3] - 64;
           camsy = ABOVE_GROUND;
           camsz = roolz[3] + 100;

           camdx = roolx[3];
           camdy = ABOVE_GROUND;
           camdz = roolz[3];
          }
        else if (CheckSongPosition (0x35, 63))
          {
           spin1 += 0.03 * past_ticks;
           camsx = roolx[3] + sin (spin1) * 80;
           camsy = ABOVE_GROUND * 3;
           camsz = roolz[3] + cos (spin1) * 80;

           camdx = roolx[3];
           camdy = ABOVE_GROUND * 2;
           camdz = roolz[3];
          }
        else if (CheckSongPosition (0x38, 32))
          {
           camsx = -800;
           camsy = ABOVE_GROUND;
           camsz = 300;

           camdx = roolx[3];
           camdy = ABOVE_GROUND;
           camdz = roolz[3];
          }

        PR_SetCameraSource (newcam, camsx, camsy, camsz);
        PR_SetCameraTarget (newcam, camdx, camdy, camdz);
        PR_SetActiveCamera (newcam);
       }


     /* -------------- Render Normal Frame ----------- */

     PR_NewFrame ();

     wsetcolor (0);
     PRGFX_ClearScreen ();

     PR_SetLightPosition (&userlights, 0,
                          newcam->source.x,
                          newcam->source.y,
                          newcam->source.z);

     PR_TransformLights (&userlights);



     PR_UpdateTerrain (terrain);
     PR_TransformTerrain (terrain);
     PR_RenderTerrain (terrain);


     for (i = 0; i < NUMROO; i++)
       {
        roo_t[i] += past_ticks * roo_ticks[i];
        while (roo_t[i] > 5.0)
          roo_t[i] -= 5.0;

        if (roo_t[i] < 1)
          {
           src_obj = jump1_shape;
           dst_obj = jump2_shape;
           tempt = roo_t[i];
           roollx[i] = 0;
          }
        else if (roo_t[i] < 3)
          {
           src_obj = jump2_shape;
           dst_obj = jump3_shape;
           tempt = (roo_t[i] - 1) / 2;


           rooly[i] = sin((tempt/2)*3.1415) * roo_jumpheight[i];
           roolx[i] -= ((roo_t[i]-1) - roollx[i]) * roo_speed[i];
           roollx[i] = (roo_t[i] - 1);
           PR_PositionEntity (roo_entity[i], roolx[i], baseheight[i] + rooly[i], roolz[i]);

          }
        else if (roo_t[i] < 5)
          {
           src_obj = jump3_shape;
           dst_obj = jump1_shape;
           tempt = (roo_t[i] - 3) / 2;
           rooly[i] = sin((tempt/2 + 0.5)*3.1415) * roo_jumpheight[i];

           roolx[i] -= ((roo_t[i]-1) - roollx[i]) * roo_speed[i];
           roollx[i] = (roo_t[i]-1);
           PR_PositionEntity (roo_entity[i], roolx[i], baseheight[i] + rooly[i], roolz[i]);
          }

        PR_MorphObject (src_obj, dst_obj, roo_shape, tempt);

        CheckRooHeight (roo_entity[i], i);

        PR_RotateEntity (roo_entity[i], roox[i], rooy[i], rooz[i]);
        PR_TransformEntity (roo_entity[i]);
        PR_RenderEntity (roo_entity[i]);

        if (i == NUMROO - 1)
          PR_PositionEntity (shadow_entity, roolx[i], baseheight[i] - 12, roolz[i]);
        else
          PR_PositionEntity (shadow_entity, roolx[i], baseheight[i] - 16, roolz[i]);
        PR_RotateEntity (shadow_entity, -90, 0, 0);
        PR_TransformEntity (shadow_entity);
        PR_RenderEntity (shadow_entity);
       }

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

   #ifndef __3DFX__
     PR_RenderFrame ();
   #endif

     PR_Flip ();
    }


  memcpy (fadepal, global_palette, 768);
  BlackPalette ();
  fading = 1;

  if (secret)
    mdeinit ();
  PR_FreeObject (jump1_shape);
  PR_FreeObject (jump2_shape);
  PR_FreeObject (jump3_shape);
  PR_FreeObject (roo_shape);

  for (i = 0; i < NUMROO; i++)
    PR_FreeEntity (roo_entity[i]);

  PR_DeleteAllWorldTextures ();
  PR_DeleteAllShadeTables ();
  PR_DeleteAllMaterials ();

  PR_AmbientLight = 0;
  PR_SetFogState (0);
  newcam->tilt_angle = 0;

  while (CheckSongPosition (0x3D, 63)) {}
}


