{ Real-Time Coders Compo }
{ Mad Max / Queue Members Group }

Uses Dos, CRT;

type
  TRGBPalette = array[0..255] of record R,G,B: Byte; end;

const
  Cell = 10;

var
  Timer : LongInt absolute $40:$6C;

procedure TDelay( Ticks: Integer );
var
  Time:         LongInt;
begin
    Time := Timer+Ticks;
    repeat until Time = Timer;
end;

procedure WaitRetrace;
begin
  repeat until (Port[$3DA] and $08) = 0;
  repeat until (Port[$3DA] and $08) <> 0;
end;

procedure SetPalette( P: Pointer );
begin
  WaitRetrace;
  asm
    push ds
    xor     al,al
    mov     dx,3c8h
    out     dx,al
    inc     dx
    mov     cx,768
    lds     si,P
    rep     outsb
    pop ds
  end;
end;

procedure CopyBar( P: Pointer; X,Y,XS,YS: Integer );
begin
  asm
    mov ax,SegA000
    mov es,ax
    push ds
    lds si,P
    mov ax,320
    mov bx,Y
    mul bx
    mov si,X
    add si,ax
    mov di,si
    mov bx,320
    sub bx,XS
    mov cx,YS
@loop_y:
    push cx
    mov cx,XS
    rep movsb
    add si,bx
    add di,bx
    pop cx
    loop @loop_y
    pop ds
  end;
end;

procedure FadeToPal( var Pal1, Pal2: TRGBPalette; Steps: Integer );
var
  I,J:          Integer;
  Pal:          TRGBPalette;
begin
  for J := 0 to Steps-1 do
  begin
    for I := 0 to 255 do
    begin
      Pal[I].R := Pal1[I].R+(Pal2[I].R-Pal1[I].R)*J div Steps;
      Pal[I].G := Pal1[I].G+(Pal2[I].G-Pal1[I].G)*J div Steps;
      Pal[I].B := Pal1[I].B+(Pal2[I].B-Pal1[I].B)*J div Steps;
    end;
    SetPalette(@Pal);
    TDelay(1);
  end;
end;

var
   f    : file;
   Pal1,
   Pal2,
   pBuf : TRGBPalette;
   iBuf : Pointer;
   hBuf : array[0..32] of byte;
   X,Y,
   I,J:     Integer;
   flag:  array[0..199 div Cell,0..319 div Cell] of Boolean;
   VStep: array[0..319] of Byte;
   Tmp:   Word;

begin
  asm
    mov     ax,0013h
    int     10h
  end;
  GetMem( iBuf, 64000 );
  FillChar(Flag,SizeOf(Flag),0);
  Assign(f,ParamStr(1));Reset(f,1);
  BlockRead(f,hBuf,32);
  BlockRead(f,pBuf,768);
  BlockRead(f,iBuf^,64000);
  FillChar( Pal1, 768, 0 );
  FillChar( Pal2, 768, 63 );
  SetPalette( @Pal1 );
  Move( iBuf^, Mem[ SegA000: 0 ], 64000 );
  FadeToPal( Pal1, Pal2, 8 );
  for I := 0 to 255 do
  begin
    Pal1[I].R := 63-(pBuf[I].R + pBuf[I].G + pBuf[I].B) div 3;
    Pal1[I].G := Pal1[I].R;
    Pal1[I].B := Pal1[I].G;
  end;
  FadeToPal( Pal2, Pal1, 4 );
  Delay(10);
  FillChar( Pal2, 768, 0 );
  FadeToPal( Pal1, Pal2, 15 );
  for I := 0 to 255 do
  begin
    Pal1[I].R := (pBuf[I].R + pBuf[I].G + pBuf[I].B) div 3;
    Pal1[I].G := Pal1[I].R;
    Pal1[I].B := Pal1[I].G;
  end;
  FadeToPal( Pal2, Pal1, 4 );
  FadeToPal( Pal1, pBuf, 20 );
  for I := 0 to 319 do
    VStep[I] := Random(20)+5;
  for I := 0 to 199 div 5 do
  begin
    for J := 0 to 319 do
    begin
      Tmp := VStep[J]*320;
      asm
        mov ax,SegA000
        mov es,ax
        mov di,64000-320
        add di,J
        mov si,di
        sub si,Tmp
@loop:
        mov al,es:[si]
        mov es:[di],al
        sub di,320
        sub si,320
        cmp si,320
        jae @loop
        mov si,Tmp
        add si,J
        xor al,al
@loop1:
        mov es:[si],al
        sub si,320
        jg @loop1
      end;
    end;
  end;
  for I := 1 to 320*200 div (Cell*Cell) do
  begin
    repeat
      X := Random(320 div Cell);
      Y := Random(200 div Cell);
    until Flag[Y][X] = False;
    Flag[Y][X] := True;
    CopyBar( iBuf, X*Cell, Y*Cell, Cell, Cell );
    Delay(5);
  end;
  ReadKey;
  close(f);
  asm
    mov ax,3
    int 10h
  end;
end.
