/*                           p p.
	    Copyright (C) 1995 by D.J. Wolf/Nimbus Studio Labs.
		 GiF-Picture by Mentat/Nimbus Studio Labs.
			    All rights reserved.                              */

#include <mtools.hpp>        // 䠩  襩 ⥪ Multimedia Toolkits v1.0.
#include <graphics.hpp>      //     cc⢥(c 
			     //y c c ;)
#include <gif.hpp>

#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/stat.h>
#include <mem.h>
#include <dos.h>
#include <psts4.hpp>

#include "nsdemo.hpp"

//pp ⨯.
#define WORD unsigned
#define DWORD unsigned long
#define HUGEPTR char huge *
#define FARPTR char far *

#define PI 3.14159265

//쭮  c쭮 pccﭨ  ⥫.
#define MAX_DIST 0
#define MIN_DIST -512

//c室 p.
#define TEXPIC01 "lab256.gif"

//p 窨, c뢠饩 業p p饭.
int xCentre,yCentre;

//p楤yp p p py  業p.
//Special thanks to Paul H. Kahler.
//pp:
//          x - p X 業p p,
//          y - p Y 業p p,
//          nAngle - y p( pyc),
//          nScale - c⠡,
//          lpImage - y⥫  p,
//          nWidth - p p,
//          nHeight - c p.
void RotateBitmap(int x,int y,int nAngle,int nScale,
		  FARPTR lpImage,int nWidth,int nHeight)
  {
   int ddx,ddy,d2x,d2y;
   int i,j;

   //c塞 p  c⭮ cc⥬ p.
   //p right  down.
   // pc   p쭮  ⭮襭  c p.
   ddx=(((long)floor(cos(nAngle*3.14159265/180)*360))*nScale)/nWidth;
   ddy=((long)(floor(sin(nAngle*3.14159265/180)*360))*nScale)/nHeight;

   d2x=(((long)floor(cos(nAngle*3.14159265/180+3.14159265/2)*360*1.2))*nScale)/nWidth;
   d2y=(((long)floor(sin(nAngle*3.14159265/180+3.14159265/2)*360*1.2))*nScale)/nHeight;

   //p 業p p饭 p.
   i=x-ddx*xCentre-d2x*yCentre;
   j=y-ddy*xCentre-d2y*yCentre;

   asm {
	push ds

	mov ax,word ptr lpImage+2
	mov ds,ax                    //ds-c pc p.

	mov ax,0xa000
	mov es,ax
	xor di,di                    //es:di - y⥫  .

	mov ax,[ddx]
	mov si,ax                   //si=ddx.

	mov cx,200                  //p p  c.
	};

   vloop:
   asm {
	push cx
	mov ax,[i]                  //p X,Y  c室 p.
	mov dx,[j]

	mov cx,320                  //c p  c.
	};

   hloop:
   asm {
	add ax,si                   //稢 祭 right-p.
	add dx,[ddy]
	mov bl,ah                   //bx = 256*y+x
	mov bh,dh
	mov bl,[ds:bx]
	mov [es:di],bl              //py c  .
	inc di

	loop hloop

	mov ax,d2x
	mov dx,d2y

	add i,ax
	add j,dx
	pop cx
	loop vloop
	pop ds
       };

  }

//p楤yp p p py  業p c cﬨ.
//Special thanks to Paul H. Kahler.
//pp:
//          x - p X 業p p,
//          y - p Y 業p p,
//          nAngle - y p( pyc),
//          nScale - c⠡,
//          lpImage - y⥫  p,
//          nWidth - p p,
//          nHeight - c p
void RotateBitmapExtra(int x,int y,int nAngle,int nScale,
		       FARPTR lpImage,int nWidth,int nHeight)
  {
   int ddx,ddy,d2x,d2y;
   int i,j;

   //c塞 p  c⭮ cc⥬ p.
   //p right  down.
   // pc   p쭮  ⭮襭  c p.
   ddx=(((long)floor(cos(nAngle*3.14159265/180)*360))*nScale)/nWidth;
   ddy=((long)(floor(sin(nAngle*3.14159265/180)*360))*nScale)/nHeight;

   d2x=(((long)floor(cos(nAngle*3.14159265/180+3.14159265/2)*360*1.2))*nScale)/nWidth;
   d2y=(((long)floor(sin(nAngle*3.14159265/180+3.14159265/2)*360*1.2))*nScale)/nHeight;

   //p 業p p饭 p.
   i=x-ddx*xCentre-d2x*yCentre;
   j=y-ddy*xCentre-d2y*yCentre;

   asm {
	push ds

	mov ax,word ptr lpImage+2
	mov ds,ax                    //ds-c pc p.

	mov ax,0xa000
	mov es,ax
	xor di,di                    //es:di - y⥫  .

	mov ax,[ddx]
	mov si,ax                   //si=ddx.

	mov cx,200                  //p p  c.
	};

   vloop:
   asm {
	push cx
	mov ax,[i]                  //p X,Y  c室 p.
	mov dx,[j]

	mov cx,320                  //c p  c.
	};

   hloop:
   asm {
	add ax,si                   //稢 祭 right-p.
	add dx,[ddy]
	mov bl,ah                   //bx = 256*y+x
	mov bh,dh
	mov bl,[ds:bx]
	mov [es:di],bl              //py c  .
	inc di

	loop hloop

	mov ax,d2x
	mov dx,d2y

	add si,2        	     //c p.

	add i,ax
	add j,dx
	pop cx
	loop vloop
	pop ds
       };

  }

//䥪 p饭 p c cﬨ.
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int TextureWarper()
  {
   char byColorMap[768];                 //⥫  py.

   //뤥塞   py p.
   if (!MakeVirtualScreen(&Scr,256,256,MEM_STANDARD))
       {
	CloseGraph();
	printf("\nNot enough memory!");
	return FALSE;
       }

   //樠 pc p.
   InitGraph("vga.drv",0);
   if (GraphResult()!=GRAPH_NO_ERROR)
       {
	CloseGraph();
	DeleteVirtualScreen(&Scr);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

    //py 䮭 p.
    SetActiveScreen(VIRTUAL_SCREEN,&Scr);
    GIFFile *gif=new GIFFile(TEXPIC01);
    if (gif->Error()!=GIF_NO_ERROR)
       {
	//H p 䠩.
	CloseGraph();
	printf("\nCan't open file %s !",TEXPIC01);
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }
    gif->LoadScreen();

    delete gif;

    //y砥 py.
    GetColorMap(byColorMap);

    SetActiveScreen(DISPLAY);

    //c⠭ py.
    SetColorMap(byColorMap);

    //p 業p p饭.
    xCentre=MaxX()/2;
    yCentre=MaxY()/2;

    WORD rot,drot;                   //  p   pp饭.
    int dist,ddist;                  //ccﭨ  ⥫   pp饭.
    int x,y;
    WORD wState;
    WORD bFlag;

    x=0;
    y=0;

    rot=0;
    drot=2;

    dist=0;
    ddist=8;

    wState=0;
    bFlag=FALSE;

    do
      {
       //p bitmap.
       if (wState>0) RotateBitmapExtra(x,y,rot,dist,Scr.RasterData.lpRealAddress,256,256);
       else RotateBitmap(x,y,rot,dist,Scr.RasterData.lpRealAddress,256,256);

       //砢 y .
       rot=rot+drot;

       y=y+128;

       //塞 c⠭.
       if (bFlag==FALSE) dist=dist-ddist;
       else dist=dist+ddist;

       if (dist>=MAX_DIST)
	  {
	   bFlag=FALSE;
	   wState++;
	  }
       if (dist<=MIN_DIST) bFlag=TRUE;

       if (wState==3 && bFlag==TRUE) FadeColorMapOnce(byColorMap,OFF,0,256);

       if (dwP5!=1) DPause(4,18);
      }
    while(!kbhit() && wState<4);          //   py y.

    DeleteVirtualScreen(&Scr);

    return TRUE;
   }

