/*                   p⬮  3D p䨪.
	    Copyright (C) 1995 by D.J. Wolf/Nimbus Studio Labs.
			    All rights reserved.                              */

#include <math.h>
#include <stdlib.h>

#include "engine3d.hpp"

#define PI 3.1415

//祭 y権 sin  cos  p 3-嬥p ꥪ.
float RotSinX,RotSinY,RotSinZ;
float RotCosX,RotCosY,RotCosZ;

//⥫  cy ꥪ.
Point3D far *ObjPtr;

//y p pyc  p.
//pp:
//          nAngle - y  pyc.
float Radian(int nAngle)
  {
   return (float)nAngle*PI/180;
  }

//p楤yp 樠樨 祭  p ꥪ.
//pp:
//          nXAngle - y p ⭮c⥫쭮 c X,
//          nYAngle - y p ⭮c⥫쭮 c Y,
//          nZAngle - y p ⭮c⥫쭮 c Z,
void SetupRotate3D(int nXAngle,int nYAngle,int nZAngle)
  {
   RotSinX=sin(Radian(nXAngle));
   RotSinY=sin(Radian(nYAngle));
   RotSinZ=sin(Radian(nZAngle));
   RotCosX=cos(Radian(nXAngle));
   RotCosY=cos(Radian(nYAngle));
   RotCosZ=cos(Radian(nZAngle));
  }

//p楤yp p 3-嬥p ꥪ.
//p砭: p砫쭮 室 c SetupRotate3D.
//pp:
//          CrntObj - y⥫  ⥪y騩 3D-ꥪ,
//          CrntObj - y⥫  3D-ꥪ c p,
//          nSizeObj - pp ꥪ.
void Rotate3DObject(Point3D far *CrntObj,
		    Point3D far *RotatedObj,
		    int nSizeObj)
  {
   for (int i=0;i<nSizeObj;i++)
      {
       RotatedObj[i].x=CrntObj[i].x*(RotSinY*RotSinZ*RotSinX+RotCosY*RotCosX)+
		       CrntObj[i].y*(RotCosZ*RotSinX)+CrntObj[i].z*(RotCosY*RotSinZ*RotSinX-
		       RotCosX*RotSinY);

       RotatedObj[i].y=CrntObj[i].x*(RotCosX*RotSinY*RotSinZ-RotCosY*RotSinX)+
		       CrntObj[i].y*(RotCosZ*RotCosX)+CrntObj[i].z*(RotCosY*RotCosX*RotSinZ+
		       RotSinY*RotSinX);

       RotatedObj[i].z=CrntObj[i].x*(RotCosY*RotSinZ*RotSinX-RotCosX*RotSinY)+
		       CrntObj[i].y*(-RotSinZ)+CrntObj[i].z*(RotCosY*RotCosZ);
      }
  }

//p楤yp cp p Z y 祪.
//cyc  ZSort3DObject.
int ZSortFunction(const void *a,const void *b)
  {
   if (ObjPtr[*(int*)a].z<ObjPtr[*(int*)b].z) return -1;
   return 1;
  }

//p楤yp Z-cpp ⥪y饣 ꥪ.
//pp:
//          SortList - cc 祪 ꥪ   c cpp,
//          Obj - cppy 3D-ꥪ,
//          nSizeObj - pp ꥪ.
void ZSort3DObject(int far *SortList,
		   Point3D far *Obj,
		   int nSizeObj)
  {
   ObjPtr=Obj;

   qsort((int *)SortList,nSizeObj,sizeof(int),ZSortFunction);
  }

//p楤yp pcp樨  ꥪ  py.
//pp:
//          CrntObj - ⥪y騩 ꥪ,
//          TransObj - y ꥪ,
//          nSizeObj - pp ꥪ.
void Transform3DObject(Point3D far *CrntObj,
		       Point3D far *TransObj,
		       int nSizeObj)
   {
    for(int i=0;i<nSizeObj;i++)
       {
	int dx,dy,dz;             //pp饭  p c  pcppy
				  //ꥪ.

	dx=TransObj[i].x-CrntObj[i].x;
	dy=TransObj[i].y-CrntObj[i].y;
	dz=TransObj[i].z-CrntObj[i].z;

	//H  y    横.
	if (dx>2) dx=2;
	if (dx<-2) dx=-2;

	if (dy>2) dy=2;
	if (dy<-2) dy=-2;

	if (dz>2) dz=2;
	if (dz<-2) dz=-2;

	CrntObj[i].x+=dx;
	CrntObj[i].y+=dy;
	CrntObj[i].z+=dz;
       }
   }
