{$M 16384,0,0}

USES Crt, Dos;




FUNCTION GetYN : BOOLEAN;
  VAR
    ch, c : CHAR;
  BEGIN
    ch := #0;
    REPEAT
      ch := ReadKey; IF ch = #0 THEN c := ReadKey;
      IF ch = #27 THEN HALT(1);
      ch := UpCase(ch);
    UNTIL (ch = 'N') OR (ch = 'Y') OR (ch = 'S');

    GetYN := ch <> 'N';
  END;


FUNCTION GetAnswer(n: WORD) : WORD;
  VAR
    ch, c : CHAR;
  BEGIN
    ch := #0;
    REPEAT
      ch := ReadKey; IF ch = #0 THEN c := ReadKey;
      IF ch = #27 THEN HALT(1);
    UNTIL (ch >= '1') AND (ch <= CHAR(n+BYTE('0')));

    GetAnswer := BYTE(ch) - BYTE('0');
  END;




CONST
  SterTabl : ARRAY[1..8] OF BOOLEAN =
    ( FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE );
  DevTabl  : ARRAY[1..8] OF STRING[40] =
    (
      'Speaker',
      'AdLib',
      'DAC-SB',
      'DAC-Mono',
      'DAC-Stereo',
      'SBlaster-Mono',
      'DMA-SB-Mono',
      'DMA-SB-Stereo'
    );
  Frectabl : ARRAY[1..8] OF STRING[5] =
    (
      '8000',
      '10000',
      '12000',
      '14000',
      '16000',
      '18000',
      '20000',
      '22000'
    );

VAR
  i : WORD;
  p : STRING;
  parm : TEXT;

LABEL
  doit;

BEGIN

  WriteLn;
  WriteLn('           Sound initialisation procedure.');

  p := '';

  Assign(parm, 'FIRE.CFG');
  Reset(parm);
  ReadLn(parm, p);
  Close(parm);
  IF IOresult = 0 THEN ;

  IF p <> '' THEN BEGIN
     WriteLn;
     WriteLn(' Do you want to use the last setup?');
     IF GetYN THEN GOTO doit
  END;

  WriteLn;
  WriteLn('Please, select a sound device:');
  WriteLn;
  WriteLn(' [1] PC Internal Speaker');
  WriteLn(' [2] AdLib sound card');
  WriteLn(' [3] DAC + SB (stereo)');
  WriteLn(' [4] DAC mono on LPT1');
  WriteLn(' [5] DAC stereo on LPT1 - LPT2');
  WriteLn(' [6] NON-DMA Sound Blaster');
  WriteLn(' [7] DMA Mono Sound Blaster');
  WriteLn(' [8] DMA Stereo SB Pro or SB 16');

  i := GetAnswer(8);

  IF SterTabl[i] THEN
    BEGIN
      WriteLn;
      WriteLn('Do you want any stereo mixing?');
      IF GetYN THEN
        BEGIN
          WriteLn;
          WriteLn('Do you want the softer stereo mix?');
          IF GetYN THEN
            p := '/d:Mix-'+DevTabl[i]
          ELSE
            p := '/d:Mix2-'+DevTabl[i];
        END
      ELSE
        p := '/d:'+DevTabl[i];
    END
  ELSE
    BEGIN
      p := '/d:'+DevTabl[i];

      WriteLn;
      WriteLn('Do you want to have a loudness filter?');
      WriteLn('(It slows down the demo, but sounds better on a good amplifier)');
      IF GetYN THEN p := p + ' /bfil';
    END;                             

  WriteLn;
  WriteLn('Select a sampling frequency:');
  WriteLn;
  WriteLn(' [1]  8000 Hz');
  WriteLn(' [2] 10000 Hz');
  WriteLn(' [3] 12000 Hz');
  WriteLn(' [4] 14000 Hz');
  WriteLn(' [5] 16000 Hz');
  WriteLn(' [6] 18000 Hz');
  WriteLn(' [7] 20000 Hz');
  WriteLn(' [8] 22000 Hz');

  i := GetAnswer(8);

  p := p + ' /f:'+FrecTabl[i];

  WriteLn;
  WriteLn('Do you want to boost up the volume?');

  IF NOT GetYN THEN p := p + ' /v:63';

  p := p + ' /hq * /sh:Fire.Exe';

  Assign(parm, 'FIRE.CFG');
  ReWrite(parm);
  WriteLn(parm, p);
  Close(parm);
  IF IOresult = 0 THEN ;

doit:
  Exec('ShellVT.Exe', p);

END.
