#include "pmc.h"
#include "dflib.h"

DWORD   vga_segment;

BYTE pal[51] = {
0, 0, 0,
8, 8, 8,
12,12,12,
16,16,16,
20,20,20,
24,24,24,
28,28,28,
32,32,32,
35,35,35,
39,39,39,
43,43,43,
47,47,47,
51,51,51,
55,55,55,
57,57,57,
59,59,59,
59,59,59
};

void    __cdecl setpalette(BYTE start,DWORD ncolors,PTR palette)
{
    asm {
        mov     esi,[palette]
        mov     ecx,[ncolors]
        mov     dx,03c8h
        mov     al,[start]
        out     dx,al
        mov     eax,3
        mul     ecx
        mov     ecx,eax
        mov     dx,03c9h
        rep     outsb
    }
}

void __cdecl init_mode13(void)
{
    REGSTRUCT   rs;

    vga_segment=rlp(0xa0000);

    rs.w.FLAGS=rs.d.SSSP=0;
    rs.w.AX=0x13;

    xlt_simrmint(0x10,&rs,0);
    setpalette(0,17,pal);
}

void __cdecl init_mode3(void)
{
    REGSTRUCT   rs;

    rs.w.FLAGS=rs.d.SSSP=0;
    rs.b.AH=0;
    rs.b.AL=3;

    xlt_simrmint(0x10,&rs,0);
}

void __cdecl copy_bob(DWORD x,DWORD y,PTR bob)
{
    asm {
        mov     esi,[bob]
        mov     edi,[vga_segment]
        add     edi,[x]
        mov     eax,320
        mul     [y]
        add     edi,eax

        lodsw
        movzx   ecx,ax              // bitmap width
        lodsw
        movzx   ebx,ax              // bitmap height

        mov     edx,320             // modulo
        sub     edx,ecx
    }
l1:
    asm push    ecx
l2:
    asm {
        lodsb
        cmp     al,0
        je      nodraw
        mov     [edi],al
    }
nodraw:
    asm {
        inc     edi
        loop    l2

        pop     ecx
        add     edi,edx
        dec     ebx
        jnz     l1
    }
}

void __cdecl PMmain (void)
{
    DATAFILE *dfile;
    WORD    file;
    BYTE    libname[256];
    STR     tname;
    PTR     buffer;

    tname=getexe();
    strcpy(libname,tname);

    if(file=df_open(libname)) {
        if(dfile=df_getinfos(file)) {
            if(buffer=df_read(file,dfile,"digital1.raw",NULL)) {
                init_mode13();
                copy_bob(37,57,buffer);
                getch();
                init_mode3();
                free(buffer);
            }
            df_delinfos(dfile);
        }
        df_close(file);
    }
}

