#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>

#define CHAR_WIDE   8
#define CHAR_HIGH   8
#define MAX_CHAR  256

#define CHAR_SIZE ((CHAR_HIGH * CHAR_WIDE) / 8)

#define CHAR_FILL 0xDB

// Global Variables
unsigned char charmap[MAX_CHAR][CHAR_SIZE];


// Function Prototypes
void main(void);
void init(void);
int  load(char *fname);
int  save(char *fname);
void showchar(int curr_char, int xpos, int ypos);


void
init(void)
{
    memset(charmap, 0, (MAX_CHAR * CHAR_SIZE));
}


int
load(char *fname)
{
    FILE *fp;
    int i;

    fp = fopen(fname, "rb");

    for (i = 0; i < MAX_CHAR; i++) {
        fread(&charmap[i][0], CHAR_SIZE, 1, fp);
    }

    fclose(fp);

    return 1;
}


int
save(char *fname)
{
    FILE *fp;
    int i;

    fp = fopen(fname, "wb");

    for (i = 0; i < MAX_CHAR; i++) {
        fwrite(&charmap[i][0], CHAR_SIZE, 1, fp);
    }

    fclose(fp);

    return 1;
}


void
main(void)
{
    unsigned char byte;
    int temp, done, curr_char, xpos, ypos;

    clrscr();

    init();

	done = 0;
    curr_char = 0;
    xpos = 0;
    ypos = 0;

    load("vga8x8.fnt");

    while (!done) {
        showchar(curr_char, xpos, ypos);

        byte = toupper(getch());

        switch (byte) {
            case 'I':
                init();
                break;

            case 'C':
                memset(charmap[curr_char], 0, CHAR_SIZE);
                break;

            case 'L':
                load("vga8x8.fnt");
                break;

            case 'S':
                save("vga8x8.fnt");
                break;

            case 'Q':
                done = 1;
                break;

            case ' ':
                temp = (ypos * CHAR_WIDE) + xpos;
                charmap[curr_char][temp / 8] ^= (0x01 << (temp % 8));
                break;

            case '>':
                curr_char = (curr_char + MAX_CHAR + 1) % MAX_CHAR;
                break;

            case '<':
                curr_char = (curr_char + MAX_CHAR - 1) % MAX_CHAR;
                break;

            case '7':
                xpos = (xpos + CHAR_WIDE - 1) % CHAR_WIDE;
                ypos = (ypos + CHAR_HIGH - 1) % CHAR_HIGH;
                break;

            case '8':
                ypos = (ypos + CHAR_HIGH - 1) % CHAR_HIGH;
                break;

            case '9':
                xpos = (xpos + CHAR_WIDE + 1) % CHAR_WIDE;
                ypos = (ypos + CHAR_HIGH - 1) % CHAR_HIGH;
                break;

            case '4':
                xpos = (xpos + CHAR_WIDE - 1) % CHAR_WIDE;
                break;

            case '6':
                xpos = (xpos + CHAR_WIDE + 1) % CHAR_WIDE;
                break;

            case '1':
                xpos = (xpos + CHAR_WIDE - 1) % CHAR_WIDE;
                ypos = (ypos + CHAR_HIGH + 1) % CHAR_HIGH;
                break;

            case '2':
                ypos = (ypos + CHAR_HIGH + 1) % CHAR_HIGH;
                break;

            case '3':
                xpos = (xpos + CHAR_WIDE + 1) % CHAR_WIDE;
                ypos = (ypos + CHAR_HIGH + 1) % CHAR_HIGH;
                break;
        }
    }

    clrscr();
}


void
showchar(int curr_char, int xpos, int ypos)
{
    unsigned char far *screen;
    unsigned char *bufptr;
    int i, j, temp;

    FP_SEG(screen) = 0xB800;
    FP_OFF(screen) = 0x0000;

    *screen++ = (curr_char / 100) + '0';
    *screen++ = 0x0F;
    *screen++ = ((curr_char % 100) / 10) + '0';
    *screen++ = 0x0F;
    *screen++ = (curr_char % 10) + '0';
    *screen++ = 0x0F;

    screen += 4;

    *screen++ = curr_char;
    *screen++ = 0x0F;

    FP_OFF(screen) = (160 * 3) + 8;

    for (i=0; i < (CHAR_WIDE + 1); i++) {
        *screen++ = '-';
        *screen++ = 0x02;
        *screen++ = '-';
        *screen++ = 0x02;
    }

    for (i=0; i < CHAR_HIGH; i++) {
        FP_OFF(screen) = (160 * (i + 4)) + 8;

        *screen++ = '|';
        *screen++ = 0x02;

        for (j=0; j < CHAR_WIDE; j++) {
            temp = (i * CHAR_WIDE) + j;

            if ( charmap[curr_char][temp / 8] & (0x01 << (temp % 8)) ) {
                *screen++ = CHAR_FILL;
                *screen++ = 0x0F;
                *screen++ = CHAR_FILL;
                *screen++ = 0x0F;
            } else {
                *screen++ = ' ';
                *screen++ = 0x0F;
                *screen++ = ' ';
                *screen++ = 0x0F;
            }
        }

        *screen++ = '|';
        *screen++ = 0x02;
    }

    FP_OFF(screen) = (160 * (CHAR_HIGH + 4)) + 8;
    for (i=0; i < (CHAR_WIDE + 1); i++) {
        *screen++ = '-';
        *screen++ = 0x02;
        *screen++ = '-';
        *screen++ = 0x02;
    }

    FP_OFF(screen) = (160 * (ypos + 4)) + (xpos * 4) + 11;
    *screen++ = 0x72;
    screen++;
    *screen++ = 0x72;
}

