.data
  us mouse_user <>
.code
;this proc is called every time the mouse moves or a button is pressed/released
;NOTE:this is called in an IRQ!!  (so don't do any file IO, ok? - just
;don't do anything that calls DOS)
user proc
  mov ax,us.x
  mov bx,us.y
  mov cx,us.but
;the following changes the mouse ptr if it's in the BOX
  .if (ax>100) && (ax<200) && (bx>110) && (bx<199)
    .if bpp==8
      callp mouse_setcursor,offset cursor8a,9,9,0,0
    .elseif bpp==16 || bpp==15
      callp mouse_setcursor,offset cursor16a,8,8,0,0
    .elseif bpp==24
      callp mouse_setcursor,offset cursor24a,8,8,0,0
    .else
      callp mouse_setcursor,offset cursor32a,8,8,0,0
    .endif
  .else
    .if bpp==8
      callp mouse_setcursor,offset cursor8b,9,9,0,0
    .elseif bpp==16 || bpp==15
      callp mouse_setcursor,offset cursor16b,8,8,0,0
    .elseif bpp==24
      callp mouse_setcursor,offset cursor24b,8,8,0,0
    .else
      callp mouse_setcursor,offset cursor32b,8,8,0,0
    .endif
  .endif
  ret
user endp

exit_error proc
    callp printf,a
    callp exit,0
exit_error endp

exit_on_null macro a:REQ
  .if eax==NULL
    callp exit_error,a
  .endif
endm

exit_on_error macro a:REQ
  .if eax==ERROR
    callp exit_error,a
  .endif
endm

grafix_test proc
  call clrscr
top:
  callp printf,"Grafix Mode Tests\n\n"
  callp printf,"Enter X Res (ie: 320,640,800,etc.) :>"
  callp gets,offset tmpstr
  callp atol,offset tmpstr
  mov x,eax
  callp printf,"Enter Y Res (ie: 200,480,600,etc.) :>"
  callp gets,offset tmpstr
  callp atol,offset tmpstr
  mov y,eax
  callp printf,"Enter BPP (ie: 8,16,24,etc.) :>"
  callp gets,offset tmpstr
  callp atol,offset tmpstr
  mov bpp,al
  .if ! (al==32 || al==24 || al==16 || al==15 || al==8)
    jmp not_avail
  .endif
  .if x<320 || y<200 || bpp<8
    jmp not_avail
  .endif
  mov eax,x
  mul y
  .if bpp == 24
    lea eax,[eax+eax*2]  ;*3
  .elseif bpp == 32
    shl eax,2   ;*4
  .elseif bpp==16 || bpp==15
    shl eax,1   ;*2
  .endif

  callp calloc,eax,1
  exit_on_null "Out of memory"
  mov tvid,eax
  callp g_setbuf,tvid

  callp mouse_setuser,offset user,offset us

  .if bpp==24
    callp mouse_setcursor,offset cursor24a,9,9,0,0
    callp g_loadfnt,offset font24
  .elseif bpp==32
    callp mouse_setcursor,offset cursor32a,9,9,0,0
    callp g_loadfnt,offset font32
  .elseif bpp==16 || bpp==15
    callp mouse_setcursor,offset cursor16a,9,9,0,0
    callp g_loadfnt,offset font16
  .else
    callp mouse_setcursor,offset cursor8a,9,9,0,0
    callp g_loadfnt,offset font8
  .endif
  mov fontbuf,eax
  exit_on_error "Unable to load FONT file!"

;int 3
  callp g_getmode,x,y,bpp
  .if eax==ERROR
not_avail:
    callp printf,"\nVideo mode not supported!\n Press a key..."
    call sleep
    ret
  .endif
  mov mode,al
  callp g_setmode

  callp g_printf,10,0,"Video Type ="
  .if mode==G_VGA
    callp g_printf,110,0,"VGA"
  .elseif mode==G_VESA
    callp g_printf,110,0,"VESA"
  .elseif mode==G_MODEX
    callp g_printf,110,0,"ModeX"
  .else
    callp g_printf,110,0,"???"
  .endif

  callp g_printf,10,10,"Video Mode %dx%d %dbit",x,y,bpp

  callp g_printxy,10,30,"Press keys to move on..."
  callp g_printxy,10,50,"Mouse Window : (50,50)-(100,100)"
  .if bpp==24 || bpp==32
    mov eax,0ffffffh  ;24bit color
  .else
    mov eax,15
  .endif
  callp g_box,100,110,200,199,eax
  callp g_printxy,102,112,"User Defined"
  callp g_printxy,102,122," area"
  call g_copy

  callp mouse_setwin,50,50,100,100  ;must reset size before mouse_on
  callp mouse_setspd,1,1
  call mouse_on
  call sleep

  callp g_printxy,10,60,"Full Window"
  call g_copy
  mov ebx,x
  mov ecx,y
  dec ebx
  dec ecx
  callp mouse_setwin,0,0,ebx,ecx
  call sleep

  callp g_printxy,10,70,"Half Speed"
  call g_copy
  callp mouse_setspd,2,2
  call sleep

  callp g_printxy,10,80,"Move mouse to (100,100)"
  .if bpp>8
    callp g_printxy,10,90,"Press a key to quit"
  .endif
  call g_copy
  callp mouse_setpos,100,100
  call sleep

  .if bpp==8
    callp g_printxy,10,90,"Hold in buttons to change color:"
    callp g_printxy,10,100,"Press a key to quit"
    call g_copy
    mov ccol,63
    .repeat
      mov cx,us.but
      .if (cl & 1)
        inc ccol
      .endif
      .if (cl & 2)
        dec ccol
      .endif
      .if ccol==64
        mov ccol,0
      .elseif ccol==255
        mov ccol,63
      .endif

      callp g_setcol,1,0,0,ccol
      call kbhit
    .until al
    call getch
  .endif
done:
  call mouse_off
  callp g_setmode,3
  callp free,tvid
  callp free,fontbuf
  ret
grafix_test endp

