include qlib.inc

.code

;this converts a linear addr into a linear addr
alloc_phys proc,loc:dword,siz:dword
  .if !siz || !loc
    mov eax,NULL
    ret
  .endif
  pushad
  mov ax,800h
  mov ebx,loc
  mov cx,bx
  shr ebx,16    ;bx:cx
  mov esi,siz
  mov di,si
  shr esi,16    ;si:di
  int 31h
  .if carry?
    popad
    mov eax,NULL
    ret
  .endif
  shl ebx,16
  mov bx,cx
  mov [esp+7*4],ebx  ;save EAX for return
  popad
  ret
alloc_phys endp

free_phys proc,lin:dword
  .if _dosXtyp==DOSX_DOS32
    mov eax,NULL  ;there is no way to free this under DOS32 v3.5
    ret
  .endif
  pushad   ;FIX : v2.00 Beta #5
  mov ax,801h
  mov ebx,lin
  mov cx,bx
  shr ebx,16     ;bx:cx
  int 31h
  popad
  .if carry?
    mov eax,ERROR
    ret
  .endif
  xor eax,eax
  ret
free_phys endp

end



