// see video.txt for what is returned and what is needed in regs

#ifndef __VIDEO_H__
#define __VIDEO_H__

#include <stddef.h>

#include <vesa.h>

//video sub-system
extern sbyte g_getmode (word,word,byte);
extern void g_setmode (void);
extern sbyte t_setmode (byte,byte);

extern void g_copy (void);      //copies buffer to VRAM
extern void g_setbuf (dword);
extern void g_setpal (void *);
extern void g_setcol (byte n,byte r,byte g,byte b);
extern void g_get (dword a,word x,word xl,word y,word yl);
extern void g_put (dword a,word x,word xl,word y,word yl);
extern void g_put0 (dword a,word x,word xl,word y,word yl);
extern void g_waitvsync (void);

extern sbyte mouse_init (void);
extern void mouse_uninit (void);
extern void mouse_setcursor (dword a,word x,word y,word hx,word hy);
extern void mouse_setcursor_text (byte);
extern void mouse_setspd (byte x,byte y);
extern void mouse_setwin (word x1,word y1,word x2,word y2);
extern void mouse_on (void);
extern void mouse_off (void);
struct mouse_user {
  word x;
  word y;
  word but;
};

extern void mouse_setuser (dword,struct mouse_user*);
extern void mouse_setpos (word x,word y);

extern sbyte g_loadfnt (byte *n,word x,word y,dword buf);
extern void g_setfnt (word x,word y,dword buf);
extern void g_putch (word x,word y,byte ch);
extern void g_printxy (word x,word y,byte *s);
extern void g_printf (dword x,dword y,byte* str1,...);

extern void g_hline (word x,word y,word len,byte col);
extern void g_vline (word x,word y,word len,byte col);
extern void g_box (word x,word xl,word y,word yl,byte col);
extern void g_boxfill (word x,word xl,word y,word yl,byte col);
extern void g_cls (void);

extern dword _v_buffer;   //buffer you have alloc (set by gset();)
extern dword _v_linear;   //linear addr to VRAM (may not be 0a0000h under VESA 2.0)

//vesa
extern byte vesa_init(void);
extern void vesa_func06(void);
extern void vesa_setstart(dword,dword);
extern byte vesa_firstmode(void);
extern byte vesa_nextmode(void);

extern struct vesa_infoblock vesa_info;
extern struct vesa_modeinfoblock vesa_modeinfo;

//FONT HEADER!!  Added in QLIB v1.1
struct fnthead {
  byte head[4];   //='FNT',27
  word x;
  word y;
  byte bpp;   //bits / pixel  (ignored)
  byte bypp;  //bytes / pixel
  byte flg;   //must = 0 (compression? other formats?)
};

#define G_TEXT 1
#define G_VGA 2
#define G_VESA 3
#define G_MODEX 4

#endif
