/*

Ver 1.01 : compiled w/ qlib making it 32bit
    1.01a : compiled w/ PMODE/w v1.31
    1.01b : updated usage()
*/

#include <qlib.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>

void usage(void) {
  printf("  Usage : FS infile outfile1 outfile2 [length]\n");
  printf("   infile = file to split into 2\n");
  printf("   outfile1 = 1st part\n");
  printf("   outfile2 = 2nd part\n");
  printf("   length=size of outfile1 [default=1/2 sizeof(infile)]\n");
  exit(0);
}

void error(byte *m){
  printf("Error:");
  print(m);
  exit(0);
};

word main(byte argc,byte **args) {
  int hi,ho1,ho2,b;
  dword len,a;
  byte buf[2048];

  printf("File Splitter v1.01b  32bit   by:Peter Quiring\n");
  if ((argc>5)||(argc<4)) usage();
  hi=open(args[1],O_RDONLY|O_BINARY);
  if (hi==-1) error("Opening infile");
  a=filelength(hi);
  if (argc==5) {
    len=atoi(args[4]);
    if (len>a) error("Invalid length");
  }else len=(int)(a / 2);
  ho1=creat(args[2],FA_ARCH);
  if (ho1==-1) error("Opening outfile1");
  ho2=creat(args[3],FA_ARCH);
  if (ho2==-1) error("Opening outfile2");
  a=0;
  b=1;
  do{
    if (len-a>2048) b=read(hi,buf,2048);
      else b=read(hi,buf,len-a);
    if (b==-1) error("Reading infile");
    b=write(ho1,buf,b);
    if (b==-1) error("Writing outfile1");
    a+=b;
  }while (a<len);
  close(ho1);
  do{
    b=read(hi,buf,2048);
    if (b==-1) error("Reading infile");
    if (b) b=write(ho2,buf,b);
    if (b==-1) error("Writing outfile2");
  }while (b);
  close(ho2);
  return 0;
}
