
// Programa EFECTO1.CPP
// por FAC

// Este programa corresponde al cuarto tutorial de grficos FAC

// Realiza un efecto sobre un bitmap usando una matriz de transformacin


#include <iostream.h>      // cout
#include <conio.h>         // clrscr, getch
#include <math.h>          // sin, cos
#include "mode13.h"
#include "mode13.cpp"


typedef int TMatrix[161][161];

byte far Image[120][160];
TMatrix far TransX;
TMatrix far TransY;
TPalette pal;
int xp, yp, n;
PTVirtual VirScr;
word VirSeg;
float SinT[361], CosT[361];


int sgn(int n)
{
     if (n > 0) return 1; else if (n < 0) return -1; else return 0;
}


void SetTrigTables()
{
     int ang;

     for (ang = 0; ang <= 360; ang++)
     {
          SinT[ang] = sin(ang * 3.14159265 / 180);
          CosT[ang] = cos(ang * 3.14159265 / 180);
     }
}


void SetTransMatrix()
{
     int x, y, a, b;
     long d;

     for (x = -80; x <= 80; x++)
         for (y = -80; y <= 80; y++)
         {
               d = (long)((x * x + y * y) / 640.0);
               a = (int)((x + 80) * 36 / 16.0);
               b = (int)((y + 80) * 36 / 16.0);
               TransX[y+80][x+80] = (int)(SinT[a] * (d * sgn(x)));
               TransY[y+80][x+80] = (int)(SinT[b] * (d * sgn(y)));
         }
}


void LoadImage()
{
     word x, y;

     LoadPCX("pic1.pcx", VirSeg, 120, 160, 0, 0, pal);
     for (x = 0; x < 120; x++)
         for (y = 0; y < 160; y++)
             Image[x][y] = GetPixel(x, y, VirSeg);
     ClearScreen(0, VirSeg);
}


void DrawImage(int xpos, int ypos)
{
     byte x, y;
     int u, v, x1, y1;

     for (x = 0; x < 120; x++)
         for (y = 0; y < 160; y++)
         {
               u = (x >> 2) + xpos + 65;
               v = (y >> 2) + ypos + 60;

               x1 = x + TransX[u][v];
               y1 = y + TransY[u][v];
               if (x1 > 119) x1 = 119; else if (x1 < 0) x1 = 0;
               if (y1 > 159) y1 = 159; else if (y1 < 0) y1 = 0;

               PutPixel(x + 100, y + 20, Image[x1][y1], VirSeg);
         }

     VRetrace();
     CopyScreen(VirSeg, VGA);
}


void main()
{
     clrscr();
     cout << "\nPrograma que muestra cmo realizar un efecto sobre un\n"
          << "bitmap usando una matriz de transformacin.\n"
          << "\nPresiona una tecla para continuar...\n";
     getch();

     SetupVirtual(VirScr, VirSeg);
     SetMode13();

     LoadImage();
     SetTrigTables();
     SetTransMatrix();
     SetPalette(pal);

     n = 0;
     while (!kbhit())
     {
          xp = (int)(SinT[n * 3] * 65);
          yp = (int)(CosT[n * 3] * 60);
          DrawImage(xp, yp);
          if (++n > 119) n = 0;
     }

     getch();
     ShutDownVirtual(VirScr);
     SetTextMode();
}
