
// PLASMA1.CPP  --  Ejemplo de plasma en tiempo real  --  por FAC

#include <iostream.h>       // cout
#include <conio.h>          // clrscr, getch, kbhit
#include <math.h>           // sin, cos, exp
#include <stdlib.h>         // randomize, random, exit
#include <dos.h>            // MK_FP
#include "mode13.h"
#include "mode13.cpp"

#define Pi 3.14159265

TPalette pal;
PTVirtual VirScr;
word VirSeg;
byte ColorTable1[256];
byte ColorTable2[320];
byte pos1, pos2, pos3, pos4;


void InitPlasma()
{
     word i;

     if (!SetupVirtual(VirScr, VirSeg)) exit(EXIT_FAILURE);
     SetMode13();
     FadeOut(0);

     for (i = 0; i < 64; i++)
     {
          pal[i][0] = (63 - i) / 16;
          pal[i][1] = pal[i][2] = 0;
     }
     for (i = 0; i < 32; i++)
     {
          pal[i + 64][0] = i;
          pal[i + 64][1] = pal[i + 64][2] = 0;

          pal[i + 96][0] = 31 - i;
          pal[i + 96][1] = pal[i + 96][2] = 0;
     }

     for (i = 0; i < 256; i++)
         ColorTable1[i] = cos(2 * Pi * i / 256.0) * 31 + 32;

     for (i = 0; i < 320; i++)
         ColorTable2[i] = sin(i / 100.0) * exp(i / 240.0) * i * 2.5;
}


void DrawPlasma()
{
     int i, j;
     byte p1, p2, color;
     byte *off = (byte *) MK_FP(VirSeg, 0);
     byte p3 = pos3;
     byte p4 = pos4;

     for (i = 0; i < 200; i++)
     {
          p1 = pos1;
          p2 = pos2;
          for (j = 0; j < 320; j++)
          {
               color = ColorTable1[p1] + ColorTable1[p2] + ColorTable1[p3] +
                       ColorTable1[p4] + ColorTable2[i] + ColorTable2[j];
               *(off++) = color >> 1;
               p1 += 3;
               p2 += 2;
          }
          p3 += 3;
          p4 += 2;
     }
}


void MovePlasma()
{
     pos1 += random(3) - 4;
     pos2 += random(3) - 1;
     pos3 += random(3) + 3;
     pos4 -= random(3);
}


void DoPlasma()
{
     SetPalette(pal);
     while (!kbhit())
     {
          DrawPlasma();
//        VRetrace();
          CopyScreen(VirSeg, VGA);
          MovePlasma();
     }
     getch();
}


void main()
{
     clrscr();
     cout << "\nEjemplo de plasma en tiempo real\n"
          << "\nPresiona una tecla...\n";
     getch();

     InitPlasma();
     DoPlasma();
     FadeOut(5);
     SetTextMode();
     ShutDownVirtual(VirScr);
}
