
//  MODE13.H
//  por FAC

//  Contiene las definiciones de las funciones para trabajar en el modo 13h
//  utilizadas en los tutoriales de grficos FAC.

#ifndef __MODE13

#define __MODE13

#include <dos.h>         // MK_FP, geninterrupt


// Tipos y constantes utilizadas:

typedef unsigned char byte;
typedef unsigned int word;

typedef byte TColor[3];
typedef TColor TPalette[256];

const word VGA = 0xA000;
const byte *pVGA = (byte *) MK_FP(0xA000, 0);

const mText = 0;
const m13h = 1;

const Long = 0x66;

word YOffset[200];

byte CurrentMode;

// Funciones para cambiar el modo grfico

void SetMode13();
void SetTextMode();

// Funciones de dibujo

void ClearScreen(byte color, word where);
void PutPixel(word x, word y, byte color, word where);
byte GetPixel(word x, word y, word where);

void HLine(word x1, word x2, word y, byte color, word where);
void Line(word x1, word y1, word x2, word y2, byte color, word where);

// Funciones de paleta

void GetPal(byte color, byte &R, byte &G, byte &B);
void SetPal(byte color, byte R, byte G, byte B);
void GetPalette(TPalette &pal);
void SetPalette(TPalette pal);

void RotatePalette(TPalette &pal, byte first, byte last);
void FadeOut(word d);
void FadeTo(TPalette pal, word d);

// Pantallas virtuales

typedef byte far *PTVirtual;

PTVirtual SetupVirtual(PTVirtual &VScr, word &VSeg);
void ShutDownVirtual(PTVirtual &VScr);
void CopyScreen(word source, word dest);

// Funciones diversas

void VRetrace();
void LoadPCX(const char *fn, word where, word dimX, word dimY,
             word offX, word offY, TPalette &pal);


#endif
