
//  LLAMAS3.CPP  --  por FAC
//  Ejemplo del efecto de llamas y "flamazo"

#include <iostream.h>     // cout
#include <conio.h>        // clrscr, getch, kbhit
#include <dos.h>          // MK_FP
#include <stdlib.h>       // randomize, random, exit
#include "mode13.h"
#include "mode13.cpp"


#define ColorSemilla 255
#define ColorSemilla2 160


PTVirtual DestScr, OrigScr;
word Destino, Origen;
TPalette pal;
char key;
int flag, flamazo;


void GeneraPaleta()
{
     byte i;

     for (i = 0; i < 16; i++)
     {
          pal[i][0] = pal[i][2] = i;
          pal[i][1] = 0;

          pal[i + 16][0] = pal[i + 16][2] = 15 - i;
          pal[i + 16][1] = 0;
     }
     for (i = 0; i < 64; i++)
     {
          pal[i + 32][0] = i;
          pal[i + 32][1] = pal[i + 32][2] = 0;

          pal[i + 96][0] = 63;
          pal[i + 96][1] = i;
          pal[i + 96][2] = 0;

          pal[i + 160][0] = pal[i + 160][1] = 63;
          pal[i + 160][2] = i;

          pal[i + 224][0] = pal[i + 224][1] = pal[i + 224][2] = 63;
     }
}


void LineaH(int x1, int x2, int y)
{
     byte *off = (byte *) MK_FP(Origen, YOffset[y] + x1);

     for (int i = x1; i <= x2; i++)
         *(off++) = random(2) * ColorSemilla2;
}

void LineaV(int x, int y1, int y2)
{
     byte *off = (byte *) MK_FP(Origen, YOffset[y1] + x);

     for (int i = y1; i <= y2; i++)
     {
          *off = random(2) * ColorSemilla2;
          off += 320;
     }
}


void DibujaFAC()
{
     LineaH(20, 100, 50);
     LineaH(20, 80, 100);
     LineaV(20, 50, 150);

     LineaH(120, 200, 50);
     LineaH(120, 200, 100);
     LineaV(120, 50, 150);
     LineaV(200, 50, 150);

     LineaH(220, 300, 50);
     LineaH(220, 300, 150);
     LineaV(220, 50, 150);
}


void IniciaLlamas()
{
     if (!SetupVirtual(DestScr, Destino)) exit(EXIT_FAILURE);
     if (!SetupVirtual(OrigScr, Origen)) exit(EXIT_FAILURE);
     ClearScreen(0, Origen);
     ClearScreen(0, Destino);
     for (int x = 0; x < 320; x++)
     {
          PutPixel(x, 198, random(2) * ColorSemilla, Origen);
          PutPixel(x, 199, random(2) * ColorSemilla, Origen);
     }
}


void MueveLlamas()
{
     word x, y;
     int color;
     byte *offO = (byte *) MK_FP(Origen, 1);
     byte *offD = (byte *) MK_FP(Destino, 1);

     for (y = 0; y < 198; y++)
     {
          for (x = 1; x < 319; x++)
          {
               color = (*offO) + (*(offO + 640)) +
                       (*(offO + 319)) + (*((offO++) + 321));
               color = (color >> 2) - 1;
               if (color < 0) color = 0;
               *(offD++) = color;
          }
          offO += 2;
          offD += 2;
     }

     CopyScreen(Destino, Origen);

     if ((flamazo--) > 0) DibujaFAC();

     offO = (byte *)MK_FP(Origen, YOffset[198]);
     for (x = 0; x < 320; x++)
     {
          *offO = random(2) * ColorSemilla;
          *((offO++) + 320) = random(2) * ColorSemilla;
     }
}


void main()
{
     clrscr();
     cout << "\nEjemplo de llamas y flamazo.\n"
          << "\nESPACIO - produce el flamazo\n"
          << "  ESC   - termina el programa\n"
          << "\nCualquier tecla para continuar...\n";
     getch();

     randomize();
     GeneraPaleta();
     SetMode13();
     SetPalette(pal);
     IniciaLlamas();

     flag = 1;
     flamazo = 0;

     while (flag)
     {
          if (kbhit())
          {
               key = getch();
               if (key == 27) flag = 0;
               if (key == ' ') flamazo = 15;
          }
          MueveLlamas();
//        VRetrace();
          CopyScreen(Destino, VGA);
     }

     ShutDownVirtual(DestScr);
     ShutDownVirtual(OrigScr);
     SetTextMode();
}
