
// Programa INTERFER.CPP  --  por FAC
// Ejemplo del efecto de interferencia sobre un fondo esttico

#include <iostream.h>    // cout
#include <conio.h>       // clrscr, getch
#include <stdlib.h>      // randomize, random, exit
#include "mode13.h"
#include "mode13.cpp"


typedef byte TCuadro[80][80];


PTVirtual VirScr1, VirScr2;
word VirSeg1, VirSeg2;

TPalette paleta;

TCuadro Cuadro[8];  // 8 cuadros en la animacin

// Variables del sprite
int CaraX, CaraY, CaraXVel, CaraYVel, CaraCuadro;


void Inicializa()
{
     int x, y, c;
     TPalette temp;
     char *fn;

     randomize();

     SetMode13();
     if (!SetupVirtual(VirScr1, VirSeg1)) exit(EXIT_FAILURE);
     if (!SetupVirtual(VirScr2, VirSeg2)) exit(EXIT_FAILURE);

     // Cargar y almacenar los sprites
     for (c = 0; c < 8; c++)
     {
          fn = "face .pcx";
          fn[4] = c + 48;
          LoadPCX(fn, VirSeg1, 80, 80, 0, 0, temp);
          for (y = 0; y < 80; y++)
              for (x = 0; x < 80; x++)
                  Cuadro[c][y][x] = GetPixel(x, y, VirSeg1);
     }

     // Cargar imagen de fondo
     LoadPCX("back.pcx", VirSeg1, 320, 200, 0, 0, paleta);

     // Crear imagen de interferencia
     for (y = 0; y < 200; y++)
         for (x = 0; x < 320; x++)
             PutPixel(x, y, random(16) + 240, VirSeg2);

     // Formar paleta
     for (c = 128; c <= 146; c++)
     {
          paleta[c][0] = temp[c][0];
          paleta[c][1] = temp[c][1];
          paleta[c][2] = temp[c][2];
     }

     for (c = 240; c < 256; c++)
         paleta[c][0] = paleta[c][1] = paleta[c][2] = (c - 240) * 16;

     // Inicializar sprite
     CaraX = 120;
     CaraY = 60;
     CaraXVel = -2;
     CaraYVel = -2;
     CaraCuadro = 0;
}


void Termina()
{
     ShutDownVirtual(VirScr1);
     ShutDownVirtual(VirScr2);
     SetTextMode();
}


void DibujaCara()
{
     word x, y;
     byte far *off;
     int cuad = CaraCuadro / 4;

     off = (byte *)pVGA + YOffset[CaraY] + CaraX;
     for (y = 0; y < 80; y++)
     {
          for (x = 0; x < 80; x++)
          {
               if (!(Cuadro[cuad][y][x] == 128)) *off = Cuadro[cuad][y][x];
               off++;
          }
          off += 240;
     }
}


void MueveCara()
{
     CaraX += CaraXVel;
     CaraY += CaraYVel;

     if (CaraX < 2) CaraXVel = 2; else if (CaraX > 236) CaraXVel = -2;
     if (CaraY < 2) CaraYVel = 2; else if (CaraY > 116) CaraYVel = -2;

     CaraCuadro = (CaraCuadro + 1) % 32;
}


void SinInterferencia()
{
     SetPalette(paleta);
     while (!kbhit())
     {
          VRetrace();
          CopyScreen(VirSeg1, VGA);
          DibujaCara();
          MueveCara();
     }
     getch();
}


void ComienzaInterferencia()
{
     int prob = 100;

     while ((!kbhit()) && (prob < 800))
     {
          VRetrace();

          if (random(prob++) > 100) CopyScreen(VirSeg2, VGA);
          else CopyScreen(VirSeg1, VGA);

          DibujaCara();
          SetPalette(paleta);
          MueveCara();
          RotatePalette(paleta, 240, 255);
     }
     if (kbhit()) getch();
}


void PuraInterferencia()
{
     while (!kbhit())
     {
          VRetrace();
          CopyScreen(VirSeg2, VGA);
          DibujaCara();
          SetPalette(paleta);
          MueveCara();
          RotatePalette(paleta, 240, 255);
     }
     getch();
}


void main()
{
     clrscr();
     cout << "\nEjemplo de interferencia sobre un fondo esttico\n"
          << "\nPresiona una tecla para comenzar, otra para iniciar la\n"
          << "interferencia y otra para terminar...\n";
     getch();

     Inicializa();

     SinInterferencia();
     ComienzaInterferencia();
     PuraInterferencia();

     Termina();
}
