
// SCROLLV.CPP  -- Ejemplo de scrolling vertical -- por FAC

#include <iostream.h>      // cout
#include <conio.h>         // clrscr, getch
#include <mem.h>           // memmove
#include "mode13.h"
#include "mode13.cpp"


PTVirtual VirScr;
word VirSeg;


void DibujaFondo()
{
     int x, y, i, color;

     color = 1;
     for (y = 0; y < 8; y++)
     {
          for (x = 0; x < 10; x++)
          {
               for (i = 0; i < 25; i++)
                   HLine(x * 32, x * 32 + 31, y * 25 + i, color, VirSeg);
               if (++color > 2) color = 1;
          }
          if (++color > 2) color = 1;
     }
}


void ScrollHaciaArriba()
{
     byte buffer[320];

     memmove(buffer, VirScr, 320);
     memmove(VirScr, VirScr + 320, 63680);
     memmove(VirScr + 63680, buffer, 320);
     VRetrace();
     CopyScreen(VirSeg, VGA);
}


void ScrollHaciaAbajo()
{
     byte buffer[320];

     memmove(buffer, VirScr + 63680, 320);
     memmove(VirScr + 320, VirScr, 63680);
     memmove(VirScr, buffer, 320);
     VRetrace();
     CopyScreen(VirSeg, VGA);
}


void main()
{
     clrscr();
     cout << "\nEjemplo de scroll vertical de pantalla completa.\n"
          << "\nPresiona cualquier tecla para continuar...\n";
     getch();

     SetMode13();
     SetupVirtual(VirScr, VirSeg);
     DibujaFondo();

     while (!kbhit()) ScrollHaciaArriba();
     getch();
     while (!kbhit()) ScrollHaciaAbajo();
     getch();

     ShutDownVirtual(VirScr);
     SetTextMode();
}
