
unit Objeto3D;

interface

uses Vertices;

const MaxVertices = 870;  { Nmero mximo de vrtices }
      MaxCaras = 870;     { Nmero mximo de caras }
      MaxVerticesCara = 4; { Nmero mximo de vrtices en cada cara }


{ Variables globales usadas para el sombreado }
var rango, colorinicial : byte;
    FuenteLuz : TVertice;


{ Tipo cara (polgono) }
type TCara = record
             NVertices : integer;  { Nmero de vrtices en el polgono }
             Vertice : array[1..MaxVerticesCara] of integer;
                       { Indices correspondientes a cada vrtice }
             normal : TVertice;  { vector normal al plano de la cara }
             color : byte;       { color de la cara }
             Z : double;
             end;

type PTCara = ^TCara;
     TCaraArray = array[1..MaxCaras] of PTCara;
     PTCaraArray = ^TCaraArray;


{ Tipo Objeto Tridimensional }
type PTObjeto3D = ^TObjeto3D;
     TObjeto3D = record
                 NVertices : integer;  { Nmero de vrtices }
                 NCaras : integer;     { Nmero de caras }
                 ox, oy, oz : double;  { Coordenadas del origen del objeto }
                 Vertice : array[1..MaxVertices] of TVertice; { Vrtices }
                 Cara : array[1..MaxCaras] of TCara;          { Caras }
                 end;


{ procedimientos para las caras }
procedure CaraReinicia(var cara : TCara);
procedure CaraAgregaVertice(var cara : TCara; vertice : integer);
{function CaraVisible(cara : TCara) : boolean; }
function CaraVisible(cara : TCara; objeto : PTObjeto3D) : boolean;
procedure CaraDibuja(obj : PTObjeto3D; cara : TCara; where : word);


{ procedimientos para los objetos }
procedure Objeto3DReinicia(obj : PTObjeto3D);
procedure Objeto3DAgregaVertice(obj : PTObjeto3D; nx, ny, nz : double);
procedure Objeto3DAgregaCara(obj : PTObjeto3D; cara : TCara);
procedure Objeto3DRota(obj : PTObjeto3D; ax, ay, az : integer);
procedure Objeto3DMueve(obj : PTObjeto3D; nx, ny, nz : double);
procedure Objeto3DEscala(obj : PTObjeto3D; sx, sy, sz : double);
procedure Objeto3DTraslada(obj : PTObjeto3D; tx, ty, tz : double);
procedure Objeto3DCentra(obj : PTObjeto3D);
procedure Objeto3DEncaja(obj : PTObjeto3D; distmax : double);
procedure Objeto3DCalcula2D(obj : PTObjeto3D);
procedure Objeto3DCalculaNormales(obj : PTObjeto3D);
procedure Objeto3DDibujaVertices(obj : PTObjeto3D; color : byte; where : word);
procedure Objeto3DDibujaMalla(obj : PTObjeto3D; color : byte; where : word);
procedure Objeto3DDibujaPlano(obj : PTObjeto3D; where : word);
procedure Objeto3DDibujaSombreadoPlano(obj : PTObjeto3D; where : word);
procedure Objeto3DLeeASC(archivo : string; obj : PTObjeto3D; inv : boolean);


implementation

uses Mode13;


{ Procedimiento QuickSort para ordenar un arreglo de caras }
procedure QuickSort(a : PTCaraArray; inicio, final : integer);
var izq, der, pos : integer;
    temp : PTCara;
    flag : boolean;
begin
     izq := inicio;
     der := final;
     pos := inicio;
     flag := true;
     while flag do
     begin
          flag := false;
          while (a^[pos]^.Z <= a^[der]^.Z) and (pos <> der) do dec(der);
          if pos <> der then
          begin
               temp := a^[pos]; a^[pos] := a^[der]; a^[der] := temp;
               pos := der;
               while (a^[pos]^.Z >= a^[izq]^.Z) and (pos <> izq) do inc(izq);
               if pos <> izq then
               begin
                    flag := true;
                    temp := a^[pos]; a^[pos] := a^[izq]; a^[izq] := temp;
                    pos := izq;
               end;
          end;
     end;
     if (pos - 1) > inicio then QuickSort(a, inicio, pos - 1);
     if final > (pos + 1) then QuickSort(a, pos + 1, final);
end;



{ Procedimientos de las caras }

{ Este procedimiento resetea las variables principales de una cara }
procedure CaraReinicia(var cara : TCara);
begin
     cara.NVertices := 0;
end;

{ Este procedimiento aade un vrtice (su ndice) a una cara }
{ IMPORTANTE!!! Los vrtices se deben aadir en el sentido OPUESTO
                a las manecillas del reloj.                       }
procedure CaraAgregaVertice(var cara : TCara; vertice : integer);
begin
     { Primero comprobamos si podemos aadir otro vrtice }
     if cara.NVertices = MaxVerticesCara then exit;
     { Si es as, lo aadimos }
     inc(cara.NVertices);
     cara.Vertice[cara.NVertices] := vertice;
end;


{ Algoritmo mejorado para detectar si una cara es visible o no:
  Funciona de la misma forma, es decir, comprobamos si el vector
  normal al plano de la cara est dirigido hacia el observador
  (normal.z >= 0), pero lo hacemos despus de hacer la proyeccin a 2D }

function CaraVisible(cara : TCara; objeto : PTObjeto3D) : boolean;
var ax, ay, bx, by : integer;
begin
     if cara.NVertices < 3 then exit;
     ax := objeto^.Vertice[cara.Vertice[1]].x2d -
           objeto^.Vertice[cara.Vertice[2]].x2d;
     ay := objeto^.Vertice[cara.Vertice[1]].y2d -
           objeto^.Vertice[cara.Vertice[2]].y2d;
     bx := objeto^.Vertice[cara.Vertice[3]].x2d -
           objeto^.Vertice[cara.Vertice[2]].x2d;
     by := objeto^.Vertice[cara.Vertice[3]].y2d -
           objeto^.Vertice[cara.Vertice[2]].y2d;
     CaraVisible := (bx * ay) > (by * ax);
end;


procedure CaraDibuja(obj : PTObjeto3D; cara : TCara; where : word);
var Xmin, Xmax : array[0..199] of integer;
    i, x1, y1, x2, y2 : integer;
    Ymin, Ymax, y : integer;

    procedure ScanSide(x1, y1, x2, y2 : integer);
    var y, ydiv, temp : integer;
        x, xinc : double;
    begin
         if y1 > y2 then
         begin
              { nos aseguramos de que (x1, y1) sea el punto SUPERIOR
                y (x2, y2) sea el punto INFERIOR }
              temp := y1; y1 := y2; y2 := temp;
              temp := x1; x1 := x2; x2 := temp;
         end;
         ydiv := y2 - y1;
         if ydiv = 0 then exit;
         xinc := (x2 - x1) / ydiv;
         x := x1;
         for y := y1 to y2 do
         begin
              if trunc(x) < Xmin[y] then Xmin[y] := trunc(x);
              if round(x) > Xmax[y] then Xmax[y] := round(x);
              x := x + xinc;
         end;
    end;

begin
     { Lo primero es obtener las coordenadas Y mxima y mnima del
       polgono }
     Ymin := 32000;
     Ymax := -32000;
     for i := 1 to cara.NVertices do
     begin
          y := obj^.Vertice[cara.Vertice[i]].y2d;
          if y < Ymin then Ymin := y;
          if y > Ymax then Ymax := y;
     end;

     { Si el polgono tiene altura igual a cero, entonces no lo dibujamos }
     if (Ymax - Ymin) = 0 then exit;

     for i := 0 to 199 do       { Inicializamos Xmin y Xmax }
     begin
          Xmin[i] := 32000;
          Xmax[i] := -32000;
     end;

     { Obtenemos las coordenadas del primer vrtice }
     x1 := obj^.Vertice[cara.Vertice[1]].x2d;
     y1 := obj^.Vertice[cara.Vertice[1]].y2d;

     { y hacemos un ciclo para dibujar todas las aristas }
     for i := 2 to cara.NVertices do
     begin
          { Obtenemos las coordenadas del siguiente vrtice }
          x2 := obj^.Vertice[cara.Vertice[i]].x2d;
          y2 := obj^.Vertice[cara.Vertice[i]].y2d;
          { "Escaneamos" el lado (x1, y1)-(x2, y2) }
          ScanSide(x1, y1, x2, y2);
          { y continuamos con el siguiente lado }
          x1 := x2;
          y1 := y2;
     end;

     { Obtenemos nuevamente las coordenadas del primer vrtice para
       escanear la lnea entre el primero y el ltimo vrtices }
     x2 := obj^.Vertice[cara.Vertice[1]].x2d;
     y2 := obj^.Vertice[cara.Vertice[1]].y2d;
     ScanSide(x1, y1, x2, y2);

     { En este momento, ya tenemos la informacin necesaria almacenada
       en Xmin y Xmax. Ahora procedemos a dibujar el polgono }
     for i := Ymin to Ymax do
         HLine(Xmin[i], Xmax[i], i, cara.color, where);
end;


{ Procedimiento que calcula la profundidad (Z) de cara cara   }
{ simplemente sumando las coordenadas Z de todos sus vrtices }
procedure CaraCalculaZ(var cara : TCara; obj : PTObjeto3D);
var i : integer;
begin
     with cara do
     begin
          Z := 0;
          for i := 1 to NVertices do Z := Z + obj^.Vertice[Vertice[i]].z;
     end;
end;


{ Procedimientos de los objetos 3D }

{ Este procedimiento reinicia las variables importantes de un objeto 3D }
procedure Objeto3DReinicia(obj : PTObjeto3D);
begin
     obj^.NVertices := 0;
     obj^.NCaras := 0;
     obj^.ox := 0;
     obj^.oy := 0;
     obj^.oz := 0;
end;


{ Este procedimiento agrega un vrtice al objeto tridimensional }
{ (no importa el orden, pero hay que recordar el ndice de cada vrtice
   a la hora de especificar los polgonos) }
procedure Objeto3DAgregaVertice(obj : PTObjeto3D; nx, ny, nz : double);
begin
     { Comprobamos si se le puede aadir otro vrtice al objeto }
     if obj^.NVertices = MaxVertices then exit;
     { Si se puede, lo agregamos }
     inc(obj^.NVertices);
     obj^.Vertice[obj^.NVertices].x := nx;
     obj^.Vertice[obj^.NVertices].y := ny;
     obj^.Vertice[obj^.NVertices].z := nz;
end;


{ Este procedimiento aade una cara (o polgono) al objeto }
procedure Objeto3DAgregaCara(obj : PTObjeto3D; cara : TCara);
begin
     { Comprobamos que se pueda aadir otra cara }
     if obj^.NCaras = MaxCaras then exit;
     { Si es as, la aadimos }
     inc(obj^.NCaras);
     obj^.Cara[obj^.NCaras] := cara;
end;

{ Este procedimiento rota un objeto mediante la rotacin de sus vrtices }
procedure Objeto3DRota(obj : PTObjeto3D; ax, ay, az : integer);
var i : integer;
begin
     { Simplemente rotamos todos los vrtices }
     for i := 1 to obj^.NVertices do
         VerticeRota(obj^.Vertice[i], ax, ay, az);

     { Y todas las normales }
     for i := 1 to obj^.NCaras do
         VerticeRota(obj^.Cara[i].normal, ax, ay, az);
end;

{ Este procedimiento mueve el origen del objeto (y por lo tanto, el objeto)
  al punto (nx, ny, nz) con respecto al centro de la pantalla }
procedure Objeto3DMueve(obj : PTObjeto3D; nx, ny, nz : double);
begin
     obj^.ox := nx;
     obj^.oy := ny;
     obj^.oz := nz;
end;

{ Procedimiento que escala un objeto }
procedure Objeto3DEscala(obj : PTObjeto3D; sx, sy, sz : double);
var i : integer;
begin
     with obj^ do
          for i := 1 to NVertices do
          begin
               Vertice[i].x := Vertice[i].x * sx;
               Vertice[i].y := Vertice[i].y * sy;
               Vertice[i].z := Vertice[i].z * sz;
          end;
end;

{ Este procedimiento traslada el objeto }
procedure Objeto3DTraslada(obj : PTObjeto3D; tx, ty, tz : double);
var i : integer;
begin
     with obj^ do
          for i := 1 to NVertices do
          begin
               Vertice[i].x := Vertice[i].x + tx;
               Vertice[i].y := Vertice[i].y + ty;
               Vertice[i].z := Vertice[i].z + tz;
          end;
end;

{ Este procedimiento centra el objeto con respecto al origen }
procedure Objeto3DCentra(obj : PTObjeto3D);
var i : integer;
    tx, ty, tz : double;
begin
     tx := 0;
     ty := 0;
     tz := 0;
     with obj^ do
     begin
          for i := 1 to NVertices do
          begin
               tx := tx + Vertice[i].x;
               ty := ty + Vertice[i].y;
               tz := tz + Vertice[i].z;
          end;
          tx := tx / NVertices;
          ty := ty / NVertices;
          tz := tz / NVertices;
     end;
     Objeto3DTraslada(obj, -tx, -ty, -tz);
end;


{ Hace que el objeto quepa en un cubo de lado especfico }
procedure Objeto3DEncaja(obj : PTObjeto3D; distmax : double);
var i : integer;
    dist, max, escala : double;
begin
     max := 0;
     with obj^ do
          for i := 1 to NVertices do
          begin
               dist := sqrt( Vertice[i].x * Vertice[i].x +
                             Vertice[i].y * Vertice[i].y +
                             Vertice[i].z * Vertice[i].z);
               if dist > max then max := dist;
          end;
     escala := distmax / max;
     Objeto3DEscala(obj, escala, escala, escala);
end;

{ Este procedimiento calcula la proyeccin bidimensional de sus vrtices
  y los traslada respecto al origen del objeto }
procedure Objeto3DCalcula2D(obj : PTObjeto3D);
var i : integer;
begin
     { Calcula la proyeccin 2D de cada vrtice y lo desplaza con respecto
       al origen del objeto }
     with obj^ do
          for i := 1 to NVertices do
              VerticeCalcula2D(Vertice[i], ox, oy, oz);
end;

{ Solo es necesario llamar una vez a este procedimiento }
procedure Objeto3DCalculaNormales(obj : PTObjeto3D);
var ax, ay, az, bx, by, bz, nx, ny, nz, mag : double;
    i : integer;
begin
     with obj^ do
     for i := 1 to NCaras do
     begin
       { Calculamos los dos vectores en el plano de la cara (A y B) }
       ax := Vertice[Cara[i].Vertice[1]].x - Vertice[Cara[i].Vertice[2]].x;
       ay := Vertice[Cara[i].Vertice[1]].y - Vertice[Cara[i].Vertice[2]].y;
       az := Vertice[Cara[i].Vertice[1]].z - Vertice[Cara[i].Vertice[2]].z;
       bx := Vertice[Cara[i].Vertice[3]].x - Vertice[Cara[i].Vertice[2]].x;
       by := Vertice[Cara[i].Vertice[3]].y - Vertice[Cara[i].Vertice[2]].y;
       bz := Vertice[Cara[i].Vertice[3]].z - Vertice[Cara[i].Vertice[2]].z;

       { Obtenemos el producto cruz de A x B }
       Cara[i].normal.x := by * az - ay * bz;
       Cara[i].normal.y := ax * bz - bx * az;
       Cara[i].normal.z := bx * ay - by * ax;

       { Normalizamos el vector perpendicular (A x B) }
       VerticeNormaliza(Cara[i].normal);
     end;
end;



{ Procedimientos para dibujar objetos 3D }
{ IMPORTANTE!!! No se hace ninguna comprobacin acerca de si los objetos
                quedan dentro de los lmites de la pantalla (0, 0, 319, 199),
                por lo tanto se pueden producir resultados inesperados si
                no se controla el movimiento de los objetos }

{ Este procedimiento simplemente dibuja un punto en cada vrtice del objeto }
procedure Objeto3DDibujaVertices(obj : PTObjeto3D; color : byte; where : word);
var i : integer;
begin
     Objeto3DCalcula2D(obj); { Primero calculamos la proyeccin en 2D }
     for i := 1 to obj^.NVertices do
         PutPixel(obj^.Vertice[i].x2d, obj^.Vertice[i].y2d, color, where);
end;


{ Este procedimiento dibuja un "modelo de alambre" del objeto, es decir,
  dibuja nicamente las aristas }
procedure Objeto3DDibujaMalla(obj : PTObjeto3D; color : byte; where : word);
var x1, y1, x2, y2 : integer;
    i, j : integer;
begin
     Objeto3DCalcula2D(obj);  { Calculamos la proyeccin en 2D }
     for j := 1 to obj^.NCaras do { Dibujamos todas las caras }
     begin
          if CaraVisible(obj^.cara[j], obj) then
          begin
               { Obtenemos las coordenadas del primer vrtice }
               x1 := obj^.Vertice[obj^.Cara[j].Vertice[1]].x2d;
               y1 := obj^.Vertice[obj^.Cara[j].Vertice[1]].y2d;

               { y hacemos un ciclo para dibujar todas las aristas }
               for i := 2 to obj^.cara[j].NVertices do
               begin
                    { Obtenemos las coordenadas del siguiente vrtice }
                    x2 := obj^.Vertice[obj^.Cara[j].Vertice[i]].x2d;
                    y2 := obj^.Vertice[obj^.Cara[j].Vertice[i]].y2d;
                    { Dibujamos una lnea entre los dos vrtices }
                    Line(x1, y1, x2, y2, color, where);
                    x1 := x2;
                    y1 := y2;
               end;

               { Obtenemos nuevamente las coordenadas del primer vrtice para
                  dibujar una lnea entre el primero y el ltimo vrtices }
               x2 := obj^.Vertice[obj^.Cara[j].Vertice[1]].x2d;
               y2 := obj^.Vertice[obj^.Cara[j].Vertice[1]].y2d;
               Line(x1, y1, x2, y2, color, where);
          end;
     end;
end;


procedure Objeto3DDibujaPlano(obj : PTObjeto3D; where : word);
var i, j : integer;
    a : TCaraArray;
begin
     Objeto3DCalcula2D(obj);    { calcula la proyeccin a 2D del objeto }
     j := 1;
     { Generamos un arreglo de apuntadores a caras, incluyendo nicamente }
     { aquellas caras que son visibles                                    }
     for i := 1 to obj^.NCaras do
         if CaraVisible(obj^.cara[i], obj) then
         begin
              CaraCalculaZ(obj^.cara[i], obj);
              a[j] := addr(obj^.cara[i]);
              inc(j);
         end;
     { Ordenamos el arreglo }
     QuickSort(addr(a), 1, j - 1);
     { y dibujamos las caras }
     for i := 1 to (j - 1) do CaraDibuja(obj, a[i]^, where);
end;


{ Procedimiento que dibuja un objeto usando sombreado plano }
procedure Objeto3DDibujaSombreadoPlano(obj : PTObjeto3D; where : word);
var i, j : integer;
    cosang : double;
    a : TCaraArray;
begin
     Objeto3DCalcula2D(obj);    { calcula la proyeccin a 2D del objeto }
     j := 1;
     { Generamos un arreglo de apuntadores a caras, incluyendo nicamente }
     { aquellas caras que son visibles                                    }
     for i := 1 to obj^.NCaras do
         if CaraVisible(obj^.cara[i], obj) then
         begin
              CaraCalculaZ(obj^.cara[i], obj);
              a[j] := addr(obj^.cara[i]);
              inc(j);
         end;
     { Ordenamos el arreglo }
     QuickSort(addr(a), 1, j - 1);
     { Y dibujamos las caras }
     for i := 1 to (j - 1) do
     begin
          with a[i]^ do
          begin
               cosang := normal.x * FuenteLuz.x +
                         normal.y * FuenteLuz.y +
                         normal.z * FuenteLuz.z;
               color := trunc((cosang + 1.0) * rango / 2.0) + colorinicial;
          end;
          CaraDibuja(obj, a[i]^, where);
     end;
end;



procedure Objeto3DLeeASC(archivo : string; obj : PTObjeto3D; inv : boolean);

          { Compara el inicio de la cadena s con la cadena pre }
          { devuelve true si son iguales, false en el caso contrario }
          function ComparaInicio(s, pre : string) : boolean;
          var i : integer;
          begin
               ComparaInicio := true;
               { Si s es menor que pre, entonces devuelve falso }
               if Length(s) < Length(pre) then
               begin
                    ComparaInicio := false;
                    exit;
               end;
               { Comprueba caracter por caracter }
               for i := 1 to Length(pre) do
                   if s[i] <> pre[i] then
                   begin
                        ComparaInicio := false;
                        exit;
                   end;
          end;

          { Elimina la parte de la cadena s desde el principio hasta }
          { que se encuentren dos puntos (:). Si se encontraron los  }
          { dos puntos, la funcin devuelve false. Si no, devuelve true }
          function EliminaHastaDosPuntos(var s : string) : boolean;
          var i : integer;
              ss : string;
          begin
               EliminaHastaDosPuntos := false;
               ss := '';
               i := 1;
               { Busca los dos puntos }
               while (i < Length(s)) and (s[i] <> ':') do inc(i);
               { Si no los encontr, devuelve true }
               if i = Length(s) then
               begin
                    EliminaHastaDosPuntos := true;
                    exit;
               end;
               { Si los encontr, entonces obtiene el resto de la cadena }
               { pero elimina los espacios no deseados }
               inc(i);
               while s[i] = ' ' do inc(i);
               { copia el resto de la cadena en ss }
               while (i <= Length(s)) do
               begin
                    ss := ss + s[i];
                    inc(i);
               end;
               { sustituye la cadena original por la cadena nueva }
               s := ss;
          end;

          { Obtiene el valor numrico al principio de una cadena }
          function ObtenerValor(var s : string) : double;
          var sub : string;
              i : integer;
              valor : double;
          begin
               sub := '';
               i := 1;
               { Obtiene una subcadena hasta que encuentra un espacio }
               while (i <= Length(s)) and (s[i] <> ' ') do
               begin
                    sub := sub + s[i];
                    inc(i);
               end;
               { Obtiene el valor numrico de la subcadena }
               val(sub, valor, i);
               ObtenerValor := valor;
          end;

{ variables utilizadas }
var ascii : text;      { archivo de texto }
    nv, nc : integer;  { nmero de vrtices y caras }
    x, y, z : double;  { coordenadas de los vrtices }
    a, b, c : integer; { ndices de los vrtices de las caras }
    i : integer;       { contador universal }
    t : string;        { cadena temporal }
    cara : TCara;      { cara temporal }
    TotalVertices : integer; { numero total de vrtices }

label fin;

begin
     Objeto3DReinicia(obj);     { reinicia el objeto }
     TotalVertices := 0;
     assign(ascii, archivo);    { abre el archivo para lectura }
     reset(ascii);

     { mientras no se llegue al final del archivo, leemos los objetos }
     while not eof(ascii) do
     begin

          { Busca en el archivo hasta encontrar la palabra "Tri-mesh" }
          t := '';
          while not ComparaInicio(t, 'Tri-mesh') do
          begin
               readln(ascii, t);
               if eof(ascii) then goto fin;
          end;

          { Obtiene el nmero de vrtices y de caras }
          if EliminaHastaDosPuntos(t) then goto fin;
          nv := trunc(ObtenerValor(t));
          if EliminaHastaDosPuntos(t) then goto fin;
          nc := trunc(ObtenerValor(t));

          { Ahora busca hasta encontrar la palabra "Vertex" y se brinca  }
          { la lnea "Vertex list:"                                      }
          t := '';
          while not ComparaInicio(t, 'Vertex') do
          begin
               readln(ascii, t);
               if eof(ascii) then goto fin;
          end;

          { Ahora obtiene la informacin de los vrtices }
          for i := 1 to nv do
          begin
               { Busca nuevamente la palabra 'Vertex' al inicio }
               t := '';
               while not ComparaInicio(t, 'Vertex') do
               begin
                    readln(ascii, t);
                    if eof(ascii) then goto fin;
               end;
               { Obtiene las coordenadas del vrtice }
               if EliminaHastaDosPuntos(t) then goto fin;
               if EliminaHastaDosPuntos(t) then goto fin;
               x := ObtenerValor(t);
               if EliminaHastaDosPuntos(t) then goto fin;
               y := ObtenerValor(t);
               if EliminaHastaDosPuntos(t) then goto fin;
               z := ObtenerValor(t);
               { Y agrega el vrtice al objeto }
               Objeto3DAgregaVertice(obj, x, y, z);
          end;

          { Ahora busca hasta encontrar la palabra "Face" y se brinca  }
          { la lnea "Face list:"                                      }
          t := '';
          while not ComparaInicio(t, 'Face') do
          begin
               readln(ascii, t);
               if eof(ascii) then goto fin;
          end;

          { Obtenemos la informacin de las caras }
          for i := 1 to nc do
          begin
               CaraReinicia(cara);   { reinicia la cara }
               { busca nuevamente la cadena 'Face' al principio de la lnea }
               t := '';
               while not ComparaInicio(t, 'Face') do
               begin
                    readln(ascii, t);
                    if eof(ascii) then goto fin;
               end;
               { Y obtiene los ndices de los vrtices de la cara,    }
               { sumndoles un uno porque en 3DS comienzan desde cero }
               if EliminaHastaDosPuntos(t) then goto fin;
               if EliminaHastaDosPuntos(t) then goto fin;
               a := trunc(ObtenerValor(t)) + 1 + TotalVertices;
               if EliminaHastaDosPuntos(t) then goto fin;
               b := trunc(ObtenerValor(t)) + 1 + TotalVertices;
               if EliminaHastaDosPuntos(t) then goto fin;
               c := trunc(ObtenerValor(t)) + 1 + TotalVertices;
               { agregamos los vrtices a la cara }
               if not inv then
               begin
                    { si inv = falso, usamos el orden original }
                    CaraAgregaVertice(cara, a);
                    CaraAgregaVertice(cara, b);
                    CaraAgregaVertice(cara, c);
               end
               else
               begin
                    { si inv = verdadero, invertimos el orden }
                    CaraAgregaVertice(cara, c);
                    CaraAgregaVertice(cara, b);
                    CaraAgregaVertice(cara, a);
               end;
               { Finalmente, agregamos la cara al objeto }
               Objeto3DAgregaCara(obj, cara);
          end;
          TotalVertices := TotalVertices + nv;
     end;

fin: { cerramos el archivo }
     close(ascii);

     { y obtenemos las normales del objeto }
     Objeto3DCalculaNormales(obj);
end;

end.
