{
  Ejemplo de las rutinas bsicas de 3D:

             - Generacin de un objeto tridimensional
             - Proyeccin a dos dimensiones
             - Rotacin y traslacin
             - Deteccin y eliminacin de caras invisibles
             - Rellenado de polgonos
             - Sombreado plano (flat)
             - Fuente de iluminacin mvil.
             - Algoritmo de eliminacin de caras ocultas mejorado.
             - Soporte para el formato ASCII de 3D Studio
             - Ordenamiento de caras usando QuickSort

 Codificado por FAC, para el tutorial de grficos #12
}

{$M 65520, 0, 655360}

program Base3D_5;        { versin 0.5 }

uses Vertices, Objeto3D, Mode13, Crt, Dos;


var objeto : PTObjeto3D;  { Objeto tridimensional }
    pal : TPalette;
    estilo : integer;

    t0, frames : longint;
    timer : longint absolute $0040:$006C;


{ El siguiente procedimiento "dibuja" la fuente de luz }
procedure DibujaLuz(where : word);
var i, cx, cy, radio : integer;
    p : double;
    Luz : TVertice;
begin
     Luz := FuenteLuz;  { obtiene la posicin de la fuente de luz }
     VerticeEscala(Luz, 250, 250, 500); { la alejamos del centro }
     VerticeCalcula2D(Luz, 0, 0, 0);
     p := 512.0 / (1024.0 - Luz.z); { para darle cierta perspectiva... }
     for i := 0 to 7 do
     begin
          if odd(i) then radio := 5 else radio := 8;
          cx := round(Coseno[i * 45] * radio * p) + Luz.x2d;
          cy := round(Seno[i * 45] * radio * p) + Luz.y2d;
          Line(Luz.x2d, Luz.y2d, cx, cy, colorinicial + rango, where);
     end;
end;


{ Procedimiento que realiza la demostracin }
procedure Demo;
var ax, ay, az, a : integer;  { Angulos de rotacin sobre cada eje }
    VirScr : PTVirtual;  { pantalla virtual }
    VirSeg : word;
    key : char;

begin
     { Iniciamos las pantallas virtuales y cargamos la imagen de fondo }
     SetupVirtual(VirScr, VirSeg);

     SetMode13;  { Entramos al modo grfico }
     SetPalette(pal);  { activamos la paleta }

     a := 0; { contador usado en la rotacin }
     estilo := 0;   { 0 = malla de alambre }
     key := ' ';
     frames := 0;
     t0 := timer;

     while key <> #27 do  { mientras no se presione ESC... }
     begin
          ClearScreen(0, VirSeg); { Borramos la pantalla virtual }

          case estilo of
               0 : Objeto3DDibujaMalla(objeto, colorinicial + 63, VirSeg);
               1 : begin
                        if FuenteLuz.z < 0 then DibujaLuz(VirSeg);
                        Objeto3DDibujaSombreadoPlano(objeto, VirSeg);
                        if FuenteLuz.z >= 0 then DibujaLuz(VirSeg);
                   end;
          end;

          VRetrace;       { Espera al retrazo vertical }
          CopyScreen(VirSeg, VGA);  { y muestra todo en VGA }
          inc(frames);

          { Rota el objeto y actualiza los ngulos de rotacin }
          ax := round(Coseno[a] * 3);
          ay := round(Seno[a] * 2 - 1);
          az := round(-Seno[a] * 2 + 1);
          if (a < 360) then inc(a) else a := 0;
          Objeto3DRota(objeto, ax, ay, az);

          if keypressed then     { si se presiona una tecla...}
          begin
               key := readkey;   { la leemos }
               case key of       { y la comparamos }
                    #13: inc(colorinicial, 64); { enter = cambia color }
                    #32: VerticeRota(FuenteLuz, 0, -2, 0);
                    'm', 'M': estilo := 0;
                    's', 'S': estilo := 1;
               end;
          end;
     end;
     t0 := timer - t0;

     { Liberamos la memoria de las pantallas virtuales }
     ShutDownVirtual(VirScr);
end;


var i : byte;

{ Secuencia principal }
begin
     if paramcount = 0 then
     begin
          writeln;
          writeln('Visualizador de objetos en formato ASCII de 3D Studio');
          writeln('Admite un nmero mximo de 870 vrtices y 870 caras');
          writeln;
          writeln('Uso:   base3d_5 <objeto.asc>');
          writeln;
          halt(0);
     end;
     if FSearch(paramstr(1), '') = '' then
     begin
          writeln;
          writeln('No existe el archivo ', paramstr(1));
          writeln;
          halt(1);
     end;

     clrscr;
     writeln;
     writeln('Demostracin de las rutinas bsicas de 3D.');
     writeln;
     writeln('Ahora con ordenamiento de caras para visualizar correctamente');
     writeln('cualquier objeto!');
     writeln;
     writeln('Puedes utilizar las siguientes teclas:');
     writeln;
     writeln('  ENTER:    cambia el color del objeto tridimensional');
     writeln('  ESPACIO:  mueve la fuente de luz alrededor del eje Y');
     writeln('  ESC:      termina la demostracin');
     writeln('  M:        dibuja la malla del objeto');
     writeln('  S:        dibuja el objeto con sombreado plano');
     writeln;

     objeto := new(PTObjeto3D);
     Objeto3DLeeASC(paramstr(1), objeto, false);
     Objeto3DCentra(objeto);
     Objeto3DEncaja(objeto, 180);
     Objeto3DRota(objeto, 180, 0, 0);

     writeln('El objeto cargado es: ', paramstr(1));
     writeln('Nmero de vrtices: ', objeto^.NVertices);
     writeln('Nmero de caras:    ', objeto^.NCaras);
     writeln;

     writeln('Presiona una tecla para empezar...');
     readkey;

     { Inicializa la fuente de iluminacin y la paleta de colores }
     FuenteLuz.x := 0;
     FuenteLuz.y := 0;
     FuenteLuz.z := 1;
     VerticeNormaliza(FuenteLuz);

     fillchar(pal, 768, 0);  { llena la paleta con ceros (negro) }
     for i := 0 to 63 do
     begin
          pal[i][0] := i;       { del 0 al 63:     rojo }
          pal[i + 64][1] := i;  { del 64 al 127:   verde }
          pal[i + 128][2] := i; { del 128 al 191:  azul }
          pal[i + 192][0] := i; { del 192 al 255:  amarillo }
          pal[i + 192][1] := i;
     end;
     colorinicial := 0;
     rango := 63;

     Demo;
     SetTextMode;
     dispose(objeto);
     write('Velocidad alcanzada: ', frames * 18.2 / t0:1:2);
     writeln(' cuadros por segundo');
     writeln;
end.
