{
  Ejemplo de las rutinas bsicas de 3D:

             - Generacin de un objeto tridimensional
             - Proyeccin a dos dimensiones
             - Rotacin y traslacin
             - Deteccin y eliminacin de caras invisibles
             - Rellenado de polgonos
             - Sombreado plano (flat)
             - Fuente de iluminacin mvil.
             - Algoritmo de eliminacin de caras ocultas mejorado.
             - Sombreado por distancia

 Codificado por FAC, para el tutorial de grficos #11
}

program Base3D_4;        { versin 0.4 }

uses Vertices, Objeto3D, Mode13, Crt;


var Cubo : TObjeto3D;  { Objeto tridimensional }
    pal : TPalette;    { paleta utilizada }


{ Este procedimiento genera un cubo con centro en el origen }
{ Se puede alterar este procedimiento (y solamente este) para
  generar otros objetos diferentes (pirmides, letras, etc...) }
procedure GeneraCubo;
const lado = 50;

var cara : TCara;

{  Nuestro cubo est formado de la siguiente manera:

                                 3       4
                                 o-------o
                                /|      /|
                               / |     / |
                           1  /  |  2 /  |
                             o---|---o   |
                             |   o---|---o
                             |  / 5  |  / 6
                             | /     | /
                             |/      |/
                             o-------o
                             7       8

}
begin
     { Agregamos los 8 vrtices del cubo }
     Objeto3DReinicia(Cubo);
     Objeto3DAgregaVertice(Cubo, -lado, lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, lado, lado);
     Objeto3DAgregaVertice(Cubo, -lado, lado, -lado);
     Objeto3DAgregaVertice(Cubo, lado, lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, lado);

     { Ahora agregamos las 6 caras, construyndolas una por una }
     CaraReinicia(cara);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 8);
     cara.color := 255;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 8);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 4);
     cara.color := 254;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 3);
     cara.color := 253;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 1);
     cara.color := 251;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 3);
     cara.color := 250;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 8);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 5);
     cara.color := 249;
     Objeto3DAgregaCara(Cubo, cara);
end;


{ Como ejemplo, aqu se muestra OTRO procedimiento GeneraCubo que
  genera un objeto diferente (una pirmide), aunque el nombre del
  objeto sigue siendo "cubo" :) }

{
                                    1
                                    o
                                   /|\
                                  / |  \
                                 o--|----o
                                / 5 |   / 4
                               /    |  /
                              /     | /
                             o-------o
                             2       3
}
procedure GeneraPiramide;
const lado = 50;
var cara : TCara;
begin
     Objeto3DReinicia(Cubo);
     Objeto3DAgregaVertice(Cubo, 0, lado, 0);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, -lado);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 3);
     cara.color := 255;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 4);
     cara.color := 254;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 5);
     cara.color := 253;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 2);
     cara.color := 252;
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 2);
     cara.color := 251;
     Objeto3DAgregaCara(Cubo, cara);
end;


{ El siguiente procedimiento "dibuja" la fuente de luz }
procedure DibujaLuz(where : word);
var i, cx, cy, radio : integer;
    p : double;
    Luz : TVertice;
begin
     Luz := FuenteLuz;  { obtiene la posicin de la fuente de luz }
     VerticeEscala(Luz, 0.5, 0.5, 1); { la alejamos del centro }
     VerticeCalcula2D(Luz, 0);
     p := 512.0 / (1024.0 - Luz.z); { para darle cierta perspectiva... }
     for i := 0 to 7 do
     begin
          if odd(i) then radio := 5 else radio := 8;
          cx := round(Coseno[i * 45] * radio * p) + Luz.x2d;
          cy := round(Seno[i * 45] * radio * p) + Luz.y2d;
          Line(Luz.x2d, Luz.y2d, cx, cy, colorinicial + rango, where);
     end;
end;



{ Procedimiento que dibuja un objeto usando sombreado plano por ngulo  }
{ y por distancia                                                       }
procedure Objeto3DDibujaSombreado(obj : TObjeto3D; where : word);
const DistanciaMaxima : double = 1000;
var i, j, c : integer;
    cosang, invmagnitud, factor, distancia : double;
    centro : TVertice;
begin
     Objeto3DCalcula2D(obj);    { calcula la proyeccin a 2D del objeto }
     { Calculamos el inverso de la magnitud del vector de iluminacin }
     invmagnitud := sqrt(FuenteLuz.x * FuenteLuz.x +
                         FuenteLuz.y * FuenteLuz.y +
                         FuenteLuz.z * FuenteLuz.z);
     if invmagnitud <> 0 then invmagnitud := 1.0 / invmagnitud;

     for i := 1 to obj.NCaras do
         if CaraVisible(obj.cara[i], obj) then
         begin
              with obj.cara[i] do
              begin
                   { calculamos el color aplicando sombreado por ngulo }
                   cosang := (normal.x * FuenteLuz.x +
                              normal.y * FuenteLuz.y +
                              normal.z * FuenteLuz.z) * invmagnitud;
                   c := trunc((cosang + 1) * rango / 2) + colorinicial;
              end;
              { y aplicamos el sombreado por distancia }
              centro.x := 0;
              centro.y := 0;
              centro.z := 0;
              { calculamos el promedio de los vrtices de la cara }
              with obj do
              begin
                   for j := 1 to cara[i].NVertices do
                   begin
                        centro.x := centro.x + Vertice[cara[i].Vertice[j]].x;
                        centro.y := centro.y + Vertice[cara[i].Vertice[j]].y;
                        centro.z := centro.z + Vertice[cara[i].Vertice[j]].z;
                   end;
                   centro.x := centro.x / cara[i].NVertices;
                   centro.y := centro.y / cara[i].NVertices;
                   centro.z := centro.z / cara[i].NVertices;
              end;
              { y la distancia entre el centro de la cara y la luz }
              distancia := sqrt((centro.x-FuenteLuz.x)*(centro.x-FuenteLuz.x)+
                                (centro.y-FuenteLuz.y)*(centro.y-FuenteLuz.y)+
                                (centro.z-FuenteLuz.z)*(centro.z-FuenteLuz.z));
              { calculamos el color final }
              c := c - round(rango * distancia / DistanciaMaxima);
              { y no permitimos que se salga del rango }
              if c < colorinicial then c := colorinicial;
              obj.cara[i].color := c;
              CaraDibuja(obj, obj.cara[i], where);
         end;
end;



{ Procedimiento que realiza la demostracin }
procedure Demo;
var ax, ay, az, a : integer;  { Angulos de rotacin sobre cada eje }
    VirScr : PTVirtual;  { pantalla virtual }
    VirSeg : word;
    key : char;

begin
     { Iniciamos las pantallas virtuales y cargamos la imagen de fondo }
     SetupVirtual(VirScr, VirSeg);

     SetMode13;  { Entramos al modo grfico }
     SetPalette(pal); { activamos la paleta }

     { Preparamos el objeto tridimensional }
     Objeto3DCalculaNormales(Cubo);
     a := 0; { contador usado en la rotacin }

     key := ' ';

     while key <> #27 do  { mientras no se presione ESC... }
     begin
          ClearScreen(0, VirSeg); { Borramos la pantalla virtual }
          { Si la luz est detrs del objeto, la dibujamos primero }
          { de esa forma la luz parece ocultarse detrs del objeto }
          if FuenteLuz.z < 0 then DibujaLuz(VirSeg);
          Objeto3DDibujaSombreado(Cubo, VirSeg); { Dibuja el objeto }
          if FuenteLuz.z >= 0 then DibujaLuz(VirSeg);

          VRetrace;       { Espera al retrazo vertical }
          CopyScreen(VirSeg, VGA);  { y muestra todo en VGA }

          { Rota el objeto y actualiza los ngulos de rotacin }
          ax := round(Coseno[a] * 3);
          ay := round(Seno[a] * 2 - 1);
          az := round(-Seno[a] * 2 + 1);
          if (a < 360) then inc(a) else a := 0;
          Objeto3DRota(Cubo, ax, ay, az);

          if keypressed then     { si se presiona una tecla...}
          begin
               key := readkey;   { la leemos }
               case key of       { y la comparamos }
                    #13: inc(colorinicial, 64); { enter = cambia color }
                    #32: VerticeRota(FuenteLuz, 0, -2, 0);
                    'q', 'Q': VerticeEscala(FuenteLuz, 0.99, 0.99, 0.99);
                    'a', 'A': VerticeEscala(FuenteLuz, 1.01, 1.01, 1.01);
                    'r', 'R': begin
                                   FuenteLuz.x := 0;
                                   FuenteLuz.y := 0;
                                   FuenteLuz.z := 500;
                              end;
               end;
          end;
     end;

     { Liberamos la memoria de las pantallas virtuales }
     ShutDownVirtual(VirScr);
end;


var i : byte;

{ Secuencia principal }
begin
     clrscr;
     writeln;
     writeln('Demostracin de las rutinas bsicas de 3D.');
     writeln('Este ejemplo muestra cmo funciona el sombreado por distancia');
     writeln;
     writeln('Puedes utilizar las siguientes teclas:');
     writeln;
     writeln('  ENTER:    cambia el color del objeto tridimensional');
     writeln('  ESPACIO:  mueve la fuente de luz alrededor del eje Y');
     writeln('  ESC:      termina la demostracin');
     writeln('  Q:        Acerca la fuente de luz al objeto');
     writeln('  A:        Aleja la fuente de luz del objeto');
     writeln('  R:        Restaura la fuente de luz a su posicin original (0, 0, 500)');
     writeln;
     writeln('Presiona una tecla para empezar...');
     readkey;

     GeneraTablas;
     GeneraCubo;  { Se puede cambiar por GeneraPiramide }
{     GeneraPiramide; {}

     { Inicializa la fuente de iluminacin y la paleta de colores }
     FuenteLuz.x := 0;
     FuenteLuz.y := 0;
     FuenteLuz.z := 500;
     fillchar(pal, 768, 0);  { llena la paleta con ceros (negro) }
     for i := 0 to 63 do
     begin
          pal[i][0] := i;       { del 0 al 63:     rojo }
          pal[i + 64][1] := i;  { del 64 al 127:   verde }
          pal[i + 128][2] := i; { del 128 al 191:  azul }
          pal[i + 192][0] := i; { del 192 al 255:  amarillo }
          pal[i + 192][1] := i;
     end;
     colorinicial := 0;
     rango := 63;

     Demo;
     SetTextMode;
end.
