{ Ejemplo de uso de la unidad CHARSET.PAS  --  Copyright (C) 1998 - FAC   }

{
  Este "ejemplo" es un programa relativamente largo como para ser un
  ejemplo, pero muestra una buena forma de usar las rutinas de CHARSET.

  Hay MUCHAS variables globales en este programa, as que espero que
  no se hagan bolas :)
}

program TXTDemo2;

uses Mode13, CharSet, Crt;

{ Un simple tipo de registro con la informacin de un "letrero" }
type TLetrero = record
                x, y : word;    { posicin del "letrero" }
                s : string[20]; { texto del "letrero"    }
                t : integer;    { tiempo que dura el "letrero" en (18=1seg)}
                end;

var pal : TPalette;       { paleta actual }
    ChSet : PTCharSet;    { apuntador al juego de caracteres }
    VirScr : PTVirtual;   { pantalla virtual }
    VirSeg : word;        { segmento de la pantalla virtual }

    { Las siguientes variables se usan en el "wobbler" }
    FondoScr : PTVirtual; { imagen de fondo }
    FondoSeg : word;      { segmento de la imagen de fondo }
    FondoPal : TPalette;  { paleta de la imagen de fondo }
    trans : array[0..255] of integer; { matriz de transformacin del fondo }
    transpos : byte;      { posicin en la matriz de transformacin }
    transoff : word;      { offset de la matriz de fondo }

    { Las siguientes variables se usan en el plasma }
    ColorTable1 : array[0..255] of byte; { tabla #1 para el plasma }
    ColorTable2 : array[0..639] of byte; { tabla #2 para el plasma }
    pos1, pos2, pos3, pos4 : byte;       { posiciones del plasma }
    BigPal : array[0..1023] of TColor;   { colores para el plasma }
    palpos : word;                       { posicin dentro de la paletota }

    { Las siguientes variables controlan la temporizacin del programa }
    time : longint absolute $0040:$006C; { temporizador }
    t1 : longint;                        { se usa con el temporizador }

{ Cmo funciona el temporizador?

  Bueno, la variable time declarada anteriormente es una variable ABSOLUTA,
  eso significa que su posicin en la memoria est fija. En este caso, la
  hemos fijado en la posicin $0040:$006C, la cual contiene un reloj del
  sistema que se incrementa 18.2 veces por segundo. Esto significa que la
  variable time tambin se incrementa 18 veces por segundo, y de esa forma
  podemos medir el tiempo que transcurre en alguna parte de nuestro programa.

  Ms adelante se vern ejemplos del uso del temporizador
}


{ El siguiente procedimiento inicializa las tablas del plasma y la super
  paleta rotatoria de 1024 colores que se utiliza }
procedure InitPlasma;
var i : word;
    e, n : real;

begin
     { Generando la tabla #1 }
     for i := 0 to 255 do
     begin
          ColorTable1[i] := round(sin(2 * Pi * i / 512) *
                                 sqrt(abs(sin(2 * Pi * i / 256) * 16)) *
                                 cos(2 * Pi * i / 512) * 31) + 32;
          e := exp(i / 256) * sin(2 * Pi * i / 256) * 8;
          ColorTable1[i] := ColorTable1[i] + round(e);
     end;
     { Generando la tabla #2 }
     e := 1;
     for i := 0 to 639 do
     begin
          ColorTable2[i] := round(sin(2 * Pi * i / 80) * 32 -
                                  exp(cos(Pi * i / 160) * 6.5));
          n := 40 + 30 * sin(Pi * i / 640);
          e := e + sqrt(i) * cos(Pi * i / n);
          ColorTable2[i] := ColorTable2[i] + round(e);
     end;

     { Llenando la "paletota" con ceros }
     fillchar(bigpal, 1024, 0);

     { Generando la superpaleta de colores del plasma (1024 colores!) }
     for i := 0 to 127 do
     begin
          bigpal[i][0] := i shr 1;
     end;
     for i := 0 to 127 do
     begin
          bigpal[128+i][0] := (127 - i) shr 1;
     end;
     for i := 0 to 127 do
     begin
          bigpal[256+i][0] := i shr 2;
          bigpal[256+i][1] := i shr 1;
     end;
     for i := 0 to 127 do
     begin
          bigpal[384+i][0] := 32 + i shr 2;
          bigpal[384+i][1] := (127 - i) shr 1;
     end;
     for i := 0 to 127 do
     begin
          bigpal[512+i][0] := (127 - i) shr 1;
          bigpal[512+i][2] := i shr 2;
     end;
     for i := 0 to 127 do
     begin
          bigpal[640+i][1] := i shr 1;
          bigpal[640+i][2] := (127 - i) shr 2;
     end;
     for i := 0 to 127 do
     begin
          bigpal[768+i][1] := (127 - i) shr 1;
     end;
     for i := 0 to 127 do
     begin
          bigpal[896+i][0] := i shr 1;
     end;

     palpos := 0;       { posicin inicial dentro de la superpaleta }
end;


{ El siguiente procedimiento inicializa la tabla y la paleta del "wobbler" }
{ (ejecuten el programa para ver qu demonios es un wobbler) }
procedure InitWobbler;
var i, x, y : integer;
    angle : real;
begin
     { Generando la tabla de transformacin para el wobbler }
     { (es solamente un simple movimiento circular) }
     for i := 0 to 255 do
     begin
          angle := 2 * pi * i / 256;
          x := round(cos(angle) * 10);
          y := round(sin(angle) * 10);
          trans[i] := y * 320 + x;
     end;

     { Generando la paleta del wobbler, aunque en realidad, la mitad de
       la paleta se toma de la imagen de fondo (FONDO.PCX)  }
     for i := 128 to 223 do
     begin
          FondoPal[i][0] := 8;
          FondoPal[i][1] := 0;
          FondoPal[i][2] := 4;
     end;
     { Los colores que siguen son para el texto }
     for i := 0 to 21 do
     begin
          FondoPal[224+i][0] := i * 3;
          FondoPal[224+i][1] := i * 3;
          FondoPal[224+i][2] := 0;
     end;

     transoff := ofs(trans); { offset de la tabla de transformacin }
end;


{ El siguiente procedimiento realiza toda la iniciacin (no hay comentarios) }
procedure InitDemo;
var i : byte;
begin
     SetupVirtual(VirScr, VirSeg);
     SetupVirtual(FondoScr, FondoSeg);
     clrscr;
     writeln; write('  Cargando imagen de fondo...');
     LoadPCX('fondo.pcx', FondoSeg, 320, 200, 0, 0, FondoPal);
     writeln(' LISTO!');
     write('  Generando plasma...');
     InitPlasma; writeln(' LISTO!');
     write('  Cargando juego de caracteres...');
     ChSet := new(PTCharSet, Init('charset2.chr'));
     writeln(' LISTO!');
     write('  Perdiendo el tiempo...');
     InitWobbler;
     delay(500);
     fillchar(pal, sizeof(pal), 0);
     { Los siguientes colores son para el texto en la parte del plasma }
     for i := 0 to 21 do
     begin
          pal[224+i][0] := i * 3;
          pal[224+i][1] := i * 3;
          pal[224+i][2] := i * 3;
     end;
     writeln(' LISTO!'); delay(1000);
     SetMode13;
     SetPalette(pal);
end;

{ El siguiente procedimiento realiza toda la desinicializacin }
procedure Finish;
begin
     SetTextMode;
     writeln; writeln(' ... cero!');
     writeln; write('  Liberando memoria...');
     dispose(ChSet, Done);
     ShutDownVirtual(VirScr);
     ShutDownVirtual(FondoScr);
     writeln(' LISTO!'); writeln;
end;


{ Este procedimiento dibuja un plasma en una resolucin de 160*100 a una
  velocidad relativamente alta. Es una modificacin del procedimiento que
  se us en el ejemplo PLASMA3.PAS del tutorial #7  (no hay comentarios) }
procedure DrawPlasmaASM; assembler;
asm
   mov es, VirSeg
   mov di, 63676
   mov dh, pos3
   mov dl, pos4
   mov si, dx
   mov ch, 100
   @loopy:  mov dh, pos1
            mov dl, pos2
            mov cl, 160
   @loopx:  xor bh, bh
            mov bl, ch
            shl bl, 1
            mov al, byte ptr [ColorTable2 + bx]
            xchg si, dx
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            xchg si, dx
            mov bl, al
            db long; shl ax, 16  { shl eax, 16 }
            mov al, bl
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            mov bl, ch   { he he... esto le da un buen efecto :) }
            add bl, cl
            adc bh, 0
            add bl, cl
            adc bh, 0
            add al, byte ptr [ColorTable2 + bx]
            shr al, 1
            mov ah, al
            db long; rol ax, 16  { rol eax, 16 }
            sub dh, 3
            sub dl, 4
            sub bx, 2
            add al, byte ptr [ColorTable2 + bx]
            xor bh, bh
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            shr al, 1
            mov ah, al
            db long; mov es:[di], ax         { mov es:[di], eax }
            db long; mov es:[di + 320], ax   { mov es:[di + 320], eax }
            sub di, 4
            sub dh, 4
            sub dl, 3
            sub cl, 2
            jnz @loopx
            sub di, 320
            mov bx, si
            sub bh, 4
            sub bl, 5
            mov si, bx
            dec ch
            jnz @loopy
end;

{ Movimiento del plasma }
procedure MovePlasma;
begin
     dec(pos1, 3);
     inc(pos3, 3);
     inc(pos2, random(4) - 1);
     inc(pos4, random(4) - 1);
end;

{ El siguiente procedimiento mapea una parte de la superpaleta en la paleta
  actual e incrementa la posicin dentro de esta superpaleta. De esta forma,
  se hace una rotacin entre los 1024 colores, obteniendo un plasma muy
  colorido. Despus de eso, se dibuja el plasma en la pantalla virtual }
procedure DrawPlasma;
var i : word;
begin
     for i := 0 to 63 do pal[i] := bigpal[palpos + i];
     for i := 0 to 63 do pal[64+i] := bigpal[palpos+63-i];
     if palpos < 896 then inc(palpos) else palpos := 0;
     DrawPlasmaASM;
end;


{ El siguiente procedimiento realiza toda la parte del plasma+texto }
procedure DoPlasma;
const LetNum = 10; { Nmero de "letreros" a desplegar }
      Letr : array[0..LetNum] of TLetrero = ( (x:0; y:0; s:''; t:20),
                                              (x:40; y:40; s:'"With'; t:10),
                                              (x:110; y:40; s:'no'; t:10),
                                              (x:150; y:40; s:'dinero'; t:18),
                                              (x:50; y:60; s:'you''re'; t:10),
                                              (x:140; y:60; s:'zero!"'; t:20),
                                              (x:150; y:135; s:'- KRS-One -'; t:15),
                                              (x:120; y:160; s:'Step'; t:10),
                                              (x:170; y:160; s:'into'; t:10),
                                              (x:225; y:160; s:'a'; t:10),
                                              (x:250; y:160; s:'world'; t:100));

var i : byte;
begin
     ChSet^.ClearText;  { Aseguramos que la lista de texto est vaca! }
     for i := 0 to LetNum do  { para cada letrero... }
     begin
          { Agregamos el letrero a la lista de cadenas a desplegar }
          ChSet^.AddText(Letr[i].x, Letr[i].y, Letr[i].s, -5);
          t1 := time; { tomamos el tiempo inicial }
          { y mientras no transcurra el tiempo indicado para cada letrero... }
          while (time - t1) < Letr[i].t do
          begin
               DrawPlasma;              { Dibujamos el plasma }
               ChSet^.PrintAll(VirSeg); { Imprimimos la lista de cadenas }
               SetPalette(pal);         { Actualizamos la paleta }
               CopyScreen(VirSeg, VGA); { Mostramos todo en VGA }
               MovePlasma;              { y movemos el plasma }
          end;
     end;
end;


{ El siguiente procedimiento dibuja el wobbler. Este efecto ser explicado
  en el siguiente tutorial que trate sobre efectos (mas o menos por el
  nmero #13), por eso es que no contiene comentarios }
procedure DrawWobblerASM; assembler;
     asm
        mov di, 3210            { di = offset = 10 * 320 + 10 }
        mov es, VirSeg          { es = VirSeg }
        mov dl, 180             { dl = 180 (contador en y) }
        mov ax, FondoSeg
        db $8E, $E0             { mov fs, ax  ==> fs = FondoSeg }
        mov si, transoff
        @loopy: mov cx, 300     { cx = 300 (contador en x) }
                mov dh, transpos
        @loopx: db $0F, $B6, $DE  { movzx bx, dh }
                shl bx, 1
                add bx, si      { bx = level * 256 + pos }
                mov ax, ds:[bx]    { ax = trans[pos] }
                mov bx, di
                add bx, ax      { bx = scroff + trans[pos] }
                db $64, $8A, $07  { mov al, fs:[bx] }
                mov es:[di], al
                inc dh
                inc di
                dec cx
                jnz @loopx
                add di, 20
                dec dl
                jnz @loopy
                inc transpos
     end;


{ El siguiente procedimiento realiza toda la parte del wobbler+texto }
procedure DoWobbler;
const LetNum = 5;  { Nmero de letreros a desplegar }
      Letr : array[1..LetNum] of TLetrero = ( (x:72; y:30; s:'... cinco ...'; t:18),
                                              (x:64; y:60; s:'... cuatro ...'; t:18),
                                              (x:80; y:90; s:'... tres ...'; t:18),
                                              (x:88; y:120; s:'... dos ...'; t:18),
                                              (x:88; y:150; s:'... uno ...'; t:18));

var i : byte;
begin
     { Hacemos todos los colores de la paleta igual a blanco para obtener
       un efecto de "flashazo" }
     fillchar(pal, sizeof(pal), 63);
     ClearScreen(0, VirSeg); { Borramos la pantalla virtual }
     SetPalette(pal);        { y fijamos la paleta "flasheada" }
     t1 := time;             { tomamos el tiempo }
     { y hacemos que la siguiente parte dure mas o menos 5.5 segundos }
     while (time - t1) < 100 do
     begin
          DrawWobblerASM;           { Dibuja el wobbler }
          ChSet^.PrintAll(VirSeg);  { Imprime la lista de cadenas }
          SetPalette(pal);          { actualiza la paleta }
          CopyScreen(VirSeg, VGA);  { Muestra todo en VGA }
          { Hace un "fade" rpidamente desde el color blanco hasta los
            colores de la paleta utilizada para el efecto. (flashazo) }
          for i := 0 to 255 do
          begin
               if pal[i][0] > FondoPal[i][0] then dec(pal[i][0]);
               if pal[i][1] > FondoPal[i][1] then dec(pal[i][1]);
               if pal[i][2] > FondoPal[i][2] then dec(pal[i][2]);
          end;
     end;

     ChSet^.ClearText;   { Borra la lista de cadenas a desplegar }

     for i := 1 to LetNum do  { Para cada letrero, hacer lo siguiente... }
     begin
          t1 := time;  { Toma el tiempo actual }
          { y realiza el efecto durante la duracin de cada letrero }
          while (time - t1) < Letr[i].t do
          begin
               DrawWobblerASM;  { Dibuja el wobbler y despliega el letrero }
               ChSet^.PrintString(Letr[i].x, Letr[i].y, Letr[i].s, -4, VirSeg);
               CopyScreen(VirSeg, VGA); { Muestra todo en VGA }
          end;
     end;
end;


begin
     InitDemo;    { Inicializacin }
     DoPlasma;    { Plasma + Texto }
     DoWobbler;   { Wobbler + Texto }
     Finish;      { Desinicializacin }
end.