.386p
.model flat,syscall
.code

                include p:\nms.mac
                include p:\nms.pub
                include p:\nms.str

;
; NMS Init 
;
; INFO        Autodetects PM-handler,
; IN    EAX - Pointer to System CMD list
; OUT   EAX - System Name (Ending with 13,10,36)
;
nms_init                PROC    PUBLIC USES es esi edi ecx
			push	ds
			pop	es
                        cmp     nms_mainstat,1
			je	nms_init_recursive
                        mov     esi,eax
nms_init_l:             cmp     dwptr [esi],-1
                        je      nms_init_fail
                        push    esi
                        mov     esi,[esi]
                        call    sys.detect[esi]
                        pop     esi
                        jnc     nms_init_found
                        add     esi,4
                        jmp     nms_init_l
nms_init_found:         mov     esi,[esi]
                        lea     edi,SYS
                        mov     ecx,size sys
                rep     movsb
                        call    SYS_init
                        mov     eax,SYS_text
			mov	nms_mainstat,1
                        clc
			jmp	nms_init_done
nms_init_recursive:	mov	nms_error,5h
                        stc
			jmp	nms_init_done
nms_init_fail:          mov     nms_error,3h
                        stc
nms_init_done:          ret
nms_init                ENDP

;
; NMS Exit 
;
; INFO        At present it does nothing.
; IN        -
; OUT       -
;
nms_exit                PROC    PUBLIC USES es
			push	ds
			pop	es
			cmp	nms_mainstat,1
			je	nms_exit_ok
			mov     nms_error,6h
                        stc
			jmp	nms_exit_done
nms_exit_ok:            mov	nms_mainstat,0
			clc
nms_exit_done:          ret
nms_exit                ENDP

;
; NMS Driver Init 
;
; INFO        Initializes and tells the musicsystem to use this driver.
; IN    EAX - Pointer to Driver CMD list
; OUT   EAX - Pointer to to driver name
;

nms_driverinit          PROC    PUBLIC USES es ecx esi edi
			push	ds
			pop	es
			cmp	nms_driverstat,1
			je	nms_driverinit_recursive
                        mov     esi,eax
                        lea     edi,DRV
                        mov     ecx,size drv
                rep     movsb                           ;Copy all data to local buffer
                        call    DRV_init
			jc	nms_driverinit_error
                        mov     ecx,DRV_cardlst
                        mov     eax,DRV_text
                        cmp     DRV_card,0
                        je      nms_driverinit_ok
                        mov     eax,DRV_card
                        dec     eax
                        mov     eax,[ecx+eax*8]
			jmp	nms_driverinit_ok
nms_driverinit_recursive:
			mov	nms_error,5h
nms_driverinit_error:	stc
                        jmp     nms_driverinit_done
nms_driverinit_ok:	mov	nms_driverstat,1
			clc
nms_driverinit_done:   	ret
nms_driverinit          ENDP

;
; NMS Driver Exit 
;
; INFO        Deinitializes the soundcard driver
; IN        -
; OUT       -
;

nms_driverexit          PROC    PUBLIC USES es eax ecx edi
			push	ds
			pop	es
			cmp	nms_driverstat,1
			jne     nms_driverexit_not
                        call    DRV_exit
			jc	nms_driverexit_error
                        lea     edi,DRV
                        clr     eax
                        mov     ecx,size drv
                rep     stosb                           ;Copy all data to local buffer
			mov	nms_driverstat,0
                  	clc
			jmp	nms_driverexit_done
nms_driverexit_not:     mov	nms_error,6h
nms_driverexit_error:   stc
nms_driverexit_done:    ret
nms_driverexit          ENDP

;
; NMS Module Init 
;
; INFO        Initializes the module player.
; IN    EAX - Pointer to Formats CMD list
;       EBX - Pointer to Module
; OUT   EAX - Pointer to module format name
;
nms_moduleinit          PROC    PUBLIC USES es ebx ecx esi edi
			push	ds
			pop	es
			cmp	nms_modulestat,1
			je	nms_moduleinit_recursive
                        mov     esi,eax
nms_moduleinit_l1:      cmp     dwptr [esi],-1          ;Test if last format
                        je      nms_moduleinit_fail     ;If yes we're done
                        lodsd                           ;Get pointer to format struct
                        push    eax
                        push    ebx
                        push    esi
                        mov     esi,ebx
                        call    fmt.check[eax]          ;Check if OK?
                        pop     esi
                        pop     ebx
                        pop     eax
                        jc      nms_moduleinit_l1       ;If failed try next
                        mov     esi,eax
                        lea     edi,FMT
                        mov     ecx,size fmt
                rep     movsb                           ;Copy all data to local buffer
                        mov     esi,ebx
                        call    FMT_init
                        mov     eax,FMT_text
			mov	nms_modulestat,1
                        jmp     nms_moduleinit_done
nms_moduleinit_recursive:
			mov     nms_error,5h
                        stc
                        jmp     nms_moduleinit_done
nms_moduleinit_fail:    mov     nms_error,2h            ;Error code if module not recognized
                        stc
nms_moduleinit_done:    ret
nms_moduleinit          ENDP

;
; NMS Module Exit 
;
; INFO        Deinitializes the module player.
; IN        -
; OUT       -
;
nms_moduleexit          PROC    PUBLIC USES es eax ecx edi
			push	ds
			pop	es
			cmp	nms_modulestat,1
			jne     nms_moduleexit_not
                        call    FMT_exit
			jc	nms_moduleexit_error
                        lea     edi,FMT
                        clr     eax
                        mov     ecx,size fmt
                rep     stosb                           ;Copy all data to local buffer
			mov	nms_modulestat,0
                  	clc
			jmp	nms_moduleexit_done
nms_moduleexit_not:     mov	nms_error,6h
nms_moduleexit_error:   stc
nms_moduleexit_done:    ret
nms_moduleexit          ENDP

;
; NMS Module Start 
;
; INFO        Starts playing the module.
; IN        -
; OUT       -
;
nms_modulestart         PROC    PUBLIC USES es
			push	ds
			pop	es
			cmp	nms_playstat,1
			je	nms_modulestart_recursive
			call    [FMT_play]
			mov	nms_playstat,1
			jmp	nms_modulestart_done
nms_modulestart_recursive:
			mov	nms_error,5h
			stc
nms_modulestart_done:   ret
nms_modulestart         ENDP

;
; NMS Module Stop 
;
; INFO        Stops playing the module.
; IN        -
; OUT       -
;
nms_modulestop          PROC    PUBLIC USES es
			push	ds
			pop	es
			cmp	nms_playstat,1
			jne     nms_modulestop_not
			call    [FMT_stop]
			mov	nms_playstat,0
			jmp	nms_modulestop_done
nms_modulestop_not:	mov	nms_error,6h
			stc
nms_modulestop_done:   	ret
nms_modulestop          ENDP

;
; NMS Activate Vblank Sync 
;
; INFO        Stops playing the module.
; IN    EAX - Procedure to jump to every vblank
; OUT       -
;
nms_activatesync        PROC    PUBLIC USES es
			push	ds
			pop	es
			cmp	nms_syncstat,1
			je	nms_activatesync_recursive
                        call    [DRV_activatesync]
			mov	nms_syncstat,1
			jmp	nms_activatesync_done
nms_activatesync_recursive:
			mov	nms_error,5h
			stc
nms_activatesync_done:  ret
nms_activatesync        ENDP

;
; NMS Deactivate Vblank Sync 
;
; INFO        Stops playing the module.
; IN        -
; OUT       -
;
nms_deactivatesync      PROC    PUBLIC USES es
			push	ds
			pop	es
			cmp	nms_syncstat,1
			jne     nms_deactivatesync_not
                        call    [DRV_deactivatesync]
			mov	nms_syncstat,0
			jmp	nms_deactivatesync_done
nms_deactivatesync_not:	mov	nms_error,6h
			stc
nms_deactivatesync_done:ret
nms_deactivatesync      ENDP

;
; NMS Set master volume 
;
; INFO        Sets master volume
; IN    EAX - Volume (0-256)
; OUT       -
;

nms_setmastervol        PROC    PUBLIC USES es eax
			push	ds
			pop	es
			cmp	eax,256
			jbe	ok
			mov	eax,256
ok:			call    [DRV_setmastervol]
                        ret
nms_setmastervol        ENDP

;Ŀ
; Subroutines 
;

NMS_findenvstr          PROC    PUBLIC
                        push    esi
                        push    ecx
                        call    [SYS_getprginfo]
                        pop     edx
                        pop     esi
                        clr     eax
NMS_findenvstr_l1:      cmp     bptr [edi],0
                        jz      NMS_findenvstr_notfound
                        mov     ebx,[edi]
                        mov     ecx,[esi]
                        mov     ecx,edx
                        push    esi
                repe    cmpsb
                        je      NMS_findenvstr_found
                        clr     ecx
                        dec     ecx
                repnz   scasb
                        pop     esi
                        jmp     NMS_findenvstr_l1
NMS_findenvstr_found:   pop     esi
                        mov     esi,edi
                        clc
                        ret
NMS_findenvstr_notfound:stc
                        ret
NMS_findenvstr          ENDP

;

NMS_dosint              PROC    PUBLIC
                        push    dwptr 0                 ;Ignore SS,SP
                        push    dwptr 0                 ;Ignore CS,IP
                        push    [NMS_dosint_GS]         ;GS,FS
                        push    [NMS_dosint_ES]         ;ES,DS
                        db      66h
                        pushfd                          ;Flags
                        pushad                          ;And the rest...
                        mov     eax,300h
                        movzx   ebx,NMS_dosint_int
                        clr     ecx
                        mov     edi,esp
                        int     31h
                        popad
                        db      66h
                        popfd
                        pop     [NMS_dosint_ES]
                        pop     [NMS_dosint_GS]
                        lea     esp,[esp+8]
                        ret
NMS_dosint              ENDP
                public  NMS_dosint_GS
NMS_dosint_GS           dw      0
                public  NMS_dosint_FS
NMS_dosint_FS           dw      0
                public  NMS_dosint_ES
NMS_dosint_ES           dw      0
                public  NMS_dosint_DS
NMS_dosint_DS           dw      0
                public  NMS_dosint_int
NMS_dosint_int          db      0

;

nms_dummy               PROC    PUBLIC
                        ret
nms_dummy               ENDP

;Ŀ
;Ŀ
; Data 
;ٰ
;


.data

nms_mainstat		dd	0
nms_driverstat  	dd	0
nms_modulestat  	dd	0
nms_playstat    	dd	0
nms_syncstat    	dd	0

nms_error               dd      0

;Ŀ
; Dynamic Global Variables 
;

DRV                     label   dword
DRV_id                  dd      0
DRV_text                dd      0
DRV_version             dd      0
DRV_note                dd      0
DRV_card                dd      0
DRV_cards               dd      0
DRV_cardlst             dd      0
DRV_config              dd      0
DRV_port1               dd      0
DRV_port1lst            dd      0
DRV_port1desc           dd      0
DRV_port2               dd      0
DRV_port2lst            dd      0
DRV_port2desc           dd      0
DRV_irq1                dd      0
DRV_irq1lst             dd      0
DRV_irq1desc            dd      0
DRV_irq2                dd      0
DRV_irq2lst             dd      0
DRV_irq2desc            dd      0
DRV_dma1                dd      0
DRV_dma1lst             dd      0
DRV_dma1desc            dd      0
DRV_dma2                dd      0
DRV_dma2lst             dd      0
DRV_dma2desc            dd      0
DRV_detect              dd      0
DRV_init                dd      0
DRV_exit                dd      0
DRV_activate            dd      0
DRV_deactivate          dd      0
DRV_setbpm              dd      0
DRV_activatesync        dd      0
DRV_deactivatesync      dd      0
DRV_sync                dd      0
DRV_setsample           dd      0
DRV_clrsamples          dd      0
DRV_initsamples         dd      0
DRV_setactivesample     dd      0
DRV_setchns             dd      0
DRV_setmastervol        dd      0
DRV_setactivechn        dd      0
DRV_setmode             dd      0
DRV_setstart            dd      0
DRV_setend              dd      0
DRV_setlstart           dd      0
DRV_setlend             dd      0
DRV_setfreq             dd      0
DRV_setvol              dd      0
DRV_setpan              dd      0
DRV_startchn            dd      0
DRV_stopchn             dd      0

FMT                     label   dword
FMT_id                  dd      0
FMT_text                dd      0
FMT_test                dd      0
FMT_init                dd      0
FMT_exit                dd      0
FMT_play                dd      0
FMT_stop                dd      0
FMT_playtick            dd      0
FMT_module              dd      0
nms_modulepos           LABEL DWORD
FMT_pos                 dd      0
nms_jmp_tick            LABEL DWORD
FMT_jmp_tick            dd      nms_dummy
nms_jmp_row             LABEL DWORD
FMT_jmp_row             dd      nms_dummy
nms_jmp_cmd             LABEL DWORD
FMT_jmp_cmd             dd      nms_dummy
nms_jmp_end             LABEL DWORD
FMT_jmp_end             dd      nms_dummy


CFG                     label   dword
CFG_id                  db      'NMSCFG'
CFG_version             dd      0
CFG_sndid               dd      0
CFG_sndcard             dd      0
CFG_sndport1            dd      0
CFG_sndport2            dd      0
CFG_sndirq1             dd      0
CFG_sndirq2             dd      0
CFG_snddma1             dd      0
CFG_snddma2             dd      0

SYS                     label   dword
SYS_id                  dd      0
SYS_text                dd      0
SYS_detect              dd      0
SYS_init                dd      0
SYS_allocdma            dd      0
SYS_getprginfo          dd      0
SYS_getvect             dd      0
SYS_setvect             dd      0

                        END
