.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext
                include p:\nms.str
                include p:\devices\mix.ext
                include p:\devices\mix.str
                include p:\devices\timer.ext
                include p:\devices\dma.ext

                public  PAS_cmdlist

;Ĵ PAS Start timer 

PAS_activate		PROC
			lea	eax,PAS_TIRQ
			call	TMR_activatemix
			mov	PAS_active,1
			ret
PAS_activate		ENDP

;Ĵ PAS Stop timer 

PAS_deactivate		PROC	USES eax ecx edi
			mov	PAS_active,0
			call	TMR_deactivatemix
			clr	eax
PAS_deactivate_l:	call	MIX_setactivechn
			call	MIX_stopchn
			inc	eax
			cmp	eax,MIX_chns
			jne	PAS_deactivate_l
			mov	edi,DMA_addr
                        mov     ecx,PAS_mixsize
			clr	eax
		rep	stosb
			ret
PAS_deactivate		ENDP

;Ĵ PAS detect 

PAS_detect		PROC
			pushad
			mov	ax,0bc00h
			mov	bx,'??'
			clr	cx
			clr	dx
			int	2fh
			xor	bx,cx
			xor	bx,dx
			cmp	bx,'MV'
			jne	PAS_detect_fail

			mov	ax,0bc04h
			int	2fh
			and	ebx,0ffh
			and	ecx,0ffh
			mov	PAS_dma,ebx
			mov	PAS_irq,ecx

			lea	esi,PAS_portlst
PAS_detect_l1:		lodsd
			cmp	eax,-1
			je	PAS_detect_fail
			call	PAS_testhdw
			jnc	PAS_detect_hdwok
			jmp	PAS_detect_l1
PAS_detect_hdwok:	mov	eax,[esi-4]
			mov	PAS_port,eax
			call	PAS_getver
			popad
			clc
			ret
PAS_detect_fail:	popad
			stc
			ret
PAS_detect		ENDP

;Ĵ PAS test hardware 

PAS_testhdw		PROC	USES eax edx
			mov	edx,eax
			xor	edx,0388h
			xor	edx,0b8bh
			in	al,dx
			cmp	al,-1
			je	PAS_testhdw_fail

			mov	ah,al
			xor	al,11100000b

			out	dx,al
			nop
			nop
			nop
			nop
			in	al,dx

			cmp	al,ah
			xchg	al,ah
			out	dx,al
			jne	PAS_testhdw_fail
			clc
			ret
PAS_testhdw_fail:	stc
			ret
PAS_testhdw		ENDP

;Ĵ PAS get version 

PAS_getver		PROC
			mov	edi,PAS_port
			xor	edi,0388h

			mov	edx,0b8bh
			xor	edx,edi
			in	al,dx
			cmp	al,-1
			je	PAS_getver_fail

			mov	ah,al
			xor	al,11100000b

			out	dx,al
			nop
			nop
			nop
			nop
			in	al,dx

			cmp	al,ah
			xchg	al,ah
			out	dx,al
			jne	PAS_getver_fail

			and	eax,11100000b
			shr	al,5
			mov	esi,eax

			or	al,al
			jz	PAS_getver_org

			mov	edx,0ef8bh
			xor	edx,edi
			in	al,dx

			test	al,00001000b
			jz	PAS_getver_pls

			mov	PAS_card,3
                        mov     PAS_config,mixctrl_16bit+mixctrl_stereo
                        mov     PAS_rate,44192
			jmp	PAS_getver_done
PAS_getver_pls: 	mov	PAS_card,2
                        mov     PAS_config,mixctrl_stereo
			mov	PAS_rate,22096
			jmp	PAS_getver_done
PAS_getver_org: 	mov	PAS_card,1
                        mov     PAS_config,mixctrl_stereo
			mov	PAS_rate,22096
			jmp	PAS_getver_done
PAS_getver_done:	clc
			ret
PAS_getver_fail:	stc
			ret
PAS_getver		ENDP

;Ĵ PAS init 

PAS_init		PROC
			pushad
			mov	nms_error,12h
			mov	eax,PAS_port
			call	PAS_testhdw
			jc	PAS_init_fail

                        call    DMA_init
			jc	PAS_init_fail

			mov	PAS_active,0

			mov	eax,PAS_port
			xor	eax,388h
			mov	PAS_xorport,eax

			lea	eax,PAS_buff
			mov	PAS_tabptr,eax

			mov	pas.audiomixr[eax],31h
			mov	pas.crosschannel[eax],09h

			mov	ax,0bc00h
			mov	bx,'??'
			clr	cx
			clr	dx
			int	2fh
			xor	bx,cx
			xor	bx,dx
			cmp	bx,'MV'
			mov	nms_error,12h
			jne	PAS_init_nomvsound

			mov	ax,0bc02h
			int	2fh
			cmp	ax,'MV'
			mov	nms_error,16h
			jne	PAS_init_fail

			mov	PAS_tabseg,dx
			and	edx,0ffffh
			and	ebx,0ffffh
			shl	edx,4
			add	edx,ebx
			push	edx
			call	[SYS_getprginfo]
			pop	eax
			sub	eax,ebx
			mov	PAS_tabptr,eax
PAS_init_nomvsound:
			mov	edx,0b89h
			xor	edx,PAS_xorport
			out	dx,al

			mov	edi,PAS_tabptr

			mov	eax,1193180
			xor	edx,edx
                        mov     ebx,PAS_rate
			div	ebx
                        test    PAS_config,mixctrl_stereo
                        jz      PAS_init_notstereo
			shr	eax,1
PAS_init_notstereo:	mov	pas.samplerate[edi],ax

			mov	al,00110110b		;36h Timer 0 & square wave
			mov	edx,0138bh
			xor	edx,PAS_xorport
			cli
			out	dx,al
			mov	pas.tmrctlr[edi],al
			mov	ax,pas.samplerate[edi]
			mov	edx,01388h
			xor	edx,PAS_xorport
			out	dx,al
			nop
			nop
			xchg	al,ah
			out	dx,al
			sti

			mov	edx,0f8ah
			xor	edx,PAS_xorport
			mov	al,pas.crosschannel[edi]
			or	al,80h
			mov	pas.crosschannel[edi],al
			out	dx,al

                        mov     eax,PAS_rate
			clr	edx
			mov	ebx,25
			div	ebx
                        test    PAS_config,mixctrl_16bit
                        jz      PAS_init_not16bit
			shl	eax,1
PAS_init_not16bit:      test    PAS_config,mixctrl_stereo
                        jz      PAS_init_notstereo2
			shl	eax,1
PAS_init_notstereo2:	add	eax,16
			and	eax,0fff0h
                        mov     PAS_mixsize,eax

			mov	al,01011000b
			mov	ah,bptr PAS_dma
                        mov     ecx,PAS_mixsize
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	edi,PAS_tabptr
                        test    PAS_config,mixctrl_16bit
                        jz      PAS_init_not16bit2
			mov	cx,0f304h
			mov	edx,08389h
			xor	edx,PAS_xorport
			in	al,dx
			and	al,ch
			or	al,cl
			out	dx,al
PAS_init_not16bit2:
			mov	al,20h
                        test    PAS_config,mixctrl_stereo
                        jz      PAS_init_nostereo3
			clr	al
PAS_init_nostereo3:	or	al,50h
			mov	edx,0f8ah
			xor	edx,PAS_xorport
			mov	ah,8fh
			and	ah,pas.crosschannel[edi]
			or	al,ah
			xor	al,40h
			out	dx,al
			nop
			nop
			xor	al,40h
			out	dx,al
			mov	pas.crosschannel[edi],al

			mov	al,pas.audiofilt[edi]
			or	al,0c0h
			mov	edx,0b8ah
			xor	edx,PAS_xorport
			out	dx,al
			mov	pas.audiofilt[edi],al

			mov	al,pas.crosschannel[edi]
			mov	edx,0f8ah
			xor	edx,PAS_xorport
			or	al,80h
			out	dx,al
			mov	pas.crosschannel[edi],al

			mov	eax,5000/40
                        call    PAS_setbpm

                        mov     eax,PAS_config
                        mov     ebx,PAS_rate
                        call    MIX_init

			call	TMR_init

			popad
			clc
			ret
PAS_init_fail:		popad
			stc
			ret
PAS_init		ENDP
;Ĵ PAS exit 

PAS_exit		PROC
			pushad
			call	TMR_exit

                        mov     eax,PAS_dma
			call	DMA_stop

                        mov     edi,PAS_tabptr
			mov	edx,0b8ah
			xor	edx,PAS_xorport
			cli
			mov	al,pas.audiofilt[edi]
			and	al,not 0c0h
			mov	pas.audiofilt[edi],al
			out	dx,al

                        test    PAS_config,mixctrl_16bit
                        jz      PAS_exit_not16bit
			mov	edx,08389h
			xor	edx,PAS_xorport
			in	al,dx
			and	al,not 0ch
			out	dx,al
PAS_exit_not16bit:	mov	ah,not 08h
			mov	edx,0b8bh
			xor	edx,PAS_xorport
			in	al,dx
			and	al,ah
			out	dx,al
			mov	pas.intrctlr[edi],al

			mov	al,pas.crosschannel[edi]
			mov	edx,0f8ah
			xor	edx,PAS_xorport
			and	al,not 0c0h
			or	al,010h
			out	dx,al
			mov	pas.crosschannel[edi],al

			sti

			popad
			ret
PAS_exit		ENDP

;Ĵ PAS Set/Get bpm 

PAS_setbpm              PROC    USES eax ebx ecx edx
			mov	ebx,eax
			imul	ebx,40
			mov	eax,100
                        mul     PAS_rate
			div	ebx

			inc	eax
			and	eax,not 1

			mov	ebx,1
			clr	ecx
                        test    PAS_config,mixctrl_16bit
                        jz      PAS_setbpm_8bit
			shl	ebx,1
			inc	ecx
PAS_setbpm_8bit:        test    PAS_config,mixctrl_stereo
                        jz      PAS_setbpm_mono
			shl	ebx,1
			inc	ecx
PAS_setbpm_mono:        mov     PAS_bytespercount,ebx
                        mov     PAS_shiftpercount,ecx
			shl	eax,cl
                        mov     PAS_ticksize,eax
                        mov     PAS_tickleft,eax
			ret
PAS_setbpm              ENDP


;Ĵ PAS timer procedure 

PAS_TIRQ                PROC
			pushad
                        mov     eax,PAS_dma
                        call    DMA_getpos
                        mov     ebx,PAS_mixsize
			sub	ebx,eax
                        mov     PAS_dmapos,ebx
                        mov     eax,PAS_playpos
			xchg	eax,ebx
			cmp	ebx,eax
                        jge     PAS_TIRQ_after
PAS_TIRQ_before:        mov     ecx,eax
			sub	ecx,ebx
                        jmp     PAS_TIRQ_check
PAS_TIRQ_after:         mov     ecx,PAS_mixsize
			sub	ecx,ebx
			add	ecx,eax
PAS_TIRQ_check:         sub     ecx,16
			cmp	ecx,16
                        jl      PAS_TIRQ_noplay
                        cmp     ecx,PAS_tickleft
                        jbe     PAS_TIRQ_ok
                        mov     ecx,PAS_tickleft
PAS_TIRQ_ok:            and     ecx,NOT 3
                	and	ecx,NOT 1

                        mov     eax,PAS_playpos
                        mov     ebx,PAS_mixsize
			mov	edi,DMA_addr

			call    MIX
                        mov     PAS_playpos,eax

                        sub     PAS_tickleft,ecx
                        jnz     PAS_TIRQ_noplay
                	cmp	[FMT_playtick],0
                        je      PAS_TIRQ_noplay
			call	[FMT_playtick]
                        mov     eax,PAS_ticksize
                        mov     PAS_tickleft,eax
PAS_TIRQ_noplay:        popad
			ret
PAS_TIRQ                ENDP

;Ĵ PAS data 

.data

pas                     STRUC,NONUNIQUE
sysspkrtmr		db	0		;    42 System Speaker Timer Address
systmrctlr		db	0		;    43 System Timer Control
sysspkrreg		db	0		;    61 System Speaker Register
joystick		db	0		;   201 Joystick Register
lfmaddr 		db	0		;   388 Left  FM Synth Address
lfmdata 		db	0		;   389 Left  FM Synth Data
rfmaddr 		db	0		;   38A Right FM Synth Address
rfmdata 		db	0		;   38B Right FM Synth Data
dfmaddr 		db	0		;   788 Dual  FM Synthesizer Address Register
dfmdata 		db	0		;   789 Dual  FM Synthesizer Data Register
			db	0		;	reserved for future use
paudiomixr		db	0		;   78B Paralllel Audio Mixer Control
audiomixr		db	0		;   B88 Audio Mixer Control
intrctlrst		db	0		;   B89 Interrupt Status
audiofilt		db	0		;   B8A Audio Filter Control
intrctlr		db	0		;   B8B Interrupt Control
pcmdata 		db	0		;   F88 PCM Data I/O Register
			db	0		;	reserved
crosschannel		db	0		;   F8A Cross Channel
			db	0		;	reserved
samplerate		dw	0		;  1388 Sample Rate Timer
samplecnt		dw	0		;  1389 Sample Count Register
spkrtmr 		dw	0		;  138A Shadow Speaker Timer Count
tmrctlr 		db	0		;  138B Shadow Speaker Timer Control
mdirqvect		db	0		;  1788 MIDI IRQ Vector Register
mdsysctlr		db	0		;  1789 MIDI System Control Register
mdsysstat		db	0		;  178A MIDI IRQ Status Register
mdirqclr		db	0		;  178B MIDI IRQ Clear Register
mdgroup1		db	0		;  1B88 MIDI Group #1 Register
mdgroup2		db	0		;  1B89 MIDI Group #2 Register
mdgroup3		db	0		;  1B8A MIDI Group #3 Register
mdgroup4		db	0		;  1B8B MIDI Group #4 Register
pas			ENDS

PAS_name                db      "Pro Audio Spectrum",eol
PAS_name1		db	"Pro Audio Spectrum",eol
PAS_name2		db	"Pro Audio Spectrum plus",eol
PAS_name3		db	"Pro Audio Spectrum 16",eol

PAS_version		db	"Pro Audio Spectrum driver v1.00",eol
PAS_note                db      "NOT TESTED! Doesn't require mvsound.sys to be installed.",eol

PAS_cardlst		dd	PAS_name1,00010101b
			dd	PAS_name2,00010101b
			dd	PAS_name3,00010101b

PAS_portdesc		db	'Port',eol
PAS_portlst		dd	388h,384h,38ch,288h,-1
PAS_irqdesc		db	'IRQ',eol
PAS_irqlst		dd	2,3,5,7,10,11,12,15,-1
PAS_dmadesc		db	'DMA',eol
PAS_dmalst		dd	1,3,5,6,7,-1

PAS_cmdlist		db	'PAS',0                 ;drv_id
                        dd      PAS_name                ;drv_text
			dd	PAS_version		;drv_version
			dd	PAS_note		;drv_note
PAS_card		dd	0			;drv_card
			dd	3			;drv_cards
			dd	PAS_cardlst		;drv_cardlst
			dd	00010101b		;drv_config
PAS_port		dd	388h			;drv_port1
			dd	PAS_portlst		;drv_port1lst
			dd	PAS_portdesc		;drv_port1desc
			dd	-1			;drv_port2
			dd	-1			;drv_port2lst
			dd	-1			;drv_port2desc
PAS_irq 		dd	7			;drv_irq1
			dd	PAS_irqlst		;drv_irq1lst
			dd	PAS_irqdesc		;drv_irq1desc
			dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
PAS_dma 		dd	3			;drv_dma1
			dd	PAS_dmalst		;drv_dma1lst
			dd	PAS_dmadesc		;drv_dma1desc
			dd	-1			;drv_dma2
			dd	-1			;drv_dma2lst
			dd	-1			;drv_dma2desc
			dd	PAS_detect		;drv_detect
			dd	PAS_init		;drv_init
			dd	PAS_exit		;drv_exit
			dd	PAS_activate		;drv_activate
			dd	PAS_deactivate		;drv_deactivate
                        dd      PAS_setbpm              ;drv_setbpm
                        dd      TMR_activatesync        ;drv_activatesync
                        dd      TMR_deactivatesync      ;drv_deactivatesync
                        dd      TMR_sync                ;drv_sync
                        dd      MIX_setsample           ;drv_setsample
			dd	MIX_clrsamples		;drv_clrsamples
			dd	MIX_initsamples 	;drv_initsamples
			dd	MIX_setactivesample	;drv_setactivesample
			dd	MIX_setchns		;drv_setchns
			dd	MIX_setmastervol	;drv_setmastervol
			dd	MIX_setactivechn	;drv_setactivechn
			dd	MIX_setmode		;drv_setmode
			dd	MIX_setstart		;drv_setstart
			dd	MIX_setend		;drv_setend
			dd	MIX_setlstart		;drv_setlstart
			dd	MIX_setlend		;drv_setlend
			dd	MIX_setfreq		;drv_setfreq
			dd	MIX_setvol		;drv_setvol
			dd	MIX_setpan		;drv_setpan
			dd	MIX_startchn		;drv_startchn
			dd	MIX_stopchn		;drv_stopchn

PAS_config              dd      0
PAS_rate                dd      0
PAS_mixsize             dd      8192

PAS_ticksize            dd      0
PAS_tickleft            dd      0
PAS_bytespercount       dd      0
PAS_shiftpercount       dd      0
PAS_playpos             dd      0
PAS_dmapos              dd      0

PAS_active              db      0

PAS_buff                db      size pas dup(0)

PAS_tabptr		dd	0
PAS_tabseg		dw	0
PAS_xorport		dd	0

PAS_irqlist             db      08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,70h,71h,72h,73h,74h,75h,76h,77h


			END
