

 

                     Ŀ
                       
        Ŀ           
          Ŀ      Ŀ Ŀ
            Ŀ   Ŀ  
        Ŀ         Ŀ       Ŀ  
                              
                              
          Ŀ            Ŀ
              

                                        Ŀ
                                          
                                          
                   Ŀ Ŀ   Ŀ Ŀ
                   Ŀ     ٳ      Ŀ  
                   Ŀ                  Ŀ Ŀ  
                                          
                                                
                     Ŀ   Ŀ   Ŀ     Ŀ
                     ٳ   
                                                       
                                               
                                             

 

; Player by
;    the edge / CASCADA  <f94-hwa@nada.kth.se>
; Conversion to flat real mode by
;    Cyborg / Mistery  <cyborg@otitsun.oulu.fi>


;-----------------------------------------------------------------------------
; Are we using flat real mode or Watcom flat protected mode?

 ;FRM              = 1  ; Flat real mode

;-----------------------------------------------------------------------------
; Different volume tables:

 VolFineLinear    = 1  ; best quality
 ;VolBoostedLinear = 1  ; maximum output

;-----------------------------------------------------------------------------

 SetGUSLatches = 1 ; Set GUS internal irq and dma selection, neccessary
                   ; to override Plug n' Play stupidity.

;-----------------------------------------------------------------------------

                .386p
                LOCALS
                JUMPS
IFNDEF FRM
                MODEL FLAT
ENDIF

;

                PUBLIC  init_card_
                PUBLIC  init_song_
                PUBLIC  start_song_
                PUBLIC  stop_song_
                PUBLIC  play_musictick_
                PUBLIC  start_gusirq_
                PUBLIC  gus_interrupt_
                PUBLIC  set_globalvol_
                PUBLIC  set_songpos_
                PUBLIC  set_pattpos_

;

                PUBLIC C SongPtr
                PUBLIC C SongPos             ; Read ONLY!
                PUBLIC C PattPos             ; Read ONLY!
                PUBLIC C SoundCard

                PUBLIC C GUSBasePort
                PUBLIC C GUSDramDMA
                PUBLIC C GUSAdcDMA
                PUBLIC C GUSGf1IRQ
                PUBLIC C GUSMidiIRQ

;

                AudioMem_Required = 256*1024


;

                Card_NoSound    = 0
                Card_GUS        = 1
                Card_GUSIW      = 2


;
; Flat real mode support macros
;

outsbd          MACRO
IFDEF FRM
                db 67h
ENDIF
                outsb
                ENDM

stosbd          MACRO
IFDEF FRM
                db 67h
ENDIF
                stosb
                ENDM

stosdd          MACRO
IFDEF FRM
                db 67h
ENDIF
                stosd
                ENDM


lodsbd          MACRO
IFDEF FRM
                db 67h
ENDIF
                lodsb
                ENDM


;
; XM structures
;

SongType        STRUC

Song_id         db      17 dup (0)
Song_modname    db      20 dup (0)
Song_dummy1     db      0
Song_trkrname   db      20 dup (0)
Song_version    dw      0
Song_hsize      dd      0
Song_songlen    dw      0
Song_restart    dw      0
Song_channum    dw      0
Song_pattnum    dw      0
Song_instnum    dw      0
Song_flags      dw      0
Song_tempo      dw      0
Song_speed      dw      0
Song_pattorder  db      256 dup (0)

                ENDS

;-----------------------------------------------------------------------------

InstType        STRUC

Inst_size       dd      0
Inst_name       db      22 dup (0)
Inst_type       db      0
Inst_sampnum    dw      0
Inst_samphsize  dd      0
Inst_sampnotes  db      96 dup (0)
Inst_volenvpts  dw      24 dup (0)
Inst_panenvpts  dw      24 dup (0)
Inst_volptsnum  db      0
Inst_panptsnum  db      0
Inst_volsuspnt  db      0
Inst_vollpspnt  db      0
Inst_vollpepnt  db      0
Inst_pansuspnt  db      0
Inst_panlpspnt  db      0
Inst_panlpepnt  db      0
Inst_voltype    db      0
Inst_pantype    db      0
Inst_vibtype    db      0
Inst_vibsweep   db      0
Inst_vibdepth   db      0
Inst_vibrate    db      0
Inst_volfadout  dw      0
Inst_reserved   dw      0

                ENDS

;-----------------------------------------------------------------------------

SampType        STRUC

Samp_len        dd      0
Samp_loopstart  dd      0
Samp_looplen    dd      0
Samp_vol        db      0
Samp_finetune   db      0
Samp_type       db      0
Samp_pan        db      0
Samp_relnote    db      0
Samp_reserved   db      0
Samp_name       db      22 dup (0)

                ENDS

;-----------------------------------------------------------------------------

PattType        STRUC

Patt_hsize      dd      0
Patt_packtype   db      0
Patt_rownum     dw      0
Patt_packsize   dw      0

                ENDS

;-----------------------------------------------------------------------------

ChanType        STRUC

Chan_period     dd      0        ; 8 dwords
Chan_basperiod  dd      0
Chan_desperiod  dd      0
Chan_finperiod  dd      0
Chan_venvvol    dd      0
Chan_venvadd    dd      0
Chan_penvpan    dd      0
Chan_penvadd    dd      0

Chan_portaspd   dw      0        ; 6 words
Chan_pattpos    dw      0
Chan_eff        dw      0
Chan_venvcnt    dw      0
Chan_fadevol    dw      0
Chan_penvcnt    dw      0

Chan_delaycnt   db      0        ; 59 bytes
Chan_tickcnt    db      0
Chan_vibcon     db      0
Chan_vibpos     db      0
Chan_trempos    db      0
Chan_tremcon    db      0
Chan_portadir   db      0
Chan_glissfunc  db      0
Chan_vibspeed   db      0
Chan_vibdepth   db      0
Chan_loopcnt    db      0
Chan_tremspeed  db      0
Chan_tremdepth  db      0
Chan_status     db      0
Chan_gusvol     db      0
Chan_iton       db      0
Chan_iinst      db      0
Chan_ivoldata   db      0
Chan_ieff       db      0
Chan_ieffdata   db      0
Chan_linst      db      0
Chan_portainst  db      0
Chan_vibflag    db      0
Chan_samp       db      0
Chan_vol        db      0
Chan_basvol     db      0
Chan_finetune   db      0
Chan_relnote    db      0
Chan_chanoff    db      0
Chan_ldportup   db      0
Chan_ldportdw   db      0
Chan_ldtonport  db      0
Chan_ldvib      db      0
Chan_ldtpvol    db      0
Chan_ldvibvol   db      0
Chan_ldtrem     db      0
Chan_ldvols     db      0
Chan_ldfportup  db      0
Chan_ldfportdw  db      0
Chan_ldfvolsup  db      0
Chan_ldfvolsdw  db      0
Chan_venvppos   db      0
Chan_susflag    db      0
Chan_pan        db      0
Chan_ldpans     db      0
Chan_penvppos   db      0
Chan_ivibscnt   db      0
Chan_ivibpos    db      0
Chan_volatsus   db      0
Chan_panatsus   db      0
Chan_ldxfporup  db      0
Chan_ldxfpordw  db      0
Chan_ldgvols    db      0
Chan_lton       db      0
Chan_volswitch  db      0
Chan_tremorcnt  db      0
Chan_zerovol    db      0
Chan_mrtrigdat  db      0
Chan_mrtrigcnt  db      0

Chan_dummy      db      1 dup (0)   ; alignment fillout

                ENDS

ChanFlg_vol     EQU 001
ChanFlg_period  EQU 002
ChanFlg_newtone EQU 004
ChanFlg_pan     EQU 008


;

IFNDEF FRM
DATASEG
ENDIF

;

                ALIGN   4

SongPtr         dd      0
InstPtrs        dd      128 dup (0)
SampPtrs        dd      16*128 dup (0)
SampDataPtrs    dd      16*128 dup (0)
SampDataGUSPtrs dd      16*128 dup (0)
PattPtrs        dd      256 dup (0)

                ALIGN   4
Channels        db      32*(SIZE ChanType) dup (0)

;-----------------------------------------------------------------------------

                ALIGN   4

SongVars        LABEL   BYTE

ChanNum         dw      0
Speed           dw      0
Tempo           dw      0
SpeedCount      dw      0
TempoCount      dw      0
SongPos         dw      0
PattPos         dw      0
PattDataOffset  dd      0
PattDelayCnt    db      0
StopFlag        db      0
PlayFlag        db      0
EmptyPattFlag   db      0
PattBreakFlag   db      0
PosJumpFlag     db      0
PattBreakPos    dw      0
NewPattPosFlag  db      0
AmigaFlag       db      0
SongPresent     db      0
SongStatus      db      0

SongVarsEnd     LABEL   BYTE

GlobalVol       db      0
SoundCard       dd      0

;-----------------------------------------------------------------------------
                ALIGN   4

GUSBasePort     dd      0
GUSDramDMA      dd      0
GUSAdcDMA       dd      0
GUSGf1IRQ       dd      0
GUSMidiIRQ      dd      0
GUSMem          dd      0
GUSDMAChn       dw      0
GUSStatusP      dw      0
GUSTimerCntlP   dw      0
GUSTimerDataP   dw      0
GUSMidiCntlP    dw      0
GUSMidiDataP    dw      0
GUSVoiceP       dw      0
GUSCommandP     dw      0
GUSDataLoP      dw      0
GUSDataHiP      dw      0
GUSDRAMIOP      dw      0
GUSIntCount     db      0
GUSPresent      db      0
GUSActiveVoices db      0
GUSIrqEnabled   db      0

;-----------------------------------------------------------------------------
                ALIGN   4

LinearTab       dd 535232,534749,534266,533784,533303,532822,532341,531861
                dd 531381,530902,530423,529944,529466,528988,528511,528034
                dd 527558,527082,526607,526131,525657,525183,524709,524236
                dd 523763,523290,522818,522346,521875,521404,520934,520464
                dd 519994,519525,519057,518588,518121,517653,517186,516720
                dd 516253,515788,515322,514858,514393,513929,513465,513002
                dd 512539,512077,511615,511154,510692,510232,509771,509312
                dd 508852,508393,507934,507476,507018,506561,506104,505647
                dd 505191,504735,504280,503825,503371,502917,502463,502010
                dd 501557,501104,500652,500201,499749,499298,498848,498398
                dd 497948,497499,497050,496602,496154,495706,495259,494812
                dd 494366,493920,493474,493029,492585,492140,491696,491253
                dd 490809,490367,489924,489482,489041,488600,488159,487718
                dd 487278,486839,486400,485961,485522,485084,484647,484210
                dd 483773,483336,482900,482465,482029,481595,481160,480726
                dd 480292,479859,479426,478994,478562,478130,477699,477268
                dd 476837,476407,475977,475548,475119,474690,474262,473834
                dd 473407,472979,472553,472126,471701,471275,470850,470425
                dd 470001,469577,469153,468730,468307,467884,467462,467041
                dd 466619,466198,465778,465358,464938,464518,464099,463681
                dd 463262,462844,462427,462010,461593,461177,460760,460345
                dd 459930,459515,459100,458686,458272,457859,457446,457033
                dd 456621,456209,455797,455386,454975,454565,454155,453745
                dd 453336,452927,452518,452110,451702,451294,450887,450481
                dd 450074,449668,449262,448857,448452,448048,447644,447240
                dd 446836,446433,446030,445628,445226,444824,444423,444022
                dd 443622,443221,442821,442422,442023,441624,441226,440828
                dd 440430,440033,439636,439239,438843,438447,438051,437656
                dd 437261,436867,436473,436079,435686,435293,434900,434508
                dd 434116,433724,433333,432942,432551,432161,431771,431382
                dd 430992,430604,430215,429827,429439,429052,428665,428278
                dd 427892,427506,427120,426735,426350,425965,425581,425197
                dd 424813,424430,424047,423665,423283,422901,422519,422138
                dd 421757,421377,420997,420617,420237,419858,419479,419101
                dd 418723,418345,417968,417591,417214,416838,416462,416086
                dd 415711,415336,414961,414586,414212,413839,413465,413092
                dd 412720,412347,411975,411604,411232,410862,410491,410121
                dd 409751,409381,409012,408643,408274,407906,407538,407170
                dd 406803,406436,406069,405703,405337,404971,404606,404241
                dd 403876,403512,403148,402784,402421,402058,401695,401333
                dd 400970,400609,400247,399886,399525,399165,398805,398445
                dd 398086,397727,397368,397009,396651,396293,395936,395579
                dd 395222,394865,394509,394153,393798,393442,393087,392733
                dd 392378,392024,391671,391317,390964,390612,390259,389907
                dd 389556,389204,388853,388502,388152,387802,387452,387102
                dd 386753,386404,386056,385707,385359,385012,384664,384317
                dd 383971,383624,383278,382932,382587,382242,381897,381552
                dd 381208,380864,380521,380177,379834,379492,379149,378807
                dd 378466,378124,377783,377442,377102,376762,376422,376082
                dd 375743,375404,375065,374727,374389,374051,373714,373377
                dd 373040,372703,372367,372031,371695,371360,371025,370690
                dd 370356,370022,369688,369355,369021,368688,368356,368023
                dd 367691,367360,367028,366697,366366,366036,365706,365376
                dd 365046,364717,364388,364059,363731,363403,363075,362747
                dd 362420,362093,361766,361440,361114,360788,360463,360137
                dd 359813,359488,359164,358840,358516,358193,357869,357547
                dd 357224,356902,356580,356258,355937,355616,355295,354974
                dd 354654,354334,354014,353695,353376,353057,352739,352420
                dd 352103,351785,351468,351150,350834,350517,350201,349885
                dd 349569,349254,348939,348624,348310,347995,347682,347368
                dd 347055,346741,346429,346116,345804,345492,345180,344869
                dd 344558,344247,343936,343626,343316,343006,342697,342388
                dd 342079,341770,341462,341154,340846,340539,340231,339924
                dd 339618,339311,339005,338700,338394,338089,337784,337479
                dd 337175,336870,336566,336263,335959,335656,335354,335051
                dd 334749,334447,334145,333844,333542,333242,332941,332641
                dd 332341,332041,331741,331442,331143,330844,330546,330247
                dd 329950,329652,329355,329057,328761,328464,328168,327872
                dd 327576,327280,326985,326690,326395,326101,325807,325513
                dd 325219,324926,324633,324340,324047,323755,323463,323171
                dd 322879,322588,322297,322006,321716,321426,321136,320846
                dd 320557,320267,319978,319690,319401,319113,318825,318538
                dd 318250,317963,317676,317390,317103,316817,316532,316246
                dd 315961,315676,315391,315106,314822,314538,314254,313971
                dd 313688,313405,313122,312839,312557,312275,311994,311712
                dd 311431,311150,310869,310589,310309,310029,309749,309470
                dd 309190,308911,308633,308354,308076,307798,307521,307243
                dd 306966,306689,306412,306136,305860,305584,305308,305033
                dd 304758,304483,304208,303934,303659,303385,303112,302838
                dd 302565,302292,302019,301747,301475,301203,300931,300660
                dd 300388,300117,299847,299576,299306,299036,298766,298497
                dd 298227,297958,297689,297421,297153,296884,296617,296349
                dd 296082,295815,295548,295281,295015,294749,294483,294217
                dd 293952,293686,293421,293157,292892,292628,292364,292100
                dd 291837,291574,291311,291048,290785,290523,290261,289999
                dd 289737,289476,289215,288954,288693,288433,288173,287913
                dd 287653,287393,287134,286875,286616,286358,286099,285841
                dd 285583,285326,285068,284811,284554,284298,284041,283785
                dd 283529,283273,283017,282762,282507,282252,281998,281743
                dd 281489,281235,280981,280728,280475,280222,279969,279716
                dd 279464,279212,278960,278708,278457,278206,277955,277704
                dd 277453,277203,276953,276703,276453,276204,275955,275706
                dd 275457,275209,274960,274712,274465,274217,273970,273722
                dd 273476,273229,272982,272736,272490,272244,271999,271753
                dd 271508,271263,271018,270774,270530,270286,270042,269798
                dd 269555,269312,269069,268826,268583,268341,268099,267857

AmigaTab        dw 914
                dw 907,900,894,887,881,875,868,862
                dw 856,850,844,838,832,826,820,814
                dw 808,802,796,791,785,779,774,768
                dw 762,757,752,746,741,736,730,725
                dw 720,715,709,704,699,694,689,684
                dw 678,675,670,665,660,655,651,646
                dw 640,636,632,628,623,619,614,610
                dw 604,601,597,592,588,584,580,575
                dw 570,567,563,559,555,551,547,543
                dw 538,535,532,528,524,520,516,513
                dw 508,505,502,498,494,491,487,484
                dw 480,477,474,470,467,463,460,457
                dw 453,450,447,443,440,437,434,431
                dw 428


ArpTab          db 0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0


VibTab          db 000,024,049,074,097,120,141,161
                db 180,197,212,224,235,244,250,253
                db 255,253,250,244,235,224,212,197
                db 180,161,141,120,097,074,049,024

                ALIGN 2
                IFDEF VolFineLinear
GUSVolTab       dw 02000h,08ff0h,09ff0h,0a800h,0aff0h,0b400h,0b800h,0bc00h
                dw 0bff0h,0c200h,0c400h,0c600h,0c800h,0ca00h,0cc00h,0ce00h
                dw 0cff0h,0d100h,0d200h,0d300h,0d400h,0d500h,0d600h,0d700h
                dw 0d800h,0d900h,0da00h,0db00h,0dc00h,0dd00h,0de00h,0df00h
                dw 0dff0h,0e080h,0e100h,0e180h,0e200h,0e280h,0e300h,0e380h
                dw 0e400h,0e480h,0e500h,0e580h,0e600h,0e680h,0e700h,0e780h
                dw 0e800h,0e880h,0e900h,0e980h,0ea00h,0ea80h,0eb00h,0eb80h
                dw 0ec00h,0ec80h,0ed00h,0ed80h,0ee00h,0ee80h,0ef00h,0ef80h
                ENDIF
                IFDEF VolBoostedLinear
GUSVolTab       dw 02000h,09ef0h,0aef0h,0b700h,0bef0h,0c300h,0c700h,0cb00h
                dw 0cef0h,0d100h,0d300h,0d500h,0d700h,0d900h,0db00h,0dd00h
                dw 0def0h,0e000h,0e100h,0e200h,0e300h,0e400h,0e500h,0e600h
                dw 0e700h,0e800h,0eb00h,0ea00h,0eb00h,0ec00h,0ed00h,0ee00h
                dw 0eef0h,0ef80h,0f000h,0f080h,0f100h,0f180h,0f200h,0f280h
                dw 0f300h,0f380h,0f400h,0f480h,0f500h,0f580h,0f600h,0f680h
                dw 0f700h,0f780h,0f800h,0f880h,0fb00h,0f980h,0fa00h,0fa80h
                dw 0fb00h,0fb80h,0fc00h,0fc80h,0fd00h,0fd80h,0fe00h,0fe80h
                dw 0fef0h
                ENDIF

GUSIWPanTab     dw 0fff0h,06fd0h,05fd0h,05670h,04fd0h,04ab0h,04670h,042e0h
                dw 03fd0h,03d20h,03ab0h,03870h,03670h,034a0h,032e0h,03150h
                dw 02fd0h,02e70h,02d20h,02be0h,02ab0h,02990h,02870h,02770h
                dw 02670h,02580h,024a0h,023c0h,022e0h,02210h,02150h,02090h
                dw 01fd0h,01f20h,01e70h,01dc0h,01d20h,01c70h,01be0h,01b40h
                dw 01ab0h,01a20h,01990h,01900h,01870h,017f0h,01770h,016f0h
                dw 01670h,01600h,01580h,01510h,014a0h,01430h,013c0h,01350h
                dw 012e0h,01280h,01210h,011b0h,01150h,010f0h,01090h,01030h
GUSIWPanTabMid  dw 00fd0h,00f70h,00f20h,00ec0h,00e70h,00e10h,00dc0h,00d70h
                dw 00d20h,00cd0h,00c70h,00c30h,00be0h,00b90h,00b40h,00af0h
                dw 00ab0h,00a60h,00a20h,009d0h,00990h,00940h,00900h,008c0h
                dw 00870h,00830h,007f0h,007b0h,00770h,00730h,006f0h,006b0h
                dw 00670h,00640h,00600h,005c0h,00580h,00550h,00510h,004d0h
                dw 004a0h,00460h,00430h,003f0h,003c0h,00380h,00350h,00320h
                dw 002e0h,002b0h,00280h,00250h,00210h,001e0h,001b0h,00180h
                dw 00150h,00120h,000f0h,000c0h,00090h,00060h,00030h,00000h
                dw 00000h

GUSDivTab       dw 44100,41160,38588,36318,34300,32495,30870
                dw 29400,28064,26843,25725,24696,23746,22867
                dw 22050,21290,20580,19916,19294


;
;

IFNDEF FRM
CODESEG
ENDIF

;
; Main playing routines
;


;

start_song_     PROC    NEAR

                cmp     GUSIrqEnabled,0
                jz      @@no_irq
                call    start_gusirq_
@@no_irq:

                cmp     SongPresent,0
                jz      @@end
                mov     PlayFlag,1
@@end:          ret
                ENDP

;

stop_song_      PROC    NEAR
                pushad

                cmp     PlayFlag,0
                jz      @@end
                mov     PlayFlag,0

                mov     eax,SoundCard
                cmp     eax,Card_GUS
                je      @@gus
                cmp     eax,Card_GUSIW
                je      @@gusiw

                jmp     @@end
;-----------------------------------------------------------------------------
@@gus:          call    GUSStopVocs
                jmp     @@end
;-----------------------------------------------------------------------------
@@gusiw:        call    GUSIWStopVocs
                call    GUSSetGF1Mode

@@end:          popad
                ret
                ENDP


;

play_musictick_ PROC    NEAR

                pushad

                cmp     PlayFlag,0
                jz      @@end

                mov     eax,SoundCard
                cmp     eax,Card_GUS
                je      @@gus
                cmp     eax,Card_GUSIW
                je      @@gusiw

                call    PlayNoSTick
                jmp     @@end

@@gus:          call    PlayGUSTick
                jmp     @@end

@@gusiw:        call    PlayGUSIWTick
                jmp     @@end

@@end:          popad

                ret
                ENDP

;


set_globalvol_  PROC    NEAR
                ;       In:
                ;        eax = global volume (0-64)

                push    ecx
                push    edx
                cmp     eax,64
                jbe     @@gvolok
                mov     eax,64
@@gvolok:       mov     GlobalVol,al
                movzx   ecx,ChanNum
                lea     edx,Channels
@@gvolsetloop:  or      [edx.Chan_status],ChanFlg_vol
                lea     edx,SIZE ChanType[edx]
                dec     ecx
                jg      @@gvolsetloop
                pop     edx
                pop     ecx

                ret
                ENDP


;

CalcVol         PROC    NEAR
                ;       In:
                ;        edi = channel ptr
                ;       Out:
                ;        eax = volume (0-64)

                xor     eax,eax
                cmp     [edi.Chan_zerovol],0
                jnz     @@zerovol

                push    ebx
                push    edx
                mov     ebx,[edi.Chan_venvvol]
                shr     ebx,16
                mov     al,[edi.Chan_vol]
                imul    eax,ebx
                movzx   ebx,GlobalVol
                imul    eax,ebx
                xor     ebx,ebx
                mov     bx,[edi.Chan_fadevol]
                imul    ebx
                shrd    eax,edx,28
                pop     edx
                pop     ebx
@@zerovol:
                ret
                ENDP

;

CalcPan         PROC    NEAR
                ;       In:
                ;        edi = channel ptr
                ;       Out:
                ;         al = pan (0-255)

                push    edx
                mov     al,[edi.Chan_pan]
                sub     al,128
                jge     @@pan_npneg
                neg     al
@@pan_npneg:    sub     al,128
                movsx   eax,al
                neg     eax
                mov     edx,[edi.Chan_penvpan]
                sar     edx,16
                sub     edx,32
                imul    eax,edx
                sar     eax,5
                add     al,[edi.Chan_pan]
                pop     edx

                ret
                ENDP

;

CalcCombVolPan  PROC    NEAR
                ;       In:
                ;        edi = channel ptr
                ;       Out:
                ;         al = right volume (0-255)
                ;         ah =  left volume (0-255)


                call    CalcVol
                mov     edx,eax
                mov     ecx,eax

                call    CalcPan

                and     eax,0ffh
                imul    edx,eax
                sub     eax,255
                neg     eax
                imul    ecx,eax
                shr     ecx,6
                shr     edx,6

                mov     al,dl
                mov     ah,cl

                ret
                ENDP


;

CalcFreq        PROC    NEAR
                ;       In:
                ;        eax = period
                ;       Out:
                ;        eax = frequency


                push    ebx
                push    ecx
                push    edx

                or      eax,eax
                jz      @@frq_ready
                cmp     AmigaFlag,0
                jnz     @@amiga

@@linear:       cdq
                mov     ebx,768
                div     ebx
                mov     cl,al
                mov     eax,LinearTab[edx*4]
                sar     eax,cl
                jmp     @@frq_ready

@@amiga:        mov     ebx,eax
                mov     eax,8363*1712
                xor     edx,edx
                div     ebx

@@frq_ready:    pop     edx
                pop     ecx
                pop     ebx
                ret
                ENDP

;

CalcPeriod      PROC    NEAR
                ;       In:
                ;         al = notenumber (0..118)
                ;         ah = finetune   (-128..127)
                ;       Out:
                ;        eax = period


                push    ebx
                push    ecx
                push    edx

@@note_ok1:     cmp     al,118
                jbe     @@note_ok
                mov     al,118
@@note_ok:
                cmp     AmigaFlag,0
                jnz     @@amiga

@@linear:       mov     dl,al
                mov     al,ah
                movsx   eax,al
                movzx   edx,dl
                sal     edx,6
                sar     eax,1
                add     eax,edx
                neg     eax
                add     eax,7680
                jmp     @@end

@@amiga:        push    esi

                movsx   ecx,ah
                movzx   eax,al
                cdq
                mov     ebx,12
                div     ebx
                sal     edx,3
                mov     ebx,ecx
                sar     ebx,4
                lea     ebx,9[ebx+edx]
                movzx   esi,AmigaTab[ebx*2]
                or      ecx,ecx
                jl      @@fineisneg
                inc     ebx
                jmp     @@finecont
@@fineisneg:    dec     ebx
                neg     ecx
@@finecont:     movzx   ebx,AmigaTab[ebx*2]
                and     ecx,0fh
                imul    ebx,ecx
                sub     ecx,16
                neg     ecx
                imul    esi,ecx
                add     ebx,esi
                add     ebx,ebx
                mov     ecx,eax
                sar     ebx,cl
                mov     eax,ebx

                pop     esi

@@end:          pop     edx
                pop     ecx
                pop     ebx

                ret
                ENDP

;

BoundPeriod     PROC    NEAR
                ;       In:
                ;       eax = period
                ;       Out:
                ;       eax = bounded period

                push    ebx
                push    edx

                cmp     AmigaFlag,0
                jnz     @@amiga

@@linear:       cmp     eax,64
                jge     @@lok1
                mov     eax,64
@@lok1:         cmp     eax,7744
                jle     @@lok2
                mov     eax,7744
@@lok2:         jmp     @@end

@@amiga:        cmp     eax,28
                jge     @@aok1
                mov     eax,28
@@aok1:         cmp     eax,29024
                jle     @@aok2
                mov     eax,29024
@@aok2:
@@end:          pop     edx
                pop     ebx
                ret
                ENDP

;


DCodePeriod     PROC    NEAR
                ;       In:
                ;        al = finetune   (-128..127)
                ;       ebx = period
                ;       Out:
                ;        al = tonenumber


                push    ebx
                push    edx

                cmp     AmigaFlag,0
                jnz     @@amiga

@@linear:       movsx   edx,al
                sar     edx,1
                neg     ebx
                sub     ebx,edx
                mov     edx,7680
                add     ebx,edx
                sal     ebx,2
                cmp     bl,80h
                jb      @@lower
                inc     bh
@@lower:        mov     al,bh
                jmp     @@end


@@amiga:        push    ecx
                push    ebp

                mov     ebp,ebx
                mov     ah,al
                mov     al,118/2
                mov     dl,al

                mov     ecx,8
@@search_loop:  dec     ecx
                jl      @@note_found

                push    eax
                call    CalcPeriod
                mov     ebx,eax
                pop     eax

                cmp     ebp,ebx
                je      @@note_found
                jl      @@note_higher

@@note_lower:   shr     dl,1
                or      dl,dl
                jg      @@step_notz1
                mov     dl,1
@@step_notz1:   sub     al,dl
                jmp     @@search_loop

@@note_higher:  shr     dl,1
                or      dl,dl
                jg      @@step_notz2
                mov     dl,1
@@step_notz2:   add     al,dl
                jmp     @@search_loop

@@note_found:   pop     ebp
                pop     ecx

@@end:          pop     edx
                pop     ebx
                ret
                ENDP

;

StartTone       PROC    NEAR
                ;       In:
                ;        ax = effect (al=type,ah=data)
                ;       edi = ptr to channel

                push    edx
                mov     dl,ChanFlg_newtone
                or      dl,ChanFlg_period
                or      dl,ChanFlg_vol
                or      dl,ChanFlg_pan
                or      [edi.Chan_status],dl
                mov     edx,[edi.Chan_basperiod]
                mov     [edi.Chan_period],edx
                mov     [edi.Chan_eff],ax
                pop     edx
                ret
                ENDP

;

PlayNotes       PROC    NEAR

                cmp     StopFlag,0
                jnz     @@nonew

                dec     TempoCount
                jg      @@nonew
                mov     ax,Tempo
                mov     TempoCount,ax

                cmp     PattDelayCnt,0
                je      @@no_pattdelay

                dec     PattDelayCnt
                jnz     @@nonew

@@no_pattdelay: mov     ebx,SongPtr
                movzx   eax,SongPos
                mov     al,[ebx.Song_pattorder+eax]
                mov     esi,PattPtrs[eax*4]

                cmp     [esi.Patt_packsize],0
                jz      @@next_pos

                mov     eax,[esi.Patt_hsize]
                add     esi,eax
                push    esi
                add     esi,PattDataOffset
                lea     edi,Channels
                xor     ecx,ecx
@@new_chanloop: push    ecx
                call    GetNewNote
                pop     ecx
                lea     edi,SIZE ChanType[edi]
                inc     ecx
                cmp     cx,ChanNum
                jl      @@new_chanloop
                pop     eax
                sub     esi,eax
                mov     PattDataOffset,esi

                cmp     Tempo,0
                jnz     @@next_pos
                mov     StopFlag,1

@@next_pos:     call    GetNextPos
                jmp     @@noeff

@@nonew:        call    DoEffects
@@noeff:        call    DoIEffects

                ret
                ENDP

;

GetNewNote      PROC    NEAR
                ;       In:
                ;        esi = ptr to packed pattern data
                ;        edi = ptr to channel


                mov     ah,[esi]
                inc     esi
                test    ah,80h
                jz      @@not_packed

                xor     al,al
                mov     [edi.Chan_iinst],al
                mov     [edi.Chan_ivoldata],al
                mov     [edi.Chan_ieff],al
                mov     [edi.Chan_ieffdata],al
                mov     [edi.Chan_iton],al

                test    ah,1
                jz      @@no_note
                mov     al,[esi]
                inc     esi
                mov     [edi.Chan_iton],al
@@no_note:      test    ah,2
                jz      @@no_inst
                mov     al,[esi]
                inc     esi
                mov     [edi.Chan_iinst],al
@@no_inst:      test    ah,4
                jz      @@no_voleff
                mov     al,[esi]
                inc     esi
                mov     [edi.Chan_ivoldata],al
@@no_voleff:    test    ah,8
                jz      @@no_eff
                mov     al,[esi]
                inc     esi
                mov     [edi.Chan_ieff],al
@@no_eff:       test    ah,16
                jz      @@no_effdata
                mov     al,[esi]
                inc     esi
                mov     [edi.Chan_ieffdata],al
@@no_effdata:   jmp     @@got_data


@@not_packed:   mov     [edi.Chan_iton],ah
                mov     al,[esi]
                mov     [edi.Chan_iinst],al
                mov     al,1[esi]
                mov     [edi.Chan_ivoldata],al
                mov     al,2[esi]
                mov     [edi.Chan_ieff],al
                mov     al,3[esi]
                mov     [edi.Chan_ieffdata],al
                lea     esi,4[esi]

@@got_data:
                ; special treatment of notedelay function

                cmp     [edi.Chan_ieff],0eh
                jne     .NoDelay

                mov     al,[edi.Chan_ieffdata]
                mov     ah,al
                and     ah,0f0h
                cmp     ah,0d0h
                jne     .NoDelay
                and     al,0fh
                jz      .NoDelay

                mov     [edi.Chan_delaycnt],al
                ret

;

.NoDelay:       push    esi

                movzx   eax,[edi.Chan_iinst]
                cmp     al,128
                jbe     @@inst_ok1
                xor     eax,eax
                mov     [edi.Chan_iinst],al
@@inst_ok1:     or      al,al
                jz      @@no_vinst
                mov     esi,InstPtrs-4[eax*4]
                or      esi,esi
                jl      @@no_vinst
                mov     [edi.Chan_linst],al
@@no_vinst:
                cmp     [edi.Chan_ieff],14h             ; 'K'
                jne     @@no_krelease
                mov     [edi.Chan_iton],97
@@no_krelease:

;-----------------------------------------------------------------------------
; Note validity / Release handling

                mov     @@releaseflag,0

                mov     al,[edi.Chan_iton]
                cmp     al,96
                ja      @@no_tone
                or      al,al
                jz      @@no_tone
                mov     [edi.Chan_lton],al

@@no_tone:      cmp     al,96
                jbe     @@ton_ok
                mov     [edi.Chan_iton],0
                cmp     al,97
                jne     @@ton_ok

                mov     @@releaseflag,1
                mov     [edi.Chan_susflag],0
                xor     eax,eax
                mov     al,[edi.Chan_linst]
                dec     al
                jl      @@ton_ok
                mov     eax,InstPtrs[eax*4]
                or      eax,eax
                jl      @@ton_ok
                test    [eax.Inst_voltype],1
                jnz     @@ton_ok
                mov     [edi.Chan_vol],0
                mov     [edi.Chan_basvol],0
                or      [edi.Chan_status],ChanFlg_vol
@@ton_ok:

;-----------------------------------------------------------------------------
; Frequency retrig

                xor     bl,bl
                mov     al,[edi.Chan_vibflag]
                mov     bh,[edi.Chan_ieff]
                cmp     bh,4
                jne     @@frq_novib1
                inc     bl
@@frq_novib1:   cmp     bh,6
                jne     @@frq_novib2
                inc     bl
@@frq_novib2:   mov     bh,[edi.Chan_ivoldata]
                shr     bh,4
                cmp     bh,0bh
                jne     @@frq_novib3
                inc     bl
@@frq_novib3:   or      al,al
                jz      @@frq_rtrig
@@frq_rtest:    or      bl,bl
                jnz     @@frq_nortrig
@@frq_rtrig:    mov     eax,[edi.Chan_basperiod]
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
@@frq_nortrig:  mov     [edi.Chan_vibflag],bl


;-----------------------------------------------------------------------------
; New instrument

                xor     ecx,ecx
                mov     cl,[edi.Chan_iinst]
                or      cl,cl
                jz      @@no_newinst

                mov     dl,[edi.Chan_ieff]
                mov     bl,[edi.Chan_ivoldata]
                shr     bl,4
                cmp     dl,3
                je      @@ni_isporta
                cmp     dl,5
                je      @@ni_isporta
                cmp     bl,0fh
                je      @@ni_isporta

                mov     [edi.Chan_portainst],cl
                jmp     @@ni_portacont

@@ni_isporta:   mov     cl,[edi.Chan_portainst]
                or      cl,cl
                jz      @@no_newinst
@@ni_portacont:

                mov     esi,InstPtrs-4[ecx*4]
                or      esi,esi
                jl      @@no_newinst

                cmp     @@releaseflag,0
                jnz     @@is_release

                xor     edx,edx
                mov     [edi.Chan_venvppos],dl
                mov     [edi.Chan_venvcnt],dx
                mov     [edi.Chan_penvppos],dl
                mov     [edi.Chan_penvcnt],dx
                mov     [edi.Chan_ivibscnt],dl
                mov     [edi.Chan_ivibpos],dl
                mov     [edi.Chan_volatsus],dl
                mov     [edi.Chan_panatsus],dl
                mov     [edi.Chan_mrtrigcnt],dl

                test    [edi.Chan_vibcon],4
                jnz     @@vib_nretr
                mov     [edi.Chan_vibpos],0
@@vib_nretr:
                test    [edi.Chan_tremcon],4
                jnz     @@trem_nretr
                mov     [edi.Chan_trempos],0
@@trem_nretr:
                mov     ax,[esi.Inst_volenvpts+2]
                test    [esi.Inst_voltype],1
                jnz     @@is_envvol
                mov     al,64
@@is_envvol:    sal     eax,16
                mov     [edi.Chan_venvvol],eax

                mov     ax,[esi.Inst_panenvpts+2]
                test    [esi.Inst_pantype],1
                jnz     @@is_envpan
                mov     al,32
@@is_envpan:    sal     eax,16
                mov     [edi.Chan_penvpan],eax

                mov     [edi.Chan_susflag],1
                mov     [edi.Chan_fadevol],0ffffh
                or      [edi.Chan_status],ChanFlg_vol
                or      [edi.Chan_status],ChanFlg_pan


@@is_release:   movzx   eax,[edi.Chan_lton]
                or      eax,eax
                jz      @@no_newinst

                mov     al,[esi.Inst_sampnotes-1+eax]
                dec     cl
                mov     esi,ecx
                sal     esi,6
                mov     esi,SampPtrs[esi+eax*4]

                mov     al,[esi.Samp_vol]
                mov     [edi.Chan_vol],al
                mov     [edi.Chan_basvol],al
                mov     al,[esi.Samp_pan]
                mov     [edi.Chan_pan],al
                mov     [edi.Chan_zerovol],0
                mov     [edi.Chan_tremorcnt],0
                or      [edi.Chan_status],ChanFlg_vol
                or      [edi.Chan_status],ChanFlg_pan
@@no_newinst:

                cmp     [edi.Chan_linst],0
                jnz     @@no_linst
                mov     [edi.Chan_iton],0
@@no_linst:

;-----------------------------------------------------------------------------
; New tone

                mov     al,[edi.Chan_iton]
                mov     dl,[edi.Chan_ieff]
                mov     dh,[edi.Chan_ieffdata]
                mov     bl,[edi.Chan_ivoldata]

                mov     bh,bl
                shr     bl,4
                and     bh,0fh

                cmp     dl,3
                je      @@tone_porta
                cmp     dl,5
                je      @@tone_porta
                cmp     bl,0fh
                je      @@tone_porta

                or      al,al
                jz      @@get_effects
                dec     al

                push    eax
                push    ebx
                push    edx

                xor     edx,edx
                mov     dl,[edi.Chan_linst]
                dec     edx
                mov     ebx,InstPtrs[edx*4]
                and     eax,0ffh
                mov     al,[ebx.Inst_sampnotes+eax]
                mov     [edi.Chan_samp],al
                sal     edx,6
                mov     ebx,SampPtrs[edx+eax*4]
                mov     al,[ebx.Samp_finetune]
                mov     [edi.Chan_finetune],al
                mov     al,[ebx.Samp_relnote]
                mov     [edi.Chan_relnote],al

                pop     edx
                pop     ebx
                pop     eax

                mov     cx,dx
                and     cx,0f00fh
                cmp     cx,0500eh
                jne     @@no_finealter
                mov     cl,dh
                sal     cl,4
                sub     cl,80h
                mov     [edi.Chan_finetune],cl
@@no_finealter:

                push    eax
                mov     ah,[edi.Chan_finetune]
                add     al,[edi.Chan_relnote]
                call    CalcPeriod

                mov     [edi.Chan_basperiod],eax
                mov     eax,edx
                call    StartTone
                pop     eax

                jmp     @@get_effects


@@tone_porta:   or      al,al
                jz      @@porta_nofrq
                dec     al

                push    eax
                push    ebx
                push    edx

                xor     edx,edx
                mov     dl,[edi.Chan_portainst]
                dec     edx
                mov     ebx,InstPtrs[edx*4]
                and     eax,0ffh
                mov     al,[ebx.Inst_sampnotes+eax]
                mov     [edi.Chan_samp],al
                sal     edx,6
                mov     ebx,SampPtrs[edx+eax*4]
                mov     al,[ebx.Samp_finetune]
                mov     [edi.Chan_finetune],al
                mov     al,[ebx.Samp_relnote]
                mov     [edi.Chan_relnote],al

                pop     edx
                pop     ebx
                pop     eax

                mov     ah,[edi.Chan_finetune]
                add     al,[edi.Chan_relnote]
                call    CalcPeriod

                mov     [edi.Chan_desperiod],eax
                cmp     eax,[edi.Chan_basperiod]
                je      @@porta_nodiff
                jb      @@porta_up
                mov     [edi.Chan_portadir],1
                jmp     @@porta_nofrq
@@porta_up:     mov     [edi.Chan_portadir],2
                jmp     @@porta_nofrq
@@porta_nodiff: mov     [edi.Chan_portadir],0
@@porta_nofrq:  cmp     dl,5
                je      @@porta_nospd
                cmp     bl,0fh
                jne     @@porta_notvol
                mov     cl,bh
                sal     cl,4
                jmp     @@porta_setspd
@@porta_notvol: mov     cl,dh
@@porta_setspd: xor     ch,ch
                or      cx,cx
                jz      @@porta_nospd
                mov     [edi.Chan_portaspd],cx
@@porta_nospd:


;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
; New effect handeling
;

@@get_effects:  mov     ax,dx
                or      al,bl
                or      ax,ax
                jnz     @@eff_exist

@@end:          pop     esi
                ret

;-----------------------------------------------------------------------------
; Volume column


@@eff_exist:
IFNDEF FRM
                lea     eax,@@end
                push    eax
ELSE
                lea     ax,@@end
                push    ax
ENDIF

                push    edx
IFNDEF FRM
                lea     eax,@@vccom_end1
                push    eax
ELSE
                lea     ax,@@vccom_end1
                push    ax
ENDIF

                cmp     bl,1
                jl      @@no_vcvol
                cmp     bl,5
                jg      @@no_vcvol
                mov     dh,[edi.Chan_ivoldata]
                sub     dh,10h
                jmp     @@setvol
@@no_vcvol:
                cmp     bl,8
                jne     @@no_vcfvoldw
                mov     dh,bh
                jmp     @@fvoldw_vc
@@no_vcfvoldw:
                cmp     bl,9
                jne     @@no_vcfvolup
                mov     dh,bh
                jmp     @@fvolup_vc
@@no_vcfvolup:
                cmp     bl,0ah
                je      @@setvibspeed
                cmp     bl,0bh
                je      @@vc_vib
                cmp     bl,0ch
                je      @@vcsetpan

IFNDEF FRM
                lea     esp,4[esp]
ELSE
                lea     sp,2[esp]
ENDIF
@@vccom_end1:   pop     edx

;-----------------------------------------------------------------------------
; Ordinary column

                cmp     dl,0ch
                je      @@setvol
                cmp     dl,0ah
                je      @@vols
                cmp     dl,0eh
                je      @@eeffs
                cmp     dl,1
                je      @@portup
                cmp     dl,2
                je      @@portdw
                cmp     dl,4
                je      @@vib
                cmp     dl,5
                je      @@tonportvol
                cmp     dl,6
                je      @@vibvol
                cmp     dl,7
                je      @@trem
                cmp     dl,8
                je      @@setpan
                cmp     dl,0bh
                je      @@posjmp
                cmp     dl,0dh
                je      @@patbrk
                cmp     dl,0fh
                je      @@setspd
                cmp     dl,10h          ; 'G'
                je      @@setgvol
                cmp     dl,11h          ; 'H'
                je      @@gvols
                cmp     dl,15h          ; 'L'
                je      @@setenvp
                cmp     dl,19h          ; 'P'
                je      @@setpans
                cmp     dl,1bh
                je      @@mretrig       ; 'R'
                cmp     dl,21h          ; 'X'
                je      @@xfinpor

                ret

;-----------------------------------------------------------------------------
; E-effects

@@eeffs:        mov     dl,dh
                shr     dl,4

                cmp     dl,1
                je      @@fporup
                cmp     dl,2
                je      @@fpordw
                cmp     dl,3
                je      @@gliscn
                cmp     dl,4
                je      @@vibcn
                cmp     dl,7
                je      @@tremcn
                cmp     dl,9
                je      @@rtnote
                cmp     dl,0ah
                je      @@fvolup
                cmp     dl,0bh
                je      @@fvoldw
                cmp     dl,0ch
                je      @@notecut
                cmp     dl,6
                je      @@jmplop
                cmp     dl,0eh
                je      @@pattdelay

                ret

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
; Routines for effects / Last data store


@@fixeffdata:   or      dh,dh
                jz      @@fed_zero
                mov     [ebx],dh
                ret
@@fed_zero:     mov     dh,[ebx]
                mov     [edi.Chan_ieffdata],dh
                ret

;-----------------------------------------------------------------------------

@@fixeeffdata:  test    dh,0fh
                jz      @@feed_zero
                mov     [ebx],dh
                ret
@@feed_zero:    mov     dh,[ebx]
                mov     [edi.Chan_ieffdata],dh
                ret

;-----------------------------------------------------------------------------

@@portup:       lea     ebx,[edi.Chan_ldportup]
                jmp     @@fixeffdata

@@portdw:       lea     ebx,[edi.Chan_ldportdw]
                jmp     @@fixeffdata

@@tonport:      lea     ebx,[edi.Chan_ldtonport]
                jmp     @@fixeffdata

@@tonportvol:   lea     ebx,[edi.Chan_ldtpvol]
                jmp     @@fixeffdata

@@vibvol:       lea     ebx,[edi.Chan_ldvibvol]
                jmp     @@fixeffdata

@@trem:         lea     ebx,[edi.Chan_ldtrem]
                jmp     @@fixeffdata

@@vols:         lea     ebx,[edi.Chan_ldvols]
                jmp     @@fixeffdata

@@gvols:        lea     ebx,[edi.Chan_ldgvols]
                jmp     @@fixeffdata

@@setpans:      lea     ebx,[edi.Chan_ldpans]
                jmp     @@fixeffdata

;-----------------------------------------------------------------------------

@@setpan:       mov     [edi.Chan_pan],dh
                or      [edi.Chan_status],ChanFlg_pan
                ret

;-----------------------------------------------------------------------------

@@setenvp:      movzx   edx,dh
                xor     ecx,ecx
                mov     cl,[edi.Chan_linst]
                or      cl,cl
                jz      @@no_panenv

                mov     esi,InstPtrs-4[ecx*4]
                test    [esi.Inst_voltype],1
                jz      @@no_volenv
                lea     ebx,[esi.Inst_volenvpts]
                mov     ecx,1
@@volploop:     lea     ebx,4[ebx]
                cmp     dx,[ebx]
                jb      @@volpntfound
                inc     ecx
                cmp     cl,[esi.Inst_volptsnum]
                jl      @@volploop
                movzx   edx,WORD PTR 2[ebx]
                mov     [edi.Chan_venvppos],cl
                mov     [edi.Chan_venvvol],edx
                jmp     @@no_volenv
@@volpntfound:  mov     bp,[ebx]
                mov     ax,bp
                sub     ax,dx
                mov     [edi.Chan_venvcnt],ax
                mov     [edi.Chan_venvppos],cl
                xor     al,al
                dec     cl
                cmp     cl,[esi.Inst_volsuspnt]
                jne     @@volnosusmark
                mov     al,1
@@volnosusmark: mov     [edi.Chan_volatsus],al
                mov     ax,2[ebx]
                lea     ebx,-4[ebx]
                sub     bp,[ebx]
                sub     ax,2[ebx]
                movsx   ebp,bp
                movsx   eax,ax
                sal     eax,16
                push    edx
                cdq
                idiv    ebp
                pop     edx
                mov     [edi.Chan_venvadd],eax
                sub     dx,[ebx]
                movzx   edx,dx
                imul    eax,edx
                movzx   edx,WORD PTR 2[ebx]
                sal     edx,16
                add     edx,eax
                mov     [edi.Chan_venvvol],edx
@@no_volenv:
                test    [esi.Inst_pantype],1
                jz      @@no_panenv
                ;lea     ebx,InstT_panenvpts[esi]
                lea     ebx,[esi.Inst_panenvpts]
                mov     ecx,1
@@panploop:     lea     ebx,4[ebx]
                cmp     dx,[ebx]
                jb      @@panpntfound
                inc     ecx
                cmp     cl,[esi.Inst_panptsnum]
                jl      @@panploop
                mov     ax,2[ebx]
                mov     [edi.Chan_penvppos],cl
                movzx   edx,WORD PTR 2[ebx]
                mov     [edi.Chan_penvpan],edx
                jmp     @@no_panenv
@@panpntfound:  mov     bp,[ebx]
                mov     ax,bp
                sub     ax,dx
                mov     [edi.Chan_penvcnt],ax
                mov     [edi.Chan_penvppos],cl
                xor     al,al
                dec     cl
                cmp     cl,[esi.Inst_pansuspnt]
                jne     @@pannosusmark
                mov     al,1
@@pannosusmark: mov     [edi.Chan_panatsus],al
                mov     ax,2[ebx]
                lea     ebx,-4[ebx]
                sub     bp,[ebx]
                sub     ax,2[ebx]
                movsx   ebp,bp
                movsx   eax,ax
                sal     eax,16
                push    edx
                cdq
                idiv    ebp
                pop     edx
                mov     [edi.Chan_penvadd],eax
                sub     dx,[ebx]
                movzx   edx,dx
                imul    eax,edx
                movzx   edx,WORD PTR 2[ebx]
                sal     edx,16
                add     edx,eax
                mov     [edi.Chan_penvpan],edx
@@no_panenv:    ret

;-----------------------------------------------------------------------------

@@vcsetpan:     shl     bh,4
                mov     [edi.Chan_pan],bh
                or      [edi.Chan_status],ChanFlg_pan
                ret

;-----------------------------------------------------------------------------

@@vib:          or      dh,dh
                jz      @@vib_end
                mov     dl,dh
                and     dl,0fh
                jz      @@vib1
                mov     [edi.Chan_vibdepth],dl
@@vib1:         and     dh,0f0h
                jz      @@vib_end
                shr     dh,2
                mov     [edi.Chan_vibspeed],dh
@@vib_end:      ret

;-----------------------------------------------------------------------------

@@vc_vib:       mov     dh,bh
                jmp     @@vib

;-----------------------------------------------------------------------------

@@setvibspeed:  sal     bh,2
                mov     [edi.Chan_vibspeed],bh
                ret

;-----------------------------------------------------------------------------

@@setgvol:      push    eax
                xor     eax,eax
                mov     al,dh
                call    set_globalvol_
                pop     eax
                ret
                ret

;-----------------------------------------------------------------------------

@@setvol:       cmp     dh,64
                jbe     SHORT .mscgnn_volok
                mov     dh,64
.mscgnn_volok:  mov     [edi.Chan_basvol],dh
                mov     [edi.Chan_vol],dh
                or      [edi.Chan_status],ChanFlg_vol
                ret

;-----------------------------------------------------------------------------

@@posjmp:       mov     al,dh
                xor     ah,ah
                dec     ax
                mov     SongPos,ax
                mov     PattBreakPos,0
                mov     PosJumpFlag,1
                ret

;-----------------------------------------------------------------------------

@@patbrk:       mov     al,dh
                and     al,0f0h
                shr     al,1
                mov     ah,al
                shr     al,2
                add     al,ah
                and     dh,0fh
                add     al,dh
                xor     ah,ah
                mov     PattBreakPos,ax
                mov     PosJumpFlag,1
                ret

;-----------------------------------------------------------------------------

@@setspd:       mov     al,dh
                xor     ah,ah
                cmp     al,32
                jb      @@settempo
                mov     Speed,ax
                ret
@@settempo:     mov     Tempo,ax
                mov     TempoCount,ax
                ret

;-----------------------------------------------------------------------------

@@xfinpor:      mov     al,dh
                and     al,0f0h
                cmp     al,10h
                je      @@xfinporup
                cmp     al,20h
                je      @@xfinpordw
                ret
@@xfinporup:    lea     ebx,[edi.Chan_ldxfporup]
                call    @@fixeeffdata
                mov     eax,[edi.Chan_basperiod]
                xor     ecx,ecx
                mov     cl,dh
                and     cl,0fh
                sub     eax,ecx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret
@@xfinpordw:    lea     ebx,[edi.Chan_ldxfpordw]
                call    @@fixeeffdata
                mov     eax,[edi.Chan_basperiod]
                xor     ecx,ecx
                mov     cl,dh
                and     cl,0fh
                add     eax,ecx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret

;-----------------------------------------------------------------------------

@@fporup:       lea     ebx,[edi.Chan_ldfportup]
                call    @@fixeeffdata
                mov     eax,[edi.Chan_basperiod]
                xor     ecx,ecx
                mov     cl,dh
                and     cl,0fh
                sal     ecx,2
                sub     eax,ecx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret

;-----------------------------------------------------------------------------

@@fpordw:       lea     ebx,[edi.Chan_ldfportdw]
                call    @@fixeeffdata
                mov     eax,[edi.Chan_basperiod]
                xor     ecx,ecx
                mov     cl,dh
                and     cl,0fh
                sal     ecx,2
                add     eax,ecx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret

;-----------------------------------------------------------------------------

@@gliscn:       and     dh,0fh
                mov     [edi.Chan_glissfunc],dh
                ret

;-----------------------------------------------------------------------------

@@vibcn:        and     dh,0fh
                mov     [edi.Chan_vibcon],dh
                ret

;-----------------------------------------------------------------------------

@@tremcn:       and     dh,0fh
                mov     [edi.Chan_tremcon],dh
                ret

;-----------------------------------------------------------------------------

@@rtnote:       mov     [edi.Chan_tickcnt],0
                and     dh,0fh
                jnz     @@rt_notzero
                mov     [edi.Chan_ieff],0
                mov     [edi.Chan_ieffdata],0
                xor     eax,eax
                call    StartTone
@@rt_notzero:   ret

;-----------------------------------------------------------------------------

@@mretrig:      mov     ah,[edi.Chan_mrtrigdat]
                mov     al,dh
                and     al,0f0h
                jz      @@mret_zero1
                and     ah,0fh
                or      ah,al
@@mret_zero1:   and     dh,0fh
                jz      @@mret_zero2
                and     ah,0f0h
                or      ah,dh
@@mret_zero2:   mov     [edi.Chan_mrtrigdat],ah
                call    .DoMRetrig
                ret

;-----------------------------------------------------------------------------

@@fvolup:       lea     ebx,[edi.Chan_ldfvolsup]
                call    @@fixeeffdata
@@fvolup_vc:    and     dh,0fh
                add     dh,[edi.Chan_basvol]
                cmp     dh,64
                jbe     SHORT .mscgnn_fvuok
                mov     dh,64
.mscgnn_fvuok:  mov     [edi.Chan_basvol],dh
                mov     [edi.Chan_vol],dh
                or      [edi.Chan_status],ChanFlg_vol
                ret

;-----------------------------------------------------------------------------

@@fvoldw:       lea     ebx,[edi.Chan_ldfvolsdw]
                call    @@fixeeffdata
@@fvoldw_vc:    and     dh,0fh
                sub     dh,[edi.Chan_basvol]
                neg     dh
                jge     SHORT .mscgnn_fvdok
                xor     dh,dh
.mscgnn_fvdok:  mov     [edi.Chan_basvol],dh
                mov     [edi.Chan_vol],dh
                or      [edi.Chan_status],ChanFlg_vol
                ret

;-----------------------------------------------------------------------------

@@notecut:      and     dh,0fh
                jnz     @@notecut_end
                xor     al,al
                mov     [edi.Chan_basvol],al
                mov     [edi.Chan_vol],al
                or      [edi.Chan_status],ChanFlg_vol
@@notecut_end:  ret

;-----------------------------------------------------------------------------

@@jmplop:       and     dh,0fh
                jz      @@jsetlp
                cmp     [edi.Chan_loopcnt],0
                jz      @@jstrlp
                dec     [edi.Chan_loopcnt]
                jz      @@jlpend
@@jlp2:         mov     ax,[edi.Chan_pattpos]
                mov     PattBreakPos,ax
                mov     PattBreakFlag,1
                jmp     @@jlpend
@@jstrlp:       mov     [edi.Chan_loopcnt],dh
                jmp     @@jlp2
@@jsetlp:       mov     ax,PattPos
                mov     [edi.Chan_pattpos],ax
@@jlpend:       ret

;-----------------------------------------------------------------------------

@@pattdelay:    and     dh,0fh
                jz      @@pd_end
                inc     dh
                mov     PattDelayCnt,dh
@@pd_end:       ret

;-----------------------------------------------------------------------------

@@releaseflag   db      0

                ENDP

;


DoEffects       PROC    NEAR

                lea     edi,Channels
                xor     ecx,ecx
@@chan_loop:    call    @@do_chneffs

                lea     edi,SIZE ChanType[edi]
                inc     ecx
                cmp     cx,ChanNum
                jl      @@chan_loop
                ret
;-----------------------------------------------------------------------------

@@do_chneffs:
IFNDEF FRM
                lea     eax,@@vc_end
                push    eax
ELSE
                lea     ax,@@vc_end
                push    ax
ENDIF

                mov     al,[edi.Chan_ivoldata]
                mov     ah,al
                shr     al,4
                and     ah,0fh

                cmp     al,6
                je      @@vc_volsdw
                cmp     al,7
                je      @@vc_volsup
                cmp     al,0bh
                je      @@vc_vib
                cmp     al,0dh
                je      @@vc_panslft
                cmp     al,0eh
                je      @@vc_pansrgt
                cmp     al,0fh
                je      @@tonpor

IFNDEF FRM
                lea     esp,4[esp]
ELSE
                lea     sp,2[esp]
ENDIF

@@vc_end:       mov     al,[edi.Chan_ieff]
                mov     ah,[edi.Chan_ieffdata]
                or      ax,ax
                jz      @@chan_end

                cmp     al,0eh
                je      @@eeffs
                or      al,al
                jz      @@arp
                cmp     al,1
                je      @@porup
                cmp     al,2
                je      @@pordw
                cmp     al,3
                je      @@tonpor
                cmp     al,4
                je      @@vib
                cmp     al,5
                je      @@tonvol
                cmp     al,6
                je      @@vibvol
                cmp     al,7
                je      @@trem
                cmp     al,0ah
                je      @@vols
                cmp     al,11h          ;'H'
                je      @@gvols
                cmp     al,19h          ;'P'
                je      @@pans
                cmp     al,1bh          ;'R'
                je      @@mretrig
                cmp     al,1dh          ;'T'
                je      @@tremor

@@chan_end:     ret

@@eeffs:        mov     al,ah
                shr     al,4
                cmp     al,9
                je      @@retrig
                cmp     al,0ch
                je      @@notecut
                cmp     al,0dh
                je      @@notedelay
                ret

;-----------------------------------------------------------------------------

@@vc_volsdw:    jmp     @@vols

@@vc_volsup:    sal     ah,4
                jmp     @@vols

@@vc_vib:       jmp     @@vib

@@vc_panslft:   jmp     @@pans

@@vc_pansrgt:   sal     ah,4
                jmp     @@pans

;-----------------------------------------------------------------------------

@@arp:          movzx   ebx,TempoCount
                mov     al,ArpTab[ebx]
                cmp     al,1
                je      @@arp1
                ja      @@arp2
                mov     eax,[edi.Chan_basperiod]
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                jmp     @@arpend
@@arp1:         shr     ah,4
@@arp3:         mov     ebx,[edi.Chan_basperiod]
                mov     al,[edi.Chan_finetune]
                push    edx
                mov     dl,ah
                call    DCodePeriod
                mov     ah,dl
                pop     edx
                add     al,ah
                cmp     al,118
                jbe     @@arpok
                mov     [edi.Chan_period],0
                or      [edi.Chan_status],ChanFlg_period
                jmp     @@arpend
@@arpok:        call    CalcPeriod
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                jmp     @@arpend
@@arp2:         and     ah,0fh
                jmp     @@arp3
@@arpend:       ret

;-----------------------------------------------------------------------------

@@porup:        movzx   edx,ah
                sal     edx,2
                mov     eax,[edi.Chan_basperiod]
                sub     eax,edx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret

;-----------------------------------------------------------------------------

@@pordw:        movzx   edx,ah
                sal     edx,2
                mov     eax,[edi.Chan_basperiod]
                add     eax,edx
                call    BoundPeriod
                mov     [edi.Chan_basperiod],eax
                mov     [edi.Chan_period],eax
                or      [edi.Chan_status],ChanFlg_period
                ret

;-----------------------------------------------------------------------------

@@tonpor:       movzx   edx,[edi.Chan_portaspd]
                sal     edx,2
                cmp     [edi.Chan_portadir],1
                ja      @@tporup
                jne     @@tporend
                mov     ebx,[edi.Chan_basperiod]
                add     ebx,edx
                mov     eax,ebx
                call    BoundPeriod
                mov     ebx,eax
                cmp     ebx,[edi.Chan_desperiod]
                jb      @@tporok
                mov     ebx,[edi.Chan_desperiod]
                mov     [edi.Chan_portadir],0
                jmp     @@tporok
@@tporup:       mov     ebx,[edi.Chan_basperiod]
                sub     ebx,edx
                mov     eax,ebx
                call    BoundPeriod
                mov     ebx,eax
                cmp     ebx,[edi.Chan_desperiod]
                ja      @@tporok
                mov     ebx,[edi.Chan_desperiod]
                mov     [edi.Chan_portadir],0
@@tporok:       mov     [edi.Chan_basperiod],ebx
                cmp     [edi.Chan_glissfunc],0
                jz      @@nogliss
                mov     al,[edi.Chan_finetune]
                call    DCodePeriod
                mov     ah,[edi.Chan_finetune]
                call    CalcPeriod
                mov     ebx,eax
@@nogliss:      mov     [edi.Chan_period],ebx
                or      [edi.Chan_status],ChanFlg_period
@@tporend:      ret

;-----------------------------------------------------------------------------

@@vib:          mov     al,[edi.Chan_vibpos]
                shr     al,2
                and     al,01fh
                mov     ah,[edi.Chan_vibcon]
                and     ah,3
                jz      @@vibsine
                cmp     ah,1
                je      @@vibramp
                mov     al,0ffh
                jmp     @@vibset
@@vibsine:      xor     edx,edx
                mov     dl,al
                mov     al,VibTab[edx]
@@vibset:       xor     ah,ah
                mov     bl,[edi.Chan_vibdepth]
                xor     bh,bh
                sal     bx,2
                mul     bx
                shr     ax,7
                mov     ebx,[edi.Chan_basperiod]
                and     eax,0ffffh
                cmp     [edi.Chan_vibpos],0
                jl      @@vibneg
                add     ebx,eax
                jmp     @@vibok
@@vibneg:       sub     ebx,eax
@@vibok:        mov     [edi.Chan_period],ebx
                or      [edi.Chan_status],ChanFlg_period
                mov     al,[edi.Chan_vibspeed]
                add     [edi.Chan_vibpos],al
                jmp     @@vibend
@@vibramp:      shl     al,3
                cmp     [edi.Chan_vibpos],0
                jge     @@vibset
                not     al
                jmp     @@vibset
@@vibend:       ret

;-----------------------------------------------------------------------------

@@tonvol:       push    eax
                call    @@tonpor
                pop     eax
                jmp     @@vols

;-----------------------------------------------------------------------------

@@vibvol:       push    eax
                call    @@vib
                pop     eax
                jmp     @@vols

;-----------------------------------------------------------------------------

@@trem:         or      ah,ah
                jz      @@trm2
                mov     al,ah
                and     al,0fh
                jz      @@trm1
                mov     [edi.Chan_tremdepth],al
@@trm1:         and     ah,0f0h
                shr     ah,2
                jz      @@trm2
                mov     [edi.Chan_tremspeed],ah
@@trm2:         mov     al,[edi.Chan_trempos]
                shr     al,2
                and     al,1fh
                mov     ah,[edi.Chan_tremcon]
                and     ah,3
                jz      @@trmsine
                cmp     ah,1
                je      @@trmramp
                mov     al,0ffh
                jmp     @@trmset
@@trmsine:      xor     edx,edx
                mov     dl,al
                mov     al,VibTab[edx]
@@trmset:       xor     ah,ah
                mov     bl,[edi.Chan_tremdepth]
                xor     bh,bh
                mul     bx
                shr     ax,6
                mov     bl,[edi.Chan_basvol]
                cmp     [edi.Chan_trempos],0
                jl      @@trmneg
                add     bx,ax
                cmp     bx,64
                jbe     @@trmok
                mov     bx,64
                jmp     @@trmok
@@trmneg:       sub     bx,ax
                jge     @@trmok
                xor     bx,bx
@@trmok:        mov     [edi.Chan_vol],bl
                or      [edi.Chan_status],ChanFlg_vol
                mov     al,[edi.Chan_tremspeed]
                add     [edi.Chan_trempos],al
                jmp     @@trmend
@@trmramp:      shl     al,3
                cmp     [edi.Chan_trempos],0
                jle     @@trmset
                not     al
                jmp     @@trmset
@@trmend:       ret

;-----------------------------------------------------------------------------

@@gvols:        mov     al,ah
                shr     al,4
                jz      @@gvoldw
                add     al,GlobalVol
                cmp     al,64
                jbe     @@gvolok
                mov     al,64
                jmp     @@gvolok
@@gvoldw:       mov     al,GlobalVol
                sub     al,ah
                jge     @@gvolok
                xor     al,al
@@gvolok:       mov     GlobalVol,al
                lea     ebx,Channels
                movzx   edx,ChanNum
@@gvols_loop:   or      [ebx.Chan_status],ChanFlg_vol
                lea     ebx,SIZE ChanType[ebx]
                dec     edx
                jg      @@gvols_loop
                ret

;-----------------------------------------------------------------------------

@@vols:         mov     al,ah
                shr     al,4
                jz      @@voldw
                add     al,[edi.Chan_basvol]
                cmp     al,64
                jbe     @@volend
                mov     al,64
                jmp     @@volend
@@voldw:        mov     al,[edi.Chan_basvol]
                sub     al,ah
                jge     @@volend
                xor     al,al
@@volend:       mov     [edi.Chan_basvol],al
                mov     [edi.Chan_vol],al
                or      [edi.Chan_status],ChanFlg_vol
                ret

;-----------------------------------------------------------------------------

@@pans:         movzx   bx,[edi.Chan_pan]
                mov     al,ah
                shr     al,4
                jz      @@panlft
                movzx   ax,al
                add     ax,bx
                cmp     ax,100h
                jb      @@panok
                mov     al,0ffh
                jmp     @@panok
@@panlft:       movzx   ax,ah
                sub     bx,ax
                mov     al,bl
                jae     @@panok
                xor     al,al
@@panok:        mov     [edi.Chan_pan],al
                or      [edi.Chan_status],ChanFlg_pan
                ret

;-----------------------------------------------------------------------------

@@retrig:       and     ah,0fh
                mov     al,[edi.Chan_tickcnt]
                inc     al
                cmp     al,ah
                jl      @@no_rtyet
                xor     al,al
                mov     [edi.Chan_tickcnt],al
                xor     eax,eax
                call    StartTone
                ret
@@no_rtyet:     mov     [edi.Chan_tickcnt],al
                ret

;-----------------------------------------------------------------------------

.DoMRetrig:

@@mretrig:      inc     [edi.Chan_mrtrigcnt]
                mov     ah,[edi.Chan_mrtrigdat]
                mov     al,ah
                and     ah,0fh
                cmp     ah,[edi.Chan_mrtrigcnt]
                ja      @@no_mrtyet
                mov     [edi.Chan_mrtrigcnt],0
                xor     eax,eax
                call    StartTone
                mov     al,[edi.Chan_mrtrigdat]
                shr     al,4
                test    al,7
                jz      @@no_mrtyet
                cmp     al,6
                je      @@mretr_23
                cmp     al,7
                je      @@mretr_12
                cmp     al,0eh
                je      @@mretr_32
                cmp     al,0fh
                je      @@mretr_21
                mov     cl,al
                and     cl,7
                dec     cl
                mov     ah,1
                sal     ah,cl
                test    al,8
                mov     al,[edi.Chan_vol]
                jz      @@mretr_neg
                add     al,ah
                cmp     al,64
                jbe     @@mretr_vok
                mov     al,64
@@mretr_vok:    mov     [edi.Chan_vol],al
                jmp     @@no_mrtyet
@@mretr_neg:    sub     al,ah
                jge     @@mretr_vok
                xor     al,al
                jmp     @@mretr_vok
@@mretr_23:     movzx   eax,[edi.Chan_vol]
                add     eax,eax
                cdq
                mov     ebx,3
                div     ebx
                mov     [edi.Chan_vol],al
                jmp     @@no_mrtyet
@@mretr_12:     shr     [edi.Chan_vol],1
                jmp     @@no_mrtyet
@@mretr_32:     movzx   eax,[edi.Chan_vol]
                lea     eax,[eax+eax*2]
                shr     eax,1
                cmp     al,64
                jbe     @@mretr_vok
                mov     al,64
                jmp     @@mretr_vok
@@mretr_21:     mov     al,[edi.Chan_vol]
                add     al,al
                cmp     al,64
                jbe     @@mretr_vok
                mov     al,64
                jmp     @@mretr_vok
@@no_mrtyet:    ret

;-----------------------------------------------------------------------------

@@notecut:      mov     bx,Tempo
                sub     bx,TempoCount
                and     ah,0fh
                cmp     bl,ah
                jne     @@ncend
                mov     [edi.Chan_basvol],0
                mov     [edi.Chan_vol],0
                or      [edi.Chan_status],ChanFlg_vol
@@ncend:        ret

;-----------------------------------------------------------------------------

@@notedelay:    dec     [edi.Chan_delaycnt]
                jg      @@delay_ndone
                mov     [edi.Chan_ieff],0
                mov     [edi.Chan_ieffdata],0
                push    ecx
                call    .NoDelay
                pop     ecx
                ret
@@delay_ndone:  mov     bx,Tempo
                sub     bx,TempoCount
                and     ah,0fh
                cmp     bl,ah
                jne     SHORT .mscde_ndend
.mscde_dretrig: xor     ax,ax
                call    StartTone
.mscde_ndend:   ret

;-----------------------------------------------------------------------------

@@tremor:       cmp     [edi.Chan_zerovol],0
                jz      @@trmr_volison
                and     ah,0fh
                cmp     ah,[edi.Chan_tremorcnt]
                jae     @@trmr_end
                mov     [edi.Chan_zerovol],0
                mov     [edi.Chan_tremorcnt],0
                or      [edi.Chan_status],ChanFlg_vol
                jmp     @@trmr_end
@@trmr_volison: shr     ah,4
                cmp     ah,[edi.Chan_tremorcnt]
                jae     @@trmr_end
                mov     [edi.Chan_zerovol],1
                mov     [edi.Chan_tremorcnt],0
                or      [edi.Chan_status],ChanFlg_vol
@@trmr_end:     inc     [edi.Chan_tremorcnt]
                ret

                ENDP

;


DoIEffects      PROC    NEAR

                lea     edi,Channels
                xor     ecx,ecx
@@chn_loop:     call    @@do_chnieffs

                lea     edi,SIZE ChanType[edi]
                inc     ecx
                cmp     cx,ChanNum
                jl      @@chn_loop

                ret
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

@@do_chnieffs:  push    ecx

                movzx   eax,[edi.Chan_linst]
                dec     al
                jl      @@go_ret

                mov     esi,InstPtrs[eax*4]
                or      esi,esi
                jl      @@go_ret


;-----------------------------------------------------------------------------
; Fadeout volume

                cmp     [edi.Chan_susflag],0
                jnz     @@no_fadevol

                mov     ax,[esi.Inst_volfadout]
                or      ax,ax
                jz      @@no_fadevol
                mov     bx,[edi.Chan_fadevol]
                sal     eax,1
                sub     bx,ax
                jae     @@fadevolok
                xor     ebx,ebx
@@fadevolok:    mov     [edi.Chan_fadevol],bx
                or      [edi.Chan_status],ChanFlg_vol
@@no_fadevol:

;-----------------------------------------------------------------------------
; Volume envelope

                test    [esi.Inst_voltype],1
                jz      @@end_vol
                xor     edx,edx
                mov     dl,[edi.Chan_venvppos]
                cmp     dl,[esi.Inst_volptsnum]
                jge     @@end_vol
                test    [esi.Inst_voltype],2
                jz      @@no_sustain
                cmp     [edi.Chan_susflag],0
                jz      @@no_sustain
                cmp     [edi.Chan_volatsus],0
                jnz     @@end_vol
@@no_sustain:   mov     [edi.Chan_volatsus],0
                mov     eax,[edi.Chan_venvadd]
                add     [edi.Chan_venvvol],eax
                or      [edi.Chan_status],ChanFlg_vol
                movzx   ebx,[edi.Chan_venvcnt]
                dec     ebx
                jg      @@nonewvolp
@@volloop:      lea     ebx,[esi.Inst_volenvpts+edx*4]
                mov     ax,2[ebx]
                movsx   ebp,ax
                sal     ebp,16
                mov     [edi.Chan_venvvol],ebp
                mov     bp,[ebx]
                inc     dl
                test    [esi.Inst_voltype],4
                jz      @@volnoloop
                cmp     dl,[esi.Inst_vollpepnt]
                jle     @@volnoloop
                mov     dl,[esi.Inst_vollpspnt]
                cmp     dl,[esi.Inst_vollpepnt]
                jge     @@end_vol
                jmp     @@volloop
@@volnoloop:    mov     [edi.Chan_venvppos],dl
                cmp     dl,[esi.Inst_volptsnum]
                jge     @@end_vol
                mov     bl,[esi.Inst_volsuspnt]
                inc     bl
                cmp     dl,bl
                jne     @@volnosusmark
                mov     [edi.Chan_volatsus],1
@@volnosusmark: lea     ebx,[esi.Inst_volenvpts+edx*4]
                sub     bp,[ebx]
                sub     ax,2[ebx]
                movsx   ebp,bp
                movsx   eax,ax
                neg     eax
                neg     ebp
                mov     [edi.Chan_venvcnt],bp
                sal     eax,16
                cdq
                idiv    ebp
                mov     [edi.Chan_venvadd],eax
                jmp     @@end_vol
@@nonewvolp:    mov     [edi.Chan_venvcnt],bx
@@end_vol:

;-----------------------------------------------------------------------------
; Panning envelope

                test    [esi.Inst_pantype],1
                jz      @@end_pan
                xor     edx,edx
                mov     dl,[edi.Chan_penvppos]
                cmp     dl,[esi.Inst_panptsnum]
                jge     @@end_pan
                test    [esi.Inst_pantype],2
                jz      @@no_psustain
                cmp     [edi.Chan_susflag],0
                jz      @@no_psustain
                cmp     [edi.Chan_panatsus],0
                jnz     @@end_pan
@@no_psustain:  mov     [edi.Chan_panatsus],0
                mov     eax,[edi.Chan_penvadd]
                add     [edi.Chan_penvpan],eax
                or      [edi.Chan_status],ChanFlg_pan
                movzx   ebx,[edi.Chan_penvcnt]
                dec     ebx
                jg      @@nonewpanp
@@panloop:      lea     ebx,[esi.Inst_panenvpts+edx*4]
                mov     ax,2[ebx]
                movsx   ebp,ax
                sal     ebp,16
                mov     [edi.Chan_penvpan],ebp
                mov     bp,[ebx]
                inc     dl
                test    [esi.Inst_pantype],4
                jz      @@pannoloop
                cmp     dl,[esi.Inst_panlpepnt]
                jle     @@pannoloop
                mov     dl,[esi.Inst_panlpspnt]
                cmp     dl,[esi.Inst_panlpepnt]
                jge     @@end_pan
                jmp     @@panloop
@@pannoloop:    mov     [edi.Chan_penvppos],dl
                cmp     dl,[esi.Inst_panptsnum]
                jge     @@end_pan
                mov     bl,[esi.Inst_pansuspnt]
                inc     bl
                cmp     dl,bl
                jne     @@pannosusmark
                mov     [edi.Chan_panatsus],1
@@pannosusmark: lea     ebx,[esi.Inst_panenvpts+edx*4]
                sub     bp,[ebx]
                sub     ax,2[ebx]
                movsx   ebp,bp
                movsx   eax,ax
                neg     eax
                neg     ebp
                mov     [edi.Chan_penvcnt],bp
                sal     eax,16
                cdq
                idiv    ebp
                mov     [edi.Chan_penvadd],eax
                jmp     @@end_pan
@@nonewpanp:    mov     [edi.Chan_penvcnt],bx
@@end_pan:

;-----------------------------------------------------------------------------
; Instrument vibrato


                movzx   ecx,[esi.Inst_vibsweep]
                movzx   eax,[edi.Chan_ivibscnt]
                inc     eax
                cmp     eax,ecx
                jle     @@vib_sweep
                mov     eax,ecx
@@vib_sweep:    mov     [edi.Chan_ivibscnt],al
                inc     eax
                inc     ecx
                sal     eax,16
                cdq
                idiv    ecx
                movzx   ecx,[esi.Inst_vibdepth]
                imul    eax,ecx
                xor     ebx,ebx
                mov     bl,[edi.Chan_ivibpos]
                add     bl,[esi.Inst_vibrate]
                mov     [edi.Chan_ivibpos],bl
                mov     ecx,ebx
                and     ebx,07fh
                mov     dl,[esi.Inst_vibtype]
                or      dl,dl
                jz      @@vib_sine
                cmp     dl,2
                je      @@vib_rampdw
                jg      @@vib_rampup

                ; square wave
                sar     eax,16
                jmp     @@vib_square

@@vib_rampdw:   add     ebx,ebx
                neg     ebx
                test    ecx,80h
                jz      @@vib_set
                add     ebx,255
                neg     ebx
                jmp     @@vib_set
@@vib_rampup:   add     ebx,ebx
                test    ecx,80h
                jz      @@vib_set
                sub     ebx,255
                neg     ebx
                jmp     @@vib_set
@@vib_sine:     shr     ebx,2
                movzx   ebx,BYTE PTR VibTab[ebx]
@@vib_set:      imul    eax,ebx
                sar     eax,24
@@vib_square:   mov     ebx,[edi.Chan_period]
                test    ecx,80h
                jnz     @@vib_neg
                sub     ebx,eax
                jmp     @@vib_ok
@@vib_neg:      add     ebx,eax
@@vib_ok:       mov     [edi.Chan_finperiod],ebx
                or      [edi.Chan_status],ChanFlg_period


;-----------------------------------------------------------------------------

@@go_ret:       pop     ecx
                ret
                ENDP

;

set_songpos_    PROC    NEAR
                ;       In:
                ;        al = songpos

                pushad

                and     eax,0ffh
                dec     ax
                mov     SongPos,ax
                mov     PosJumpFlag,1
                mov     PattBreakFlag,0
                mov     PattBreakPos,0

                call    GetNextPos

                xor     al,al
                movzx   ecx,ChanNum
                lea     edx,Channels
@@gvolsetloop:  mov     [edx.Chan_vol],al
                or      [edx.Chan_status],ChanFlg_vol
                lea     edx,SIZE ChanType[edx]
                dec     ecx
                jg      @@gvolsetloop

                popad
                ret
                ENDP

;

set_pattpos_    PROC    NEAR
                ;       In:
                ;        al = pattpos

                pushad

                and     eax,0ffh
                mov     PattBreakPos,ax
                mov     PattBreakFlag,1
                mov     PosJumpFlag,0

                call    GetNextPos

                popad
                ret
                ENDP

;

GetNextPos      PROC    NEAR

                xor     eax,eax
                mov     ebx,SongPtr
                inc     PattPos

                cmp     PattBreakFlag,0
                jz      @@no_break
                mov     PattBreakFlag,0
                mov     ax,PattBreakPos
                mov     PattPos,ax
                mov     NewPattPosFlag,1
@@no_break:
                cmp     PosJumpFlag,0
                jnz     @@new_pattern

                mov     ax,SongPos
                mov     al,[ebx+eax.Song_pattorder]
                and     eax,0ffh
                mov     esi,PattPtrs[eax*4]

                mov     ax,[esi.Patt_rownum]
                dec     ax
                cmp     ax,PattPos
                jae     @@nonew_patt

@@new_pattern:  mov     ax,PattBreakPos
                mov     PattPos,ax
                mov     NewPattPosFlag,1
                mov     PattBreakPos,0
                mov     PosJumpFlag,0
                mov     ax,SongPos
                inc     ax
                cmp     ax,[ebx.Song_songlen]
                jb      @@no_restart
                mov     ax,[ebx.Song_restart]
@@no_restart:   mov     SongPos,ax

@@nonew_patt:   ;cmp     PosJumpFlag,0
                ;jnz     @@new_pattern

                cmp     NewPattPosFlag,0
                jz      @@end
                mov     NewPattPosFlag,0
                xor     esi,esi
                mov     ax,PattPos
                or      ax,ax
                jz      @@no_poffset
                mov     cx,ax
                mov     ax,SongPos
                mov     al,[ebx.Song_pattorder+eax]
                and     eax,0ffh
                mov     esi,PattPtrs[eax*4]
                mov     ax,[esi.Patt_rownum]
                dec     ax
                cmp     cx,ax
                jg      @@no_poffset
                mov     eax,[esi.Patt_hsize]
                add     esi,eax
                push    esi
                movzx   eax,ChanNum
                imul    ecx,eax
@@scan_loop:    mov     ah,[esi]
                inc     esi
                test    ah,80h
                jz      @@not_packed
                test    ah,1
                jz      @@snot1
                inc     esi
@@snot1:        test    ah,2
                jz      @@snot2
                inc     esi
@@snot2:        test    ah,4
                jz      @@snot4
                inc     esi
@@snot4:        test    ah,8
                jz      @@snot8
                inc     esi
@@snot8:        test    ah,16
                jz      @@snot16
                inc     esi
@@snot16:       jmp     @@scont
@@not_packed:   lea     esi,4[esi]
@@scont:        dec     ecx
                jg      @@scan_loop
                pop     edi
                sub     esi,edi
@@no_poffset:   mov     PattDataOffset,esi

@@end:          ret
                ENDP

;
; NoSound routines
;

PlayNoSTick     PROC    NEAR

                mov     ax,Speed
                add     ax,ax
                sub     SpeedCount,ax
                jge     @@nonew
                add     SpeedCount,3125

                call    PlayNotes           ; Allows silent music sync

@@nonew:        ret
                ENDP


;
; GUS routines
;

;

gus_interrupt_  PROC    FAR
                cli
                pushad
                push    ds
                push    es
IFNDEF FRM
                mov     ax,DGROUP
ELSE
                mov     ax,seg SongPtr          ; Or any variable in data seg
ENDIF
                mov     ds,ax
                mov     es,ax

                sti

                mov     dx,GUSCommandP
                mov     al,8fh
                out     dx,al
                mov     dx,GUSDataHiP
                in      al,dx
                mov     dx,GUSStatusP
                in      al,dx
                test    al,4
                jz      @@end                   ; no GUS timer1 irq

                mov     dx,GUSCommandP
                mov     al,45h
                out     dx,al
                mov     dx,GUSDataHiP
                xor     al,al
                out     dx,al
                mov     al,4
                out     dx,al

                call    play_musictick_

@@end:          mov     al,20h
                out     20h,al
                nop
                nop
                out     0a0h,al

                pop     es
                pop     ds
                popad
IFNDEF FRM
                iretd
ELSE
                iret
ENDIF
                ENDP

;


start_gusirq_   PROC    NEAR
                ;
                ;        Sets up GUS to produce 625Hz periodic irq


                mov     GUSIrqEnabled,1

                mov     dx,GUSCommandP
                mov     al,46h
                out     dx,al
                add     dx,2
                mov     al,256-20
                out     dx,al
                sub     dx,2

                mov     al,45h
                out     dx,al
                add     dx,2
                mov     al,0
                out     dx,al
                mov     al,4
                out     dx,al

                mov     edx,GUSBasePort
                add     dx,8
                mov     al,4
                out     dx,al
                inc     dx
                mov     al,1
                out     dx,al
                sub     dx,3
                in      al,dx

                ret
                ENDP

;

PlayGUSTick     PROC    NEAR

                mov     ax,Speed
                add     ax,ax
                sub     SpeedCount,ax
                jge     @@nonew
                add     SpeedCount,3125
                mov     GUSIntCount,0

                call    PlayNotes
                jmp     @@end

@@nonew:        inc     GUSIntCount
                cmp     GUSIntCount,3
                je      @@stop_smps
                cmp     GUSIntCount,4
                je      @@setregs
                cmp     GUSIntCount,5
                jle     @@end
                dec     GUSIntCount
                jmp     @@end

;-----------------------------------------------------------------------------
@@stop_smps:    xor     ecx,ecx
                lea     edi,Channels

@@stopsmp_loop: push    ecx
                mov     al,[edi.Chan_status]
                test    al,ChanFlg_newtone
                jz      @@stopsmp_not

                mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                ;mov     bx,4004h                ; ramp to zero volume
                ;mov     dx,GUSCommandP
                ;mov     al,89h
                ;out     dx,al
                ;inc     edx
                ;in      ax,dx
                ;cmp     ax,bx
                ;je      @@stopsmp_not
                ;mov     cx,ax

                mov     bx,GUSVolTab
                mov     bl,bh
                mov     bh,64
                mov     ah,bl
                xchg    ah,[edi.Chan_gusvol]
                cmp     ah,bl
                je      @@stopsmp_not
                ja      @@stopsmp_vabv
                xor     bh,bh
                xchg    ah,bl
@@stopsmp_vabv: mov     dx,GUSCommandP
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,3
                or      al,bh
                out     dx,al
                sub     dx,2
                mov     al,7
                out     dx,al
                add     dx,2
                mov     al,bl
                out     dx,al
                sub     dx,2
                mov     al,8
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2

                ;mov     al,9
                ;out     dx,al
                ;inc     edx
                ;mov     ax,cx
                ;out     dx,ax
                ;dec     edx

                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,bh
                out     dx,al

@@stopsmp_not:  pop     ecx
                lea     edi,SIZE ChanType[edi]
                inc     ecx
                cmp     cx,ChanNum
                jl      @@stopsmp_loop
                jmp     @@end

;-----------------------------------------------------------------------------

@@setregs:      xor     ecx,ecx
                lea     edi,Channels

@@setregs_loop: push    ecx
                mov     al,[edi.Chan_status]
                or      al,al
                jz      @@sr_next

                mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     al,[edi.Chan_status]
                test    al,ChanFlg_newtone
                jz      @@sr_notone

                mov     dx,GUSCommandP      ; stop voice
                xor     al,al
                out     dx,al
                add     dx,2
                mov     al,3
                out     dx,al
                sub     dx,2
                call    GUSDelay

                xor     eax,eax
                xor     ebx,ebx
                mov     al,[edi.Chan_linst]
                dec     al
                jl      @@sr_next

                shl     eax,6
                mov     bl,[edi.Chan_samp]
                lea     esi,[eax+ebx*4]
                mov     ebx,SampDataGUSPtrs[esi]
                or      ebx,ebx
                jl      @@sr_next
                mov     ecx,SampPtrs[esi]
                or      ecx,ecx
                jl      @@sr_next

                mov     cl,[ecx.Samp_type]

                test    cl,10h                  ; translate to 16bit address
                jz      @@8bit_1
                mov     eax,ebx
                shr     ebx,1
                and     ebx,01ffffh
                and     eax,0c0000h
                or      ebx,eax
@@8bit_1:
                mov     ax,[edi.Chan_eff]
                cmp     al,9
                jne     @@sr_nooffset
                and     eax,0ff00h
                add     ebx,eax
@@sr_nooffset:

                shl     ebx,9                   ; set voice start position
                mov     al,0ah
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,0bh
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx
                call    GUSDelay

                mov     ebx,SampPtrs[esi]
                test    cl,3
                jnz     @@sr_isloop

                mov     ebp,[ebx.Samp_len]
                or      ebp,ebp
                jz      @@sr_next
                mov     ebx,SampDataGUSPtrs[esi]
                add     ebx,ebp

                test    cl,10h
                jz      @@8bit_2
                mov     eax,ebx
                shr     ebx,1
                and     ebx,01ffffh
                and     eax,0c0000h
                or      ebx,eax
@@8bit_2:
                shl     ebx,9                   ; set voice end position
                mov     al,4
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,5
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx
                jmp     @@sr_startsmp

@@sr_isloop:    mov     ebx,[ebx.Samp_loopstart]
                add     ebx,SampDataGUSPtrs[esi]

                test    cl,10h
                jz      @@8bit_3
                mov     eax,ebx
                shr     ebx,1
                and     ebx,01ffffh
                and     eax,0c0000h
                or      ebx,eax
@@8bit_3:
                shl     ebx,9                   ; set loop start position
                mov     al,2
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,3
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx

                mov     ebx,SampPtrs[esi]
                mov     ebp,[ebx.Samp_looplen]
                add     ebp,SampDataGUSPtrs[esi]
                add     ebp,[ebx.Samp_loopstart]
                mov     ebx,ebp

                test    cl,10h
                jz      @@8bit_4
                mov     eax,ebx
                shr     ebx,1
                and     ebx,01ffffh
                and     eax,0c0000h
                or      ebx,eax
@@8bit_4:
                shl     ebx,9                   ; set loop end position
                mov     al,4
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,5
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx

@@sr_startsmp:  xor     ah,ah
                mov     ebx,SampPtrs[esi]
                cmp     [ebx.Samp_looplen],0
                jz      @@sr_noloop
                test    cl,3
                jz      @@sr_noloop
                or      ah,8
                test    cl,2
                jz      @@sr_noloop
                or      ah,16
@@sr_noloop:    test    cl,16
                jz      @@sr_is8bit
                or      ah,4

@@sr_is8bit:    xor     al,al                   ; start voice
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2
                call    GUSDelay

@@sr_notone:    test    [edi.Chan_status],ChanFlg_vol
                jz      @@sr_novol

                call    CalcVol
                mov     bx,GUSVolTab[eax*2]

                ;mov     dx,GUSCommandP
                ;mov     al,89h
                ;out     dx,al
                ;inc     edx
                ;in      ax,dx
                ;cmp     ax,bx
                ;je      @@sr_novol
                ;mov     cx,ax

                mov     bl,bh
                mov     bh,64
                mov     ah,bl
                xchg    ah,[edi.Chan_gusvol]
                cmp     ah,bl
                je      @@sr_novol
                ja      @@sr_volabove
                xor     bh,bh
                xchg    ah,bl
@@sr_volabove:  mov     dx,GUSCommandP
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,3
                or      al,bh
                out     dx,al
                sub     dx,2
                mov     al,7
                out     dx,al
                add     dx,2
                mov     al,bl
                out     dx,al
                sub     dx,2
                mov     al,8
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2

                ;mov     al,9
                ;out     dx,al
                ;inc     edx
                ;mov     ax,cx
                ;out     dx,ax
                ;dec     edx

                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,bh
                out     dx,al


@@sr_novol:     test    [edi.Chan_status],ChanFlg_period
                jz      @@sr_noperiod

                mov     eax,[edi.Chan_finperiod]
                call    CalcFreq

                movzx   ebx,GUSActiveVoices
                sub     bl,14
                jge     @@sr_gusfrq1
                xor     ebx,ebx
@@sr_gusfrq1:   mov     bx,GUSDivTab[ebx*2]
                sal     eax,9
                mov     edx,ebx
                shr     edx,1
                add     eax,edx
                cdq
                div     ebx
                add     eax,eax
                mov     ebx,eax

                mov     dx,GUSCommandP      ; set voice frequency
                mov     al,1
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax


@@sr_noperiod:  test    [edi.Chan_status],ChanFlg_pan
                jz      @@sr_nopan

                call    CalcPan

                push    eax                     ; set pan
                mov     dx,GUSCommandP
                mov     al,0ch
                out     dx,al
                add     dx,2
                pop     eax
                shr     ax,4
                out     dx,al

@@sr_nopan:
@@sr_next:      mov     [edi.Chan_status],0
                lea     edi,SIZE ChanType[edi]
                pop     ecx
                inc     ecx
                cmp     cx,ChanNum
                jl      @@setregs_loop

@@end:          ret
                ENDP

;

PlayGUSIWTick   PROC    NEAR

                mov     ax,Speed
                add     ax,ax
                sub     SpeedCount,ax
                jge     @@nonew
                add     SpeedCount,3125
                mov     GUSIntCount,0

                call    PlayNotes
                jmp     @@end

@@nonew:        inc     GUSIntCount
                cmp     GUSIntCount,3
                je      @@stop_smps
                cmp     GUSIntCount,4
                je      @@setregs
                cmp     GUSIntCount,5
                jle     @@end
                dec     GUSIntCount
                jmp     @@end

;-----------------------------------------------------------------------------
@@stop_smps:    xor     ecx,ecx
                lea     edi,Channels

@@stopsmp_loop: push    ecx
                mov     al,[edi.Chan_status]
                test    al,ChanFlg_newtone
                jz      @@stopsmp_not

                mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     bx,GUSVolTab            ; ramp to zero volume
                mov     bl,bh
                mov     bh,64
                mov     ah,bl
                xchg    ah,[edi.Chan_gusvol]
                cmp     ah,bl
                je      @@stopsmp_not
                ja      @@stopsmp_vabv
                xor     bh,bh
                xchg    ah,bl
@@stopsmp_vabv: mov     dx,GUSCommandP
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,3
                or      al,bh
                out     dx,al
                sub     dx,2
                mov     al,7
                out     dx,al
                add     dx,2
                mov     al,bl
                out     dx,al
                sub     dx,2
                mov     al,8
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,bh
                out     dx,al

@@stopsmp_not:  pop     ecx
                lea     edi,SIZE ChanType[edi]
                inc     ecx
                cmp     cx,ChanNum
                jl      @@stopsmp_loop
                jmp     @@end

;-----------------------------------------------------------------------------

@@setregs:      xor     ecx,ecx
                lea     edi,Channels

@@setregs_loop: push    ecx
                mov     al,[edi.Chan_status]
                or      al,al
                jz      @@sr_next

                mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     al,[edi.Chan_status]
                test    al,ChanFlg_newtone
                jz      @@sr_notone

                mov     dx,GUSCommandP      ; stop voice
                xor     al,al
                out     dx,al
                add     dx,2
                mov     al,3
                out     dx,al
                sub     dx,2
                call    GUSDelay

                xor     eax,eax
                xor     ebx,ebx
                mov     al,[edi.Chan_linst]
                dec     al
                jl      @@sr_next

                shl     eax,6
                mov     bl,[edi.Chan_samp]
                lea     esi,[eax+ebx*4]
                mov     ebx,SampDataGUSPtrs[esi]
                or      ebx,ebx
                jl      @@sr_next
                mov     ecx,SampPtrs[esi]
                or      ecx,ecx
                jl      @@sr_next

                mov     cl,[ecx.Samp_type]

                test    cl,10h                  ; translate to 16bit address
                jz      @@8bit_1
                shr     ebx,1
@@8bit_1:
                mov     ax,[edi.Chan_eff]
                cmp     al,9
                jne     @@sr_nooffset
                and     eax,0ff00h
                add     ebx,eax
@@sr_nooffset:

                shl     ebx,9                   ; set voice start position
                mov     al,0ah
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,0bh
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx
                call    GUSDelay

                mov     ebx,SampPtrs[esi]
                test    cl,3
                jnz     @@sr_isloop

                mov     ebp,[ebx.Samp_len]
                or      ebp,ebp
                jz      @@sr_next
                mov     ebx,SampDataGUSPtrs[esi]
                add     ebx,ebp

                test    cl,10h
                jz      @@8bit_2
                shr     ebx,1
@@8bit_2:
                shl     ebx,9                   ; set voice end position
                mov     al,4
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,5
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx
                jmp     @@sr_startsmp

@@sr_isloop:    mov     ebx,[ebx.Samp_loopstart]
                add     ebx,SampDataGUSPtrs[esi]

                test    cl,10h
                jz      @@8bit_3
                shr     ebx,1
@@8bit_3:
                shl     ebx,9                   ; set loop start position
                mov     al,2
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,3
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx

                mov     ebx,SampPtrs[esi]
                mov     ebp,[ebx.Samp_looplen]
                add     ebp,SampDataGUSPtrs[esi]
                add     ebp,[ebx.Samp_loopstart]
                mov     ebx,ebp

                test    cl,10h
                jz      @@8bit_4
                shr     ebx,1
@@8bit_4:
                shl     ebx,9                   ; set loop end position
                mov     al,4
                out     dx,al
                inc     dx
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                dec     dx
                mov     al,5
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax
                dec     dx

@@sr_startsmp:  xor     ah,ah
                mov     ebx,SampPtrs[esi]
                cmp     [ebx.Samp_looplen],0
                jz      @@sr_noloop
                test    cl,3
                jz      @@sr_noloop
                or      ah,8
                test    cl,2
                jz      @@sr_noloop
                or      ah,16
@@sr_noloop:    test    cl,16
                jz      @@sr_is8bit
                or      ah,4

@@sr_is8bit:    xor     al,al                   ; start voice
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2
                call    GUSDelay

@@sr_notone:    test    [edi.Chan_status],ChanFlg_vol
                jz      @@sr_novol

                call    CalcVol
                mov     bx,GUSVolTab[eax*2]

                mov     bl,bh
                mov     bh,64
                mov     ah,bl
                xchg    ah,[edi.Chan_gusvol]
                cmp     ah,bl
                je      @@sr_novol
                ja      @@sr_volabove
                xor     bh,bh
                xchg    ah,bl
@@sr_volabove:  mov     dx,GUSCommandP
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,3
                or      al,bh
                out     dx,al
                sub     dx,2
                mov     al,7
                out     dx,al
                add     dx,2
                mov     al,bl
                out     dx,al
                sub     dx,2
                mov     al,8
                out     dx,al
                add     dx,2
                mov     al,ah
                out     dx,al
                sub     dx,2
                mov     al,0dh
                out     dx,al
                add     dx,2
                mov     al,bh
                out     dx,al


@@sr_novol:     test    [edi.Chan_status],ChanFlg_period
                jz      @@sr_noperiod

                mov     eax,[edi.Chan_finperiod]
                call    CalcFreq

                sal     eax,9
                add     eax,22050
                mov     ebx,44100
                cdq
                div     ebx
                add     eax,eax
                mov     ebx,eax

                mov     dx,GUSCommandP      ; set voice frequency
                mov     al,1
                out     dx,al
                inc     dx
                mov     ax,bx
                out     dx,ax


@@sr_noperiod:  test    [edi.Chan_status],ChanFlg_pan
                jz      @@sr_nopan

                call    CalcPan
                and     eax,0ffh
                lea     ebx,-128[eax]
                sar     ebx,1

                mov     dx,GUSCommandP
                mov     al,0ch
                out     dx,al
                inc     edx
                mov     ax,GUSIWPanTabMid[ebx*2]
                out     dx,ax

                dec     edx
                mov     al,1bh
                out     dx,al
                inc     edx
                mov     ax,GUSIWPanTabMid[ebx*2]
                out     dx,ax

                neg     ebx

                dec     edx
                mov     al,13h
                out     dx,al
                inc     edx
                mov     ax,GUSIWPanTabMid[ebx*2]
                out     dx,ax

                dec     edx
                mov     al,1ch
                out     dx,al
                inc     edx
                mov     ax,GUSIWPanTabMid[ebx*2]
                out     dx,ax

@@sr_nopan:
@@sr_next:      mov     [edi.Chan_status],0
                lea     edi,SIZE ChanType[edi]
                pop     ecx
                inc     ecx
                cmp     cx,ChanNum
                jl      @@setregs_loop

@@end:          ret
                ENDP

;


ProbeGUS        PROC    NEAR
                ;       Out:
                ;        [GUSPresent] = 1 if GUS exist


                mov     GUSPresent,0

                mov     ecx,GUSBasePort
                lea     eax,6[ecx]
                mov     GUSStatusP,ax
                lea     eax,8[ecx]
                mov     GUSTimerCntlP,ax
                lea     eax,9[ecx]
                mov     GUSTimerDataP,ax
                lea     eax,100h[ecx]
                mov     GUSMidiCntlP,ax
                lea     eax,101h[ecx]
                mov     GUSMidiDataP,ax
                lea     eax,102h[ecx]
                mov     GUSVoiceP,ax
                lea     eax,103h[ecx]
                mov     GUSCommandP,ax
                lea     eax,104h[ecx]
                mov     GUSDataLoP,ax
                lea     eax,105h[ecx]
                mov     GUSDataHiP,ax
                lea     eax,107h[ecx]
                mov     GUSDRAMIOP,ax


                mov     dx,GUSCommandP
                mov     al,4ch
                out     dx,al
                mov     dx,GUSDataHiP
                xor     al,al
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                mov     dx,GUSCommandP
                mov     al,4ch
                out     dx,al
                mov     dx,GUSDataHiP
                mov     al,1
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                mov     dx,GUSCommandP
                mov     al,44h
                out     dx,al
                xor     eax,eax
                add     edx,2
                out     dx,al

                sub     edx,2
                mov     al,43h
                out     dx,al
                inc     edx
                xor     eax,eax
                out     dx,ax

                add     edx,3
                mov     al,55h
                out     dx,al

                sub     edx,3
                mov     eax,1
                out     dx,ax
                add     edx,3
                mov     al,0aah
                out     dx,al

                sub     edx,3
                xor     eax,eax
                out     dx,ax
                add     edx,3
                in      al,dx
                cmp     al,55h
                jne     @@end

                sub     edx,3
                mov     eax,1
                out     dx,ax
                add     edx,3
                in      al,dx
                cmp     al,0aah
                jne     @@end

                mov     GUSPresent,1

                mov     ecx,4
                call    GUSCheckMem

@@end:          ret
                ENDP

;

ProbeGUSIW      PROC    NEAR
                ;       Out:
                ;        [GUSPresent] = 1 if GUSIW exist


                call    ProbeGUS

                cmp     GUSPresent,0
                jz      @@end

                ;mov     GUSPresent,0

                ; special test for interwave chip

                ;mov     GUSPresent,1

                call    GUSSetIWMode

                mov     ecx,64
                call    GUSCheckMem

@@end:          ret
                ENDP

;

GUSCheckMem     PROC    NEAR
                ;       In:
                ;        ecx = number of 256K banks to look for


                pushad

                xor     ebp,ebp
                xor     ebx,ebx

@@mem_loop:     mov     dx,GUSCommandP
                mov     al,44h
                out     dx,al
                add     edx,2
                mov     ax,bx
                out     dx,al

                sub     edx,2
                mov     al,43h
                out     dx,al
                inc     edx
                xor     eax,eax
                out     dx,ax
                add     edx,3
                mov     al,55h
                out     dx,al

                sub     edx,3
                mov     eax,1
                out     dx,ax
                add     edx,3
                mov     al,0aah
                out     dx,al

                sub     edx,3
                xor     eax,eax
                out     dx,ax
                add     edx,3
                in      al,dx
                cmp     al,55h
                jne     @@end_mem

                sub     edx,3
                mov     eax,1
                out     dx,ax
                add     edx,3
                in      al,dx
                cmp     al,0aah
                jne     @@end_mem

                add     ebp,256*1024
                add     ebx,4
                dec     ecx
                jg      @@mem_loop

@@end_mem:      sub     ebp,16
                mov     GUSMem,ebp

                popad
                ret
                ENDP

;

GUSMov2DRAM     PROC    NEAR
                ;       In:
                ;        eax = ptr to data
                ;        ebx = address in GUS-DRAM
                ;        ecx = length

                pushad
                mov     esi,eax
                xor     edx,edx
                mov     dx,GUSCommandP
@@set32bit:     mov     al,44h
                out     dx,al
                lea     edx,2[edx]
                mov     eax,ebx
                rol     eax,16
                out     dx,ax
                lea     edx,-2[edx]
@@set16bit:     mov     al,43h
                out     dx,al
                inc     edx
                mov     eax,ebx
                out     dx,ax
                lea     edx,3[edx]
                outsbd                      ;FRM
                lea     edx,-4[edx]
                inc     ebx
                dec     ecx
                jle     @@end
                or      bx,bx
                jnz     @@set16bit
                jmp     @@set32bit
@@end:          popad
                ret
                ENDP

;

GUSDelay        PROC    NEAR
                pushad
                mov     dx,GUSDRAMIOP
                mov     cl,7
@@delay_loop:   in      al,dx
                dec     cl
                jg      @@delay_loop
                popad
                ret
                ENDP

;

GUSStopVocs     PROC    NEAR

                pushad

                xor     ecx,ecx
@@stop_loop:    mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     dx,GUSCommandP
                mov     al,0
                out     dx,al
                mov     dx,GUSDataHiP
                mov     al,3
                out     dx,al

                mov     dx,GUSCommandP
                mov     al,0dh
                out     dx,al
                mov     dx,GUSDataHiP
                mov     al,3
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                inc     ecx
                cmp     cx,32
                jl      @@stop_loop

                xor     ecx,ecx
@@vol_loop:     mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al
                mov     dx,GUSCommandP
                mov     al,9
                out     dx,al
                inc     edx
                mov     ax,0500h
                out     dx,ax
                inc     ecx
                cmp     cx,32
                jl      @@vol_loop

                popad
                ret
                ENDP

;

GUSIWStopVocs   PROC    NEAR

                pushad

                xor     ecx,ecx
@@stop_loop:    mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     dx,GUSCommandP      ; stop voice
                xor     al,al
                out     dx,al
                add     dx,2
                mov     al,3
                out     dx,al
                sub     dx,2

                mov     al,15h
                out     dx,al
                add     dx,2
                mov     al,2
                out     dx,al

                mov     dx,GUSCommandP  ; stop volume ramp
                mov     al,0dh
                out     dx,al
                mov     dx,GUSDataHiP
                mov     al,3
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                inc     ecx
                cmp     cl,32
                jl      @@stop_loop

                xor     ecx,ecx
@@vol_loop:     mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al
                mov     dx,GUSCommandP
                mov     al,9
                out     dx,al
                inc     edx
                mov     ax,0500h
                out     dx,ax
                inc     ecx
                cmp     cx,32
                jl      @@vol_loop

                popad
                ret
                ENDP

;

GUSSetGF1Mode   PROC    NEAR

                push    eax
                push    edx

                mov     dx,GUSCommandP
                mov     al,19h
                out     dx,al
                add     dx,2
                mov     al,0
                out     dx,al

                pop     edx
                pop     eax

                ret
                ENDP

;

GUSSetIWMode    PROC    NEAR

                push    eax
                push    edx

                mov     dx,GUSCommandP
                mov     al,19h
                out     dx,al
                add     dx,2
                mov     al,1
                out     dx,al

                pop     edx
                pop     eax
                ret
                ENDP

;

GUSHardInit     PROC    NEAR

                pushfd
                cli

                mov     edx,GUSBasePort
                mov     al,00bh
                out     dx,al

                call    GUSDelay

                ; UltraReset:

                movzx   ebx,GUSCommandP         ; ebx = CommandP
                movzx   edi,GUSDataHiP          ; edi = DataHiP
                movzx   esi,GUSDataLoP          ; esi = DataLoP

                mov     edx,ebx
                mov     al,4ch
                out     dx,al
                mov     edx,edi
                xor     al,al
                out     dx,al

                mov     ecx,10
@@wloop1:       call    GUSDelay
                loop    @@wloop1

                mov     edx,ebx
                mov     al,4ch
                out     dx,al
                mov     edx,edi
                mov     al,1
                out     dx,al

                mov     ecx,10
@@wloop2:       call    GUSDelay
                loop    @@wloop2

                mov     dx,GUSMidiCntlP
                mov     al,3
                out     dx,al

                mov     ecx,10
@@wloop3:       call    GUSDelay
                loop    @@wloop3

                xor     al,al
                out     dx,al

                cmp     SoundCard,Card_GUSIW
                jne     @@not_iw
                call    GUSSetIWMode
@@not_iw:
                mov     edx,ebx
                mov     al,41h
                out     dx,al
                mov     edx,edi
                xor     al,al
                out     dx,al
                mov     edx,ebx
                mov     al,45h
                out     dx,al
                mov     edx,edi
                xor     al,al
                out     dx,al
                mov     edx,ebx
                mov     al,49h
                out     dx,al
                mov     edx,edi
                xor     al,al
                out     dx,al

                mov     edx,ebx
                mov     al,0eh
                out     dx,al
                mov     edx,edi
                mov     al,31 OR 0c0h
                out     dx,al

                mov     dx,GUSStatusP
                in      al,dx
                mov     edx,ebx
                mov     al,41h
                out     dx,al
                mov     edx,edi
                in      al,dx
                mov     edx,ebx
                mov     al,49h
                out     dx,al
                mov     edx,edi
                in      al,dx
                mov     edx,ebx
                mov     al,8fh
                out     dx,al
                mov     edx,edi
                in      al,dx

                xor     ecx,ecx
;-----------------------------------------------------------------------------
@@clear_loop:   mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                mov     edx,ebx
                mov     al,0
                out     dx,al
                mov     edx,edi
                mov     al,3
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                mov     edx,ebx
                mov     al,0dh
                out     dx,al
                mov     edx,edi
                mov     al,3
                out     dx,al

                call    GUSDelay
                call    GUSDelay

                mov     edx,ebx
                mov     al,1
                out     dx,al
                mov     edx,esi
                mov     ax,400h
                out     dx,ax

                mov     edx,ebx
                mov     al,3
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                mov     edx,ebx
                mov     al,2
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                mov     edx,ebx
                mov     al,5
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                mov     edx,ebx
                mov     al,4
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                mov     edx,ebx
                mov     al,6
                out     dx,al
                mov     edx,edi
                mov     al,20           ; ramp speed
                out     dx,al

                mov     edx,ebx
                mov     al,7
                out     dx,al
                mov     edx,edi
                mov     al,04h
                out     dx,al

                mov     edx,ebx
                mov     al,8
                out     dx,al
                mov     edx,edi
                mov     al,0e0h
                out     dx,al

                mov     edx,ebx
                mov     al,9
                out     dx,al
                mov     edx,esi
                mov     ax,400h
                out     dx,ax

                mov     edx,ebx
                mov     al,0bh
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                mov     edx,ebx
                mov     al,0ah
                out     dx,al
                mov     edx,esi
                xor     eax,eax
                out     dx,ax

                call    GUSDelay

                mov     edx,ebx
                mov     al,0ch
                out     dx,al
                mov     edx,edi
                mov     al,7
                out     dx,al

                call    GUSDelay

                cmp     SoundCard,Card_GUSIW
                jne     @@clear_notiw

                mov     edx,ebx
                mov     al,15h
                out     dx,al
                mov     edx,edi
                mov     al,22h
                out     dx,al

                mov     edx,ebx
                mov     al,10h
                out     dx,al
                mov     edx,edi
                mov     al,0
                out     dx,al

                mov     bp,GUSIWPanTabMid

                mov     edx,ebx
                mov     al,13h
                out     dx,al
                mov     edx,esi
                mov     eax,ebp
                out     dx,ax

                mov     edx,ebx
                mov     al,1ch
                out     dx,al
                mov     edx,esi
                mov     eax,ebp
                out     dx,ax

                mov     edx,ebx
                mov     al,0ch
                out     dx,al
                mov     edx,esi
                mov     eax,ebp
                out     dx,ax

                mov     edx,ebx
                mov     al,1bh
                out     dx,al
                mov     edx,esi
                mov     eax,ebp
                out     dx,ax
@@clear_notiw:
                inc     ecx
                cmp     cl,32
                jl      @@clear_loop
;-----------------------------------------------------------------------------

                mov     edx,ebx
                mov     al,0eh
                out     dx,al
                mov     edx,edi
                mov     al,GUSActiveVoices
                dec     al
                or      al,0c0h
                out     dx,al


                xor     ecx,ecx
;-----------------------------------------------------------------------------
@@voice_loop:   mov     dx,GUSVoiceP
                mov     al,cl
                out     dx,al

                cmp     SoundCard,Card_GUSIW
                jne     @@voice_notiw

                mov     edx,ebx
                mov     al,15h
                out     dx,al
                mov     edx,edi
                mov     al,20h
                out     dx,al

@@voice_notiw:  call    GUSDelay

                inc     ecx
                cmp     cl,GUSActiveVoices
                jl      @@voice_loop
;-----------------------------------------------------------------------------

                mov     dx,GUSStatusP
                in      al,dx
                mov     edx,ebx
                mov     al,41h
                out     dx,al
                mov     edx,edi
                in      al,dx
                mov     edx,ebx
                mov     al,49h
                out     dx,al
                mov     edx,edi
                in      al,dx
                mov     edx,ebx
                mov     al,8fh
                out     dx,al
                mov     edx,edi
                in      al,dx

                mov     edx,ebx
                mov     al,4ch
                out     dx,al
                mov     edx,edi
                mov     al,7
                out     dx,al

;-----------------------------------------------------------------------------
; SetInterface
                IFDEF   SetGUSLatches

                MIX_IMAGE = 0bh

                mov     eax,GUSGf1IRQ
                mov     al,@@irq_latch[eax]
                mov     @@gf1_irq,al

                mov     eax,GUSMidiIRQ
                mov     al,@@irq_latch[eax]
                sal     al,3
                mov     @@midi_irq,al

                mov     eax,GUSDramDMA
                mov     al,@@dma_latch[eax]
                mov     @@dram_dma,al

                mov     eax,GUSAdcDMA
                mov     al,@@dma_latch[eax]
                sal     al,3
                mov     @@adc_dma,al

                mov     al,@@gf1_irq
                mov     edx,GUSGf1IRQ
                cmp     edx,GUSMidiIRQ
                jne     @@in_ic_else
                or      edx,edx
                jz      @@in_ic_else
                or      al,40h
                jmp     @@in_ic_cont
@@in_ic_else:   or      al,@@midi_irq
@@in_ic_cont:   mov     @@irq_control,al

                mov     al,@@dram_dma
                mov     edx,GUSDramDMA
                cmp     edx,GUSAdcDMA
                jne     @@in_dc_else
                or      edx,edx
                jz      @@in_dc_else
                or      al,40h
                jmp     @@in_dc_cont
@@in_dc_else:   or      al,@@adc_dma
@@in_dc_cont:   mov     @@dma_control,al


                ; Set up for Digital ASIC
                mov     edx,GUSBasePort
                add     edx,0fh
                mov     al,5
                out     dx,al
                sub     edx,0fh
                mov     al,MIX_IMAGE
                out     dx,al
                add     edx,0bh
                mov     al,0
                out     dx,al
                add     edx,4
                out     dx,al

                ; First do DMA control register
                mov     edx,GUSBasePort
                mov     al,MIX_IMAGE
                out     dx,al
                add     edx,0bh
                mov     al,@@dma_control
                or      al,80h                  ; <- Difference to _later_
                out     dx,al

                ; IRQ CONTROL REG
                mov     edx,GUSBasePort
                mov     al,MIX_IMAGE
                or      al,40h
                out     dx,al
                add     edx,0bh
                mov     al,@@irq_control
                out     dx,al

                ; First do DMA control register
                mov     edx,GUSBasePort
                mov     al,MIX_IMAGE
                out     dx,al
                add     edx,0bh
                mov     al,@@dma_control        ; _later_
                out     dx,al

                ; IRQ CONTROL REG
                mov     edx,GUSBasePort
                mov     al,MIX_IMAGE
                or      al,40h
                out     dx,al
                add     edx,0bh
                mov     al,@@irq_control
                out     dx,al

                ; just to Lock out writes to irq\dma register
                mov     dx,GUSVoiceP
                mov     al,0
                out     dx,al

                mov     edx,GUSBasePort
                mov     al,9
                out     dx,al

                ; just to Lock out writes to irq\dma register
                mov     dx,GUSVoiceP
                mov     al,0
                out     dx,al

                ENDIF
;-----------------------------------------------------------------------------

                mov     ecx,10
@@wloop4:       call    GUSDelay
                loop    @@wloop4

                mov     edx,GUSBasePort
                mov     al,9
                out     dx,al

                call    GUSDelay

                popfd
                ret
;-----------------------------------------------------------------------------

@@gf1_irq       db      0
@@midi_irq      db      0
@@dram_dma      db      0
@@adc_dma       db      0
@@irq_control   db      0
@@dma_control   db      0
@@irq_latch     db      0,0,1,3,0,2,0,4,0,0,0,5,6,0,0,7
@@dma_latch     db      0,1,0,2,0,3,4,5

                ENDP

;
; Initiation routines
;

;

init_card_      PROC    NEAR
                ;       In:
                ;         [SoundCard]
                ;         [SoundCardPort]
                ;       Out:
                ;        eax = 0 success
                ;              1 failure


                pushad

                mov     @@status,0

                mov     eax,SoundCard

                cmp     eax,Card_GUS
                je      @@gus
                cmp     eax,Card_GUSIW
                je      @@gusiw
                jmp     @@end

@@gusiw:        call    ProbeGUSIW
                cmp     GUSPresent,0
                jz      @@set_nosound
                cmp     GUSMem,AudioMem_Required
                jl      @@set_nosound
                jmp     @@end

@@gus:          call    ProbeGUS
                cmp     GUSPresent,0
                jz      @@set_nosound
                cmp     GUSMem,AudioMem_Required
                jl      @@set_nosound
                jmp     @@end

@@set_nosound:  mov     @@status,1
                mov     SoundCard,Card_NoSound

@@end:          popad
                mov     eax,@@status
                ret
;-----------------------------------------------------------------------------
@@status        dd      0
                ENDP



;

init_song_      PROC    NEAR
                ;       In:
                ;        eax = ptr to xm
                ;       Out:
                ;        eax = 0 success
                ;              1 Unidentified song format.
                ;              2 Errorous, old version XM.

                pushad
IFDEF FRM
                movzx   esp,sp
ENDIF

                cld

                mov     SongPtr,eax
                mov     esi,eax
                mov     SongPresent,0

                xor     eax,eax
                lea     edi,Channels
                mov     ecx,SIZE ChanType
                sal     ecx,5
                rep     stosbd              ;FRM

                lea     edi,SongVars
                lea     ecx,SongVarsEnd
                sub     ecx,edi
                rep     stosbd              ;FRM

                lea     edi,Channels
                mov     ecx,32
@@chan_loop:    mov     [edi.Chan_gusvol],04h
                lea     edi,SIZE ChanType[edi]
                loop    @@chan_loop

                mov     GlobalVol,64

                call    InitXM
                mov     SongStatus,al
                cmp     SongPresent,0
                jz      @@end

                mov     eax,SoundCard

                cmp     eax,Card_GUS
                je      @@gus

                cmp     eax,Card_GUSIW
                je      @@gusiw

@@end:          popad
                movzx   eax,SongStatus
                ret
;-----------------------------------------------------------------------------
@@gusiw:        ; same as for gus, but without 16bit samples 256K limit

                mov     GUSIntCount,0

                mov     ax,ChanNum
                cmp     al,14
                jge     @@iw_is14pv
                mov     al,14
@@iw_is14pv:    mov     GUSActiveVoices,al

                call    GUSHardInit

                mov     eax,-1
                lea     edi,SampDataGUSPtrs
                mov     ecx,128*16
                rep     stosdd              ;FRM

                lea     eax,@@last_word
                xor     ebx,ebx
                mov     ecx,2
                call    GUSMov2DRAM

                mov     ebx,256
                mov     ebp,GUSMem
                mov     edx,SongPtr
                sub     ebp,ebx

                movzx   ecx,[edx.Song_instnum]
                push    ecx
                xor     ecx,ecx

@@iw_inst_loop: cmp     ecx,[esp]
                jge     @@iw_end_inst

                mov     eax,InstPtrs[ecx*4]
                or      eax,eax
                jl      @@iw_next_inst

                movzx   edx,[eax.Inst_sampnum]
                push    edx
                xor     edx,edx

@@iw_samp_loop: cmp     edx,[esp]
                jge     @@iw_end_samp

                mov     esi,ecx
                sal     esi,6
                lea     esi,[esi+edx*4]
                push    ecx
                mov     eax,SampDataPtrs[esi]
                mov     edi,SampPtrs[esi]
                or      edi,edi
                jl      @@iw_next_samp

                mov     ecx,[edi.Samp_len]
                cmp     ecx,ebp
                jg      @@iw_next_samp

                mov     SampDataGUSPtrs[esi],ebx
                call    GUSMov2DRAM

                call    @@gusfix

                add     ecx,3fh
                and     cl,0e0h

                add     ebx,ecx
                sub     ebp,ecx

@@iw_next_samp: pop     ecx
                inc     edx
                jmp     @@iw_samp_loop

@@iw_end_samp:  pop     edx
@@iw_next_inst: inc     ecx
                jmp     @@iw_inst_loop

@@iw_end_inst:  pop     ecx

                cmp     GUSIrqEnabled,0
                jz      @@iw_no_irq
                call    start_gusirq_
@@iw_no_irq:
                jmp     @@end

;-----------------------------------------------------------------------------
@@gus:
                mov     GUSIntCount,0

                mov     ax,ChanNum
                cmp     al,14
                jge     @@is14pvoices
                mov     al,14
@@is14pvoices:  mov     GUSActiveVoices,al

                call    GUSHardInit

                mov     eax,-1
                lea     edi,SampDataGUSPtrs
                mov     ecx,128*16
                rep     stosdd              ;FRM

                lea     eax,@@last_word
                xor     ebx,ebx
                mov     ecx,2
                call    GUSMov2DRAM

                mov     ebx,256
                mov     ebp,GUSMem
                mov     edx,SongPtr
                sub     ebp,ebx

                movzx   ecx,[edx.Song_instnum]
                push    ecx
                xor     ecx,ecx

@@inst_loop:    cmp     ecx,[esp]           ;FRM: must be ESP=SP!
                jge     @@end_inst

                mov     eax,InstPtrs[ecx*4]
                or      eax,eax
                jl      @@next_inst

                movzx   edx,[eax.Inst_sampnum]
                push    edx
                xor     edx,edx

@@samp_loop:    cmp     edx,[esp]           ;FRM: must be ESP=SP!
                jge     @@end_samp

                call    @@try_16bits

                mov     esi,ecx
                sal     esi,6
                lea     esi,[esi+edx*4]
                push    ecx
                mov     eax,SampDataPtrs[esi]
                mov     edi,SampPtrs[esi]
                or      edi,edi
                jl      @@next_samp

                test    [edi.Samp_type],16
                jnz     @@next_samp
                mov     ecx,[edi.Samp_len]
                cmp     ecx,ebp
                jg      @@next_samp

                mov     SampDataGUSPtrs[esi],ebx
                call    GUSMov2DRAM

                call    @@gusfix

                add     ecx,3fh
                and     cl,0e0h

                add     ebx,ecx
                sub     ebp,ecx

@@next_samp:    pop     ecx
                inc     edx
                jmp     @@samp_loop

@@end_samp:     pop     edx
@@next_inst:    inc     ecx
                jmp     @@inst_loop

@@end_inst:     pop     ecx

@@last16_loop:  call    @@try_16bits
                mov     eax,ebx
                and     eax,0c0000h
                add     eax,040000h
                sub     eax,ebx
                add     ebx,eax
                sub     ebp,eax
                jg      @@last16_loop

                ; GUS memory info never stored! (not neccessary for now)

                cmp     GUSIrqEnabled,0
                jz      @@no_irq
                call    start_gusirq_
@@no_irq:
                jmp     @@end

;-----------------------------------------------------------------------------
; Padding samples with bytes to remove clicks...
;

@@gusfix:       push    ebx
                push    ecx
                push    edx

                test    [edi.Samp_type],1
                jz      @@no_floop

                mov     ecx,[edi.Samp_loopstart]
                add     eax,ecx
                add     ebx,ecx
                add     ebx,[edi.Samp_looplen]
                mov     ecx,32

                test    [edi.Samp_type],16
                jz      @@8bit
                sal     ecx,1
@@8bit:         call    GUSMov2DRAM
                jmp     @@cont_gusfix

@@no_floop:     mov     @@last_word,0
                test    [edi.Samp_type],2
                jz      @@no_biloop
                mov     dx,-2[eax+ecx]
                mov     @@last_word,dx

@@no_biloop:    add     ebx,ecx
                mov     edx,32
                lea     eax,@@last_word
                mov     ecx,1

                test    [edi.Samp_type],16
                jz      @@lastpad_loop
                sal     ecx,1
                sal     edx,1
                inc     eax

@@lastpad_loop: call    GUSMov2DRAM
                inc     ebx
                dec     edx
                jg      @@lastpad_loop

@@cont_gusfix:  pop     edx
                pop     ecx
                pop     ebx

                ret
;-----------------------------------------------------------------------------
@@last_word     dw      0

;-----------------------------------------------------------------------------
; Makes sure that 16bit samples don't cross any 256K border.
;

                ; ebx = GUS DRAM ptr
                ; ebp = GUS mem left


@@try_16bits:   push    ecx
                push    edx
                push    ebp

                ; get # bytes left to barrier
                mov     ebp,ebx
                and     ebp,0c0000h
                add     ebp,040000h
                sub     ebp,ebx
                push    ebp


                mov     edx,SongPtr
                movzx   ecx,[edx.Song_instnum]
                push    ecx
                xor     ecx,ecx

@@inst_loop16:  cmp     ecx,[esp]           ;FRM: must be ESP=SP!
                jge     @@end_inst16

                mov     eax,InstPtrs[ecx*4]
                or      eax,eax
                jl      @@next_inst16

                movzx   edx,[eax.Inst_sampnum]
                push    edx
                xor     edx,edx

@@samp_loop16:  cmp     edx,[esp]           ;FRM: must be ESP=SP!
                jge     @@end_samp16

                mov     esi,ecx
                sal     esi,6
                lea     esi,[esi+edx*4]
                push    ecx
                mov     eax,SampDataPtrs[esi]
                mov     edi,SampPtrs[esi]
                or      edi,edi
                jl      @@next_samp16

                test    [edi.Samp_type],16
                jz      @@next_samp16
                mov     ecx,[edi.Samp_len]
                cmp     ecx,ebp
                jg      @@next_samp16
                cmp     DWORD PTR SampDataGUSPtrs[esi],0
                jge     @@next_samp16
                mov     SampDataGUSPtrs[esi],ebx
                call    GUSMov2DRAM

                call    @@gusfix

                add     ecx,7fh
                and     cl,0c0h
                add     ebx,ecx
                sub     ebp,ecx

@@next_samp16:  pop     ecx
                inc     edx
                jmp     @@samp_loop16
@@end_samp16:   pop     edx
@@next_inst16:  inc     ecx
                jmp     @@inst_loop16
@@end_inst16:   pop     ecx
                pop     eax
                sub     eax,ebp

                pop     ebp
                pop     edx
                pop     ecx
                sub     ebp,eax

                ret

                ENDP

;

InitXM          PROC    NEAR
                ;       In:
                ;        esi = ptr to musicdata
                ;       Out:
                ;         ax = 0: Ok! Ready for some serious audio action!
                ;              1: Music format not identified.
                ;              2: Non-playable XM / Old XM version
                ;        [SongPresent] sets to 1 if xm were loaded


                mov     eax,-1
                lea     edi,InstPtrs
                mov     ecx,128
                rep     stosdd              ;FRM

                lea     edi,SampPtrs
                mov     ecx,128*16
                rep     stosdd              ;FRM

                lea     edi,SampDataPtrs
                mov     ecx,128*16
                rep     stosdd              ;FRM

                xor     ecx,ecx
@@idxm_loop:    lodsbd                      ;FRM
                cmp     al,@@xm_sign[ecx]   ;FRM: removed "cs:" override
                jne     @@notxm
                inc     ecx
                cmp     cl,16
                jl      @@idxm_loop

                mov     eax,SongPtr
                cmp     [eax.Song_version],0104h   ; version test
                jl      @@badxm

                mov     dx,[eax.Song_channum]
                mov     ChanNum,dx
                mov     dx,[eax.Song_tempo]
                mov     Tempo,dx
                mov     dx,[eax.Song_speed]
                mov     Speed,dx

                xor     dl,dl
                test    [eax.Song_flags],1
                jnz     @@not_amiga
                mov     dl,1
@@not_amiga:    mov     AmigaFlag,dl

                mov     ebx,[eax.Song_hsize]
                lea     eax,60[eax+ebx]

                mov     edx,SongPtr
                lea     edi,PattPtrs
                xor     ecx,ecx
                add     cx,[edx.Song_pattnum]
                jz      @@badxm
@@patt_loop:    stosdd                      ;FRM
                movzx   ebx,[eax.Patt_packsize]
                add     ebx,[eax.Patt_hsize]
                add     eax,ebx
                loopd   @@patt_loop         ;FRM

                mov     ebx,SongPtr
                xor     ecx,ecx
                add     cx,[ebx.Song_instnum]
                jz      @@badxm

                lea     edi,InstPtrs
                xor     ebp,ebp
@@inst_loop:    push    ecx
                stosdd                      ;FRM
                mov     ebx,[eax.Inst_size]
                mov     edx,[eax.Inst_samphsize]
                movzx   ecx,[eax.Inst_sampnum]
                add     eax,ebx
                or      ecx,ecx
                jnz     @@i_sampsexist

                mov     esi,-1
                mov     -4[edi],esi
                jmp     @@i_nosamps

@@i_sampsexist: push    edi
                mov     esi,ebp
                sal     esi,6
                lea     edi,SampDataPtrs[esi]
                lea     esi,SampPtrs[esi]

                push    ecx
                push    esi
@@samp_loop:    mov     [esi],eax
                lea     esi,4[esi]
                add     eax,edx
                loopd   @@samp_loop         ;FRM
                pop     esi
                pop     ecx

@@sampdat_loop: push    ecx
                stosdd                      ;FRM
                mov     ebx,[esi]
                mov     ecx,[ebx.Samp_len]
                or      ecx,ecx
                jz      @@no_sampdat
                xor     edx,edx
                test    [ebx.Samp_type],10h
                jnz     @@sd_16bitdata

                push    eax
                push    ecx
@@sd_8cnvloop:  add     dl,[eax]
                mov     [eax],dl
                inc     eax
                loopd   @@sd_8cnvloop       ;FRM
                pop     ecx
                pop     eax
                add     eax,ecx
                jmp     @@no_sampdat

@@sd_16bitdata: shr     ecx,1
@@sd_16cnvloop: add     dx,[eax]
                mov     [eax],dx
                lea     eax,2[eax]
                loopd   @@sd_16cnvloop      ;FRM
@@no_sampdat:   lea     esi,4[esi]
                pop     ecx
                loopd   @@sampdat_loop      ;FRM
                pop     edi

@@i_nosamps:    pop     ecx
                inc     ebp
                loopd   @@inst_loop         ;FRM

@@end:          mov     SongPresent,1
                xor     eax,eax
                ret
@@badxm:        xor     eax,eax
                mov     al,2
                ret
@@notxm:        xor     eax,eax
                mov     al,1
                ret
;-----------------------------------------------------------------------------
@@xm_sign       db      'Extended Module:'

                ENDP


;

IFNDEF FRM
NOWARN OPI
                ENDS

;
;
                END
ENDIF

