
/*
        PC IRQ handeling routines for WatcomC++.

        By Hkan Wallin (the edge/CDA)

*/

//

#include <dos.h>
#include <conio.h>
#include "irq.h"

//


//
// Translates an IRQ number to DOS interrupt number.

char
irq2int(char nr)
{
        return (nr + ((nr < 8) ? 0x08:0x68));
}

//

void irq_cli();
//#pragma aux irq_cli = "cli";     NOTE! Pragma defined in irq.h

//----------------------------------------------------------------------------

void irq_sti();
//#pragma aux irq_sti = "sti";     NOTE! Pragma defined in irq.h


//

void far*
irq_gethandler(char nr)
{
        union   REGS    r;
        struct  SREGS   sr;

        r.x.eax = 0x3500 | irq2int(nr);
        sr.ds   = 0;
        sr.es   = 0;
        int386x(0x21,&r,&r,&sr);
        return (MK_FP(sr.es,r.x.ebx));
}

//----------------------------------------------------------------------------

void
irq_sethandler(char nr,void far* hptr)
{
        union   REGS    r;
        struct  SREGS   sr;

        r.x.eax = 0x2500 | irq2int(nr);
        r.x.edx = FP_OFF(hptr);
        sr.ds   = FP_SEG(hptr);
        sr.es   = 0;
        int386x(0x21,&r,&r,&sr);
}


//

int
irq_isenabled(char nr)
{
        if (nr < 8)
            return ((inp(0x21) & (1 << nr)) == 0);
        else
            return ((inp(0xa1) & (1 << (nr & 7))) == 0);
}


//

void
irq_enable(char nr)
{
        if (nr < 8)
        {
            outp(0x21,inp(0x21) & ~(1 << nr));
            outp(0x20,0x60+nr);
        }
        else
        {
            outp(0xa1,inp(0xa1) & ~(1 << (nr & 7)));
            outp(0xa0,0x60+(nr & 7));
            irq_enable(2);
        }
}

//----------------------------------------------------------------------------

void
irq_disable(char nr)
{
        if (nr < 8)
            outp(0x21,inp(0x21 | (1 << nr)));
        else
            outp(0xa1,inp(0xa1 | (1 << (nr & 7))));
}


//


