
;
; Routines by Cyborg / Mistery <cyborg@otitsun.oulu.fi>


;
; Frequent string shorthand EQUs

B               EQU BYTE PTR
W               EQU WORD PTR
D               EQU DWORD PTR
O               EQU OFFSET


;
; Useful macros

; terminates program with errorlevel "code"
; [fold]  [
Exit            MACRO code
        mov     ax,4Ch shl 8 or code
        int     21h
ENDM

; [fold]  ]

; jumps to dest if no key was pressed
; [fold]  [
loopkey         MACRO dest
        mov     ah,0Bh
        int     21h
        test    al,al
        jz      dest
ENDM

; [fold]  ]

; moves source to destination using push/pop
; [fold]  [
movseg          MACRO dest,src
        push    src
        pop     dest
ENDM

; [fold]  ]

; Writes string
; [fold]  [
Prints          MACRO str
        mov    ah,09h
        mov    dx,offset str
        int    21h
ENDM

; [fold]  ]


;
; Useful routines

; Clears screen
; [fold]  [
ClrScr:
       mov   ah,0fh
       int   10h       ; Get video state: ah=columns, al=mode, bh=page
       mov   bl,ah     ; Now: bl=columns, bh=page

       mov   ah,02h
       xor   dx,dx
       int   10h       ; Cursor to 0,0

       mov   ah,06h    ; Write space for checking current attribute
       mov   dl,' '
       int   21h

       mov   ah,02h    ; Again to 0,0
       xor   dx,dx
       int   10h

       mov   ah,08h    ; Read color at cursor: ah=color
       int   10h

       mov   bh,ah     ; Scroll window up
       mov   ah,06h
       xor   al,al
       xor   cx,cx
       mov   dh,0ffh
       mov   dl,bl
       int   10h
       ret

; [fold]  ]

; Waits for vertical retrace
; [fold]  [
WaitVBL:
        mov     dx,3DAh
W1:     in      al,dx
        test    al,1000b        ; ZF set if IN vertical retrace
        jnz     W1              ; jump if not VR -> wait for VR
W2:     in      al,dx
        test    al,1000b
        jz      W2              ; wait while not in VR -> goto start of retrace
        ret

; [fold]  ]

; Writes DWORD in EAX in hex to screen
; [fold]  [
PrintHex:
        mov     cx,8
        xor     bl,bl
HexLoop:
        rol     eax,4
        push    eax
        and     al,0fh
        or      bl,al
        jz      ItsZero
        add     al,'0'
        cmp     al,'9'
        jbe     Less10
        add     al,('A'-'0'-10)
Less10: mov     dl,al
        mov     ah,02h
        int     21h
ItsZero:
        pop     eax
        loop    HexLoop
        test    bl,bl
        jnz     NotZero
        mov     ah,02h
        mov     dl,'0'
        int     21h
NotZero:
        ret

; [fold]  ]

; Writes DWORD to screen
; Input:
; CarryFlag=1 -> number is signed, otherwise CarryFlag=0 -> number is unsigned
; EAX = number
; [fold]  [
PrintNum:
        jnc     Unsigned
        test    eax,eax
        jns     Unsigned
        neg     eax
        push    ax
        mov     ah,02h
        mov     dl,'-'
        int     21h
        pop     ax
Unsigned:
        mov     esi,1000000000  ; 1.000.000.000
        mov     cx,10
        movzx   ebp,cx
        xor     bl,bl
PrintLoop:
        xor     edx,edx
        div     esi

        push    edx             ; save remainder
        or      bl,al
        jz      DontPrint
        mov     ah,02h
        add     al,'0'
        mov     dl,al
        int     21h
DontPrint:
        mov     eax,esi
        xor     edx,edx
        div     ebp
        mov     esi,eax
        pop     eax
        loop    PrintLoop
        test    bl,bl
        jnz     DontPutZero
        mov     ah,02h
        mov     dl,'0'
        int     21h
DontPutZero:
        ret

; [fold]  ]

; gets a number from ASCII source
; input:   BP = number base (16=hex, 10=dec)
;          DS:SI = source stream
;          CX    = source left length+1
;          BX    = error msg ofs (used only if error detected)
; returns: DI = number
; [fold]  [
GetNum:
StripNonNums:
        dec     cx
        jz      Error
        lodsb
        call    ToNumeric
        cmp     ax,bp
        jae     StripNonNums
        mov     di,ax           ; DI = result
LoopStart:
        dec     cx
        jz      NonNum
        lodsb
        mov     bl,al           ; Save byte to BL
        call    ToNumeric
        cmp     ax,bp
        jae     NonNum
        xchg    ax,di
        mul     bp
        add     di,ax
        jmp     LoopStart
NonNum:
        mov     al,bl
        ret

; Input:   ASCII in AL
; Returns: Number in AX  (0ffffh = error)
ToNumeric:
        xor     ah,ah
        add     al,(-'0')
        cmp     al,9            ; Is it number?
        jbe     Num
        add     al,('0'-'A')
        cmp     al,('Z'-'A')    ; Is it Upper case alphabet?
        jbe     Alp
        add     al,('A'-'a')
        cmp     al,('z'-'a')    ; Is it Lower case alphabet?
        jbe     Alp
        xor     ax,ax           ; It was not number nor alphabet
        dec     ax
Num:    ret
Alp:    add     al,10
        ret

; [fold]  ]


;
; File handling routines

; Gets opened file's length to EBP and moves position to start
; [fold]  [
GetFileLen:
        mov     ax,4202h
        xor     cx,cx
        xor     dx,dx
        int     21h
        jc      FileLenErr
        shl     edx,16
        mov     dx,ax
        mov     ebp,edx
        mov     ax,4200h
        xor     cx,cx
        xor     dx,dx
        int     21h
        jc      FileLenErr
        ret
FileLenErr:
        Prints  FileLenErrStr
        Exit    2
FileLenErrStr  db 'Error getting file length!',13,10,'$'

; [fold]  ]

; In: DS:DX=name ofs; Out: BX=handle; Destroys: AX
; [fold]  [
OpenFile:
        mov     ax,3D00h
        int     21h
        jc      OpenFileErr
        mov     bx,ax
        ret
OpenFileErr:
        Prints  OpenFileErrStr
        Exit    3
OpenFileErrStr  db 'Error opening file!',13,10,'$'

; [fold]  ]

; In: DX=bytes to skip, BX=handle; Destroys: AX, CX
; [fold]  [
SkipFile:
        mov     ax,4200h
        xor     cx,cx
        int     21h
        jc      SkipFileErr
        ret
SkipFileErr:
        Prints  SkipFileErrStr
        Exit    4
SkipFileErrStr  db 'Error skipping file!',13,10,'$'

; [fold]  ]

; In: BX=handle, ES:EDI++=dest addr, EBP=bytes to read; Destr: ECX,EBP,DX,AX,ESI
; [fold]  [
ReadFile:
        xor     ecx,ecx
ReadMore:
        mov     cx,DSK_BUFFERSIZE
        cmp     ebp,ecx
        jnb     NotLastRead
        mov     cx,bp
NotLastRead:
        mov     dx,O FileBuffer
        mov     ah,3Fh
        int     21h
        jc      ReadFileErr
        test    ax,ax
        jz      ReadFileErr
        mov     esi,[AddrFileBuffer]
        mov     cx,ax
        sub     ebp,ecx
        rep     movs B es:[edi],B es:[esi]
        jnz     ReadMore
        ret
ReadFileErr:
        Prints  ReadFileErrStr
        Exit    5
ReadFileErrStr  db 'Error reading file!',13,10,'$'

; [fold]  ]

; In: BX=handle; Destroys: AX
; [fold]  [
CloseFile:
        mov     ah,3Eh
        int     21h
        jc      CloseFileErr
        ret
CloseFileErr:
        Prints  CloseFileErrStr
        Exit    6
CloseFileErrStr db 'Error closing file!',13,10,'$'

; [fold]  ]


; [fold]  14
