/* EXE file header fixer, code taken from Morten Welinder */

#include <stdio.h>
#include <fcntl.h>

static char copyright[] =
 "\r\n%s is Copyright (C) 1996 Charles W. Sandmann (sandmann@clio.rice.edu)\r\n"
 "Copyright (c) 1994 Thomas Pytel, Copyright (c) 1996 Matthias Grimrath.\r\n"
 "ABSOLUTELY NO WARRANTY.\r\n"
 "Use for any purpose allowed provided this copyright remains unmodified.\r\n%c";

int main(int argc, char **argv)
{
  int f;
  unsigned short us, test;
  char msg[512];

  if(argc != 2) {
    printf("Usage: ehdrfix pmodetsr.exe\n      Updates heap size in exe header\n");
    exit(1);
  }

  f = open(argv[1], O_RDWR | O_BINARY);
  if (f < 0) {
    perror(argv[1]);
    exit(1);
  }

  lseek(f, 0x0aL, SEEK_SET);
  read(f, &us, sizeof(us));
  read(f, &test, sizeof(us));
  if(test == 0xffff) {		/* Not set yet */
    lseek(f, 0x0cL, SEEK_SET);
    write(f, &us, sizeof(us));	/* Update max memory */
    sprintf(msg,copyright,argv[1],26);
    msg[256] = 0;		/* Make sure we don't overwrite code */
    /* Assume here that fixups leave the last 256 bytes of the header empty */
    lseek(f, 256L, SEEK_SET);
    write(f, msg, strlen(msg));
  }
  return close(f);
}
