;****************************************************************************
; Filename: FGETC.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @fgetc(FILE * stream)
;  Comment: reads the next character from the file stream
;    Input: Eax = pointer to opened file stream.
;   Output: Eax = chracter byte read from file/device. Returns EOF on error.
;****************************************************************************

        Include STDDEF.INC


Extrn __UpdateBuffer:Near

        Codeseg

Proc  fgetc, 1

        Test    [Eax+FILE._mode],8              ; Error if error flag
        Jnz     @@EOF
;        Test    [Eax+FILE._mode],1          ; Error if not readable
;        Jz      @@EOF
;        And     [Eaxi+FILE._mode],NOT 2      ; clear writeable flag

        Mov     Ecx, [Eax+FILE._position]
        Cmp     Ecx, [Eax+FILE._size]
        Jae      @@Update
@@Updated:
        Mov     Edx, [Eax+FILE._base]
        Add     Edx, [Eax+FILE._position]
        Inc     [Eax+FILE._position]
        Clear   Eax
        Mov     Al,[Edx]
        Ret

        Align 4
@@Update:
        Push    Eax
        Call    __UpdateBuffer
        Pop     Eax
        Cmp     [Eax+FILE._size],0
        Jne     @@Updated

@@EOF:
        Or      [Eax+FILE._mode],8              ; mark error set
        Mov     Eax,EOF
        Ret

Endp

        End
