;
;UNPACK_LBM = routine depacks a 256color LBM-File an stores it into memory.
;
;             Version v3.2 done by Capella of Escape  
;             (TASM-version)
;             
;             This routine works in Protected-mode, so keep sure that you
;             have CS and DS set to one Huge 32bit segment...
;             This routine is freeware, so use it in any way you want!!
;             This routine don't takes care of the colortable, but give back
;             an offset to the colortable at the end of the routine, which 
;             can be used to load the colortable with an own routine.
;             This code runs with each Pmode-Extender, so no needs to convert
;             it. I don't understand why so much people only uses PCX-files 
;             which are much longer than LBM-files.  
;
;IN:  ESI  = Offset to the Source-Datas              
;     ECX  = Filelength of loaded LBM-File
;     EDI  = Offset to the Target-Buffer
;
;OUT: Carry=0 then;
;                       AX  = Xsize of Picture
;                       BX  = Ysize of Picture
;                       ESI = Offset to the Colortable
;                       
;     Carry=1 then something went wrong...
;
;                       AX = error-code   / 01h = Colormap not found
;                                           02h = Bitmap not found 
;
.386
IDEAL
MODEL FLAT, C


    DATASEG


ALIGN 4

Color_Table     dd ?
Bitmap_Table    dd ?
Bitmap_Bytes    dd ?
LBM_Xsize       dw ?
LBM_Ysize       dw ?

    CODESEG

    LOCALS

PROC    unpack_lbm 

                push esi
                push ecx

                add esi,14h
                mov ax,[ds:esi+2]     ; get y-size of picture
                xchg al,ah            ; switch low/high coz of amiga-format
                mov [ds:LBM_Ysize],ax
                cwde                  ; convert AX to EAX with same value
                mov ebx,eax

                mov ax,[ds:esi]       ; get x-size of picture
                xchg al,ah            ; switch low/high coz of amiga-format
                mov [ds:LBM_Xsize],ax
                cwde                  ; convert AX to EAX with same value
                
                imul ebx                   ; calculate real amount of bytes
                mov [ds:Bitmap_Bytes],eax  ; used in the bitmap
                
                mov ebx,"PAMC"        ; search for colortable

@@x1:           mov eax,[ds:esi]
                cmp eax,ebx
                je @@x2

                inc esi
                dec ecx
                jnz @@x1

                pop ecx
                pop esi
                stc
                mov ax,01h
                ret

@@x2:           add esi,8
                mov [ds:Color_Table],esi  ; store offset to colortable
                pop ecx
                pop esi               ; searching for the Bitmap-data begins
                                      ; at the beginning of the file, normaly
                                      ; it's not needed.......

                mov ebx,"YDOB"        ; search for bitmap-data
@@x3:           mov eax,[ds:esi]
                cmp eax,ebx
                je @@x4

                inc esi
                dec ecx
                jnz @@x3
                stc
                mov ax,02h
                ret

@@x4:           add esi,8
                mov [ds:Bitmap_Table],esi  ; store offset to bitmap-data
                
                xor ebx,ebx                ; byte-counter to zero

@@x5:           mov al,[ds:esi]            ; read packed bitmap-data
                mov ah,al
                cmp ebx,[ds:Bitmap_Bytes]  ; all bytes stored ??
                jae @@x9                   ; yes, then end  this shit...

                and al,10000000b           ; check if equal or different bytes
                cmp al,80h                 ; to copy
                je @@x7                    ; if bit 7 set then equal bytes to
                                           ; read
                
                mov cl,ah                  ; setup counter to copy bytes
                xor ch,ch
                inc cx
                inc esi

@@x6:           mov al,[ds:esi]            ; copy-routine for different bytes
                mov [ds:edi],al
                inc esi
                inc edi
                inc ebx
                dec cx
                jnz @@x6

                jmp @@x5

@@x7:           mov cl,ah                  ; setup counter to copy bytes
                xor ch,ch
                dec cx
                inc esi

                
@@x8:           mov al,[ds:esi]            ; copy-routine for equal bytes
                mov [ds:edi],al
                inc edi
                inc ebx
                inc cx
                cmp cx,0100h
                jnz @@x8

                inc esi
                jmp @@x5

@@x9:           mov ax,[ds:LBM_Xsize]
                mov bx,[ds:LBM_Ysize]
                mov esi,[ds:Color_Table]
                clc
                ret                       ; end this shit......

ENDP    unpack_lbm
;

    Public unpack_lbm

END