;
; Version 3.4
;
; Handling-Routines for using the Flatmodel of the '386/'486
;
; This version is not ment to be spread to the public so keep it as it is
; a tribute to the ESCAPE-crew.
; Other FLAT-model routines need a HIMEM-driver to get access on the extended
; memory, this one doesn't need any HIMEM-driver.
; If you use DOS loaded HIGH in the HIGH MEMORY AREA(HMA), it doesn't matter.
; The memory-handling routines keeps a safety-buffer of 65535 bytes after the
; beginning of the extended memory.
; Why wasting 10% of the cpu-time in the protected-mode when you can use the
; whole memory in real-mode.....
;
; Done by Capella/ESCAPE in may'95
;
; CALL SET_FLATMODE - sets up the FLAT-model
; CALL FLAT_READ    - reads bytes out of the extended memory
; CALL FLAT_WRITE   - writes bytes into the extended memory
; CALL CHECK_V86    - checks for an emm-driver or something like that
;
;

gdtsize  =   32
gdtpointer      dq ?

pmode_seg       dw 0,0,0,0

                dw 0ffffh,0
                db 0,9ah
                dw 0
                dw 0ffffh,0

                db 0,92h
                dw 0
                dw 0ffffh,0

                db 0,92h
                dw 0ffffh

;
; Generating the FLAT-Model for Real-Mode using
;
proc  set_flatmode  NEAR
                
                mov ax,cs              ;get code-segment
                push ds                ;save ds-segment-pointer
                mov ds,ax              ;set code-segment to ds-pointer
                mov [cs:rmode_seg],ax    ;save code-segment

                movzx eax,ax           ;make dword our of word
                shl eax,4              ;calculate offset-pointer
                mov ebx,eax            ;save for later calculations

                mov [cs:pmode_seg+10],ax ;set segment-pointers in Pmode
                mov [cs:pmode_seg+18],ax ;

                ror eax,16             ;get higher word of dword

                mov [byte cs:pmode_seg+12],al ;set segment-pointer in pmode
                mov [byte cs:pmode_seg+20],al

                xor eax,eax              ;make eax=0

                mov ax,offset pmode_seg  ;get offset of pmode_seg
                add ebx,eax

                mov [word cs:gdtpointer],gdtsize
                mov [dword cs:gdtpointer+2],ebx

                pushf
                cli
                in  al,70h
                mov ah,al
                or al,80h
                out 70h,al
                and ah,80h
                mov ch,ah

                lgdt [fword cs:gdtpointer]

                mov bx,ds
                mov dx,ss
                mov eax,cr0
                or al,1
                mov cr0,eax
                
                db 0eah
                dw offset pmode
                dw 8


pmode:          mov ax,10h
                mov ss,ax
                mov ds,ax
                mov ax,18h
                mov es,ax
                mov fs,ax
                mov gs,ax
                mov eax,cr0
                and eax,not 1
                mov cr0,eax
                
                db 0eah
                dw offset rmode
                
rmode_seg         dw ?

rmode:          mov ss,dx
                mov ds,bx
                xor ax,ax
                mov es,ax
                mov fs,ax
                mov gs,ax
                in al,70h
                and al,not 128
                or al,ch
                out 70h,al
                popf
                pop ds
                ret

endp

;
; Read out of Expanded Memory
;
; DS:DI  = destination-pointer in conventional memory
; CX     = amount of bytes to read
; GS:EAX = source-pointer in expanded memory
;

proc  flat_read  NEAR
                
                push cx   
                push eax

                call enable_a20

                pop eax
                pop cx
                add eax,1024*1024+0ffffh

flat_loop1:     mov bl,[gs:eax]
                mov [ds:di],bl

                inc eax
                inc di

                dec cx
                jnz flat_loop1
                ret

endp

;
; Write into Expanded Memory
;
; DS:SI  = source-pointer in conventional memory
; CX     = amount of bytes to write
; GS:EAX = destination-pointer in expanded memory
;

proc  flat_write  NEAR     
                
                push cx
                push eax

                call enable_a20

                pop eax
                pop cx
                add eax,1024*1024+0ffffh

flat_loop2:     mov bl,[ds:si]
                mov [gs:eax],bl

                inc si
                inc eax

                dec cx
                jnz flat_loop2
                ret

endp

;
; Enable the Memory Adressline 20
;

enable_a20:     cli
                
                xor cx,cx
flat_loop3:     in al,64h
                and al,2
                loopnz flat_loop3

                jnz go_back

                mov al,0d1h
                out 64h,al

                xor cx,cx
flat_loop4:     in al,64h
                and al,2
                loopnz flat_loop4

                jnz go_back

                mov al,0dfh
                out 60h,al

                xor cx,cx
flat_loop5:     in al,64h
                and al,2
                loopnz flat_loop5

go_back:        ret

;
; Check for virtual memory using like (EMM,QEMM,....)
;

v86   db 0

check_v86:      cld
                smsw ax
                test ax,1
                jnz v86_found
                ret
v86_found:      mov [byte cs:v86],1
                ret

