#define TEXTMEM 8000



/* Text output system, written in a HURRY */

#include "tos.h"
#include <memory.h>

void memstosd(dword strt,dword length,dword color);
#pragma aux memstosd=\
	"rep stosd"\
	parm [edi] [ecx] [eax]\
	modify [edi ecx];
int TOSscr=0;

int TOSinit(word xres,word yres) { /* Inits TOS currently avtomated 80x25*/
	ctext.xres=xres;
	ctext.yres=yres; /* current allocated x and y */
	ctext.data=malloc(ctext.xres*ctext.yres*2); /* ... data */
	ctext.cwidth=8;
	ctext.cheight=16;
	ctext.xvirtualres=ctext.xres*ctext.cwidth;
	ctext.yvirtualres=ctext.yres*ctext.cheight;
	TOSclear();
    TOSscr=0;
	return(0);
}

int TOSresize(word xres,word yres){ /* resizes TOS canvas */
	{
	dword oldmemsize=(dword)ctext.xres*((dword)ctext.yres)*2;
	dword memsize=(dword)xres*((dword)yres+1)*2;
    
	if ((ctext.data=(byte *)realloc(ctext.data,memsize))==-1) {
		printf("Not enough memmory for TOS resize\n");
		return (-1);
	}
    
	memstosd((dword)ctext.data+oldmemsize,(memsize-oldmemsize)/4,0x07000700);    
//	tmp=malloc(xres);
 
    
	ctext.xres=xres;
	ctext.yres=yres;
	ctext.xvirtualres=ctext.xres*ctext.cwidth;
	ctext.yvirtualres=ctext.yres*ctext.cheight;
	return(0);
	}
}
void TOSfree(void) { /*frees after usage */
	free(ctext.data);
}
int TOSclear(){ /* clears TOS canvas */ 
	memstosd((dword)ctext.data,(dword)ctext.xres*ctext.yres*2/4,0x07000700);    
}

void TOStovideo(word starty, word endy, word targety){ 
/* puts part of TOS to video screen*/
	memcpy(0x00b8000+targety*160,starty*160+ctext.data,(endy-starty)*160);
}
int lasty=0;
void SetPan(byte i);   //sets panning register to i
#pragma aux SetPan=\
	"mov dx,0x3d4"\
	"mov al,8h"\
	"out dx,ax"\
	parm [ah]\
	modify [dx ax];
        
void SetCrtStart(word off);
#pragma aux SetCrtStart=\
	"mov     ah,bh"\
	"mov     al,0ch"\
	"mov     dx,3d4h"\
	"out     dx,ax"\
	"mov     ah,bl"\
	"inc     al"\
	"out     dx,ax"\
   	parm [bx]\
	modify [bx ax dx];
                           
  	  
void Retrace();
	#pragma aux Retrace=\
	"mov dx,3dah"\
	"vert1:"\
	"in al,dx"\
	"test al,8"\
	"jz vert1"\
	"vert2:"\
	"in al,dx"\
	"test al,8"\
	"jnz vert2"\
	modify [dx al]; 

void TOSdisplay25(word y)
{
  	TOStovideo(0+y/ctext.cheight,y/ctext.cheight+25,0);
//	TOStovideo(0+y/ctext.cheight,y/ctext.cheight+25,y/ctext.cheight);
	SetCrtStart(0);
	SetPan(0);

 	Retrace();
}				
 
void TOStovideotrunc(int starty, int endy, word targety){ 
/* puts part of TOS to video screen*/
	if (starty<0) {
		targety-=starty;
		starty=0;
	}
	{	
		dword startoff=((dword)starty*160);
		dword endoff=((dword)endy*160);
		dword targetoff=((dword)targety*160)%TEXTMEM;
		
		
		if (targetoff<4000) {
			memcpy(0x00b8000+targetoff,startoff+ctext.data,(endy-starty)*160);
			memcpy(0x00b8000+targetoff+TEXTMEM,startoff+ctext.data,(endy-starty)*160);
		} else {
			memcpy(0x00b8000+targetoff,startoff+ctext.data,(endy-starty)*160);
				}
	}
}
void WaitVInActive();
#pragma aux WaitVInActive=\
	"mov     dx,0x03da"\
	"VInactive:"\
	"in      al,dx"\
	"test    al,00001000b"\
	"jz  VInactive"\
	modify [dx al]; 
	
void WaitHActive() {
#pragma aux WaitHActive=\
	"mov     dx,0x03da"\
	"HActive:"\
	"in      al,dx"\
	"test    al,00000001b"\
	"jnz     HActive"\
	modify [dx al]; 
	
}

void TOSdisplay(word y)
{
	if (TOSscr==0) {
		TOStovideo(0+y/ctext.cheight,y/ctext.cheight+25,y/ctext.cheight);
 		TOSscr=1;
 	} else {
		WaitVInActive();
		WaitHActive();
		SetCrtStart(((y>>4)*80)%(TEXTMEM/2));
 		SetPan(y&15);
 		TOStovideotrunc(y/ctext.cheight+25,y/ctext.cheight+3+25,y/ctext.cheight+25);
 		TOStovideotrunc(y/ctext.cheight-3,y/ctext.cheight,y/ctext.cheight-3);
 		
 	}
}				
				

void TOSputchar(word x, word y, char c, byte color){ /* puts char c to x,y font fin */
	word rx=x/ctext.cwidth;
	word ry=y/ctext.cheight;
	if (ry>=ctext.yres) {
		TOSresize(80,ctext.yres+25);
	}
	ctext.data[(ry*ctext.xres+rx)*2]=c;
	ctext.data[(ry*ctext.xres+rx)*2+1]=color;
	

}
void TOSputstr(word x, word y, const char *str, byte color) { /* puts string to x,y */
	int i;
	int curx=x;
	for (i=0;i<strlen(str);i++) {
		char c=str[i];
		TOSputchar(curx,y,c,color);
		curx+=TOSgetwidthchar();
	}
    
}
word TOSgetwidthchar() { /* gets width of the char of font fin */
	return(ctext.cwidth);
}
word TOSgethightchar(){ /* gets highth of the char of font fin */
	return (ctext.cheight);
}
word TOSgetwidthstr(const char *str) /* gets string width */
{
	int i;
	int curx=0;
	for (i=0;i<strlen(str);i++) {
		char c=str[i];
		curx+=TOSgetwidthchar(c);
	}
	return(curx);
}


void TOSinvertarea(word xx1,word yy1,word xx2,word yy2) { 
/* takes care of inverting specfified area of screen */
/* sets the complementar colors on that area */
	int x,y;
	word x1=xx1/TOSgetwidthchar();
	word y1=yy1/TOSgethightchar();
	word x2=xx2/TOSgetwidthchar();
	word y2=yy2/TOSgethightchar();
	
	for (x=x1;x<x2;x++) {
		for (y=y1;y<y2;y++) { 
			char pget=ctext.data[(y*ctext.xres+x)*2+1];
			
			pget=(pget^(16-(pget<<4)));
			ctext.data[(y*ctext.xres+x)*2+1]=pget;
			  
		}
	}
}
