
/* Generic BMP read unit 
   31.1.1998:
   loadpic .bmp - load bmp picture
   freepic - frees all bmp pictures
   putpic - puts bmp picture to screen 
   getwidth - gets width of char in font
   gethight - gets higth of char in font 
      
   currently max 30 pics supported
   writen by MinMax
   */
	#define MAXPICS 30

	typedef struct genpic { /* generic pic */
		char name[30];
		byte pal[768];
		byte *data;
		word width,hight;
		word pal16[256];
	} genpic;


   	int numpics=0;
   	struct genpic picsa[MAXPICS];

	int loadpic(const char *filename); /* loads bmp picture from filename */
      
                              /* returns pic's internal number */
	putpic(word x, word y, int pin); /* puts pic to x,y */
    
	word getpicwidth(int pin); /* gets width of picture fin */
	word getpichight(int pin); /* gets highth of picture fin */
   
	void freepic(); /* frees ALL pics that are loaded */
	int getpicnum(const char *filename);  /* returns pic number */
