/* Generic fonts unit 
   14.6.1998:
   Xdebug added - outputs text in grahpics debug mode and waits for keypress
   24.1.1998:
   loadfnt .fnt - load generic 16x8 one colour font
   putfntchar - put fonted char to screen
   freefnt - frees memory
   putfntstr - puts string to screen
   getwidth - gets width of char in font
   gethight - gets higth of char in font 
      
   currently max 30 fonts supported
   writen by MinMax
   */
#ifndef _FONTS_H_
#define _FONTS_H_
	#define MAXFONTS 30
   
	int loadfnt(const char *filename); /* loads generic 16x8 font from filename */
                                     /* returns font internal number */
	putfntchar(word x, word y, char c, int fin, byte color); /* puts char c to x,y font fin */
	putfntstr(word x, word y, const char *c, int fin, byte color); /* puts string to x,y */
	putfntchardbg(word x, word y, char c, int fin, word color); /* puts char c to x,y font fin */
	putfntstrdbg(word x, word y, const char *c, int fin, word color); /* puts string to x,y */
    
	word getwidthchar(char c, int fin); /* gets width of the char of font fin */
	word gethightchar(char c, int fin); /* gets highth of the char of font fin */
	word getwidthstr(const char *c, int fin); /* gets string width */
   
	void freefnt(); /* frees ALL fonts that are loaded */
	int getfntnum(const char *fontname);
   
//	int seqy=0;
//	char alls[20];
//	#define Xdebug(text) strcpy(alls,__FILE__); strcat(alls,": "); itoa(__LINE__,strlen(alls)+alls,10); putfntstrdbg(0,seqy,alls,0,0xffff);putfntstrdbg(190,seqy,text,0,0xffff);seqy+=16;
#endif