/**********************************************

	Prototypes for VGA_T.c

**********************************************/

#include "global.h"

#ifndef __VGA_T_H
#define __VGA_T_H

/**********************************************

	Prototypes

**********************************************/

extern UBYTE *hexbyte;			//	'0123456789ABCDEF' Array
extern UBYTE far * T_bscreen;	//	Byte pointer to Text Screen
extern UWORD far * T_screen;	//	Word pointer to Text Screen
extern UWORD T_attr;				//	Global Text Attribute Word
extern UBYTE T_width;			//	Global Text Screen Width
extern UWORD T_offset;			//	Screen Start Offset

extern void T_ScreenOffset(UWORD ByteOffset);
extern void T_ScreenWidth(UBYTE width);
extern void T_SetPal(UBYTE Col, struct Palette *Pal);
extern void T_GetPal(UBYTE Col, struct Palette *Pal);
extern void T_HorizontalFine(UBYTE X);
extern void T_SetCursor(UBYTE type);
extern void T_SetCursorPos(UBYTE x,UBYTE y);
extern void T_GetCursorPos(UBYTE *x,UBYTE *y);
extern void T_CharHeight(UBYTE height);
extern void T_ClearScreen(UWORD attri);
extern void T_CharXY(UBYTE tkn,UBYTE x,UBYTE y);
extern UWORD T_GetAttr(UBYTE x,UBYTE y);
extern void T_DrawBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2,UBYTE style);
extern void T_FillBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2,UBYTE style,UBYTE fillchar);
extern void T_AttrBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2);
extern void T_String(UBYTE x,UBYTE y,char *string);
extern void T_OutByte(UBYTE x,UBYTE y,UBYTE byt,UBYTE mode);


#endif
