program Demo6;

uses
    MCGA256, Crt;

const
    NumStars = 100;
    CenterX = MaxX div 2;
    CenterY = MaxY div 2;
    BoxWidth = 50;
    BoxHeight = 30;
    GreyThreshhold = 7000;
    WhiteThreshhold = 40000;
    WhiteBoxThreshhold = 60000;

type
    StarPosition = record
        x,
        y: integer;             { x,y position of star on screen        }
        deltax,                 { veloctiy components of star movement  }
        deltay,
        deltadist: integer;
        displacement: longint;  { displcement since creation            }
    end;

var
    StarArray: array [1..NumStars] of StarPosition;



procedure InitialiseStars;
var i: integer;
begin
    for i := 1 to NumStars do
    begin
        StarArray[i].x := CenterX + random(BoxWidth  + BoxWidth  + 1) - BoxWidth;
        StarArray[i].y := CenterY + random(BoxHeight + BoxHeight + 1) - BoxHeight;

        if abs(StarArray[i].x - CenterX) > 4 then
            if StarArray[i].x > CenterX then
                StarArray[i].deltax := random(8) + 1
            else
                StarArray[i].deltax := -(random(8) + 1)
        else
            StarArray[i].deltax := random(3) - 1;

        if (abs(StarArray[i].y - CenterY) > 3) then
            if (StarArray[i].y > CenterY) then
                StarArray[i].deltay := random(6) + 1
            else
                StarArray[i].deltay := -(random(6) + 1)
        else
            StarArray[i].deltay := random(3) - 1;

        StarArray[i].deltadist := Sqr(Sqr(StarArray[i].deltax) + Sqr(StarArray[i].deltay));
    end;
end; {InitialiseStars}


procedure AnimateStars;
var
    i, newx, newy: word;
begin

    for i := 1 to NumStars do
    begin
        newx := StarArray[i].x + StarArray[i].deltax;
        newy := StarArray[i].y + StarArray[i].deltay;
        StarArray[i].displacement := StarArray[i].displacement + StarArray[i].deltadist;

        if ((newx >= MaxX) or (newx < 0) or (newy >= MaxY) or (newy < 0)) then
        begin
            newx := CenterX + random(BoxWidth+BoxWidth+1) - BoxWidth;
            newy := CenterY + random(BoxHeight+BoxHeight+1) - BoxHeight;

            if (StarArray[i].displacement < WhiteBoxThreshhold) then
                PutPixel(StarArray[i].x, StarArray[i].y, 0)
            else
            begin
                {if (StarArray[i].deltax > StarArray[i].deltay) then
                begin
                    PutPixel(StarArray[i].x, StarArray[i].y, 0);
                    PutPixel(StarArray[i].x+1, StarArray[i].y+1, 0);
                end
                else
                begin
                    PutPixel(StarArray[i].x, StarArray[i].y, 0);
                    PutPixel(StarArray[i].x+1, StarArray[i].y+1, 0);
                end}
                FillRectangle(StarArray[i].x, StarArray[i].y, StarArray[i].x+1, StarArray[i].y+1, 0);
            end;

            StarArray[i].displacement := random(GreyThreshhold);

            if abs(newx - CenterX) > 4 then
                if newx > CenterX then
                    StarArray[i].deltax := random(8)+1
                else
                    StarArray[i].deltax := -(random(8)+1)
            else
                StarArray[i].deltax := random(3) - 1;

            if abs(newy - CenterY) > 3 then
                if newy > CenterY then
                    StarArray[i].deltay := random(6)+1
                else
                    StarArray[i].deltay := -(random(6)+1)
            else
                StarArray[i].deltay := random(3) - 1;

            {StarArray[i].deltax := (random(4) + 1) - 3;
            StarArray[i].deltay := (random(4) + 1) - 3;}

            if ((StarArray[i].deltax = 0) and (StarArray[i].deltay = 0)) then
            begin
                StarArray[i].deltax := 1;
                StarArray[i].deltay := 1;
            end;

            StarArray[i].deltadist := Sqr(Sqr(StarArray[i].deltax) + Sqr(StarArray[i].deltay));
        end
        else
        begin
            if (StarArray[i].displacement < WhiteBoxThreshhold) then
                PutPixel(StarArray[i].x, StarArray[i].y, 0)
            else
            begin
                FillRectangle(StarArray[i].x, StarArray[i].y, StarArray[i].x+1, StarArray[i].y+1, 0);
            end;
        end;

        StarArray[i].x := newx;
        StarArray[i].y := newy;

        if (StarArray[i].displacement < GreyThreshhold) then
            PutPixel(StarArray[i].x, StarArray[i].y, 8)
        else if (StarArray[i].displacement < WhiteThreshhold) then
            PutPixel(StarArray[i].x, StarArray[i].y, 7)
        else if (StarArray[i].displacement < WhiteBoxThreshhold) then
            PutPixel(StarArray[i].x, StarArray[i].y, 15)
        else
        begin
            FillRectangle(StarArray[i].x, StarArray[i].y, StarArray[i].x+1, StarArray[i].y+1, 15);
        end;
    end;
end; {AnimateStars}




begin
    if (not OpenGraphics) then
    begin
        WriteLn('Error opening graphics library.');
        Halt(1);
    end;

    Randomize;
    SetActivePage(VirtualScreen);
    FillRectangle(0, 0, 319, 199, 0);
    InitialiseStars;
    repeat
        AnimateStars;
        CopyAllVirtualScreen;
    until keypressed;
    CloseGraphics;
end.
