/* SETMODE.C this module contains initialization part for every graphic
   card supported by MPVGA. 

   Copyright (c) 1995 Lin Ke-Fong, Ethereal Software.
*/


#include <conio.h>
#include <dos.h>
#include "mpvga.h"

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
void MPVGA_SetMode (void)

{
  int x, y, prt;
  union REGS Registers;

  if ((inp(0x3CC) & 1) == 0) CRTC = 0x3B4; else CRTC = 0x3D4;

/* set mode 13h */
  switch (MPVGA_ChipType) {

    case __Video7   : {
      Registers.h.bl = 0x13;
      Registers.w.ax = 0x6F05;
      int386(0x10,&Registers,&Registers);
      break;
    }

    case __WD       : {
      if (MPVGA_ChipVer == WD_90c33) {
        Registers.w.ax = 0x5E; /* simulate 320x200 using a 640x400 mode */
        int386(0x10,&Registers,&Registers);
        clrinx(GRC,0x0E,1);
        wrinx(CRTC,0x13,40);
        setinx(CRTC,9,1);
      } else {
        Registers.w.ax = 0x13;
        int386(0x10,&Registers,&Registers);
      }
      break;
    }

    default : {
      Registers.w.ax = 0x13;
      int386(0x10,&Registers,&Registers);
      break;
    }

  }

/* enable extensions */
  switch (MPVGA_ChipType) {

    case __Acer     : {
      wrinx(GRC,0xFF,7);      /* unlock extended 3CEh registers */
      setinx(CRTC,0xFF,1);    /* unlock extended 3d4h registers */
      setinx(GRC,0x0F,0x80);  /* enable 64k banking */
      break;
    }

    case __Ahead    : {
      setinx(GRC,0x0F,0x20);
      setinx(GRC,0x0C,0x20);

      HalfCRTC();
      wrinx(CRTC,0x13,20);
      setinx(GRC,0x0E,1);
      clrinx(0x3C0,0x10,0x40);
      break;
    }

    case __ALG      : {
      setinx(CRTC,0x1A,0x10);
      setinx(CRTC,0x19,2);
      setinx(GRC,0x0F,4);
      break;
    }

    case __Alliance : {
      wrinx(SEQ,0x10,0x12);
   /* clrinx(SEQ,0x1C,0x0F); ???? */
      break;
    }

    case __ARK      : {
      setinx(SEQ,0x1D,1);
      clrinx(CRTC,0x31,1);
      clrinx(CRTC,0x43,8);
      modinx(SEQ,0x11,0x0C,4);
   /* modinx(SEQ,0x17,7,0); ???? */
      setinx(SEQ,0x10,3);
      break;
    }

    case __ATI      : {
      IOAdr = 0x1CE;
      clrinx(IOAdr,0xB3,0x40);
      if (MPVGA_ChipVer >= ATI_M64_GX) {
        setinx(IOAdr,0xB0,8);
        x = inp(0x6AEC);
        x = x & 0xF8;
        outp(0x6AEC,x);
      }

      if (MPVGA_ChipVer >= ATI_28800_4) setinx(IOAdr,0xB6,1);
      if (MPVGA_ChipVer >= ATI_18800_1) clrinx(IOAdr,0xB3,0x10);

      if (MPVGA_ChipVer >= ATI_18800_1)
        if ((rdinx(IOAdr,0xB6) & 0x10) == 0) {
          setinx(CRTC,0x17,0x40);
          clrinx(CRTC,0x14,0x40);
          clrinx(GRC,5,0x40);
          clrinx(0x3C0,0x10,0x40);
          setinx(SEQ,1,8);
          if (MPVGA_ChipVer == ATI_18800_1)
            setinx(IOAdr,0xB0,0x30);
          else {
            setinx(IOAdr,0xB0,0x20);
            setinx(IOAdr,0xB6,4);
          }
          HalfCRTC();
          x = rdinx(CRTC,0x13);
          wrinx(CRTC,0x13,x / 2);
        }
      if (MPVGA_ChipVer > ATI_18800) setinx(IOAdr,0xBE,8);
      break;
    }

    case __Chips    : {
      if (MPVGA_ChipVer < CT_450) {
        prt = 0x46E8;
        x = inp(prt);
        outp(prt,x | 0x10);
        y = inp(0x103);
        outp(0x103,y | 0x80);
        outp(prt,x & 0xEF);
        if ((y & 0x40) == 0) IOAdr = 0x3D6; else IOAdr = 0x3B6;
      } else IOAdr = 0x3D6;

      wrinx(IOAdr,0x15,0);
      clrinx(IOAdr,0x14,1);
      setinx(IOAdr,0xB,1);
      setinx(IOAdr,4,4);

      switch (MPVGA_ChipVer) {
	case CT_450   :
        case CT_452   :
        case CT_453   : {
          modinx(IOAdr,0x0B,3,1);
          clrinx(IOAdr,0x0C,3);
          break;
        }
	case CT_65510 :
        case CT_65520 :
        case CT_65530 : {
	  setinx(IOAdr,4,8);
	  modinx(IOAdr,0x0B,3,1);
	  clrinx(IOAdr,0x0C,3);
          break;
        }
        case CT_64300 : clrinx(IOAdr,0x0B,0x10); break;
        default : break;
      }
      setinx(IOAdr,0x0B,4);
      setinx(CRTC,0x17,0x40);
      clrinx(CRTC,0x14,0x40);
      break;
    }

    case __Cirrus54 : {
      wrinx(SEQ,6,0x12);
      setinx(CRTC,0x1B,2);
      if (MPVGA_VideoRAMSize > 1024) {
        setinx(GRC,11,0x20);
        setinx(SEQ,0x0F,0x80);
      }
      setinx(SEQ,7,1);
      setinx(SEQ,1,8);
      HalfCRTC();
      break;
    }

    case __Cirrus64 : {
      wrinx(GRC,0x0A,0xEC);
      modinx(GRC,0x0D,7,3);
      break;
    }

    case __Compaq   : {
      modinx(GRC,0x0F,0x0F,5);
      setinx(GRC,0x10,8);

      if (rdinx(GRC,0x0F) != 0xA5) {
        x = inp(0x23C7);
        x = x | 0x10;
        outp(0x23C7,x);

        x = inp(0x63CB);
        x = x & 0xF3;
        outp(0x63CB,x);

        wrinx(CRTC,0x13,512 >> 3);
        modinx(GRC,0x42,3,512 >> 11);
      }
      if (MPVGA_ChipVer == CPQ_AVGA) setinx(GRC,0x40,1);

      break;
    }

    case __HMC      : {
      if ((rdinx(SEQ,0xE7) & 2) == 0) {
        HalfCRTC();
        setinx(SEQ,0xE7,2);
        clrinx(GRC,5,0x40);
        clrinx(0x3C0,0x10,0x40);
        setinx(SEQ,1,8);
      }
      break;
    }

    case __Matrox   : {
      setinx(0x3DE,1,9);
      HalfCRTC();
      wrinx(CRTC,0x13,20);
      break;
    }

    case __MXIC     : {
      setinx(SEQ,0x65,0x40);
      wrinx(SEQ,0xA7,0x87);
      setinx(SEQ,0xC3,4);
      setinx(SEQ,0xF0,8);
      break;
    }

    case __NCR      : {
      wrinx(SEQ,5,1);
      wrinx(SEQ,0x18,0);
      wrinx(SEQ,0x19,0);
      wrinx(SEQ,0x1C,0);
      wrinx(SEQ,0x1D,0);
      setinx(SEQ,0x1E,0x1C);


      if (MPVGA_ChipVer < NCR_77c32blt) {
        wrinx(SEQ,5,5);
        wrinx(SEQ,0x1A,0);
        wrinx(SEQ,0x1B,0);
      }
      setinx(SEQ,0x20,2);
      setinx(SEQ,0x21,1);
      clrinx(GRC,5,0x40);
      clrinx(SEQ,4,8);
      clrinx(0x3C0,0x10,0x40);
      setinx(CRTC,0x17,0x40);
      clrinx(CRTC,0x14,0x40);
      setinx(SEQ,0x1F,0x10);
      setinx(SEQ,1,8);

      break;
    }

    case __Oak      : break;

    case __Primus   : break;

    case __Realtek  : {
      setinx(CRTC,0x19,0xA2);
      setinx(GRC,0x0F,4);
      break;
    }

    case __S3       : {
      wrinx(CRTC,0x38,0x48);
      wrinx(CRTC,0x39,0xA5);
      modinx(CRTC,0x31,0x39,9);
      clrinx(CRTC,0x34,0x80);
      wrinx(CRTC,0x39,0x5A);
      wrinx(CRTC,0x38,0);
      break;
    }

    case __Sierra   : {
      x = rdinx(SEQ,0x11);
      wrinx(SEQ,0x11,x);
      wrinx(SEQ,0x11,x);
      modinx(SEQ,0x11,0xE0,0);
      break;
    }

    case __SiS      : {
      wrinx(SEQ,5,0x86);
      setinx(SEQ,6,2);
      setinx(SEQ,0x0B,8);
      clrinx(0x3C0,0x10,0x40);
      setinx(SEQ,1,8);
      HalfCRTC();
      break;
    }

    case __Trident  : {
      setinx(CRTC,0x1E,0x80);
      if (MPVGA_ChipVer == TR_8900C || MPVGA_ChipVer >= TR_9000C) {
        if (MPVGA_VideoRAMSize > 512) {
	  wrinx(SEQ,0x0B,0);
	  x = inp(SEQ+1);
	  x = rdinx(SEQ,0x0E);
	  wrinx(SEQ,0x0E,0x80);
	  setinx(SEQ,0x0C,0x20);
	  wrinx(SEQ,0x0E,x);
        }
	if (MPVGA_ChipVer != TR_8900C) setinx(GRC,0x0F,5);
      }
      modinx(GRC,6,0x0C,4);
      if (MPVGA_ChipVer >= TR_GUI9440) wrinx(CRTC,0x36,0x82);
      break;
    }

    case __Tseng    : {
      outp(0x3BF,3);
      outp(CRTC+4,0xA0);
      if (MPVGA_ChipVer == ET_3000) {
        setinx(SEQ,4,2);
        if ((rdinx(SEQ,7) & 0x40) == 0) {
          HalfCRTC();
          x = rdinx(CRTC,0x13);
          wrinx(CRTC,0x13,x / 2);
          clrinx(CRTC,0x14,0x40);
          clrinx(SEQ,4,8);
          wrinx(CRTC,0x17,0xC3);
          setinx(0x3C0,0x16,0x10);
          clrinx(CRTC,0x11,0x80);
          setinx(SEQ,7,0x40);
        }
      }
      break;
    }

    case __UMC      : {
      outp(0x3BF,0xAC);
      setinx(SEQ,8,0x80);
      clrinx(CRTC,0x2F,2);
      break;
    }

    case __Video7   : {
      wrinx(SEQ,6,0xEA);
      setinx(SEQ,0xF6,0xC0);
      modinx(SEQ,0xFC,6,4);
      if (MPVGA_ChipVer >= V7_216BC && (rdinx(GRC,5) & 0x40) > 0) {
        clrinx(GRC,5,0x40);
        setinx(SEQ,0xC8,0x10);
        modinx(0x3C0,0x10,0xC0,0x80);
        setinx(SEQ,1,8);
        HalfCRTC();
      }
      if (MPVGA_ChipVer >= V7_208A) setinx(SEQ,0xFF,0x10);
      break;
    }

    case __WD       : {
      modinx(GRC,0x0F,0x17,5);
      wrinx(CRTC,0x29,0x85);
      wrinx(SEQ,6,0x48);
      clrinx(GRC,0x0B,8);

      if (MPVGA_ChipVer != WD_90c33) clrinx(CRTC,0x2F,2);
      clrinx(CRTC,0x2F,0x78);
      setinx(SEQ,0x11,0x80);
      break;
    }

    default : break;
  }
  MPVGA_SetActivePage(0);
  MPVGA_SetVisualPage(0);
  return;
}
