/* MPVGA.H header of MPVGA's modules.

   Copyright (c) 1995 Lin Ke-Fong, Ethereal Software.
*/

enum ChipType {
  __Unknown,
  __Acer,
  __Ahead,
  __ALG,
  __Alliance,
  __ARK,
  __ATI,
  __Chips,
  __Cirrus54,
  __Cirrus64,
  __Compaq,
  __HMC,
  __Matrox,
  __MXIC,
  __NCR,
  __Oak,
  __Primus,
  __Realtek,
  __S3,
  __Sierra,
  __SiS,
  __Trident,
  __Tseng,
  __UMC,
  __Video7,
  __WD,

  __VESA

/* doesn't support yet Mach32/Mach64, IITAGX/XGA, Weitek, VESA
   this should be done soon. */
};

/* chip version, please do not modify order. */
enum ChipVer {
  UnknownChipVer,

  AC_CAT32,
  AC_CAT64,

  AH_A,
  AH_B,

  ALG_2101,
  ALG_2201,
  ALG_2228,
  ALG_2301,
  ALG_2302,
  ALG_2364,

  ALI_3210,

  ARK_1000VL,
  ARK_1000PV,
  ARK_2000PV,

  ATI_18800,
  ATI_18800_1,
  ATI_28800_2,
  ATI_28800_4,
  ATI_28800_5,
  ATI_28800_6,
  ATI_GUP_3,
  ATI_GUP_6,
  ATI_GUP_AX,
  ATI_GUP_LX,
  ATI_M64_GX,
  ATI_M64_CX,

  CL_AVGA1,
  CL_AVGA2,
  CL_GD5401,
  CL_GD5402,
  CL_GD5402r1,
  CL_GD5420,
  CL_GD5420r1,
  CL_GD5422,
  CL_GD5424,
  CL_GD5426,
  CL_GD5428,
  CL_GD5429,
  CL_GD5430,
  CL_GD5434,
  CL_GD7541,
  CL_GD7542,
  CL_GD7543,

  CL_GD6205,
  CL_GD6215,
  CL_GD6225,
  CL_GD6235,

  CL_GD5410,
  CL_GD6410,
  CL_GD6412,
  CL_GD6420A,
  CL_GD6420B,
  CL_GD6440,

  CT_451,
  CT_455,
  CT_456,
  CT_457,
  CT_452,
  CT_450,
  CT_453,
  CT_65520,
  CT_65530,
  CT_65510,
  CT_65535,
  CT_65540,
  CT_65545,
  CT_64200,
  CT_64300,
  CT_64310,

  CPQ_AVPORT,
  CPQ_IVGS,
  CPQ_AVGA,
  CPQ_QV,
  CPQ_QV1024,
  CPQ_QV1280,

  ET_3000,
  ET_4000,
  ET_4W32,
  ET_4W32i_a,
  ET_4W32i_b,
  ET_4W32i_c,
  ET_4W32p_a,
  ET_4W32p_b,
  ET_4W32p_c,
  ET_4W32p_d,

  HMC_304,
  HMC_314,

  IIT_AGX1x,
  IIT_AGX14,
  IIT_AGX15,
  IIT_AGX16,
  IIT_AGX17,

  MGA_VGA,
  MGA_Titan,
  MGA_Helena,

  MX_86000,
  MX_86010,
  MX_86100,

  NCR_77c21,
  NCR_77c22,
  NCR_77c22e,
  NCR_77c22ep,
  NCR_77c32blt,

  OAK_037,
  OAK_057,
  OAK_067,
  OAK_077,
  OAK_083,
  OAK_087,

  PR_2000,

  RT_3103,
  RT_3105,
  RT_3106,

  S3_911,
  S3_924,
  S3_801AB,
  S3_805AB,
  S3_801C,
  S3_805C,
  S3_801D,
  S3_805D,
  S3_801I,
  S3_805I,
  S3_801P,
  S3_805P,
  S3_928,
  S3_928C,
  S3_928D,
  S3_928E,
  S3_928PCI,
  S3_864,
  S3_864P,
  S3_964,
  S3_732,
  S3_764,
  S3_866,
  S3_868,
  S3_968,

  SC_15064,

  SIS_201,

  TR_8800BR,
  TR_8800CS,
  TR_8900B,
  TR_8900C,
  TR_9000,
  TR_LCD9100B,
  TR_LX8200,
  TR_LCD9320,
  TR_9000i,
  TR_9000C,
  TR_8900CL,
  TR_9200CXr,
  TR_9400CXi,
  TR_GUI9420,
  TR_GUI9430,
  TR_GUI9440,
  TR_GUI9660,
  TR_GUI9680,

  UMC_408,
  UMC_418,

  V7_VEGA,
  V7_208_13,
  V7_208A,
  V7_208B,
  V7_208CD,
  V7_216BC,
  V7_216D,
  V7_216E,
  V7_216F,

  WD_PVGA1A,
  WD_90c00,
  WD_90c10,
  WD_90c11,
  WD_90c20,
  WD_90c20A,
  WD_90c22,
  WD_90c24,
  WD_90c26,
  WD_90c30,
  WD_90c31,
  WD_90c33,

  XGA_org,
  XGA_NI,

  VESA_10,
  VESA_11,
  VESA_12,
  VESA_20

};

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/* === some #defines === */
#define ATTR  0x3C0
#define SEQ   0x3C4
#define GRC   0x3CE
#define Detected 1    /* #defines used by detection routines */
#define NotDetected 0

/* === variable declarations === */
extern int IOAdr; /* IO address used by some chips */
extern int CRTC;  /* CRTC address */

extern int MPVGA_ChipType; /* chip number */
extern int MPVGA_ChipVer; /* version number */

extern int MPVGA_VideoRAMSize; /* size of the video RAM */
extern int MPVGA_BiosVRAMSize;
/* video RAM size reported by BIOS functions if available
   note: MPVGA functions use MPVGA_VideoRAMSize, I trust no one !
   	 The truth is out there ! */

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/* === high level functions prototypes === */

extern int MPVGA_DetectChip (void);
/* Detect the chip of your graphic card, and initialize variables. */

extern void MPVGA_SetMode (void);
/* Set mode 13h and enable multipaging. */

extern void MPVGA_SetActivePage (int PageNumber);
/* Select the current writing/reading page. */

extern void MPVGA_SetVisualPage (int PageNumber);
/* Select the current visual (displayed on screen) page. */

extern void MPVGA_SetWriteBank (int Bank);
/* Select the current writing bank (64K). */

extern void MPVGA_SetReadBank (int Bank);
/* Select the current reading bank (64K) if possible. */

extern void MPVGA_SetVStart (int Sx, int Sy);
/* SetVStart function, useful if you want to do hardware scrolling. */

/* ====================================================================== */
/* === low level functions prototypes === */

extern void HalfCRTC (void);

extern int rdinx(int pt, int inx);
extern void wrinx (int pt, int inx, int val);
extern void wrinx3 (int pt, int inx, long val);
extern void modinx(int pt, int inx, int mask,int nwv);
extern void setinx(int pt, int inx, int val);
extern void clrinx(int pt, int inx, int val);
extern int tstrg(int pt, int msk);
extern int testinx2(int pt, int rg, int msk);
extern int testinx(int pt, int rg);

