/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
/*
 * X Version Copyright (C) 1995 Mike Manley
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>
#include <X11/Xlib.h>

/* Open X Display and create window */
/* Note - this will currently only work on a 256 color depth 8 XServer */
int screen_set_video_mode(void)
{
	XEvent event;
	XGCValues   gcvals;
	unsigned long  gcvmask=0;

	if((jxdisplay = XOpenDisplay(NULL)) == NULL)
	{
		/* Failed - now what ? */
		return 0; /* mode set failed */
	}
	/* Get the default screen */
	jxscreen = DefaultScreen(jxdisplay);

	/* Create a Graphics Context to use for blitting */
        /* Set up graphics context - oops this is currently a memory leak */
        /* GC can probably just be created once as part of screen_set_video_mode */
	gcvals.graphics_exposures = 0;
	gcvmask = GCGraphicsExposures;
	jxgc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);

	/* and try to create a 320 x 200 (hopefully depth 8) window on it! */
	jxwindow = XCreateSimpleWindow(jxdisplay, RootWindow(jxdisplay, jxscreen),
					0, 0, 320, 200, 0, 0, 0);
	/* Now try to create a colormap */
	jxcolormap = XCreateColormap(jxdisplay, jxwindow, DefaultVisual(jxdisplay, jxscreen),
					AllocAll);
	/* Set the colormap to the window */
	XSetWindowColormap(jxdisplay, jxwindow, jxcolormap);
	/* Be friendly and tell the window manager we need a colormap */
	XSetWMColormapWindows(jxdisplay, jxwindow, NULL, 0);
	/* Map the window */
	XMapWindow(jxdisplay, jxwindow);
	/* Flush the display to ensure all requests are sent */
	XFlush(jxdisplay);
	/* Finally read the event queue - we need to do this 'coz X doesn't */
	/* display our window until we do. */
	while(XCheckMaskEvent(jxdisplay, ~NoEventMask, &event));  
}


/*+------------------------------------------------------------------------+*/
/*|close the X window and return                                           |*/
/*+------------------------------------------------------------------------+*/

void screen_restore_video_mode(void)
{
	/* Destroy our window and Close X */
	XDestroyWindow(jxdisplay, jxwindow);
	XFreeGC(jxdisplay, jxgc);
	XFreeColormap(jxdisplay, jxcolormap);
	XCloseDisplay(jxdisplay);
}

/*+------------------------------------------------------------------------+*/
/*|Return the current page number ( always 1 in this case)                 |*/
/*+------------------------------------------------------------------------+*/

int screen_get_page(void)
{
 return 1;
}

/*+------------------------------------------------------------------------+*/
/*|Show the current drawing page. ( Has no effect in this mode.)           |*/
/*+------------------------------------------------------------------------+*/

void screen_show_page(int page)
{
 /* do nothing */
}



void screen_wait_vsync(void)
{
 /* not implememted yet */	
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color                                      | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_fill (UBYTE color) 
{
 /* not implememted yet */	
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_clear (void) 
{
 /* not implememted yet */	
}
