/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

#include <jlib.h>
#include <stdlib.h>
#include <stdio.h>
#include <vgakeyboard.h>
#include <linux/keyboard.h>

/* I can't believe how long it took me to get this working ! -jpg */


static unsigned char jstate[NR_KEYS];	/* in vgakeyboard.c */
static void jlib_handler( int scancode, int newstate );

static char __jlib_kb_buff[256];        /* keyboard buffer */
static unsigned char kb_head,kb_tail;   /* indices into buffers */
static int kb_initialised = 0;

/* array of scan codes -> ascii values */
static char __jlib_sc_to_asc[128] =
{  0, 27, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
   '-', '=', 8, 9, 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p',
   '[', ']', 13, 0, 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l',
   ';', '\'', '`', 0, 0, 'z', 'x', 'c', 'v', 'b', 'n', 'm',
   ',', '.', '/', 0, '*', 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, '-', 0, '5', 0, '+', 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


void kb_init(void)
{
 if(kb_initialised){
    return;
 }
 
 kb_initialised = 1;
 
 fflush(stdin);
 
 if(keyboard_init()!=0){
    abort(); /* no kb,  no computer! */
 }
 
 memset(jstate,0,NR_KEYS); /* clear key states */
 
 keyboard_clearstate();

 keyboard_translatekeys(TRANSLATE_CURSORKEYS);
 
 kb_head = kb_tail = 0;
 
 keyboard_seteventhandler(jlib_handler);

}


void kb_clear(void)
{
  if(kb_initialised == 0){
    return;
  }

 keyboard_update(); /* pick up any key releases etc to be dealt with */
 
 memset(jstate,0,NR_KEYS); /* clear key states */
 
 kb_head = kb_tail = 0; /* clear keyboard input buffer */
 
 keyboard_clearstate();
} 


void kb_closedown(void)
{
 if(kb_initialised == 0){
    return;
 }
 
 kb_initialised = 0;
 
 keyboard_close();
 fflush(stdin);  /* just in case theres some stuff left in there... */
} 


int kb_keydown(int key)
{
  if(kb_initialised == 0){
    return 0;
  }

 keyboard_update();

 if(key < 0 || key >= NR_KEYS) {
    return 0;
 }

 return jstate[key]; 
}


int kb_key_hit(void)
{
  if(kb_initialised == 0){
    return 0;
  }

 if(keyboard_update()==0){
    return 0;
 }
 else{
    return 1;
 }
}


char kb_get_next_key(void)
{
 
 char temp;
 
  if(kb_initialised == 0){
    return 0;
  }

 /* loop until a key is pressed,  or fall thru if one is waiting */
 while(kb_head == kb_tail){
    keyboard_update();
 }
 
 temp = __jlib_kb_buff[kb_head];    
 
 kb_head++;     /* remove the char from the buffer */
     
 return temp;
}


/* my own key handler - very simple */ 
static void jlib_handler( int scancode, int newstate ) {
	if(scancode < 0 || scancode >= NR_KEYS) {
           /* invalid scancode - ignore */
           return;
	}

        /* map cursor keys */
	switch (scancode) {
 	case SCANCODE_CURSORBLOCKUP :
		scancode = SCANCODE_CURSORUP; break;
 	case SCANCODE_CURSORBLOCKLEFT :
		scancode = SCANCODE_CURSORLEFT; break;
	case SCANCODE_CURSORBLOCKRIGHT :
		scancode = SCANCODE_CURSORRIGHT; break;
	case SCANCODE_CURSORBLOCKDOWN :
		scancode = SCANCODE_CURSORDOWN; break;
	}
			
	/* set state to reflect newstate */	
	jstate[scancode] = newstate;
	
	/* add key to input buffer if apropriate */
	if(newstate != 0){
	
	   /* the key is being pressed,  not released... */
	   if(__jlib_sc_to_asc[scancode]!=0){
	   
	      /* and it is an ascii char,  so add it to the buffer */
              kb_tail++; /* will wrap automatically */
              
              /* I dont do uppercase letters yet - its coming... */
              __jlib_kb_buff[kb_head] = __jlib_sc_to_asc[scancode];
              
              if(kb_tail == kb_head){
                 kb_head++;
              }	        
           }           
        }
}
 
