/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See "readme.jon" for more details.
*/
		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */

#include <jlib.h>
#include <grx.h>

/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
/*|This routine is just a normal blit that assumes the buffer is the same  |*/
/*|size as the screen.                                                     |*/
/*+------------------------------------------------------------------------+*/

JINLINE void screen_blit_fs_buffer(buffer_rec *buff)
{
 /* 'fake' the blit as a context to context blit */
 __jlib_fake_context->gc_baseaddr =  B_BUFF_PTR(buff);

#ifdef _INLINE256  /* this might have to come out for grx 2 */
 __jlib_fake_context->gc_frameaddr =  __jlib_fake_context->gc_baseaddr;
#else
 __jlib_fake_context->gc_frameaddr =  0L;
#endif

 GrBitBltNC(NULL,0,0,__jlib_fake_context,0,0,SCREEN_MAX_X,SCREEN_MAX_Y,GrWRITE);

}


#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

#ifndef ABS
#define ABS(a)     (((a)<0) ? -(a) : (a))
#endif


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen without clipping.                   |*/
/*+------------------------------------------------------------------------+*/

void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			  USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
 /* fill in the correct details for the blit */
 __jlib_fake_partial_context->gc_lineoffset = GrLineOffset(B_X_SIZE(sbuff));
 __jlib_fake_partial_context->gc_xmax=__jlib_fake_partial_context->gc_xcliphi=B_X_SIZE(sbuff)-1;
 __jlib_fake_partial_context->gc_ymax=__jlib_fake_partial_context->gc_ycliphi=B_Y_SIZE(sbuff)-1;
 __jlib_fake_partial_context->gc_planeoffset=GrPlaneSize(B_X_SIZE(sbuff),B_Y_SIZE(sbuff));

 /* 'fake' the blit as a context to context blit */
 __jlib_fake_partial_context->gc_baseaddr =  B_BUFF_PTR(sbuff);

#ifdef _INLINE256  /* this might have to come out for grx 2 */
 __jlib_fake_partial_context->gc_frameaddr =  __jlib_fake_partial_context->gc_baseaddr;
#else
 __jlib_fake_partial_context->gc_frameaddr =  0L;
#endif

GrBitBltNC(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);

}


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen with clipping.                      |*/
/*+------------------------------------------------------------------------+*/

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
 /* test coordinates for "don't draw" clipping */
 if((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
    return;
 }

 /* fill in the correct details for the blit */
 __jlib_fake_partial_context->gc_lineoffset = GrLineOffset(B_X_SIZE(sbuff));
 __jlib_fake_partial_context->gc_xmax=__jlib_fake_partial_context->gc_xcliphi=B_X_SIZE(sbuff)-1;
 __jlib_fake_partial_context->gc_ymax=__jlib_fake_partial_context->gc_ycliphi=B_Y_SIZE(sbuff)-1;
 __jlib_fake_partial_context->gc_planeoffset=GrPlaneSize(B_X_SIZE(sbuff),B_Y_SIZE(sbuff));

 /* 'fake' the blit as a context to context blit */
 __jlib_fake_partial_context->gc_baseaddr =  B_BUFF_PTR(sbuff);

#ifdef _INLINE256  /* this might have to come out for grx 2 */
 __jlib_fake_partial_context->gc_frameaddr =  __jlib_fake_partial_context->gc_baseaddr;
#else
 __jlib_fake_partial_context->gc_frameaddr =  0L;
#endif

 /* let grx do the clipping */
 GrBitBlt(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);

}


