/****************************************************************************
 This file was based on keyboard handling code from "Allegro",  a low-level
 gaming library for djgpp V1 and V2. I have extended the code to provide
 DPMI locking of all memory touched by the handler,  in the hopes of producing
 a truly robust keyboard handler.  To date I have not had I crash on me
 (but I'm NOT saying that it won't!). Allegro is authored by:

By Shawn Hargreaves,
1 Salisbury Road,
Market Drayton,
Shropshire,
England TF9 1AJ
email slh100@tower.york.ac.uk (until 1996)

 And is available by anonymous ftp from x2ftp.oulu.fi in the directory:
 /pub/msdos/programming/djgpp2

 A brief description of Allegro appears below,  Along with the copyright
 conditions of the code.

-------begin quoting ----------
Allegro is a collection of low level routines for use in computer games.
Once upon a time I had an Atari ST, and Allegro began life on that, hence
the acronym "Atari Low Level Game Routines". Then I started programming
on the PC and I rewrote Allegro with Borland C, intending to use it
for cross-platform game development. After finishing the Borland version I
saved up and bought myself a lovely new PC and decided to make a 32-bit
pmode version with DJ Delorie's wonderful compiler, djgpp. This distracted
me so much that the Atari library is not (and now probably never will be)
finished, and Allegro-PC has become totally incompatible with the Atari
version in any case. This means that the acronym is no longer totally
appropriate, but I can't think of anything else that it could stand for
and I am not going to change it now.

Allegro features:

   Mode 13h graphics routines: putpixel, getpixel, lines, rectangles,
   triangles, circles, text output, pallete manipulation, sprites (both
   solid and masked), and blits. All of these support clipping, and can
   draw to the screen or to memory bitmaps of any size.

   Easy access to the mouse, keyboard and 5 millisecond second timer
   interrupts.

   File access, including LZSS data compression and support for
   multi-object data files including an editor utility.

   Fixed point 16.16 arithmetic, including lookup-table trig.

   Simple GUI dialog manager and file selector.


Allegro is swap-ware. You may use, modify, redistribute, and generally
hack it about in any way you like, but if you do, you must send me
something that you have written. This could be a complete game, a
routine that you think I might like, an improved version of one of
the Allegro functions, a bugfix (hopefully there won't be too many of
these!), or just a copy of your autoexec.bat if you don't have anything
better. If you redistribute parts of Allegro or make a game using it, it
would be nice if you mentioned me somewhere in the credits, but if
you just want to pinch a few routines that is OK too. I'll trust you not
to rip me off.

#include <std_disclaimer>

   "I do not accept responsibility for any effects, adverse or otherwise,
    that this code may have on you, your computer, your sanity, your dog,
    and anything else that you can think of, including the political
    situation in Taiwan. Use it at your own risk."

------ end quoting -------

There,  I think that says it quite nicely.  All modifications to this code
by me fall under the copyright terms of the rest of the library.
							  Jon Griffiths.
****************************************************************************/
	.file   "kb_v2.s"
gcc2_compiled.:
___gnu_compiled_c:

 .globl ___jlib_kb_lock_start
 ___jlib_kb_lock_start:

.globl ___jlib_kb_initted
.globl ___jlib_ds
.data
	.align 1
___jlib_kb_initted:
	.word 0
___jlib_ds:
	.word 0
___jlib_to_ascii_table:
	.byte 0
	.byte 27
	.byte 49
	.byte 50
	.byte 51
	.byte 52
	.byte 53
	.byte 54
	.byte 55
	.byte 56
	.byte 57
	.byte 48
	.byte 45
	.byte 61
	.byte 8
	.byte 9
	.byte 113
	.byte 119
	.byte 101
	.byte 114
	.byte 116
	.byte 121
	.byte 117
	.byte 105
	.byte 111
	.byte 112
	.byte 91
	.byte 93
	.byte 13
	.byte 0
	.byte 97
	.byte 115
	.byte 100
	.byte 102
	.byte 103
	.byte 104
	.byte 106
	.byte 107
	.byte 108
	.byte 59
	.byte 39
	.byte 96
	.byte 0
	.byte 0
	.byte 122
	.byte 120
	.byte 99
	.byte 118
	.byte 98
	.byte 110
	.byte 109
	.byte 44
	.byte 46
	.byte 47
	.byte 0
	.byte 42
	.byte 0
	.byte 32
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 45
	.byte 0
	.byte 53
	.byte 0
	.byte 43
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
___jlib_shifted_to_ascii_table:
	.byte 0
	.byte 27
	.byte 33
	.byte 64
	.byte 35
	.byte 36
	.byte 37
	.byte 94
	.byte 38
	.byte 42
	.byte 40
	.byte 41
	.byte 95
	.byte 43
	.byte 8
	.byte 9
	.byte 81
	.byte 87
	.byte 69
	.byte 82
	.byte 84
	.byte 89
	.byte 85
	.byte 73
	.byte 79
	.byte 80
	.byte 123
	.byte 125
	.byte 13
	.byte 0
	.byte 65
	.byte 83
	.byte 68
	.byte 70
	.byte 71
	.byte 72
	.byte 74
	.byte 75
	.byte 76
	.byte 58
	.byte 34
	.byte 126
	.byte 0
	.byte 0
	.byte 90
	.byte 88
	.byte 67
	.byte 86
	.byte 66
	.byte 78
	.byte 77
	.byte 60
	.byte 62
	.byte 63
	.byte 0
	.byte 42
	.byte 0
	.byte 32
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 45
	.byte 0
	.byte 53
	.byte 0
	.byte 43
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
	.byte 0
.globl __key_buffer_start
	.align 1
__key_buffer_start:
	.word 0
.globl __key_buffer_end
	.align 1
__key_buffer_end:
	.word 0
.text
	.align 2
.globl __my_keyint
__my_keyint:
	pushl %ebp
	movl %esp,%ebp
	pushl $96
	call _inportb
	addl $4,%esp
	movb %al,%al
	movzbw %al,%dx
	movw %dx,__k_temp
	movw __k_temp,%dx
	movb %dl,%al
	movb %al,%dl
	andb $-128,%dl
	testb %dl,%dl
	je L11
	movw __k_temp,%dx
	movl %edx,%eax
	andw $127,%ax
	movswl %ax,%edx
	movb $0,_key(%edx)
	jmp L12
	.align 2,0x90
L11:
	movw __k_temp,%ax
	movl %eax,%edx
	andw $127,%dx
	movw %dx,__k_temp
	movw __k_temp,%dx
	movswl %dx,%eax
	movb $-1,_key(%eax)
	movw __k_temp,%ax
	cmpw $29,%ax
	je L12
	movw __k_temp,%ax
	cmpw $42,%ax
	je L12
	movw __k_temp,%ax
	cmpw $54,%ax
	je L12
	movw __k_temp,%ax
	cmpw $56,%ax
	je L12
	movw __k_temp,%ax
	cmpw $58,%ax
	je L12
	movw __k_temp,%ax
	cmpw $69,%ax
	je L12
	movw __k_temp,%ax
	cmpw $70,%ax
	je L12
	movb _key+42,%al
	testb %al,%al
	jne L15
	movb _key+54,%al
	testb %al,%al
	jne L15
	jmp L14
	.align 2,0x90
L15:
	movw __k_temp,%dx
	movswl %dx,%eax
	cmpb $0,___jlib_shifted_to_ascii_table(%eax)
	jne L16
	pushl $32
	pushl $32
	call _outportb
	addl $8,%esp
	jmp L10
	.align 2,0x90
L16:
	movw __key_buffer_end,%dx
	movswl %dx,%eax
	movw __k_temp,%cx
	movswl %cx,%edx
	movb ___jlib_shifted_to_ascii_table(%edx),%cl
	movb %cl,__key_buffer(%eax)
	jmp L17
	.align 2,0x90
L14:
	movw __k_temp,%dx
	movswl %dx,%eax
	cmpb $0,___jlib_to_ascii_table(%eax)
	jne L18
	pushl $32
	pushl $32
	call _outportb
	addl $8,%esp
	jmp L10
	.align 2,0x90
L18:
	movw __key_buffer_end,%dx
	movswl %dx,%eax
	movw __k_temp,%cx
	movswl %cx,%edx
	movb ___jlib_to_ascii_table(%edx),%cl
	movb %cl,__key_buffer(%eax)
L17:
	movw __key_buffer_end,%ax
	movl %eax,%edx
	incw %dx
	movw %dx,__key_buffer_end
	movw __key_buffer_end,%ax
	movw __key_buffer_end,%dx
	cmpw $254,%dx
	jle L19
	movw $0,__key_buffer_end
L19:
	movw __key_buffer_end,%ax
	movw __key_buffer_start,%dx
	cmpw %dx,%ax
	jne L12
	movw __key_buffer_start,%ax
	movl %eax,%edx
	incw %dx
	movw %dx,__key_buffer_start
	movw __key_buffer_start,%ax
	movw __key_buffer_start,%dx
	cmpw $254,%dx
	jle L12
	movw $0,__key_buffer_start
L21:
L20:
L13:
L12:
	pushl $32
	pushl $32
	call _outportb
	addl $8,%esp
L10:
	leave
	ret
	.align 2
.globl _kb_clear
_kb_clear:
	pushl %ebp
	movl %esp,%ebp
	cmpw $0,___jlib_kb_initted
	jne L23
	jmp L22
	.align 2,0x90
L23:
	movw $0,__key_buffer_start
	movw $0,__key_buffer_end
L22:
	leave
	ret
	.align 2
.globl _kb_keydown
_kb_keydown:
	pushl %ebp
	movl %esp,%ebp
	movl 8(%ebp),%eax
	addl $_key,%eax
	movl %eax,%edx
	movb (%edx),%al
	testb %al,%al
	je L25
	movl $1,%eax
	jmp L24
	.align 2,0x90
	jmp L26
	.align 2,0x90
L25:
	xorl %eax,%eax
	jmp L24
	.align 2,0x90
L26:
L24:
	leave
	ret
	.align 2
.globl _kb_key_hit
_kb_key_hit:
	pushl %ebp
	movl %esp,%ebp
	cmpw $0,___jlib_kb_initted
	jne L28
	xorl %eax,%eax
	jmp L27
	.align 2,0x90
L28:
	movw __key_buffer_start,%ax
	movw __key_buffer_end,%dx
	cmpw %dx,%ax
	jne L29
	xorl %eax,%eax
	jmp L27
	.align 2,0x90
	jmp L30
	.align 2,0x90
L29:
	movl $1,%eax
	jmp L27
	.align 2,0x90
L30:
L27:
	leave
	ret
	.align 2
.globl _kb_get_next_key
_kb_get_next_key:
	pushl %ebp
	movl %esp,%ebp
	subl $4,%esp
	cmpw $0,___jlib_kb_initted
	jne L32
	xorl %eax,%eax
	jmp L31
	.align 2,0x90
L32:
	nop
L33:
L35:
	movw __key_buffer_start,%ax
	movw __key_buffer_end,%dx
	cmpw %dx,%ax
	je L36
	jmp L34
	.align 2,0x90
L36:
	jmp L35
	.align 2,0x90
L34:
	call _disable
	movw __key_buffer_start,%dx
	movswl %dx,%eax
	movb __key_buffer(%eax),%dl
	movb %dl,-1(%ebp)
	movw __key_buffer_start,%ax
	movl %eax,%edx
	incw %dx
	movw %dx,__key_buffer_start
	movw __key_buffer_start,%ax
	movw __key_buffer_start,%dx
	cmpw $254,%dx
	jle L37
	movw $0,__key_buffer_start
L37:
	call _enable
	movsbl -1(%ebp),%edx
	movl %edx,%eax
	jmp L31
	.align 2,0x90
L31:
	leave
	ret
	.align 2
.globl _kb_init
_kb_init:
	pushl %ebp
	movl %esp,%ebp
	subl $4,%esp
	cmpw $0,___jlib_kb_initted
	je L39
	jmp L38
	.align 2,0x90
L39:
	movw $1,___jlib_kb_initted
	movw $0,-2(%ebp)
L40:
	cmpw $127,-2(%ebp)
	jle L43
	jmp L41
	.align 2,0x90
L43:
	movswl -2(%ebp),%eax
	movb $0,_key(%eax)
L42:
	incw -2(%ebp)
	jmp L40
	.align 2,0x90
L41:
	movw $0,__key_buffer_start
	movw $0,__key_buffer_end
	call ___jlib_lock_kb_handler
	movl $__my_keyint,__key_pm_int+4
	pushl $__key_pm_int
	call __go32_dpmi_allocate_iret_wrapper
	addl $4,%esp
	call __my_cs
	movl %eax,%eax
	movw %ax,__key_pm_int+8
	pushl $__key_pm_oldint
	pushl $9
	call __go32_dpmi_get_protected_mode_interrupt_vector
	addl $8,%esp
	pushl $__key_pm_int
	pushl $9
	call __go32_dpmi_set_protected_mode_interrupt_vector
	addl $8,%esp
	pushl $52
	pushl $0
	pushl $__key_rm_regs
	call _memset
	addl $12,%esp
	movl $__my_keyint,__key_rm_int+4
	pushl $__key_rm_regs
	pushl $__key_rm_int
	call __go32_dpmi_allocate_real_mode_callback_iret
	addl $8,%esp
	pushl $__key_rm_oldint
	pushl $9
	call __go32_dpmi_get_real_mode_interrupt_vector
	addl $8,%esp
	pushl $__key_rm_int
	pushl $9
	call __go32_dpmi_set_real_mode_interrupt_vector
	addl $8,%esp
L38:
	leave
	ret
	.align 2
.globl _kb_closedown
_kb_closedown:
	pushl %ebp
	movl %esp,%ebp
	subl $4,%esp
	cmpw $0,___jlib_kb_initted
	jne L45
	jmp L44
	.align 2,0x90
L45:
	pushl $__key_pm_oldint
	pushl $9
	call __go32_dpmi_set_protected_mode_interrupt_vector
	addl $8,%esp
	pushl $__key_pm_int
	call __go32_dpmi_free_iret_wrapper
	addl $4,%esp
	pushl $__key_rm_oldint
	pushl $9
	call __go32_dpmi_set_real_mode_interrupt_vector
	addl $8,%esp
	pushl $__key_rm_int
	call __go32_dpmi_free_real_mode_callback
	addl $4,%esp
	movw $0,-2(%ebp)
L46:
	cmpw $127,-2(%ebp)
	jle L49
	jmp L47
	.align 2,0x90
L49:
	movswl -2(%ebp),%eax
	movb $0,_key(%eax)
L48:
	incw -2(%ebp)
	jmp L46
	.align 2,0x90
L47:
	movw $0,__key_buffer_start
	movw $0,__key_buffer_end
	movw $0,___jlib_kb_initted
L44:
	leave
	ret
	.align 2
__my_cs:
	pushl %ebp
	movl %esp,%ebp
	subl $4,%esp
/APP
	movw %cs,%cx
/NO_APP
	movw %cx,-2(%ebp)
	movswl -2(%ebp),%edx
	movl %edx,%eax
	jmp L1
	.align 2,0x90
L1:
	leave
	ret

 .globl ___jlib_kb_lock_end
 ___jlib_kb_lock_end:

.lcomm _JLIB_MESSAGE_STRING,84
.lcomm __jlib_dos_selector,4
.comm _key,128
.comm __k_temp,4
.comm __key_buffer,256
.comm __key_rm_oldint,16
.comm __key_rm_int,16
.comm __key_rm_regs,52
.comm __key_pm_oldint,16
.comm __key_pm_int,16
