/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.
*/

#include <jconfig.h>
#include <jtypes.h>


/* jscreen.h - screen and palette functions */

/* this module must provide the following : 
**
** constants:
**  SCREEN_WIDTH  
**  SCREEN_HEIGHT 
**  SCREEN_MAX_X  
**  SCREEN_MAX_Y  
**  SCREEN_NUM_COLORS
**  SCREEN_NUM_PAGES
**
** functions/macros:
**  int screen_set_video_mode(void);
**  void screen_restore_video_mode(void);
**  void screen_set_page(int page);
**  int  screen_get_page(void);
**  void screen_show_page(int page);
**  void screen_clear(void)
**  void screen_fill(UBYTE colour)
**  void screen_wait_vsync(void);
**
**  UBYTE *screen_load_pal(char *fname);
**  void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
**  void screen_block_set_pal(UBYTE *pal);
**  void screen_blank_pal(void);
**  void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
**  void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);
**
**  void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
**                         USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
**  void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
**                           USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
**  void screen_blit_fs_buffer(buffer_rec *sbuff);
**
*/
#ifndef __JSCREEN_H__   /* only include file once */
#define __JSCREEN_H__ 

#ifdef __cplusplus
extern "C" {
#endif 

/****************************************************************************/
#ifdef DJGPP_DPMI_COMPLIANT     /* DJGPP with DOS,  OS/2,  WIN */
/****************************************************************************/

static int _jlib_dos_selector;  /* global selector for dos memory */

void jdosmemsetup(void);        /* set up global selector */

/****************************************************************************/
#ifdef MODE_13H
/****************************************************************************/

#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);
void screen_clear(void);
void screen_fill(UBYTE colour);
void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);

#endif /* mode 13h */


/****************************************************************************/
#ifdef GRX_640x480x256
/****************************************************************************/
#include <grx.h>

GrContext *__jlib_fake_context;  /* used for blits */
GrContext *__jlib_fake_partial_context;

#define  SCREEN_WIDTH   640
#define  SCREEN_HEIGHT  480
#define  SCREEN_MAX_X   639
#define  SCREEN_MAX_Y   479
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);
void screen_clear(void);
void screen_fill(UBYTE colour);
void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);

#endif /* grx 640x480x256 */



/****************************************************************************/
#ifdef GRX2_VARIANT  /* any of the grx2 family of targets */
/****************************************************************************/
#include <grx20.h>

GrContext *__jlib_fake_context;  /* used for blits */
GrContext *__jlib_fake_partial_context;
int __jlib_planesize;

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);
void screen_clear(void);
void screen_fill(UBYTE colour);
void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);

#endif /* grx variants */


/****************************************************************************/
#ifdef GRX2_320x200x256
/****************************************************************************/

#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_320x200x256 */

/****************************************************************************/
#ifdef GRX2_640x480x256
/****************************************************************************/

#define  SCREEN_WIDTH   640
#define  SCREEN_HEIGHT  480
#define  SCREEN_MAX_X   639
#define  SCREEN_MAX_Y   479
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_640x480x256 */

/****************************************************************************/
#ifdef GRX2_800x600x256
/****************************************************************************/

#define  SCREEN_WIDTH   800
#define  SCREEN_HEIGHT  600
#define  SCREEN_MAX_X   799
#define  SCREEN_MAX_Y   599
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_800x600x256 */

#endif /* DJGPP */


/****************************************************************************/
#ifdef LINUX_SVGALIB
/****************************************************************************/

/****************************************************************************/
#ifdef MODE_13H
/****************************************************************************/

#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);
void screen_clear(void);
void screen_fill(UBYTE colour);
void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);

#endif /* mode13h */

#endif /* linux svgalib */

/****************************************************************************/
#ifdef LINUX_GRX2
/****************************************************************************/
#include <grx20.h>

GrContext *__jlib_fake_context;  /* used for blits */
GrContext *__jlib_fake_partial_context;
int __jlib_planesize;

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);
void screen_clear(void);
void screen_fill(UBYTE colour);
void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);


/****************************************************************************/
#ifdef GRX2_320x200x256
/****************************************************************************/

#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_320x200x256 */

/****************************************************************************/
#ifdef GRX2_640x480x256
/****************************************************************************/

#define  SCREEN_WIDTH   640
#define  SCREEN_HEIGHT  480
#define  SCREEN_MAX_X   639
#define  SCREEN_MAX_Y   479
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_640x480x256 */

/****************************************************************************/
#ifdef GRX2_800x600x256
/****************************************************************************/

#define  SCREEN_WIDTH   800
#define  SCREEN_HEIGHT  600
#define  SCREEN_MAX_X   799
#define  SCREEN_MAX_Y   599
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#endif /* grx2_800x600x256 */

#endif /* linux grx2 */

/****************************************************************************/
#ifdef X_WINDOWS
/****************************************************************************/

/****************************************************************************/
#ifdef X_320x200x256
/****************************************************************************/

#include<X11/Xlib.h>

/* some global stuff to help us manage */
Display*	jxdisplay;
int		jxscreen;
Window		jxwindow;
Colormap	jxcolormap;
GC		jxgc;

#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

int screen_set_video_mode(void);
void screen_restore_video_mode(void);
#define screen_set_page(page)
int screen_get_page(void);
void screen_show_page(int page);

/* void screen_clear(void);          not implemented yet
** void screen_fill(UBYTE colour);   not implemented yet
*/

void screen_wait_vsync(void);

UBYTE *screen_load_pal(char *fname);
void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue);
void screen_block_set_pal(UBYTE *pal);
void screen_blank_pal(void);
void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime);
void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime);

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			   USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2);
JINLINE void screen_blit_fs_buffer(buffer_rec *sbuff);

#endif /* X_320x200x256 */

#endif /* X windows */


#ifdef __cplusplus
}
#endif 
 
#endif /* ifndef __JSCREEN_H__ */

