 /*
   **
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more information.
 */  

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>
#include "lz.h"
#include "rle.h"
#include "../io/jio.h"

/* magic number that identifies jlib files */
#define JLB_MAGIC_NUMBER 0xd00d


image * image_load_jlb(char *filename) 
{
 FILE * infile;
 image * timg;
 USHORT magic_number;
 long comp_length,filler,rlen;
 UBYTE *sp,*rp;
 int i;
 _J_32_BIT thirtytwobit;
 
 JLIB_PRINT_DEBUG_INFO ("Entering image_load_jlb()\n");

   
 /* grab mem for header record */ 
 if((timg = (image *) malloc (sizeof (image))) == NULL){
    JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_jlb line %d\n", __LINE__);
    JLIB_PRINT_MESSAGE_STRING;
	
    return (image *) NULL;
 }
   
      
  /* grab mem for palette */ 
  if((timg->palette = (UBYTE *) malloc (768 * sizeof (UBYTE))) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
     
     return (image *) NULL;
  }
   
      
  /* Open the file */ 
  if((infile = fopen (filename, "rb")) == NULL){
    JLIB_PRINT_DEBUG_INFO ("Couldn't open file.\n");
	   
    free (timg->palette);
    
    return (image *) NULL;
  }
   
      
  /* read in header information */ 
  fseek (infile, 0L, 0);

  /* read magic number */ 
  jio_read_elementary_type(infile,&magic_number, sizeof(USHORT));

  /* check magic number */ 
  if(magic_number != JLB_MAGIC_NUMBER){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING,"Wrong magic number for jlb image file.\n");
     JLIB_PRINT_MESSAGE_STRING;
	
     free (timg->palette);
     free (timg);
     return (image *) NULL;
   }

  /* get width + height */
  jio_read_elementary_type(infile,&timg->width, sizeof(USHORT));
  jio_read_elementary_type(infile,&timg->height, sizeof(USHORT));

  JLIB_SPRINTF (JLIB_MESSAGE_STRING, "Width and Height are %d and %d\n", timg->width, timg->height);
  JLIB_PRINT_MESSAGE_STRING;

  /* get length of rle data */
  jio_read_elementary_type(infile,&thirtytwobit, sizeof(_J_32_BIT));

  rlen = (long)thirtytwobit;

  /* get length of compressed data */
  jio_read_elementary_type(infile,&thirtytwobit, sizeof(_J_32_BIT));

  comp_length = (long)thirtytwobit;

  /* grab memory to hold compressed data */
  if((sp = (UBYTE *) malloc ((comp_length) * sizeof (UBYTE))) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
	
	   free (timg->palette);
	   free (timg->data);
	   free (timg);
	   return (image *) NULL;
	
   }

  /* grab memory to hold rle data */
  if((rp = (UBYTE *) malloc (rlen )) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
	
	   free (timg->palette);
	   free (timg->data);
	   free (timg);
	   return (image *) NULL;
	
   }
   
   /* read compressed data into compressed buffer */
   for(i=0;i<comp_length;i++){
       sp[i]=(UBYTE)fgetc(infile);
   }
   
   /* uncompress from the compressed buffer to the rle buffer */  
   lz_decompress(sp,comp_length,rp,&filler);

  /* run length decode data into image buffer */
  rlen = rle_decode(rp,&timg->data);

  
   /* free the memory for the compressed buffer */
   free(sp);
   
  /* get length of compressed palette data */
  jio_read_elementary_type(infile,&thirtytwobit, sizeof(_J_32_BIT));

  comp_length = (long)thirtytwobit;
   
  /* grab memory to hold compressed palette data */
  if((sp = (UBYTE *) malloc ((comp_length) * sizeof (UBYTE))) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
	
	   free (timg->palette);
	   free (timg->data);
	   free (timg);
	   return (image *) NULL;
	
   }


   /* read compressed pal data into compressed pal buffer */
   for(i=0;i<comp_length;i++){
       sp[i]=(UBYTE)fgetc(infile);
   }
   
   /* uncompress from the compressed pal buff to the uncompressed buffer */  
   lz_decompress(sp,comp_length,timg->palette,&filler);

  /* free the memory for the compressed buffer */
  free(sp);
      
   fclose (infile);
   
      
   JLIB_PRINT_DEBUG_INFO ("Leaving image_load_jlb()\n");
   
      
   /* return a pointer to the image */ 
   return timg;
   
}



int image_save_jlb(char *filename,buffer_rec *buff,UBYTE *pal) 
{
 FILE * outfile;
 USHORT magic_number=JLB_MAGIC_NUMBER;
 long *comp_length,rlen;
 UBYTE *sp,*rp;
 int i; 
 _J_32_BIT thirtytwobit;
 
 JLIB_PRINT_DEBUG_INFO ("Entering image_save_jlb()\n");

   
  /* Open the file */ 
  if((outfile = fopen (filename, "wb")) == NULL){
    JLIB_PRINT_DEBUG_INFO ("Couldn't open file.\n");
    
    return 0;
  }
   
  /* grab memory to hold compressed length */
  if((comp_length = (long *) malloc (sizeof(long))) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_save_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
	
     return 0;
  }
      
  fseek (outfile, 0L, 0);

  /* write magic number */ 
  jio_write_elementary_type(outfile,&magic_number, sizeof(USHORT));

  /* put width + height */
  jio_write_elementary_type(outfile,&buff->width, sizeof(USHORT));
  jio_write_elementary_type(outfile,&buff->height, sizeof(USHORT));

  JLIB_SPRINTF (JLIB_MESSAGE_STRING, "Width and Height are %d and %d\n", buff->width, buff->height);
  JLIB_PRINT_MESSAGE_STRING;
  
  /* run length encode data into rp */
  rlen = rle_encode(B_BUFF_PTR(buff),B_SIZE(buff),&rp);

  /* put length of rle data */
  thirtytwobit = (_J_32_BIT)rlen;
  
/********************/
  jio_write_elementary_type(outfile,&rlen, sizeof(_J_32_BIT));
  
  /* grab memory to hold compressed rle data */
  if((sp = (UBYTE *) malloc (rlen+256)) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_save_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
	
     return 0;
   }
   
   /* compress from the rle buffer to the compressed buffer */  
   lz_compress(rp,rlen,sp,comp_length);

  /* free the rle buffer */
  free(rp);
  
  /* put length of compressed data */
  thirtytwobit = (_J_32_BIT)*comp_length;
  
  jio_write_elementary_type(outfile,&thirtytwobit, sizeof(_J_32_BIT));

   /* write compressed data into the file */
   for(i=0;i< *comp_length;i++){
       fputc(sp[i],outfile);
   }

  /* free the memory for the compressed buffer */
  free(sp);
  
  /* grab memory to hold compressed palette data */
  if((sp = (UBYTE *) malloc (256+768)) == NULL){
     JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_save_jlb line %d\n", __LINE__);
     JLIB_PRINT_MESSAGE_STRING;
     return 0;
   }

  /* compress from the uncompressed pal buff to the compressed buffer */  
  lz_compress(pal,768,sp,comp_length);

  /* put length of compressed palette data */
  thirtytwobit = (_J_32_BIT)*comp_length;
  
  jio_write_elementary_type(outfile,&thirtytwobit, sizeof(_J_32_BIT));

   /* write compressed data into the file */
   for(i=0;i<*comp_length;i++){
       fputc(sp[i],outfile);
   }

  /* free the memory for the compressed buffer */
  free(sp);
  free(comp_length);
        
   fclose (outfile);
   
      
   JLIB_PRINT_DEBUG_INFO ("Leaving image_save_jlb()\n");
   
   /* return success */ 
   return 1;
   
}


