/* demo3.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <stdlib.h>
#include <stdio.h>
#include <jlib.h>

#define RANDOM(num) (int)(((float)rand()*(float)num)/(float)RAND_MAX)

/* Note: This demo is not meant to test speed.  Its just a demo to show that 
** the simple primitives work.  In a real life situation you might well draw
** 10-15 rectangles,  20 points,  10 lines and a few circles before throwing
** the buffer out to the screen.  this demo draws 100 abitrarily- it doesnt
** *mean* anything.
*/

#define ITERATIONS 100

int main(void)
{
  int i=0,j,temp;
  buffer_rec *offscreen;

  /* seed random number generator */
  srand((int)time(NULL)|1);

  /* initialise screen sized buffer */
  offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

  /* check that initialisation was OK */
  if(offscreen == NULL){
     printf("ERROR:could not initialise buffer.\n");
     printf("press any key to exit.\n");
     fgetc(stdin);
     exit(0);
  }

  screen_set_video_mode();


  /*********************/
  /* test line drawing */
  /*********************/
  buff_clear(offscreen);
  
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
	   buff_draw_lineNC(offscreen,RANDOM(SCREEN_WIDTH), RANDOM(SCREEN_HEIGHT),
	   RANDOM(SCREEN_WIDTH), RANDOM(SCREEN_HEIGHT), i = ++i % 255);
	}
	screen_blit_fs_buffer(offscreen);
  }
  
  fgetc(stdin);


  /**********************/
  /* test point drawing */
  /**********************/
  buff_clear(offscreen);

  for(temp=0;temp!=300;temp++){
	for(j=0;j<ITERATIONS;j++){
	    buff_draw_pointNC(offscreen,RANDOM(SCREEN_WIDTH), RANDOM(SCREEN_HEIGHT),
	    i = ++i % 255);
	}    
	screen_blit_fs_buffer(offscreen);
  }

  fgetc(stdin);

  /**************************/
  /* test rectangle drawing */
  /**************************/
  buff_clear(offscreen);
      
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
	    buff_draw_rectNC(offscreen,RANDOM(SCREEN_WIDTH), RANDOM(SCREEN_HEIGHT),
	    RANDOM(SCREEN_WIDTH), RANDOM(SCREEN_HEIGHT),i = ++i % 255);
	} 
	    screen_blit_fs_buffer(offscreen);
  }

  fgetc(stdin);

  /************************/
  /* test ellipse drawing */
  /************************/
  buff_clear(offscreen);
     
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
	    buff_draw_ellipseNC(offscreen,RANDOM(SCREEN_WIDTH)/2+SCREEN_WIDTH/4,
	    RANDOM(SCREEN_HEIGHT)/2+SCREEN_HEIGHT/4, RANDOM(SCREEN_WIDTH)/4,
	    RANDOM(SCREEN_HEIGHT)/4,i = ++i % 255);
	}    
	screen_blit_fs_buffer(offscreen);
  }

  fgetc(stdin);


  /******************************/
  /* test filled ellipse drawing */
  /******************************/
  buff_clear(offscreen);
     
  for(temp=0;temp!=100;temp++){
	for(j=0;j<ITERATIONS;j++){
	    buff_filled_ellipseNC(offscreen,RANDOM(SCREEN_WIDTH)/2+SCREEN_WIDTH/4,
	    RANDOM(SCREEN_HEIGHT)/2+SCREEN_HEIGHT/4, RANDOM(SCREEN_WIDTH)/4,
	    RANDOM(SCREEN_HEIGHT)/4,i = ++i % 255);
	}    
	screen_blit_fs_buffer(offscreen);
  }

  screen_restore_video_mode();

  return(0);
}
